<?php
/**
 * Workshop module - Modify calendar event page
 * 
 * Modify calendar event page
 * 
 * @package linea21\modules\workshop
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once("../lib/input_helpers.php");
if(isset($_POST['id']))	$id=$_POST['id'];
if(isset($_GET['id']))	$id=$_GET['id'];
//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isWorkgroupOrganiser($l21auth->GetSessionElement('id'), $sql_object, $id) && !$l21auth->isSuperAdmin())
ReloadIndex('admin');
////////////


$link_add_cal = $rub_link . "&amp;todo=add_cal&amp;id=";
$link_det = $rub_link . "&amp;todo=det&amp;id=";

if(isset($_POST['task_id']))	$task_id=$_POST['task_id'];
if(isset($_GET['task_id']))	$task_id=$_GET['task_id'];

$calendar_object= new calendar;

//$result_task=$calendar_object->GetOneTask($task_id, $sql_object);
$req_task=SQL_getOneTask($task_id);
$result_task = $sql_object -> DBSelect($req_task);

// Do record exists?
if(!isset($result_task[0]['workcal_task'])) redirect_to('@module_default');

$form_date=$result_task[0]['date_t'];

$form_task=formatText($result_task[0]['workcal_task'], '2FIELD');
$display_title_task=formatText($result_task[0]['workcal_task'], '2FIELD');
$form_task_details=formatText($result_task[0]['workcal_task_details'], '2FIELD');

if($result_task[0]['workcal_workshop_id'] == 999999999) {
  $display_common = _t('divers', 'yes');
} else {
  $display_common = _t('divers', 'no');
}

$req_det_workshop= SQL_getoneCompleteWorkshop($id);
$result_workshop=$sql_object->DBSelect($req_det_workshop);
$workshop_denomination=formatText($result_workshop[0]['workshop_denomination'], '2FIELD');
$link_cancel=$rub_link."&amp;todo=list_cal&amp;id=".$id;
//$workshop_object= new workshop;

if(isset($_POST['enregistrer'])) {

  $data_table=unserialize(urldecode($_POST['data_table']));
  $result=$calendar_object->ModifyTask($task_id, $data_table, $sql_object);
  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo."&id=".$id;
  if($result) header("Location: ".safe_redirect($link_confirm));
  else  system_error();
}


if(isset($_POST['valider'])) {

  //traitement de la date
  $table = array();
  
  $table[0] = $_POST['date'];
  $table[1] = $_POST['task'];
  $table[2] = $_POST['task_details'];
  $table[3] = $_POST['id'];

  $integrity=$calendar_object->CheckDataIntegrity($table, $sql_object);

  if(is_string($integrity)) {
    $text_format='2FIELD';
  } else {
    $text_format='2HTML';
    //$table[6]=$integrity;
  }
  $form_task=formatText($_POST['task'], $text_format);
  $form_task_details=formatText($_POST['task_details'], $text_format);
  $form_date =$_POST['date'];

  $table=urlencode(serialize($table));
}
$navtitle=_t('workshop','mod_cal')." : ".$display_title_task;

// foundation Datepicker include
addDynamicCSS('../lib/js/foundation-datepicker/stylesheets/foundation-datepicker.css');
footerAddJS('../lib/js/foundation-datepicker/js/foundation-datepicker.js');
?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home') ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','workshop')?></a></li>
	<li><span><?php echo formatnavTitle($navtitle); ?></span></li>
</ul>
</div>
<!--end barre haute -->

<script type="text/javascript">
	$(function()
	{
		/** datePicker integration
		---------------------------------------------------*/
		$('.date-pick').fdatepicker({ 
			language: '<?php echo U_L; ?>',
			format: '<?php echo DATE_FORMAT; ?>'
		});

    });
</script>

<?php
if(!isset($integrity) || is_string($integrity)) {
?>
<div class="contentcontainer">
<?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<?php
if(isset($integrity) && is_string($integrity)) display_errors($integrity);
?>
<?php afflinkbar($todo,$id, $lang); ?>
<h2><?php echo _t('workshop','mod_cal'); ?></h2>
<div class="subtitle" id="workshop-subtitle"><?php echo $workshop_denomination; ?></div>

<form id="addtask" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
<p>
  <label for="task">
  <?php echo mb_ucfirst(_t('workshop','task')); ?> : *</label>
  <input name="task" type="text" class="textfield" id="task" maxlength="200" value="<?php echo $form_task; ?>" required />
</p>
<p>
  <label for="task_details">
  <?php echo mb_ucfirst(_t('workshop','task_details')); ?> : *</label>
  <textarea id="task_details" name="task_details" <?php echo AREA_SETTINGS; ?> class="largetextfield" required><?php echo $form_task_details; ?></textarea>
</p>
<p>
  <label for="date"><?php echo mb_ucfirst(_t('workshop','date')); ?> : *</label>
  <input name="date" type="text" maxlength="10" id="date" class="date-pick shorttextfield" value="<?php echo $form_date; ?>" required />
</p>
<div class="label"><?php echo mb_ucfirst(_t('workshop','task_common')); ?> : </div>
<div class="rightpanel"><?php echo $display_common; ?></div>
  <div>
    <input name="task_id" type="hidden" value="<?php echo $task_id; ?>" id="task_id" />
    <input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
    <?php echo cancel_button($link_cancel); ?>
    <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
    <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
    <input name="valider" type="submit"	value="<?php echo _t('btn','valid') ?>" class="button" id="valider" />
  </div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php
// Récapitulatif
} else	{

  if(empty($form_task)) $display_form_task=_t('divers','nc');
  else $display_form_task=formatText($form_task, $text_format);

  if(empty($form_task_details)) $display_form_task_details=_t('divers','nc');
  else $display_form_task_details=formatText($form_task_details, $text_format);

  ?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content"><?php afflinkbar($todo,$id, $lang); ?>
<h2><?php echo _t('recap','title') ?></h2>
<?php
echo "<dl class=\"summary\">\n";
echo "<dt>".mb_ucfirst(_t('workshop','task'))." :</dt>\n";
echo "<dd>". $display_form_task."</dd>\n";
echo "<dt>".mb_ucfirst(_t('workshop','task_details')). " :</dt>\n";
echo "<dd>".$display_form_task_details."</dd>\n";
echo "<dt>".mb_ucfirst(_t('workshop','date'))." :</dt>\n";
echo "<dd>".$form_date."</dd>\n";
echo "<dt>".mb_ucfirst(_t('workshop','task_common'))." :</dt>\n";
echo "<dd>".$display_common."</dd>\n";
echo "</dl>\n";
?>
<form id="addtask" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
  <div>
    <input name="task_id" type="hidden" value="<?php echo $task_id; ?>" id="taskid" />
    <input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
    <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
    <?php echo cancel_button($link_cancel); ?>
    <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
    <input name="data_table" type="hidden" value="<?php echo $table; ?>" id="data_table" />
    <input name="retour" type="button" value="<?php echo _t('btn','preview') ?>" class="button" id="retour" onclick="history.go(-1);" />
    <input name="enregistrer" type="submit" value="<?php echo _t('btn','save') ?>" class="button" id="valider" />
  </div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php } ?>