<?php
/**
 * Workshop module - Delete calendar event page
 * 
 * Delete calendar event page
 * 
 * @package linea21\modules\workshop
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

if(isset($_POST['id']))	$id=$_POST['id'];
if(isset($_GET['id']))	$id=$_GET['id'];

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if ($l21auth->isWorkgroupOrganiser($l21auth->GetSessionElement('id'), $sql_object, $id)<>true && !$l21auth->isSuperAdmin())
ReloadIndex('admin');
////////////

if(isset($_POST['task_id']))	$task_id=$_POST['task_id'];
if(isset($_GET['task_id']))	$task_id=$_GET['task_id'];


$link_add_cal = $rub_link . "&amp;todo=add_cal&amp;id=";
$link_det = $rub_link . "&amp;todo=det&amp;id=";
$link_cancel=$rub_link."&amp;todo=list_cal&amp;id=".$id;

$calendar_object = new calendar;
$req_task=SQL_getOneTask($task_id);
$result_task = $sql_object -> DBSelect($req_task);

// Do record exists?
if(!isset($result_task[0]['workcal_task'])) redirect_to('@module_default');

$display_title_task=formatText($result_task[0]['workcal_task'], '2HTML');

if(isset($_POST['valider'])) {

  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo."&id=".$id;
  $result=$calendar_object->DeleteTask($task_id, $sql_object);
  if($result) header("Location: ".safe_redirect($link_confirm));
  else  system_error();
}

$req_det= SQL_getoneCompleteWorkshop($id);
$result=$sql_object->DBSelect($req_det);

// Do record exists?
if(!isset($result[0]['workshop_denomination'])) redirect_to('@module_default');

$workshop_denomination=FormatText($result[0]['workshop_denomination'], '2HTML');

$navtitle=_t('workshop','sup_cal')." : ". $display_title_task;
$titleh2=$display_title_task." ("._t('workshop','name')." : ".$workshop_denomination.")";
?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home') ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','workshop')?></a></li>
	<li><span><?php echo formatnavTitle($navtitle); ?></span></li>
</ul>
</div>
<!--end barre haute -->

<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content"><?php afflinkbar($todo,$id, $lang); ?>
<h2><?php echo _t('workshop','sup_cal'). ' : '.$display_title_task ; ?></h2>
<div class="subtitle" id="workshop-subtitle"><?php echo $workshop_denomination; ?></div>
<form id="supworkshop" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
	<div class="info">
	<i class="icon-trash"></i>
	<?php echo _t('workshop','sup_cal_warning'); ?>
	</div>
	<div>
		<input name="id" type="hidden" value="<?php echo $id; ?>" />
		<input name="task_id" type="hidden" value="<?php echo $task_id; ?>" />
		<input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
		<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
		<?php echo cancel_button($link_cancel); ?>
		<input name="valider" type="submit" value="<?php echo _t('btn','valid') ?>" class="button" id="valider" />
	</div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->