<?php
/**
 * Workshop report module
 * 
 * Delete given workshop report from back-office
 * 
 * @package linea21\modules\workshoprep
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * 'Workshoprep' (as Workshop Report) module is used by 'Workshop' modules
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////


if(isset($_POST['id']))	$id=$_POST['id'];
if(isset($_GET['id']))	$id=$_GET['id'];

//////////// Check Droits utilisateur ////////////
if (!$l21auth->hasRight('workshop')) ReloadIndex('admin');
if(!$l21auth->isWorkgroupOrganiser($l21auth->GetSessionElement('id'), $sql_object, $id) && !$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////


$req_det= SQL_getoneCompleteWorkshopRep($id);
$result=$sql_object->DBSelect($req_det);

// Do record exists?
if(!isset($result[0]['workrep_title'])) redirect_to('@module_default');

$workrep_title=formatText($result[0]['workrep_title'], '2HTML');
$workrep_workshop_name=formatText($result[0]['workshop_denomination'], '2HTML');
$workshop_title=' ('.$workrep_workshop_name.')';
$work_id=$result[0]['workrep_workshop_id'];


if(isset($_POST['valider'])) {
  $workshop_report_object = new workshop_report;
  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo."&id=".$work_id;
  $result=$workshop_report_object->DeleteWorkshopReport($id, $sql_object);
  if($result) header("Location: ".safe_redirect($link_confirm));
  else  system_error();
}


$rub_link="index.php?rub=workshop";
?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','workshop'); ?></a></li>
	<li><span><?php echo formatnavTitle(_t('workshoprep','sup')." : ". $workrep_title.$workshop_title); ?></span></li>
</ul>
</div>
<!--end barre haute -->

<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content"><?php echo "<h2>".formatTitleh2($workrep_title.$workshop_title)."</h2>"; ?>
<form id="supworkshoprep" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
	<p class="info"><i class="icon-trash"></i> <?php echo _t('divers','sup_confirm'); ?></p>
	<div>
		<input name="id" type="hidden" value="<?php echo $id; ?>" />
		<input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
		<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
		<?php echo cancel_button('javascript:history.go(-1);'); ?>
		<input name="valider" type="submit" value="<?php echo _t('btn','valid') ?>" class="button" id="valider" />
	</div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->