<?php
/**
 * Comment module
 * 
 * Allow user to perform ajax form submission 
 * 
 * @package linea21\modules\comment
 * @author $Author$ - Simon Georget <simon@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

$noplugin = true; // flag for ../config/define.php file
include_once('../config/define.php');

include_once('../admin/mysql.inc.php');
include_once('../class/class.comment.php');
include_once('../languages/' . U_L . '/lang_comment.' . CHARSET . '.php');
include_once('../languages/' . U_L . '/lang_common.' . CHARSET . '.php');
include_once(override('../comment/display.php'));

$arr = array();

$arr['module'] = $o['module'] = $_POST['module'];
if(isset($_POST['file_id'])) {
  $arr['module_id'] = $o['module_id'] = $_POST['file_id'];
  $wgid = $_POST['id'];
} else {
  $arr['module_id'] = $o['module_id'] = $_POST['id'];
}


//////////// Check Droits utilisateur ////////////
if ($arr['module'] == 'files') {
  if(!isset($_SESSION['authenticated'])) die('<p class="error">'._t('divers', 'noauth').'</p>');
  if($wgid != 'shared' && !$l21auth->isWorkgroupUser($wgid, $sql_object)) die('<p class="error">'._t('divers', 'noauth').'</p>');
}
////////////


isset($_SESSION['userlogin']) ? $arr['user_id'] = base64_decode($_SESSION['userid']) : $arr['user_id'] = '0';
isset($_POST['cname']) ? $arr['name'] = $_POST['cname'] : $arr['name'] = '';
isset($_POST['cemail']) ? $arr['email'] = $_POST['cemail'] : $arr['email'] = '';
isset($_POST['curl']) ? $arr['url'] = $_POST['curl'] : $arr['url'] = '';
isset($_POST['cbody']) ? $arr['body'] = $_POST['cbody'] : $arr['body'] = '';
isset($_POST['cnotification']) ? $arr['notification'] = 'Y' : $arr['notification'] = 'N';
if(isset($_POST['parentid'])) $arr['module_pid'] = $_POST['parentid'];

$comm = new comment;

// prevent spam if user not authenticated
if(!isset($_SESSION['authenticated']) && $_SESSION['securityaction']!=md5($_POST['securitycode'])) {
	$passed =_t('security','message');
}

if(!isset($passed)) $passed = $comm->checkDataIntegrity($arr);


if(is_string($passed)) {
  /* Outputting the error messages */
  echo '{"status":0,"errors":{"msg":'.json_encode(formatText($passed, '2FIELD')).'}}';

} else {
  /* we add the new comment */
  $r = $comm->add($arr, $GLOBALS['sql_object']);
  if(!is_numeric($r)) system_error();

  // no email is sent when comment is posted by an administrator
  if(!empty($arr['user_id']) && $arr['user_id'] == $l21auth->GetSessionElement('id') &&  $l21auth->isSuperAdmin()) {
      // we do nothing
  }
  // we send an email to default user for moderation if needed
  else {
      emailModerators($arr, $r, $comm);
  }
   
  // we notify users if needed
  // no notification on 'contribute' module
  if($arr['module'] != 'contribute') {
    notifyUsers($arr, $r, $comm);
  }

  $o['status'] = array('P', 'D');
  $o['given_id'] = $r;

  if($arr['module'] != 'contribute') {
      /* Outputting the markup of the just-inserted comment: */
      echo json_encode(array('status'=>1,'module'=> $arr['module'], 'html'=> getComments($o,  false, false, false)));
  } else {
      echo json_encode(array('status'=>1,'module'=> $arr['module'], 'html'=> _t('comment', 'successful_contrib')));
  }
}

?>