<?php
/**
 * Handle content for publication and workgroup report modules
 * 
 * Set-up module related menu in back-office
 * 
 * @package linea21\modules\content
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * 'Content' module is used by 'Publication' and 'Workshop' modules
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->hasRight('publication') && !$l21auth->hasRight('workshop')) ReloadIndex('admin');
///////////

if($todo=='add') $title=_t('contents','add');
if($todo=='mod') $title=_t('contents','mod');
if($todo=='sup') $title=_t('contents','sup');
if($todo=='det') $title=_t('contents','det');

if($type=='W') $rub_link_back="?rub=workshoprep&amp;todo=det&amp;id=".$parent;
if($type=='P') $rub_link_back="?rub=publication&amp;todo=det&amp;id=".$parent;

if($type=='W') $gback = _t('contents','go_back_W');
if($type=='P') $gback = _t('contents','go_back');
$search="search.php?rub=".$mod_inc;

?>
<div id="itemenu">
	<h1><?php echo $title; ?></h1>
	<div class="contentlink">
		<?php $dispatcher->notify(new sfEvent('secondary_menu', 'admin_contents.menu_start'));?>
		<a href="<?php echo $rub_link_back; ?>"	title="<?php echo $gback._t('contents',$mod_inc.'_type'); ?>"><i class="icon-level-up"></i><?php echo $gback._t('contents',$mod_inc.'_type'); ?></a>
		<a href="<?php echo $search; ?>"	title="<?php echo _t('menu','search');?>"><i class="icon-search"></i><?php echo _t('menu','search');?></a>
		<?php $dispatcher->notify(new sfEvent('secondary_menu', 'admin_contents.menu_end'));?>
	</div>
</div>