<?php
/**
 * Dashboard module
 * 
 * Back-office UI to generate PDF and Word reports 
 * 
 * @package linea21\modules\dashboard
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

// ////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
// //////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->hasRight('dashboard')) ReloadIndex('admin');
////////////

include_once("../lib/input_helpers.php");
include_once(override('../level/display.php', THEME_ADMIN_PATH));

$levels = $sql_object->DBSelect(SQL_getLevelsList());
$sdi_object = new sdi;

$sdi = $sql_object->DBSelect(SQL_getListSdi("R", 0));
$sdi = add_root_level($sdi, 'sdii_level', 'level_root'); // we add extra field with level root

$finalities = $sql_object->DBSelect(SQL_getLevelsList(true));

$excludes = array('excel', 'csv', 'json', 'png');
$select_format = selectBox($lang['export']['format'], "format_report", strtolower($lang['export']['format']['pdf']), null, $excludes);

/**
 * DEBUG_informations
 * to access debug informations
 * uncomment code and change the value
 * of form action to post data
 * on the same page
 */
/**
 if (isset($_POST['valider'])) {
 if (isset($_POST['graphic'])) $graphic = 1;
 else $graphic = 'N';

 if (isset($_POST['table_value'])) $table_value = $_POST['table_value'];
 else $table_value = 'non';

 if (isset($_POST['notpublished'])) $notpublished = $_POST['notpublished'];
 else $notpublished = 'N';

 if (isset($_POST['provider'])) $provider = $_POST['provider'];
 else $provider = 'N';

 if (isset($_POST['reglementation'])) $reglementation = $_POST['reglementation'];
 else $reglementation = 'N';

 if (isset($_POST['evaluation'])) $evaluation = $_POST['evaluation'];
 else $evaluation = 'N';

 if ($_POST['scale']=='det')
 {
 print_r($_POST['eachscale']);
 }
 else echo "scale ALL<br>\n";

 if ($_POST['sdi']=='det')
 {
 while (list(, $value) = each ($_POST['eachsdi'])) {
 echo "sdi Valeur: $value<br>\n";
 }
 }
 else echo "sdi ALL<br>\n";


 $report_title = $_POST['title_report'];
 $report_author = $_POST['author'];
 $report_mail = $_POST['mail_author'];
 $report_service = $_POST['service_author'];
 $report_adress = $_POST['adresse_author'];

 echo "<br />" . $graphic;
 echo "<br />" . $table_value;
 echo "<br />" . $notpublished;
 echo "<br />" . $provider;
 echo "<br />" . $reglementation;
 echo "<br />" . $evaluation;
 echo "<br />" . $report_title;
 echo "<br />" . $report_author;
 echo "<br />" . $report_mail;
 echo "<br />" . $report_service;
 echo "<br />" . $report_adress;
 echo "<br />" . $_POST['scale'];
 echo "<br />" . $_POST['sdi'];
 }
 */

if (!isset($_REQUEST['scale_id'])) {
  $scale_id = 1;
} else {
  $scale_id = $_REQUEST['scale_id'];
}

// Finalities filter
$finalities_filter = '<div class="dashboard-filter" id="by-finalities">';
$finalities_filter .= '<h4>'._t('report','select_by_finalities').'</h4>';

$js = '';

foreach ($finalities as $finality) {

	$finalities_filter .= '<a href="#" id="filter-finality-'.$finality['level_id'].'" /><i class="icon-cancel"></i>'. formatText($finality['level_name'], '2HTML'). '</a> ';

	$js .= "$('#filter-finality-".$finality['level_id']."').click(function() {

						if($(this).hasClass('selected')) {
							$('li.finality-".$finality['level_id']." > input:checkbox').prop('checked', false);
							$(this).find('i').replaceWith('<i class=\"icon-cancel\"></i>');
							$(this).removeClass('selected');
						} else {
							$('li.finality-".$finality['level_id']." > input:checkbox').prop('checked', true);
							$(this).find('i').replaceWith('<i class=\"icon-ok\"></i>');
							$(this).addClass('selected');
						}

						return false;

					});";


}
$finalities_filter .= '</div >';

footerAddInlineJS($js);

// Attached to dashboard filter
// Finalities filter
$attached_filter = '<div class="dashboard-filter" id="by-association">';
$attached_filter .= '<h4>'._t('report','select_by_association').'</h4>';
$attached_filter .= '<a href="#" id="filter-attached" /><i class="icon-cancel"></i>'. _t('report','indicator-attached'). '</a> ';
$attached_filter .= '<a href="#" id="filter-not-attached" /><i class="icon-cancel"></i>'. _t('report','indicator-not-attached'). '</a>';
$attached_filter .= '</div >';


	$js = "$('#filter-attached').click(function() {

						if($(this).hasClass('selected')) {
							$('li.attached-to-dashboard > input:checkbox').prop('checked', false);
							$(this).find('i').replaceWith('<i class=\"icon-cancel\"></i>');
							$(this).removeClass('selected');
						} else {
							$('li.attached-to-dashboard > input:checkbox').prop('checked', true);
							$(this).find('i').replaceWith('<i class=\"icon-ok\"></i>');
							$(this).addClass('selected');
						}
			
					return false;
			
					});

					$('#filter-not-attached').click(function() {

						if($(this).hasClass('selected')) {
							$('li.not-attached-to-dashboard > input:checkbox').prop('checked', false);
							$(this).find('i').replaceWith('<i class=\"icon-cancel\"></i>');
							$(this).removeClass('selected');
						} else {
							$('li.not-attached-to-dashboard > input:checkbox').prop('checked', true);
							$(this).find('i').replaceWith('<i class=\"icon-ok\"></i>');
							$(this).addClass('selected');
						}

					return false;

					});

	";

footerAddInlineJS($js);


$listing = "";
// affichage liste échelle
$resultscale = $sql_object->DBSelect($req_list_scale);
$listing .= "<div class=\"mtm\"><h2>" . _t('report','scale_choice') . "</h2></div>";

$listing .= "<div class=\"contboxgray\"><ul>\n";
$listing .= "\t<li>\n";
$listing .= "<input type=\"radio\" name=\"scale\" value=\"all\" checked=\"checked\" id=\"scale_all\" /><label for=\"scale_all\" class=\"autowidth\">" . _t('report','scale_all') . "</label>\n";
$listing .= "<br /><input type=\"radio\" name=\"scale\" value=\"det\" id=\"scale_det\"  /><label for=\"scale_det\" class=\"autowidth\">" . _t('report','scale_det') . " </label>\n";
$listing .= "\t</li></ul>\n";
$listing .= "</div>\n";

$listing .= "<div class=\"contboxwhite\" id=\"display_scale\" style=\"display:none;\">\n";
$listing .= "<ul>\n";
for ($i = 0;$i < count($resultscale);$i++) {
  $listing .= "\t<li>\n";
  $listing .= "<input type=\"checkbox\" name=\"eachscale[]\" id=\"eachscale" . $resultscale[$i]['scale_id'] . "\" value=\"" . $resultscale[$i]['scale_id'] . "\" />
			<label for=\"eachscale" . $resultscale[$i]['scale_id'] . "\" class=\"autowidth\">" . formatText($resultscale[$i]['scale_denomination'], '2HTML') . "</label>\n";
  $listing .= "\t</li>\n";
}
$listing .= "</ul>\n";
$listing .= "</div>\n";

$js = "$('#scale_all').click(function() {
						$('#display_scale').slideUp();
					});
					$('#scale_det').click(function() {
						$('#display_scale').slideDown();
				});";

footerAddInlineJS($js);


// affichage liste indicateur en fonction des niveaux
$listing .= "<div class=\"mtm\"><h2>" . _t('report','sdi_choice') . "</h2></div>";

$listing .= "<div class=\"contboxgray\">\n";

$listing .= "\t<ul><li>\n";
$listing .= "<input type=\"radio\" name=\"sdi\" value=\"all\" checked=\"checked\" id=\"sdi_all\"/><label for=\"sdi_all\" class=\"autowidth\">" . _t('report','sdi_all') . "</label>\n";
$listing .= "<br /><input type=\"radio\" name=\"sdi\" value=\"det\"   id=\"sdi_det\" /><label for=\"sdi_det\" class=\"autowidth\">" . _t('report','sdi_det') . "</label>\n";
if(isset($_SESSION['indicator_export_ids'])) $listing .= sprintf('<span class="session-stored-notice">('._t('dashboard', 'session-stored').')</span>', count($_SESSION['indicator_export_ids']) );
$listing .= "\t</li></ul>\n";
$listing .= "</div>\n";

$listing .= "<div class=\"contboxwhite\" id=\"display_sdi\" style=\"display:none;\">\n";
$listing .= "<div id=\"select-indicators\">\n";
$listing .= "<h3>" . _t('common', 'select') . " : </h3>";
$listing .= $attached_filter;
$listing .= $finalities_filter;
$listing .= "</div>\n";
$listing .= "<ul>\n";

$a = array(); // do not display twice an indicator

for ($i = 0;$i < count($levels);$i++) {
  for ($j = 0;$j < count($sdi);$j++) {
    if ($levels[$i]['level_id'] == $sdi[$j]['sdii_level']  && !in_array($sdi[$j]['sdii_id'], $a)) {
    	if($sdi[$j]['sdii_to_dashboard'] == 'Y') {
    		$todashboard_class = 'attached-to-dashboard';
    	} else {
    		$todashboard_class = 'not-attached-to-dashboard';
    	}
      $listing .= "\t<li class=\"finality-".$sdi[$j]['level_root']." ".$todashboard_class." "."level-".$levels[$i]['level_id']."\">\n";
      $listing .= "<input type=\"checkbox\" name=\"eachsdi[]\" id=\"eachsdi" . $sdi[$j]['sdii_id'] . "\" value=\"" . $sdi[$j]['sdii_id'] . "\" /><label for=\"eachsdi" . $sdi[$j]['sdii_id'] . "\" class=\"autowidth\">" . formatText($sdi[$j]['sdii_name'], '2HTML') . "</label>\n";
      if ($sdi[$j]['sdii_statut'] == 'D') $listing .= "<span class=\"state\"> / " . _t('statut','draft') . "</span>\n";
      if ($sdi[$j]['sdii_to_dashboard'] == 'N') $listing .= "<span class=\"state\"> / " . _t('sdi','not_attached_to_dashboard') . "</span>\n";
      $listing .= "\t</li>\n";

      array_push($a, $sdi[$j]['sdii_id']); // we add the id into array for not displaying it twice
    }
  }
}
$listing .= "</ul>\n";
$listing .= "</div>\n";

$js = "$('#sdi_all').click(function() {
					$('#display_sdi').slideUp();
				});
				$('#sdi_det').click(function() {
					$('#display_sdi').slideDown();
				});";

footerAddInlineJS($js);


// affichage liste infos
$listing .= "<div class=\"mtm\"><h2>" . _t('report','comp_choice') . "</h2></div>";
$listing .= "<div class=\"contboxgray\">\n";
$listing .= "\t<ul><li>\n";


$listing .= "<input type=\"checkbox\" name=\"levels_chapters\" id=\"levels_chapters\" checked=\"checked\" />
			<label for=\"levels_chapters\" class=\"autowidth\">" . _t('report','levels-as-chapters') . "</label>\n";
$listing .= "\t</li>\n";
$listing .= "\t<li>\n";

$listing .= "<input type=\"checkbox\" name=\"firstlevel_description\" id=\"firstlevel_description\" checked=\"checked\" />
			<label for=\"firstlevel_description\" class=\"autowidth\">" . _t('report','first-level-description') . "</label>\n";
$listing .= "\t</li>\n";
$listing .= "\t<li>\n";

$listing .= "<input type=\"checkbox\" name=\"empty_levels\" id=\"empty_levels\" checked=\"checked\" />
			<label for=\"empty_levels\" class=\"autowidth\">" . _t('report','empty-levels') . "</label>\n";
$listing .= "\t</li>\n";
$listing .= "\t<li>\n";

$listing .= "<input type=\"checkbox\" name=\"graphic\" id=\"graphic\" checked=\"checked\" />
			<label for=\"graphic\" class=\"autowidth\">" . _t('report','graph_values') . "</label>\n";
$listing .= "\t</li>\n";
$listing .= "\t<li>\n";
$listing .= "<input type=\"checkbox\" name=\"table_value\" id=\"table_value\" checked=\"checked\" />
			<label for=\"table_value\" class=\"autowidth\">" . _t('report','table_values') . "</label>\n";
$listing .= "\t</li>\n";
$listing .= "\t<li>\n";
$listing .= "<input type=\"checkbox\" name=\"notpublished\" id=\"notpublished\" checked=\"checked\" />
			<label for=\"notpublished\" class=\"autowidth\">" . _t('report','notpublished_values') . "</label>\n";
$listing .= "\t</li>\n";
$listing .= "\t<li>\n";
$listing .= "<input type=\"checkbox\" name=\"provider\" id=\"provider\" checked=\"checked\" />
			<label for=\"provider\" class=\"autowidth\">" . _t('report','provider_info') . "</label>\n";
$listing .= "\t</li>\n";
$listing .= "\t<li>\n";
$listing .= "<input type=\"checkbox\" name=\"reglementation\" id=\"reglementation\" checked=\"checked\" />
			<label for=\"reglementation\" class=\"autowidth\">" . _t('report','rules_info') . "</label>\n";
$listing .= "\t</li>\n";
$listing .= "\t<li>\n";
$listing .= "<input type=\"checkbox\" name=\"evaluation\" id=\"evaluation\" checked=\"checked\" />
			<label for=\"evaluation\" class=\"autowidth\">" . _t('report','eval_info') . "</label>\n";
$listing .= "\t</li>\n";
$listing .= "\t<li>\n";
$listing .= "<input type=\"checkbox\" name=\"summary\" id=\"summary\" checked=\"checked\" />
			<label for=\"summary\" class=\"autowidth\">" . _t('report','summary_info') . "</label>\n";
$listing .= "\t</li>\n";
$listing .= "\t<li>\n";
$listing .= "<input type=\"checkbox\" name=\"publi_info\" id=\"publi_info\" checked=\"checked\" />
			<label for=\"publi_info\" class=\"autowidth\">" . _t('report','publi_info') . "</label>\n";
$listing .= "\t</li>\n";
$listing .= "\t</ul>\n";
$listing .= "</div>\n";



// if there is as selection stoed in session
if(isset($_SESSION['indicator_export_ids'])) {
    
    $js = ' var actives = '. json_encode($_SESSION["indicator_export_ids"]) . ';
			$("#sdi_det").click();
			$("input:checkbox[name=\'eachsdi[]\']").each(function() {
        
				// if in array we check input
				if($.inArray( $(this).val().toString(), actives) != -1) $(this).prop("checked", true);
        
			})';
    
    footerAddInlineJS($js);
}
?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','dashboard'); ?></a></li>
	<li><span><?php echo _t('dashboard','rap'); ?></span></li>
</ul>
</div>
<!--end barre haute -->

<div class="contentcontainer"><?php include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
  <h2><?php echo _t('dashboard','rap'); ?></h2>
  <form id="addrap" action="../export/report.php" method="post">
  <p>
    <label for="title_report"><?php echo mb_ucfirst(_t('report','title')); ?> : </label>
    <input name="title_report" type="text" class="textfield" id="title_report" maxlength="255" value="" />
   </p>
  <p>
    <label for="author"><?php echo mb_ucfirst(_t('report','author')); ?> : </label>
    <input name="author" type="text" class="textfield" id="author" maxlength="255" value="" />
  </p>
  <p>
    <label for="mail_author"><?php echo mb_ucfirst(_t('report','mail_author'));?> : </label>
    <input name="mail_author" type="text" class="textfield"	id="mail_author" maxlength="255" value="" />
  </p>
  <p>
    <label for="service_author"><?php echo mb_ucfirst(_t('report','service')); ?> : </label>
    <input name="service_author" type="text" class="textfield" id="service_author" maxlength="255" value="" />
  </p>
  <p>
    <label for="adress_author"><?php echo mb_ucfirst(_t('report','address')); ?> : </label>
    <textarea id="adress_author" name="adress_author" class="no-wysiwyg" <?php echo AREA_SETTINGS; ?>></textarea>
  </p>
  <p>
  	<label for="format_report"><?php echo mb_ucfirst(_t('export','output_format')) ?> : </label>
  	<?php echo $select_format; ?>
  </p>
  <?php
  echo $listing;
  ?>
  <div>
  	<input name="what" type="hidden" value="dashboard" />
    <input name="annuler" type="button" value="<?php echo _t('btn','annul'); ?>" onclick="window.location='javascript:history.go(-1);'" class="button" id="annuler" />
    <input name="sauver" type="submit" value="<?php echo _t('report','save') ; ?>" class="button" id="sauver" />
  </div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->