// called to test if thresholds must be visible or not
// if it contains NaN values, display is not correct
Array.prototype.containsNaN = function() {

    for(var i = 1; i < this.length; i++)
    {
        if(isNaN(this[i]))
            return false;
    }

    return true;
} 

// called to test if thresholds contains
// only null or others values (numbers)

Array.prototype.isLegendVisible = function() {
	
    for(var i = 1; i < this.length; i++)
    {
		// here we have a number, legend must be visible
		if(this[i] !== null) return true;
    }
    return false;
}

$( document ).ready(function() {
	
	// to change color palette
		if(input["indicator-colors"] !== undefined ) {
			// console.log('indicator-colors is passed !');
			Highcharts.setOptions({
			 colors: input['indicator-colors']
		});
		}
	
	// no title, we reduce margin top to maximize chart canvas
	if(input['indicator-notitle'] === 1) {
		tmargin = 40;
		chart_title = null;
		chart_subtitle = null;
	} else {
		tmargin = 120;
		
		if(input['indicator-wanted-vis']  === 'pie' || input['indicator-wanted-vis']  === 'donut'  || input['indicator-wanted-vis']  === 'treemap') chart_title = input['indicator-name'] + ' ' +   input['indicator-wanted-year'];
		else chart_title = input['indicator-name'];
		if(input['indicator-wanted-vis']  === 'pie' || input['indicator-wanted-vis']  === 'donut'  || input['indicator-wanted-vis']  === 'treemap') chart_subtitle = input['indicator-unit'] + ' ' + input['indicator-negative-notice'] ;
	}

	if(input['site-language'] == 'fr') {
		Highcharts.setOptions({
			lang: {
				decimalPoint: ',',
				thousandsSep: ' '
			}
		});
	}
	// console.log("indicator type : " + input['indicator-type']);
	// console.log("wanted vis : " + input['indicator-wanted-vis']);
	// console.log("Default vis : " + input['indicator-default-vis']);
	if(input['indicator-wanted-vis'] === 'line') input['indicator-wanted-vis'] = 'spline';
	
	/** We must populate the chart 
	*	We get values from array
	*/
	var dates = [];
	var thresholds = [];
	var values = [];
	
	// console.log('thresholds : ');
	// console.log(input['thresholds']);

	if(input['indicator-type']  === 'unique') {
		
		if(input["indicator-colors"] !== undefined ) {
			dataColor = input["indicator-colors"][0];
			thresholdColor = input["indicator-colors"][1];
		} else {
			dataColor = '#95CEFF';
			thresholdColor = Highcharts.getOptions().colors[3];
		}
		
		// console.log(input['data']);
		// console.log(input['dates']);
		// console.log(input['thresholds']);
		
		// see api : http://api.highcharts.com/highcharts
		$('#main-chart-container').highcharts({

			title: {
				text: chart_title,
				align: 'left',
				style:  { "color": "#777777" }
			},
			legend: {
				align: 'right',
				verticalAlign: 'top',
				layout: 'horizontal',
				x: -30,
				y: 0
			},
			chart: {
				type: 'column',
				// margin: 75,
				marginTop: tmargin
			},
			credits: false,
			xAxis: {
				categories: input['dates'].reverse()
			},
			yAxis: {
				title: {
					text: input['indicator-unit']
				}
			},
			labels: {
				items: [{
				   // html: '<?php echo $result_sdii[0]['sdii_name']; ?>',
					style: {
						left: '50px',
						top: '18px',
						color: (Highcharts.theme && Highcharts.theme.textColor) || 'black'
					}
				}]
			},
			tooltip: {
				headerFormat: '<b>{series.name}</b><br/>',
				pointFormat: '{point.y}',
			},
		    responsive: {
		        rules: [{
		            condition: {
		                maxWidth: 500
		            },
		            chartOptions: {
		                legend: {
		                    align: 'center',
		                    verticalAlign: 'bottom',
		                    layout: 'horizontal'
		                },
		                yAxis: {
		                    labels: {
		                        align: 'left',
		                        x: 0,
		                        y: -5
		                    },
		                },
		                title: {
		                    text: null
		                }
		            }
		        }]
		    },
			series: [{
				type: input['indicator-wanted-vis'],
				name: input['indicator-serie-name'],
				data: input['data'].reverse(),
				color: dataColor
			}, {
				type: 'spline',
				name: input['indicator-threshold-name'],
				data: input['thresholds'].reverse(),
				color: thresholdColor,
				dashStyle: 'ShortDot',
				showInLegend: input['thresholds'].isLegendVisible(),  
				visible: input['thresholds'].containsNaN(),
				marker: {
					lineWidth: 2,
					lineColor: Highcharts.getOptions().colors[3],
					fillColor: 'white'
				}
			}]
		});
    
	} // closing input['indicator-type']  === 'unique' test
	
	// we check input['indicator-type']  === 'multiple' AND input['indicator-wanted-year'] IS NULL
	if(input['indicator-type']  === 'multiple' && input['indicator-wanted-year'] == null) {
			
		// console.log(input['data']);
		// console.log(input['dates']);
		// console.log(input['thresholds']);
		
		var jsonObj = JSON.parse(input['data']);
		//	console.log(jsonObj);

		
		// finally we add threshold as spline
		if(input['thresholds'].length > 0) {
			item = {}
			marker = {}
			marker ['lineWidth'] = 2;
			marker ['lineColor'] = Highcharts.getOptions().colors[3];
			marker ['fillColor'] = 'white';
			item ["type"] = 'spline';
			item ["name"] = input['indicator-threshold-name'];
			item ["data"] = input['thresholds'].reverse();
			item ["color"] = Highcharts.getOptions().colors[3];
			item ["dashStyle"] = 'ShortDot';
			item ["marker"] = marker;
			item ["showInLegend"] = input['thresholds'].isLegendVisible();  
			jsonObj.push(item);
		}

		
		// see api : http://api.highcharts.com/highcharts
		$('#main-chart-container').highcharts({
			title: {
				text: chart_title,
				align: 'center',
				style:  { "color": "#777777" }
			},
			legend: {
				align: 'right',
				verticalAlign: 'top',
				layout: 'horizontal',
				// x: -100,
				y: 0
			},
			chart: {
				type: 'column',
				// margin: 75,
				marginTop: tmargin,
			},
			credits: false,
			xAxis: {
				categories: input['dates'].reverse()
			},
			yAxis: {
				title: {
					text: input['indicator-unit']
				},
				stackLabels: {
					enabled: true,
					style: {
						fontWeight: 'bold',
						color: (Highcharts.theme && Highcharts.theme.textColor) || 'gray'
					}
				}
			},
			responsive: {
		        rules: [{
		            condition: {
		                maxWidth: 600
		            },
		            chartOptions: {
		                legend: {
		                    align: 'center',
		                    verticalAlign: 'bottom',
		                    layout: 'horizontal'
		                },
		                yAxis: {
		                    labels: {
		                        align: 'left',
		                        x: 0,
		                        y: -5
		                    },
		                }
		            }
		        },
		        {
		            condition: {
		                maxWidth: 500
		            },
		            chartOptions: {
		                legend: {
		                    enabled: false
		                }
		            }
		        }]
		    },
			plotOptions: {
				column: {
					stacking: 'normal', // 'percent'
					dataLabels: {
						enabled: true,
						color: (Highcharts.theme && Highcharts.theme.dataLabelsColor) || 'white',
						style: {
							textShadow: 'none'
						}
					}
				}
			},
			tooltip: {
				headerFormat: '<b>{point.x}</b><br/>',
				pointFormat: '{series.name}: {point.y} ({point.percentage:,.2f} %)',
				// valueDecimals: 2
			},
			series: jsonObj
		});
	} // closing input['indicator-type']  === 'multiple' test opening around line 160
	
	
	// Generate Pie charts for a given year
		if(input['indicator-wanted-vis']  === 'pie' && input['indicator-wanted-year'] !== null) {

			if (typeof input['vis-pie-size'] !== 'undefined') var userInnerSize = input['vis-pie-size'];
			else var userInnerSize = '0%';
			
		 // console.log(input['data']);
			
		 $('#main-chart-container').highcharts({
			chart: {
				type: 'pie',
			},
			credits: false,
			title: {
				text: chart_title
			},
			subtitle: {
				text: chart_subtitle
			},
			tooltip: {
				pointFormat: '<b>{series.name}</b> : {point.y} ({point.percentage:,.2f} %)'
			},
			plotOptions: {
				pie: {
					allowPointSelect: true,
					cursor: 'pointer',
					depth: 35,
					dataLabels: {
						enabled: true,
						format: '{point.name}<br /><span style="color:#8C8C8C">{point.percentage:,.2f} %</span>',
						style: {
							textShadow: 'none'
		                }
					}
				}
			},
			responsive: {
				rules: [{
				      condition: {
				        maxWidth: 600
				      },
				      chartOptions: {
				        plotOptions: {
				          pie: {
				            dataLabels: {
				              enabled: false
				            }
				          }
				        }
				      }
				    }]
		    },
			series: [{
				type: 'pie',
				innerSize: userInnerSize,
				name: input['indicator-unit'],
				data: input['data']
			}]
		});
		
		return false;
		
    }  // closing input['indicator-wanted-vis']  === 'pie' test
		
		
		// Generate treemap charts for a given year
		if(input['indicator-wanted-vis']  === 'treemap' && input['indicator-wanted-year'] !== null) {
			
			var jsonObj = JSON.parse(input['data']);

			$('#main-chart-container').highcharts({
				
				colorAxis: {
		            // minColor: '#D9B1EF',
		            // minColor: '#FFBC75',
		            minColor: input['color1'],
		            // maxColor: '#AE69D3' //Highcharts.getOptions().colors[0]
		            // maxColor: '#EA9C4D' 
		            maxColor: input['color2']
		        },
		        credits: false,
		        series: [{
		            type: 'treemap',
		            layoutAlgorithm: 'squarified',
		            data: jsonObj,
		            dataLabels: {
		            	enabled: true,
		                style: {
		                	textOutline: 'none'
		                }
		            }
		        }],
		        legend: {
		            enabled: false
		        },
		        tooltip: {
		            pointFormat: '<b>{point.name}</b> : {point.value} ' + input['indicator-unit']
		        },
		        subtitle: {
		            text: chart_subtitle
		        },
		        title: {
		            text: chart_title
		        }
		    });
	}  // closing input['indicator-wanted-vis']  === 'treemap' test
		
		
});