# Function list by name

## A

Excel Function           | Category                       | PhpSpreadsheet Function
-------------------------|--------------------------------|--------------------------------------
ABS                      | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Absolute::evaluate
ACCRINT                  | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\Securities\AccruedInterest::periodic
ACCRINTM                 | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\Securities\AccruedInterest::atMaturity
ACOS                     | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Trig\Cosine::acos
ACOSH                    | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Trig\Cosine::acosh
ACOT                     | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Trig\Cotangent::acot
ACOTH                    | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Trig\Cotangent::acoth
ADDRESS                  | CATEGORY_LOOKUP_AND_REFERENCE  | \PhpOffice\PhpSpreadsheet\Calculation\LookupRef\Address::cell
AGGREGATE                | CATEGORY_MATH_AND_TRIG         | **Not yet Implemented**
AMORDEGRC                | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\Amortization::AMORDEGRC
AMORLINC                 | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\Amortization::AMORLINC
AND                      | CATEGORY_LOGICAL               | \PhpOffice\PhpSpreadsheet\Calculation\Logical\Operations::logicalAnd
ARABIC                   | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Arabic::evaluate
AREAS                    | CATEGORY_LOOKUP_AND_REFERENCE  | **Not yet Implemented**
ASC                      | CATEGORY_TEXT_AND_DATA         | **Not yet Implemented**
ASIN                     | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Trig\Sine::asin
ASINH                    | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Trig\Sine::asinh
ATAN                     | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Trig\Tangent::atan
ATAN2                    | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Trig\Tangent::atan2
ATANH                    | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Trig\Tangent::atanh
AVEDEV                   | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Averages::averageDeviations
AVERAGE                  | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Averages::average
AVERAGEA                 | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Averages::averageA
AVERAGEIF                | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Conditional::AVERAGEIF
AVERAGEIFS               | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Conditional::AVERAGEIFS

## B

Excel Function           | Category                       | PhpSpreadsheet Function
-------------------------|--------------------------------|--------------------------------------
BAHTTEXT                 | CATEGORY_TEXT_AND_DATA         | **Not yet Implemented**
BASE                     | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Base::evaluate
BESSELI                  | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\BesselI::BESSELI
BESSELJ                  | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\BesselJ::BESSELJ
BESSELK                  | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\BesselK::BESSELK
BESSELY                  | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\BesselY::BESSELY
BETA.DIST                | CATEGORY_STATISTICAL           | **Not yet Implemented**
BETA.INV                 | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\Beta::inverse
BETADIST                 | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\Beta::distribution
BETAINV                  | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\Beta::inverse
BIN2DEC                  | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\ConvertBinary::toDecimal
BIN2HEX                  | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\ConvertBinary::toHex
BIN2OCT                  | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\ConvertBinary::toOctal
BINOM.DIST               | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\Binomial::distribution
BINOM.DIST.RANGE         | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\Binomial::range
BINOM.INV                | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\Binomial::inverse
BINOMDIST                | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\Binomial::distribution
BITAND                   | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\BitWise::BITAND
BITLSHIFT                | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\BitWise::BITLSHIFT
BITOR                    | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\BitWise::BITOR
BITRSHIFT                | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\BitWise::BITRSHIFT
BITXOR                   | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\BitWise::BITXOR

## C

Excel Function           | Category                       | PhpSpreadsheet Function
-------------------------|--------------------------------|--------------------------------------
CEILING                  | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Ceiling::ceiling
CEILING.MATH             | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Ceiling::math
CEILING.PRECISE          | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Ceiling::precise
CELL                     | CATEGORY_INFORMATION           | **Not yet Implemented**
CHAR                     | CATEGORY_TEXT_AND_DATA         | \PhpOffice\PhpSpreadsheet\Calculation\TextData\CharacterConvert::character
CHIDIST                  | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\ChiSquared::distributionRightTail
CHIINV                   | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\ChiSquared::inverseRightTail
CHISQ.DIST               | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\ChiSquared::distributionLeftTail
CHISQ.DIST.RT            | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\ChiSquared::distributionRightTail
CHISQ.INV                | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\ChiSquared::inverseLeftTail
CHISQ.INV.RT             | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\ChiSquared::inverseRightTail
CHISQ.TEST               | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\ChiSquared::test
CHITEST                  | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\ChiSquared::test
CHOOSE                   | CATEGORY_LOOKUP_AND_REFERENCE  | \PhpOffice\PhpSpreadsheet\Calculation\LookupRef\Selection::CHOOSE
CLEAN                    | CATEGORY_TEXT_AND_DATA         | \PhpOffice\PhpSpreadsheet\Calculation\TextData\Trim::nonPrintable
CODE                     | CATEGORY_TEXT_AND_DATA         | \PhpOffice\PhpSpreadsheet\Calculation\TextData\CharacterConvert::code
COLUMN                   | CATEGORY_LOOKUP_AND_REFERENCE  | \PhpOffice\PhpSpreadsheet\Calculation\LookupRef\RowColumnInformation::COLUMN
COLUMNS                  | CATEGORY_LOOKUP_AND_REFERENCE  | \PhpOffice\PhpSpreadsheet\Calculation\LookupRef\RowColumnInformation::COLUMNS
COMBIN                   | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Combinations::withoutRepetition
COMBINA                  | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Combinations::withRepetition
COMPLEX                  | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\Complex::COMPLEX
CONCAT                   | CATEGORY_TEXT_AND_DATA         | \PhpOffice\PhpSpreadsheet\Calculation\TextData\Concatenate::CONCATENATE
CONCATENATE              | CATEGORY_TEXT_AND_DATA         | \PhpOffice\PhpSpreadsheet\Calculation\TextData\Concatenate::CONCATENATE
CONFIDENCE               | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Confidence::CONFIDENCE
CONFIDENCE.NORM          | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Confidence::CONFIDENCE
CONFIDENCE.T             | CATEGORY_STATISTICAL           | **Not yet Implemented**
CONVERT                  | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\ConvertUOM::CONVERT
CORREL                   | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Trends::CORREL
COS                      | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Trig\Cosine::cos
COSH                     | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Trig\Cosine::cosh
COT                      | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Trig\Cotangent::cot
COTH                     | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Trig\Cotangent::coth
COUNT                    | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Counts::COUNT
COUNTA                   | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Counts::COUNTA
COUNTBLANK               | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Counts::COUNTBLANK
COUNTIF                  | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Conditional::COUNTIF
COUNTIFS                 | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Conditional::COUNTIFS
COUPDAYBS                | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\Coupons::COUPDAYBS
COUPDAYS                 | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\Coupons::COUPDAYS
COUPDAYSNC               | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\Coupons::COUPDAYSNC
COUPNCD                  | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\Coupons::COUPNCD
COUPNUM                  | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\Coupons::COUPNUM
COUPPCD                  | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\Coupons::COUPPCD
COVAR                    | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Trends::COVAR
COVARIANCE.P             | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Trends::COVAR
COVARIANCE.S             | CATEGORY_STATISTICAL           | **Not yet Implemented**
CRITBINOM                | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\Binomial::inverse
CSC                      | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Trig\Cosecant::csc
CSCH                     | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Trig\Cosecant::csch
CUBEKPIMEMBER            | CATEGORY_CUBE                  | **Not yet Implemented**
CUBEMEMBER               | CATEGORY_CUBE                  | **Not yet Implemented**
CUBEMEMBERPROPERTY       | CATEGORY_CUBE                  | **Not yet Implemented**
CUBERANKEDMEMBER         | CATEGORY_CUBE                  | **Not yet Implemented**
CUBESET                  | CATEGORY_CUBE                  | **Not yet Implemented**
CUBESETCOUNT             | CATEGORY_CUBE                  | **Not yet Implemented**
CUBEVALUE                | CATEGORY_CUBE                  | **Not yet Implemented**
CUMIPMT                  | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\CashFlow\Constant\Periodic\Cumulative::interest
CUMPRINC                 | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\CashFlow\Constant\Periodic\Cumulative::principal

## D

Excel Function           | Category                       | PhpSpreadsheet Function
-------------------------|--------------------------------|--------------------------------------
DATE                     | CATEGORY_DATE_AND_TIME         | \PhpOffice\PhpSpreadsheet\Calculation\DateTimeExcel\Date::fromYMD
DATEDIF                  | CATEGORY_DATE_AND_TIME         | \PhpOffice\PhpSpreadsheet\Calculation\DateTimeExcel\Difference::interval
DATEVALUE                | CATEGORY_DATE_AND_TIME         | \PhpOffice\PhpSpreadsheet\Calculation\DateTimeExcel\DateValue::fromString
DAVERAGE                 | CATEGORY_DATABASE              | \PhpOffice\PhpSpreadsheet\Calculation\Database\DAverage::evaluate
DAY                      | CATEGORY_DATE_AND_TIME         | \PhpOffice\PhpSpreadsheet\Calculation\DateTimeExcel\DateParts::day
DAYS                     | CATEGORY_DATE_AND_TIME         | \PhpOffice\PhpSpreadsheet\Calculation\DateTimeExcel\Days::between
DAYS360                  | CATEGORY_DATE_AND_TIME         | \PhpOffice\PhpSpreadsheet\Calculation\DateTimeExcel\Days360::between
DB                       | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\Depreciation::DB
DBCS                     | CATEGORY_TEXT_AND_DATA         | **Not yet Implemented**
DCOUNT                   | CATEGORY_DATABASE              | \PhpOffice\PhpSpreadsheet\Calculation\Database\DCount::evaluate
DCOUNTA                  | CATEGORY_DATABASE              | \PhpOffice\PhpSpreadsheet\Calculation\Database\DCountA::evaluate
DDB                      | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\Depreciation::DDB
DEC2BIN                  | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\ConvertDecimal::toBinary
DEC2HEX                  | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\ConvertDecimal::toHex
DEC2OCT                  | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\ConvertDecimal::toOctal
DECIMAL                  | CATEGORY_MATH_AND_TRIG         | **Not yet Implemented**
DEGREES                  | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Angle::toDegrees
DELTA                    | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\Compare::DELTA
DEVSQ                    | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Deviations::sumSquares
DGET                     | CATEGORY_DATABASE              | \PhpOffice\PhpSpreadsheet\Calculation\Database\DGet::evaluate
DISC                     | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\Securities\Rates::discount
DMAX                     | CATEGORY_DATABASE              | \PhpOffice\PhpSpreadsheet\Calculation\Database\DMax::evaluate
DMIN                     | CATEGORY_DATABASE              | \PhpOffice\PhpSpreadsheet\Calculation\Database\DMin::evaluate
DOLLAR                   | CATEGORY_TEXT_AND_DATA         | \PhpOffice\PhpSpreadsheet\Calculation\TextData\Format::DOLLAR
DOLLARDE                 | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\Dollar::decimal
DOLLARFR                 | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\Dollar::fractional
DPRODUCT                 | CATEGORY_DATABASE              | \PhpOffice\PhpSpreadsheet\Calculation\Database\DProduct::evaluate
DSTDEV                   | CATEGORY_DATABASE              | \PhpOffice\PhpSpreadsheet\Calculation\Database\DStDev::evaluate
DSTDEVP                  | CATEGORY_DATABASE              | \PhpOffice\PhpSpreadsheet\Calculation\Database\DStDevP::evaluate
DSUM                     | CATEGORY_DATABASE              | \PhpOffice\PhpSpreadsheet\Calculation\Database\DSum::evaluate
DURATION                 | CATEGORY_FINANCIAL             | **Not yet Implemented**
DVAR                     | CATEGORY_DATABASE              | \PhpOffice\PhpSpreadsheet\Calculation\Database\DVar::evaluate
DVARP                    | CATEGORY_DATABASE              | \PhpOffice\PhpSpreadsheet\Calculation\Database\DVarP::evaluate

## E

Excel Function           | Category                       | PhpSpreadsheet Function
-------------------------|--------------------------------|--------------------------------------
ECMA.CEILING             | CATEGORY_MATH_AND_TRIG         | **Not yet Implemented**
EDATE                    | CATEGORY_DATE_AND_TIME         | \PhpOffice\PhpSpreadsheet\Calculation\DateTimeExcel\Month::adjust
EFFECT                   | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\InterestRate::effective
ENCODEURL                | CATEGORY_WEB                   | \PhpOffice\PhpSpreadsheet\Calculation\Web\Service::urlEncode
EOMONTH                  | CATEGORY_DATE_AND_TIME         | \PhpOffice\PhpSpreadsheet\Calculation\DateTimeExcel\Month::lastDay
ERF                      | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\Erf::ERF
ERF.PRECISE              | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\Erf::ERFPRECISE
ERFC                     | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\ErfC::ERFC
ERFC.PRECISE             | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\ErfC::ERFC
ERROR.TYPE               | CATEGORY_INFORMATION           | \PhpOffice\PhpSpreadsheet\Calculation\Functions::errorType
EVEN                     | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Round::even
EXACT                    | CATEGORY_TEXT_AND_DATA         | \PhpOffice\PhpSpreadsheet\Calculation\TextData\Text::exact
EXP                      | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Exp::evaluate
EXPON.DIST               | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\Exponential::distribution
EXPONDIST                | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\Exponential::distribution

## F

Excel Function           | Category                       | PhpSpreadsheet Function
-------------------------|--------------------------------|--------------------------------------
F.DIST                   | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\F::distribution
F.DIST.RT                | CATEGORY_STATISTICAL           | **Not yet Implemented**
F.INV                    | CATEGORY_STATISTICAL           | **Not yet Implemented**
F.INV.RT                 | CATEGORY_STATISTICAL           | **Not yet Implemented**
F.TEST                   | CATEGORY_STATISTICAL           | **Not yet Implemented**
FACT                     | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Factorial::fact
FACTDOUBLE               | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Factorial::factDouble
FALSE                    | CATEGORY_LOGICAL               | \PhpOffice\PhpSpreadsheet\Calculation\Logical\Boolean::FALSE
FDIST                    | CATEGORY_STATISTICAL           | **Not yet Implemented**
FILTER                   | CATEGORY_LOOKUP_AND_REFERENCE  | **Not yet Implemented**
FILTERXML                | CATEGORY_WEB                   | **Not yet Implemented**
FIND                     | CATEGORY_TEXT_AND_DATA         | \PhpOffice\PhpSpreadsheet\Calculation\TextData\Search::sensitive
FINDB                    | CATEGORY_TEXT_AND_DATA         | \PhpOffice\PhpSpreadsheet\Calculation\TextData\Search::sensitive
FINV                     | CATEGORY_STATISTICAL           | **Not yet Implemented**
FISHER                   | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\Fisher::distribution
FISHERINV                | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\Fisher::inverse
FIXED                    | CATEGORY_TEXT_AND_DATA         | \PhpOffice\PhpSpreadsheet\Calculation\TextData\Format::FIXEDFORMAT
FLOOR                    | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Floor::floor
FLOOR.MATH               | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Floor::math
FLOOR.PRECISE            | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Floor::precise
FORECAST                 | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Trends::FORECAST
FORECAST.ETS             | CATEGORY_STATISTICAL           | **Not yet Implemented**
FORECAST.ETS.CONFINT     | CATEGORY_STATISTICAL           | **Not yet Implemented**
FORECAST.ETS.SEASONALITY | CATEGORY_STATISTICAL           | **Not yet Implemented**
FORECAST.ETS.STAT        | CATEGORY_STATISTICAL           | **Not yet Implemented**
FORECAST.LINEAR          | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Trends::FORECAST
FORMULATEXT              | CATEGORY_LOOKUP_AND_REFERENCE  | \PhpOffice\PhpSpreadsheet\Calculation\LookupRef\Formula::text
FREQUENCY                | CATEGORY_STATISTICAL           | **Not yet Implemented**
FTEST                    | CATEGORY_STATISTICAL           | **Not yet Implemented**
FV                       | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\CashFlow\Constant\Periodic::futureValue
FVSCHEDULE               | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\CashFlow\Single::futureValue

## G

Excel Function           | Category                       | PhpSpreadsheet Function
-------------------------|--------------------------------|--------------------------------------
GAMMA                    | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\Gamma::gamma
GAMMA.DIST               | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\Gamma::distribution
GAMMA.INV                | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\Gamma::inverse
GAMMADIST                | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\Gamma::distribution
GAMMAINV                 | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\Gamma::inverse
GAMMALN                  | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\Gamma::ln
GAMMALN.PRECISE          | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\Gamma::ln
GAUSS                    | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\StandardNormal::gauss
GCD                      | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Gcd::evaluate
GEOMEAN                  | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Averages\Mean::geometric
GESTEP                   | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\Compare::GESTEP
GETPIVOTDATA             | CATEGORY_LOOKUP_AND_REFERENCE  | **Not yet Implemented**
GROWTH                   | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Trends::GROWTH

## H

Excel Function           | Category                       | PhpSpreadsheet Function
-------------------------|--------------------------------|--------------------------------------
HARMEAN                  | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Averages\Mean::harmonic
HEX2BIN                  | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\ConvertHex::toBinary
HEX2DEC                  | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\ConvertHex::toDecimal
HEX2OCT                  | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\ConvertHex::toOctal
HLOOKUP                  | CATEGORY_LOOKUP_AND_REFERENCE  | \PhpOffice\PhpSpreadsheet\Calculation\LookupRef\HLookup::lookup
HOUR                     | CATEGORY_DATE_AND_TIME         | \PhpOffice\PhpSpreadsheet\Calculation\DateTimeExcel\TimeParts::hour
HYPERLINK                | CATEGORY_LOOKUP_AND_REFERENCE  | \PhpOffice\PhpSpreadsheet\Calculation\LookupRef\Hyperlink::set
HYPGEOM.DIST             | CATEGORY_STATISTICAL           | **Not yet Implemented**
HYPGEOMDIST              | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\HyperGeometric::distribution

## I

Excel Function           | Category                       | PhpSpreadsheet Function
-------------------------|--------------------------------|--------------------------------------
IF                       | CATEGORY_LOGICAL               | \PhpOffice\PhpSpreadsheet\Calculation\Logical\Conditional::statementIf
IFERROR                  | CATEGORY_LOGICAL               | \PhpOffice\PhpSpreadsheet\Calculation\Logical\Conditional::IFERROR
IFNA                     | CATEGORY_LOGICAL               | \PhpOffice\PhpSpreadsheet\Calculation\Logical\Conditional::IFNA
IFS                      | CATEGORY_LOGICAL               | \PhpOffice\PhpSpreadsheet\Calculation\Logical\Conditional::IFS
IMABS                    | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\ComplexFunctions::IMABS
IMAGINARY                | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\Complex::IMAGINARY
IMARGUMENT               | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\ComplexFunctions::IMARGUMENT
IMCONJUGATE              | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\ComplexFunctions::IMCONJUGATE
IMCOS                    | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\ComplexFunctions::IMCOS
IMCOSH                   | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\ComplexFunctions::IMCOSH
IMCOT                    | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\ComplexFunctions::IMCOT
IMCSC                    | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\ComplexFunctions::IMCSC
IMCSCH                   | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\ComplexFunctions::IMCSCH
IMDIV                    | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\ComplexOperations::IMDIV
IMEXP                    | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\ComplexFunctions::IMEXP
IMLN                     | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\ComplexFunctions::IMLN
IMLOG10                  | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\ComplexFunctions::IMLOG10
IMLOG2                   | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\ComplexFunctions::IMLOG2
IMPOWER                  | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\ComplexFunctions::IMPOWER
IMPRODUCT                | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\ComplexOperations::IMPRODUCT
IMREAL                   | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\Complex::IMREAL
IMSEC                    | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\ComplexFunctions::IMSEC
IMSECH                   | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\ComplexFunctions::IMSECH
IMSIN                    | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\ComplexFunctions::IMSIN
IMSINH                   | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\ComplexFunctions::IMSINH
IMSQRT                   | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\ComplexFunctions::IMSQRT
IMSUB                    | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\ComplexOperations::IMSUB
IMSUM                    | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\ComplexOperations::IMSUM
IMTAN                    | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\ComplexFunctions::IMTAN
INDEX                    | CATEGORY_LOOKUP_AND_REFERENCE  | \PhpOffice\PhpSpreadsheet\Calculation\LookupRef\Matrix::index
INDIRECT                 | CATEGORY_LOOKUP_AND_REFERENCE  | \PhpOffice\PhpSpreadsheet\Calculation\LookupRef\Indirect::INDIRECT
INFO                     | CATEGORY_INFORMATION           | **Not yet Implemented**
INT                      | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\IntClass::evaluate
INTERCEPT                | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Trends::INTERCEPT
INTRATE                  | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\Securities\Rates::interest
IPMT                     | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\CashFlow\Constant\Periodic\Interest::payment
IRR                      | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\CashFlow\Variable\Periodic::rate
ISBLANK                  | CATEGORY_INFORMATION           | \PhpOffice\PhpSpreadsheet\Calculation\Functions::isBlank
ISERR                    | CATEGORY_INFORMATION           | \PhpOffice\PhpSpreadsheet\Calculation\Functions::isErr
ISERROR                  | CATEGORY_INFORMATION           | \PhpOffice\PhpSpreadsheet\Calculation\Functions::isError
ISEVEN                   | CATEGORY_INFORMATION           | \PhpOffice\PhpSpreadsheet\Calculation\Functions::isEven
ISFORMULA                | CATEGORY_INFORMATION           | \PhpOffice\PhpSpreadsheet\Calculation\Functions::isFormula
ISLOGICAL                | CATEGORY_INFORMATION           | \PhpOffice\PhpSpreadsheet\Calculation\Functions::isLogical
ISNA                     | CATEGORY_INFORMATION           | \PhpOffice\PhpSpreadsheet\Calculation\Functions::isNa
ISNONTEXT                | CATEGORY_INFORMATION           | \PhpOffice\PhpSpreadsheet\Calculation\Functions::isNonText
ISNUMBER                 | CATEGORY_INFORMATION           | \PhpOffice\PhpSpreadsheet\Calculation\Functions::isNumber
ISO.CEILING              | CATEGORY_MATH_AND_TRIG         | **Not yet Implemented**
ISODD                    | CATEGORY_INFORMATION           | \PhpOffice\PhpSpreadsheet\Calculation\Functions::isOdd
ISOWEEKNUM               | CATEGORY_DATE_AND_TIME         | \PhpOffice\PhpSpreadsheet\Calculation\DateTimeExcel\Week::isoWeekNumber
ISPMT                    | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\CashFlow\Constant\Periodic\Interest::schedulePayment
ISREF                    | CATEGORY_INFORMATION           | **Not yet Implemented**
ISTEXT                   | CATEGORY_INFORMATION           | \PhpOffice\PhpSpreadsheet\Calculation\Functions::isText

## J

Excel Function           | Category                       | PhpSpreadsheet Function
-------------------------|--------------------------------|--------------------------------------
JIS                      | CATEGORY_TEXT_AND_DATA         | **Not yet Implemented**

## K

Excel Function           | Category                       | PhpSpreadsheet Function
-------------------------|--------------------------------|--------------------------------------
KURT                     | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Deviations::kurtosis

## L

Excel Function           | Category                       | PhpSpreadsheet Function
-------------------------|--------------------------------|--------------------------------------
LARGE                    | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Size::large
LCM                      | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Lcm::evaluate
LEFT                     | CATEGORY_TEXT_AND_DATA         | \PhpOffice\PhpSpreadsheet\Calculation\TextData\Extract::left
LEFTB                    | CATEGORY_TEXT_AND_DATA         | \PhpOffice\PhpSpreadsheet\Calculation\TextData\Extract::left
LEN                      | CATEGORY_TEXT_AND_DATA         | \PhpOffice\PhpSpreadsheet\Calculation\TextData\Text::length
LENB                     | CATEGORY_TEXT_AND_DATA         | \PhpOffice\PhpSpreadsheet\Calculation\TextData\Text::length
LINEST                   | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Trends::LINEST
LN                       | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Logarithms::natural
LOG                      | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Logarithms::withBase
LOG10                    | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Logarithms::base10
LOGEST                   | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Trends::LOGEST
LOGINV                   | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\LogNormal::inverse
LOGNORM.DIST             | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\LogNormal::distribution
LOGNORM.INV              | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\LogNormal::inverse
LOGNORMDIST              | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\LogNormal::cumulative
LOOKUP                   | CATEGORY_LOOKUP_AND_REFERENCE  | \PhpOffice\PhpSpreadsheet\Calculation\LookupRef\Lookup::lookup
LOWER                    | CATEGORY_TEXT_AND_DATA         | \PhpOffice\PhpSpreadsheet\Calculation\TextData\CaseConvert::lower

## M

Excel Function           | Category                       | PhpSpreadsheet Function
-------------------------|--------------------------------|--------------------------------------
MATCH                    | CATEGORY_LOOKUP_AND_REFERENCE  | \PhpOffice\PhpSpreadsheet\Calculation\LookupRef\ExcelMatch::MATCH
MAX                      | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Maximum::max
MAXA                     | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Maximum::maxA
MAXIFS                   | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Conditional::MAXIFS
MDETERM                  | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\MatrixFunctions::determinant
MDURATION                | CATEGORY_FINANCIAL             | **Not yet Implemented**
MEDIAN                   | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Averages::median
MEDIANIF                 | CATEGORY_STATISTICAL           | **Not yet Implemented**
MID                      | CATEGORY_TEXT_AND_DATA         | \PhpOffice\PhpSpreadsheet\Calculation\TextData\Extract::mid
MIDB                     | CATEGORY_TEXT_AND_DATA         | \PhpOffice\PhpSpreadsheet\Calculation\TextData\Extract::mid
MIN                      | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Minimum::min
MINA                     | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Minimum::minA
MINIFS                   | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Conditional::MINIFS
MINUTE                   | CATEGORY_DATE_AND_TIME         | \PhpOffice\PhpSpreadsheet\Calculation\DateTimeExcel\TimeParts::minute
MINVERSE                 | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\MatrixFunctions::inverse
MIRR                     | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\CashFlow\Variable\Periodic::modifiedRate
MMULT                    | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\MatrixFunctions::multiply
MOD                      | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Operations::mod
MODE                     | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Averages::mode
MODE.MULT                | CATEGORY_STATISTICAL           | **Not yet Implemented**
MODE.SNGL                | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Averages::mode
MONTH                    | CATEGORY_DATE_AND_TIME         | \PhpOffice\PhpSpreadsheet\Calculation\DateTimeExcel\DateParts::month
MROUND                   | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Round::multiple
MULTINOMIAL              | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Factorial::multinomial
MUNIT                    | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\MatrixFunctions::identity

## N

Excel Function           | Category                       | PhpSpreadsheet Function
-------------------------|--------------------------------|--------------------------------------
N                        | CATEGORY_INFORMATION           | \PhpOffice\PhpSpreadsheet\Calculation\Functions::n
NA                       | CATEGORY_INFORMATION           | \PhpOffice\PhpSpreadsheet\Calculation\Functions::NA
NEGBINOM.DIST            | CATEGORY_STATISTICAL           | **Not yet Implemented**
NEGBINOMDIST             | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\Binomial::negative
NETWORKDAYS              | CATEGORY_DATE_AND_TIME         | \PhpOffice\PhpSpreadsheet\Calculation\DateTimeExcel\NetworkDays::count
NETWORKDAYS.INTL         | CATEGORY_DATE_AND_TIME         | **Not yet Implemented**
NOMINAL                  | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\InterestRate::nominal
NORM.DIST                | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\Normal::distribution
NORM.INV                 | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\Normal::inverse
NORM.S.DIST              | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\StandardNormal::distribution
NORM.S.INV               | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\StandardNormal::inverse
NORMDIST                 | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\Normal::distribution
NORMINV                  | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\Normal::inverse
NORMSDIST                | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\StandardNormal::cumulative
NORMSINV                 | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\StandardNormal::inverse
NOT                      | CATEGORY_LOGICAL               | \PhpOffice\PhpSpreadsheet\Calculation\Logical\Operations::NOT
NOW                      | CATEGORY_DATE_AND_TIME         | \PhpOffice\PhpSpreadsheet\Calculation\DateTimeExcel\Current::now
NPER                     | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\CashFlow\Constant\Periodic::periods
NPV                      | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\CashFlow\Variable\Periodic::presentValue
NUMBERVALUE              | CATEGORY_TEXT_AND_DATA         | \PhpOffice\PhpSpreadsheet\Calculation\TextData\Format::NUMBERVALUE

## O

Excel Function           | Category                       | PhpSpreadsheet Function
-------------------------|--------------------------------|--------------------------------------
OCT2BIN                  | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\ConvertOctal::toBinary
OCT2DEC                  | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\ConvertOctal::toDecimal
OCT2HEX                  | CATEGORY_ENGINEERING           | \PhpOffice\PhpSpreadsheet\Calculation\Engineering\ConvertOctal::toHex
ODD                      | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Round::odd
ODDFPRICE                | CATEGORY_FINANCIAL             | **Not yet Implemented**
ODDFYIELD                | CATEGORY_FINANCIAL             | **Not yet Implemented**
ODDLPRICE                | CATEGORY_FINANCIAL             | **Not yet Implemented**
ODDLYIELD                | CATEGORY_FINANCIAL             | **Not yet Implemented**
OFFSET                   | CATEGORY_LOOKUP_AND_REFERENCE  | \PhpOffice\PhpSpreadsheet\Calculation\LookupRef\Offset::OFFSET
OR                       | CATEGORY_LOGICAL               | \PhpOffice\PhpSpreadsheet\Calculation\Logical\Operations::logicalOr

## P

Excel Function           | Category                       | PhpSpreadsheet Function
-------------------------|--------------------------------|--------------------------------------
PDURATION                | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\CashFlow\Single::periods
PEARSON                  | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Trends::CORREL
PERCENTILE               | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Percentiles::PERCENTILE
PERCENTILE.EXC           | CATEGORY_STATISTICAL           | **Not yet Implemented**
PERCENTILE.INC           | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Percentiles::PERCENTILE
PERCENTRANK              | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Percentiles::PERCENTRANK
PERCENTRANK.EXC          | CATEGORY_STATISTICAL           | **Not yet Implemented**
PERCENTRANK.INC          | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Percentiles::PERCENTRANK
PERMUT                   | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Permutations::PERMUT
PERMUTATIONA             | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Permutations::PERMUTATIONA
PHI                      | CATEGORY_STATISTICAL           | **Not yet Implemented**
PHONETIC                 | CATEGORY_TEXT_AND_DATA         | **Not yet Implemented**
PI                       | CATEGORY_MATH_AND_TRIG         | pi
PMT                      | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\CashFlow\Constant\Periodic\Payments::annuity
POISSON                  | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\Poisson::distribution
POISSON.DIST             | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\Poisson::distribution
POWER                    | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Operations::power
PPMT                     | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\CashFlow\Constant\Periodic\Payments::interestPayment
PRICE                    | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\Securities\Price::price
PRICEDISC                | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\Securities\Price::priceDiscounted
PRICEMAT                 | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\Securities\Price::priceAtMaturity
PROB                     | CATEGORY_STATISTICAL           | **Not yet Implemented**
PRODUCT                  | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Operations::product
PROPER                   | CATEGORY_TEXT_AND_DATA         | \PhpOffice\PhpSpreadsheet\Calculation\TextData\CaseConvert::proper
PV                       | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\CashFlow\Constant\Periodic::presentValue

## Q

Excel Function           | Category                       | PhpSpreadsheet Function
-------------------------|--------------------------------|--------------------------------------
QUARTILE                 | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Percentiles::QUARTILE
QUARTILE.EXC             | CATEGORY_STATISTICAL           | **Not yet Implemented**
QUARTILE.INC             | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Percentiles::QUARTILE
QUOTIENT                 | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Operations::quotient

## R

Excel Function           | Category                       | PhpSpreadsheet Function
-------------------------|--------------------------------|--------------------------------------
RADIANS                  | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Angle::toRadians
RAND                     | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Random::rand
RANDARRAY                | CATEGORY_MATH_AND_TRIG         | **Not yet Implemented**
RANDBETWEEN              | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Random::randBetween
RANK                     | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Percentiles::RANK
RANK.AVG                 | CATEGORY_STATISTICAL           | **Not yet Implemented**
RANK.EQ                  | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Percentiles::RANK
RATE                     | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\CashFlow\Constant\Periodic\Interest::rate
RECEIVED                 | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\Securities\Price::received
REPLACE                  | CATEGORY_TEXT_AND_DATA         | \PhpOffice\PhpSpreadsheet\Calculation\TextData\Replace::replace
REPLACEB                 | CATEGORY_TEXT_AND_DATA         | \PhpOffice\PhpSpreadsheet\Calculation\TextData\Replace::replace
REPT                     | CATEGORY_TEXT_AND_DATA         | \PhpOffice\PhpSpreadsheet\Calculation\TextData\Concatenate::builtinREPT
RIGHT                    | CATEGORY_TEXT_AND_DATA         | \PhpOffice\PhpSpreadsheet\Calculation\TextData\Extract::right
RIGHTB                   | CATEGORY_TEXT_AND_DATA         | \PhpOffice\PhpSpreadsheet\Calculation\TextData\Extract::right
ROMAN                    | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Roman::evaluate
ROUND                    | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Round::round
ROUNDDOWN                | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Round::down
ROUNDUP                  | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Round::up
ROW                      | CATEGORY_LOOKUP_AND_REFERENCE  | \PhpOffice\PhpSpreadsheet\Calculation\LookupRef\RowColumnInformation::ROW
ROWS                     | CATEGORY_LOOKUP_AND_REFERENCE  | \PhpOffice\PhpSpreadsheet\Calculation\LookupRef\RowColumnInformation::ROWS
RRI                      | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\CashFlow\Single::interestRate
RSQ                      | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Trends::RSQ
RTD                      | CATEGORY_LOOKUP_AND_REFERENCE  | **Not yet Implemented**

## S

Excel Function           | Category                       | PhpSpreadsheet Function
-------------------------|--------------------------------|--------------------------------------
SEARCH                   | CATEGORY_TEXT_AND_DATA         | \PhpOffice\PhpSpreadsheet\Calculation\TextData\Search::insensitive
SEARCHB                  | CATEGORY_TEXT_AND_DATA         | \PhpOffice\PhpSpreadsheet\Calculation\TextData\Search::insensitive
SEC                      | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Trig\Secant::sec
SECH                     | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Trig\Secant::sech
SECOND                   | CATEGORY_DATE_AND_TIME         | \PhpOffice\PhpSpreadsheet\Calculation\DateTimeExcel\TimeParts::second
SEQUENCE                 | CATEGORY_MATH_AND_TRIG         | **Not yet Implemented**
SERIESSUM                | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\SeriesSum::evaluate
SHEET                    | CATEGORY_INFORMATION           | **Not yet Implemented**
SHEETS                   | CATEGORY_INFORMATION           | **Not yet Implemented**
SIGN                     | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Sign::evaluate
SIN                      | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Trig\Sine::sin
SINH                     | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Trig\Sine::sinh
SKEW                     | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Deviations::skew
SKEW.P                   | CATEGORY_STATISTICAL           | **Not yet Implemented**
SLN                      | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\Depreciation::SLN
SLOPE                    | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Trends::SLOPE
SMALL                    | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Size::small
SORT                     | CATEGORY_LOOKUP_AND_REFERENCE  | **Not yet Implemented**
SORTBY                   | CATEGORY_LOOKUP_AND_REFERENCE  | **Not yet Implemented**
SQRT                     | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Sqrt::sqrt
SQRTPI                   | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Sqrt::pi
STANDARDIZE              | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Standardize::execute
STDEV                    | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\StandardDeviations::STDEV
STDEV.P                  | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\StandardDeviations::STDEVP
STDEV.S                  | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\StandardDeviations::STDEV
STDEVA                   | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\StandardDeviations::STDEVA
STDEVP                   | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\StandardDeviations::STDEVP
STDEVPA                  | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\StandardDeviations::STDEVPA
STEYX                    | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Trends::STEYX
SUBSTITUTE               | CATEGORY_TEXT_AND_DATA         | \PhpOffice\PhpSpreadsheet\Calculation\TextData\Replace::substitute
SUBTOTAL                 | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Subtotal::evaluate
SUM                      | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Sum::sumErroringStrings
SUMIF                    | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Conditional::SUMIF
SUMIFS                   | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Conditional::SUMIFS
SUMPRODUCT               | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Sum::product
SUMSQ                    | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\SumSquares::sumSquare
SUMX2MY2                 | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\SumSquares::sumXSquaredMinusYSquared
SUMX2PY2                 | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\SumSquares::sumXSquaredPlusYSquared
SUMXMY2                  | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\SumSquares::sumXMinusYSquared
SWITCH                   | CATEGORY_LOGICAL               | \PhpOffice\PhpSpreadsheet\Calculation\Logical\Conditional::statementSwitch
SYD                      | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\Depreciation::SYD

## T

Excel Function           | Category                       | PhpSpreadsheet Function
-------------------------|--------------------------------|--------------------------------------
T                        | CATEGORY_TEXT_AND_DATA         | \PhpOffice\PhpSpreadsheet\Calculation\TextData\Text::test
T.DIST                   | CATEGORY_STATISTICAL           | **Not yet Implemented**
T.DIST.2T                | CATEGORY_STATISTICAL           | **Not yet Implemented**
T.DIST.RT                | CATEGORY_STATISTICAL           | **Not yet Implemented**
T.INV                    | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\StudentT::inverse
T.INV.2T                 | CATEGORY_STATISTICAL           | **Not yet Implemented**
T.TEST                   | CATEGORY_STATISTICAL           | **Not yet Implemented**
TAN                      | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Trig\Tangent::tan
TANH                     | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Trig\Tangent::tanh
TBILLEQ                  | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\TreasuryBill::bondEquivalentYield
TBILLPRICE               | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\TreasuryBill::price
TBILLYIELD               | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\TreasuryBill::yield
TDIST                    | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\StudentT::distribution
TEXT                     | CATEGORY_TEXT_AND_DATA         | \PhpOffice\PhpSpreadsheet\Calculation\TextData\Format::TEXTFORMAT
TEXTJOIN                 | CATEGORY_TEXT_AND_DATA         | \PhpOffice\PhpSpreadsheet\Calculation\TextData\Concatenate::TEXTJOIN
TIME                     | CATEGORY_DATE_AND_TIME         | \PhpOffice\PhpSpreadsheet\Calculation\DateTimeExcel\Time::fromHMS
TIMEVALUE                | CATEGORY_DATE_AND_TIME         | \PhpOffice\PhpSpreadsheet\Calculation\DateTimeExcel\TimeValue::fromString
TINV                     | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\StudentT::inverse
TODAY                    | CATEGORY_DATE_AND_TIME         | \PhpOffice\PhpSpreadsheet\Calculation\DateTimeExcel\Current::today
TRANSPOSE                | CATEGORY_LOOKUP_AND_REFERENCE  | \PhpOffice\PhpSpreadsheet\Calculation\LookupRef\Matrix::transpose
TREND                    | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Trends::TREND
TRIM                     | CATEGORY_TEXT_AND_DATA         | \PhpOffice\PhpSpreadsheet\Calculation\TextData\Trim::spaces
TRIMMEAN                 | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Averages\Mean::trim
TRUE                     | CATEGORY_LOGICAL               | \PhpOffice\PhpSpreadsheet\Calculation\Logical\Boolean::TRUE
TRUNC                    | CATEGORY_MATH_AND_TRIG         | \PhpOffice\PhpSpreadsheet\Calculation\MathTrig\Trunc::evaluate
TTEST                    | CATEGORY_STATISTICAL           | **Not yet Implemented**
TYPE                     | CATEGORY_INFORMATION           | \PhpOffice\PhpSpreadsheet\Calculation\Functions::TYPE

## U

Excel Function           | Category                       | PhpSpreadsheet Function
-------------------------|--------------------------------|--------------------------------------
UNICHAR                  | CATEGORY_TEXT_AND_DATA         | \PhpOffice\PhpSpreadsheet\Calculation\TextData\CharacterConvert::character
UNICODE                  | CATEGORY_TEXT_AND_DATA         | \PhpOffice\PhpSpreadsheet\Calculation\TextData\CharacterConvert::code
UNIQUE                   | CATEGORY_LOOKUP_AND_REFERENCE  | **Not yet Implemented**
UPPER                    | CATEGORY_TEXT_AND_DATA         | \PhpOffice\PhpSpreadsheet\Calculation\TextData\CaseConvert::upper
USDOLLAR                 | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\Dollar::format

## V

Excel Function           | Category                       | PhpSpreadsheet Function
-------------------------|--------------------------------|--------------------------------------
VALUE                    | CATEGORY_TEXT_AND_DATA         | \PhpOffice\PhpSpreadsheet\Calculation\TextData\Format::VALUE
VAR                      | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Variances::VAR
VAR.P                    | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Variances::VARP
VAR.S                    | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Variances::VAR
VARA                     | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Variances::VARA
VARP                     | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Variances::VARP
VARPA                    | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Variances::VARPA
VDB                      | CATEGORY_FINANCIAL             | **Not yet Implemented**
VLOOKUP                  | CATEGORY_LOOKUP_AND_REFERENCE  | \PhpOffice\PhpSpreadsheet\Calculation\LookupRef\VLookup::lookup

## W

Excel Function           | Category                       | PhpSpreadsheet Function
-------------------------|--------------------------------|--------------------------------------
WEBSERVICE               | CATEGORY_WEB                   | \PhpOffice\PhpSpreadsheet\Calculation\Web\Service::webService
WEEKDAY                  | CATEGORY_DATE_AND_TIME         | \PhpOffice\PhpSpreadsheet\Calculation\DateTimeExcel\Week::day
WEEKNUM                  | CATEGORY_DATE_AND_TIME         | \PhpOffice\PhpSpreadsheet\Calculation\DateTimeExcel\Week::number
WEIBULL                  | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\Weibull::distribution
WEIBULL.DIST             | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\Weibull::distribution
WORKDAY                  | CATEGORY_DATE_AND_TIME         | \PhpOffice\PhpSpreadsheet\Calculation\DateTimeExcel\WorkDay::date
WORKDAY.INTL             | CATEGORY_DATE_AND_TIME         | **Not yet Implemented**

## X

Excel Function           | Category                       | PhpSpreadsheet Function
-------------------------|--------------------------------|--------------------------------------
XIRR                     | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\CashFlow\Variable\NonPeriodic::rate
XLOOKUP                  | CATEGORY_LOOKUP_AND_REFERENCE  | **Not yet Implemented**
XMATCH                   | CATEGORY_LOOKUP_AND_REFERENCE  | **Not yet Implemented**
XNPV                     | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\CashFlow\Variable\NonPeriodic::presentValue
XOR                      | CATEGORY_LOGICAL               | \PhpOffice\PhpSpreadsheet\Calculation\Logical\Operations::logicalXor

## Y

Excel Function           | Category                       | PhpSpreadsheet Function
-------------------------|--------------------------------|--------------------------------------
YEAR                     | CATEGORY_DATE_AND_TIME         | \PhpOffice\PhpSpreadsheet\Calculation\DateTimeExcel\DateParts::year
YEARFRAC                 | CATEGORY_DATE_AND_TIME         | \PhpOffice\PhpSpreadsheet\Calculation\DateTimeExcel\YearFrac::fraction
YIELD                    | CATEGORY_FINANCIAL             | **Not yet Implemented**
YIELDDISC                | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\Securities\Yields::yieldDiscounted
YIELDMAT                 | CATEGORY_FINANCIAL             | \PhpOffice\PhpSpreadsheet\Calculation\Financial\Securities\Yields::yieldAtMaturity

## Z

Excel Function           | Category                       | PhpSpreadsheet Function
-------------------------|--------------------------------|--------------------------------------
Z.TEST                   | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\StandardNormal::zTest
ZTEST                    | CATEGORY_STATISTICAL           | \PhpOffice\PhpSpreadsheet\Calculation\Statistical\Distributions\StandardNormal::zTest
