<?php

//  value, format, result

return [
    [
        '0.0',
        0.0,
        '0.0',
    ],
    [
        '0',
        0.0,
        '0',
    ],
    [
        '0.0',
        0,
        '0.0',
    ],
    [
        '0',
        0,
        '0',
    ],
    [
        '000',
        0,
        '##0',
    ],
    [
        '12.00',
        12,
        '#.0#',
    ],
    [
        '0.1',
        0.10000000000000001,
        '0.0',
    ],
    [
        '0',
        0.10000000000000001,
        '0',
    ],
    [
        '5.556',
        5.5555000000000003,
        '0.###',
    ],
    [
        '5.556',
        5.5555000000000003,
        '0.0##',
    ],
    [
        '5.556',
        5.5555000000000003,
        '0.00#',
    ],
    [
        '12 345.67',
        12345.67,
        '#\ ##0.00',
    ],
    [
        '1234 567.00',
        1234567.00,
        '#\ ##0.00',
    ],
    [
        '5.556',
        5.5555000000000003,
        '0.000',
    ],
    [
        '5.5555',
        5.5555000000000003,
        '0.0000',
    ],
    [
        '12,345.68',
        12345.678900000001,
        '#,##0.00',
    ],
    [
        '12,345.679',
        12345.678900000001,
        '#,##0.000',
    ],
    [
        '12.34 kg',
        12.34,
        '0.00 "kg"',
    ],
    [
        'kg 12.34',
        12.34,
        '"kg" 0.00',
    ],
    [
        '12.34 kg.',
        12.34,
        '0.00 "kg."',
    ],
    [
        'kg. 12.34',
        12.34,
        '"kg." 0.00',
    ],
    [
        '£ 12,345.68',
        12345.678900000001,
        '£ #,##0.00',
    ],
    [
        '$ 12,345.679',
        12345.678900000001,
        '$ #,##0.000',
    ],
    [
        '12,345.679 €',
        12345.678900000001,
        '#,##0.000\ [$€-1]',
    ],
    [
        '12,345.679 $',
        12345.678900000001,
        '#,##0.000\ [$]',
    ],
    'Spacing Character' => [
        '826.00  €',
        826,
        '#,##0.00 __€',
    ],
    [
        '5.68',
        5.6788999999999996,
        '#,##0.00',
    ],
    [
        '12,000',
        12000,
        '#,###',
    ],
    [
        12,
        12000,
        '#,',
    ],
    // Scaling test
    [
        12.199999999999999,
        12200000,
        '0.0,,',
    ],
    // Percentage
    [
        '12%',
        0.12,
        '0%',
    ],
    [
        '8%',
        0.080000000000000002,
        '0%',
    ],
    [
        '80%',
        0.80000000000000004,
        '0%',
    ],
    [
        '280%',
        2.7999999999999998,
        '0%',
    ],
    [
        '$125.74 Surplus',
        125.73999999999999,
        '$0.00" Surplus";$-0.00" Shortage"',
    ],
    [
        '$-125.74 Shortage',
        -125.73999999999999,
        '$0.00" Surplus";$-0.00" Shortage"',
    ],
    [
        '$125.74 Shortage',
        -125.73999999999999,
        '$0.00" Surplus";$0.00" Shortage"',
    ],
    [
        '12%',
        0.123,
        '0%',
    ],
    [
        '10%',
        0.1,
        '0%',
    ],
    [
        '10.0%',
        0.1,
        '0.0%',
    ],
    [
        '-12%',
        -0.123,
        '0%',
    ],
    [
        '12.3  %',
        0.123,
        '0.?? %',
    ],
    [
        '12.35 %',
        0.12345,
        '0.?? %',
    ],
    [
        '12.345  %',
        0.12345,
        '0.00?? %',
    ],
    [
        '12.3457 %',
        0.123456789,
        '0.00?? %',
    ],
    [
        '-12.3  %',
        -0.123,
        '0.?? %',
    ],
    [
        '12.30 %age',
        0.123,
        '0.00 %"age"',
    ],
    [
        '-12.30 %age',
        -0.123,
        '0.00 %"age"',
    ],
    [
        '12.30%',
        0.123,
        '0.00%;(0.00%)',
    ],
    [
        '(12.30%)',
        -0.123,
        '0.00%;(0.00%)',
    ],
    [
        '12.30% ',
        0.123,
        '0.00%_;( 0.00% )',
    ],
    [
        '( 12.30% )',
        -0.123,
        '_(0.00%_;( 0.00% )',
    ],
    // Fraction
    [
        '5 1/4',
        5.25,
        '# ???/???',
    ],
    // Vulgar Fraction
    [
        '5 3/10',
        5.2999999999999998,
        '# ???/???',
    ],
    [
        '21/4',
        5.25,
        '???/???',
    ],
    [
        '0 3/4',
        0.75,
        '0??/???',
    ],
    [
        '3/4',
        0.75,
        '#??/???',
    ],
    [
        ' 3/4',
        0.75,
        '? ??/???',
    ],
    [
        ' 3/4',
        '0.75000',
        '? ??/???',
    ],
    [
        '5 1/16',
        5.0625,
        '? ??/???',
    ],
    [
        '- 5/8',
        -0.625,
        '? ??/???',
    ],
    [
        '0',
        0,
        '? ??/???',
    ],
    [
        '0',
        '0.000',
        '? ??/???',
    ],
    [
        '-16',
        '-016.0',
        '? ??/???',
    ],
    // Complex formats
    [
        '(001) 2-3456-789',
        123456789,
        '(000) 0-0000-000',
    ],
    [
        '0 (+00) 0123 45 67 89',
        123456789,
        '0 (+00) 0000 00 00 00',
    ],
    [
        '002-01-0035-7',
        20100357,
        '000-00-0000-0',
    ],
    [
        '002-01-00.35-7',
        20100.357,
        '000-00-00.00-0',
    ],
    [
        '002.01.0035.7',
        20100357,
        '000\.00\.0000\.0',
    ],
    [
        '002.01.00.35.7',
        20100.357,
        '000\.00\.00.00\.0',
    ],
    [
        '002.01.00.35.70',
        20100.357,
        '000\.00\.00.00\.00',
    ],
    [
        '12345:67:89',
        123456789,
        '0000:00:00',
    ],
    [
        '-12345:67:89',
        -123456789,
        '0000:00:00',
    ],
    [
        '12345:67.89',
        1234567.8899999999,
        '0000:00.00',
    ],
    [
        '-12345:67.89',
        -1234567.8899999999,
        '0000:00.00',
    ],
    [
        '18.952',
        18.952,
        '[$-409]General',
    ],
    [
        '9.98',
        9.98,
        '[$-409]#,##0.00;-#,##0.00',
    ],
    [
        '18.952',
        18.952,
        '[$-1010409]General',
    ],
    [
        '9.98',
        9.98,
        '[$-1010409]#,##0.00;-#,##0.00',
    ],
    [
        ' $ 23.06 ',
        23.0597,
        '_("$"* #,##0.00_);_("$"* \(#,##0.00\);_("$"* "-"??_);_(@_)',
    ],
    [
        ' € (13.03)',
        -13.0316,
        '_("€"* #,##0.00_);_("€"* \(#,##0.00\);_("€"* "-"??_);_(@_)',
    ],
    [
        ' € 11.70 ',
        11.7,
        '_-€* #,##0.00_-;"-€"* #,##0.00_-;_-€* -??_-;_-@_-',
    ],
    [
        '-€ 12.14 ',
        -12.14,
        '_-€* #,##0.00_-;"-€"* #,##0.00_-;_-€* -??_-;_-@_-',
    ],
    [
        ' € - ',
        0,
        '_-€* #,##0.00_-;"-€"* #,##0.00_-;_-€* -??_-;_-@_-',
    ],
    [
        'test',
        'test',
        '_-€* #,##0.00_-;"-€"* #,##0.00_-;_-€* -??_-;_-@_-',
    ],
    // Named colours
    // Simple color
    [
        '12345',
        12345,
        '[Green]General',
    ],
    [
        '12345',
        12345,
        '[GrEeN]General',
    ],
    [
        '-70',
        -70,
        '#,##0;[Red]-#,##0',
    ],
    [
        '-12,345',
        -12345,
        '#,##0;[Red]-#,##0',
    ],
    // Multiple colors
    [
        '12345',
        12345,
        '[Blue]0;[Red]0-',
    ],
    [
        '12345-',
        -12345,
        '[BLUE]0;[red]0-',
    ],
    [
        '12345-',
        -12345,
        '[blue]0;[RED]0-',
    ],
    // Multiple colors with text substitution
    [
        'Positive',
        12,
        '[Green]"Positive";[Red]"Negative";[Blue]"Zero"',
    ],
    [
        'Zero',
        0,
        '[Green]"Positive";[Red]"Negative";[Blue]"Zero"',
    ],
    [
        'Negative',
        -2,
        '[Green]"Positive";[Red]"Negative";[Blue]"Zero"',
    ],
    // Value break points
    [
        '<=3500 red',
        3500,
        '[Green][=17]"=17 green";[Red][<=3500]"<=3500 red";[Blue]"Zero"',
    ],
    [
        '=17 green',
        17,
        '[Green][=17]"=17 green";[Red][<=3500]"<=3500 red";[Blue]"Zero"',
    ],
    [
        '<>25 green',
        17,
        '[Green][<>25]"<>25 green";[Red]"else red"',
    ],
    [
        'else red',
        25,
        '[Green][<>25]"<>25 green";[Red]"else red"',
    ],
    // Leading/trailing quotes in mask
    [
        '$12.34 ',
        12.34,
        '$#,##0.00_;[RED]"($"#,##0.00")"',
    ],
    [
        '($12.34)',
        -12.34,
        '$#,##0.00_;[RED]"($"#,##0.00")"',
    ],
    [
        'pfx. 25.00',
        25,
        '"pfx." 0.00;"pfx." -0.00;"pfx." 0.00;',
    ],
    [
        'pfx. 25.20',
        25.2,
        '"pfx." 0.00;"pfx." -0.00;"pfx." 0.00;',
    ],
    [
        'pfx. -25.20',
        -25.2,
        '"pfx." 0.00;"pfx." -0.00;"pfx." 0.00;',
    ],
    [
        'pfx. 25.26',
        25.255555555555555,
        '"pfx." 0.00;"pfx." -0.00;"pfx." 0.00;',
    ],
];
