<?php
/**
 * Library module
 * 
 * Filemanager HTML part (UI)
 * 
 * @package linea21\core\library
 * @author $Author$ - Simon Georget <simon@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once('../config/define.php');

include_once('../languages/'.U_L. '/lang_library.'.CHARSET.'.php');

//////////// Check Inclusion de pages ////////////
if (!isset($_SESSION['authenticated'])) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="<?php echo U_L; ?>" lang="<?php echo U_L; ?>">
<head>
<meta http-equiv="content-type" content="text/html; charset=<?php echo CHARSET; ?>" />
<title>File Manager</title>
<link rel="stylesheet" type="text/css" href="styles/reset.css" />
<link rel="stylesheet" type="text/css" href="scripts/jquery.filetree/jqueryFileTree.css" />
<link rel="stylesheet" type="text/css" href="scripts/jquery.contextmenu/jquery.contextMenu-1.01.css" />
<link rel="stylesheet" type="text/css" href="scripts/custom-scrollbar-plugin/jquery.mCustomScrollbar.min.css" />
<style type="text/css">
	#loading-wrap {
		position:fixed;
		height:100%;
		width:100%;
		overflow:hidden;
		top:0;
		left:0;
		display:block;
		background: white url(./images/wait30trans.gif) no-repeat center center;
		z-index:999;
	}
</style>
<!-- CSS dynamically added using 'config.options.theme' defined in config file -->
</head>
<body>
<div id="loading-wrap"><!-- loading wrapper / removed when loaded --></div>
<div>
<form id="uploader" method="post">
	<h1></h1>
	<div id="uploadresponse"></div>
	<button id="level-up" name="level-up" type="button" value="LevelUp">&nbsp;</button>
	<button id="home" name="home" type="button" value="Home">&nbsp;</button>
	<input id="mode" name="mode" type="hidden" value="add" /> 
	<input id="currentpath" name="currentpath" type="hidden" />
	<div id="file-input-container">
		<div id="alt-fileinput">
			<input id="filepath" name="filepath" type="text" /><button id="browse" name="browse" type="button" value="Browse"></button>
		</div>
		<input	id="newfile" name="newfile" type="file" />
	</div>
	<button id="upload" name="upload" type="submit" value="Upload" class="em"></button>
	<button id="newfolder" name="newfolder" type="button" value="New Folder" class="em"></button>
	<button id="grid" class="ON" type="button">&nbsp;</button>
	<button id="list" type="button">&nbsp;</button>
</form>
<div id="splitter">
<div id="filetree"></div>
	<div id="fileinfo">
	<h1></h1>
	</div>
</div>
<div id="footer">
<form name="search" id="search" method="get">
		<div>
			<input type="text" value="" name="q" id="q" />
			<a id="reset" href="#" class="q-reset"></a>
			<span class="q-inactive"></span>
		</div> 
</form>
<a href="" id="link-to-project"></a>
<div id="folder-info"></div>
</div>

<ul id="itemOptions" class="contextMenu">
	<li class="select"><a href="#select"></a></li>
	<li class="download"><a href="#download"></a></li>
	<li class="rename"><a href="#rename"></a></li>
	<li class="move"><a href="#move"></a></li>
	<li class="replace"><a href="#replace"></a></li>
	<li class="delete separator"><a href="#delete"></a></li>
</ul>

<script src="scripts/jquery-1.11.3.min.js"></script>
<script src="scripts/jquery-browser.js"></script>
<script src="scripts/jquery.form-3.24.js"></script>
<script src="scripts/jquery.splitter/jquery.splitter-1.5.1.js"></script>
<script src="scripts/jquery.filetree/jqueryFileTree.js"></script>
<script src="scripts/jquery.contextmenu/jquery.contextMenu-1.01.js"></script>
<script src="scripts/jquery.impromptu-3.2.min.js"></script>
<script src="scripts/jquery.tablesorter-2.7.2.min.js"></script>
<script src="scripts/filemanager.min.js"></script>
</div>
</body>
</html>