<?php
/**
 * Newsletter module - send newsletter using ajax
 * 
 * Send newsletter to the connected user email using ajax. Called from back-office only
 *  
 * @package linea21\modules\newsletter
 * @author $Author$ - Simon Georget <simon@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once('../config/define.php');

if (!$l21auth->isAuthenticated()) ReloadIndex('public');
////////////

include_once('../languages/' . U_L . '/lang_common.' . CHARSET . '.php');
include_once(override('../admin/'.SQL.'.inc.php'));
include_once(override('../mail/mail_actions.php'));
include_once(override('../mail/send.php'));

// print_r($_POST);

$a = array();

$sender = $_POST['sender'];
$recipient = $_POST['recipient'];

if(!isset($_POST['token'])  && $_POST['token'] != SECRET_KEY) die('no way!');

$data = $sql_object->DBSelect(SQL_get_UserInfo($sender));
if(!isset($data[0]['user_id']))  die('no way!');

$rec = $sql_object->DBSelect(SQL_get_UserInfo($recipient));
if(!isset($rec[0]['user_id']))  die('no way!');


if(strlen($_POST['body']) < 10) {
	/* Return json values */
	echo json_encode(array('status'=> 0,'msg'=> sprintf(_t('contact', 'str_error'), _t('contact', 'body'))));
	die();
}
if(strlen($_POST['subject']) < 1) {
	/* Return json values */
	echo json_encode(array('status'=> 0,'msg'=> sprintf(_t('contact', 'str_error'), _t('contact', 'subject'))));
	die();
}



$a['action'] = 'user_pm';
$a['subject'] = $_POST['subject'];
$a['recipient'] = $rec[0]['profile_email'];
$a['userlink'] =  HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['user-profile']['linkvalue'], 'name' => $data[0]['user_login'], 'id' => $data[0]['user_id']));
$a['body'] = $_POST['body'];
$a['sender_email'] = $data[0]['profile_email'];
if(isset($_POST['show_myemail'])) $a['reply_to'] = $a['sender_email'];

// send email to recipient
$emailContainer = prepare_email($a);
$r = send_email($emailContainer);


// optionnaly, send copy to sender
if(isset($_POST['receive_copy'])) {
	$a['recipientlink'] =  HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['user-profile']['linkvalue'], 'name' => $rec[0]['user_login'], 'id' => $rec[0]['user_id']));
	$a['recipient'] = $a['sender_email'];
	$a['subject']= $a['subject']. ' ('._t('contact','copy') .')';
	$a['copy_information'] = '<p><strong>('. _t('contact','copy'). ' ' .  _t('contact','to'). ' <a href="'. $a['recipientlink'].'">' . $recipient . '</a>)</strong></p>'.PHP_EOL.PHP_EOL;
	
	$emailContainer = prepare_email($a);
	$r = send_email($emailContainer);
}


/* Return json values */
echo json_encode(array('status'=> 1,'msg'=> _t('contact', 'message_sent')));

?>