<?php
/**
 * Newsletter module
 * 
 * Newsletter detail page.
 * 
 * @package linea21\modules\newsletter
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////

include_once(override('../user/'.SQL.'.inc.php'));

if (isset($_GET['id'])) $id = $_GET['id'];
if (isset($_POST['id'])) $id = $_POST['id'];

// we get logged-in user email to send a newsletter test
$user = $sql_object->DBSelect(SQL_getAllUserInfo($l21auth->GetSessionElement('id')));
$user_email = $user[0]['profile_email'];

$req_det = SQL_getoneCompleteNewsLetter($id);
$result = $sql_object->DBSelect($req_det);

// Do record exists?
if(!isset($result[0]['newsletter_title'])) redirect_to('@module_default');

$display_title = formatText($result[0]['newsletter_title'], '2HTML');
$display_body = formatText($result[0]['newsletter_body'], '2HTML');
$display_user = formatText($result[0]['user_login'], '2HTML');
$display_date_crea = $result[0]['newsletter_date_crea_display'];
$display_last_modify = $result[0]['newsletter_last_modify_display'];
$display_statut = display_statut($result[0]['newsletter_statut']);
$newsletter_status = $result[0]['newsletter_statut'];
$newsletter_owner= $result[0]['newsletter_posted_by'];

if (formatDate($result[0]['newsletter_published_date_display'], true) == formatDate('0001-01-01', true)) $display_published_date = _t('statut','draft');
else $display_published_date = $result[0]['newsletter_published_date_display'];

$link_sup = $rub_link . "&amp;todo=sup&amp;id=";
$link_mod = $rub_link . "&amp;todo=mod&amp;id=";

// ajax code
$js = '$("a.send-newsletter").click(function() {
        var url = $(this).attr("href");
        id = $(this).attr("id");

        if(id == "send-bulk") {
            
            // if already clicked, we exit
            if( $(this).attr("data-clicked") == "true") {return false};

            /// alertify confirm
        	alertify.set({
        		labels : {
        			ok: "'._t('divers', 'yes').'", cancel: "'._t('divers', 'no').'" }
        	});
        	alertify.confirm("' . _t('newsletter', 'send_confirm') . '", function (e) {
        		if (e) {
        			$("#" + id).attr("data-clicked", true); // we init data clicked flag to prevent double click
                    $("#" + id).html("<span class=\"loading\">&nbsp;<\/span> '._t('newsletter', 'sending_mail').'");
                    
                    alertify.log("<span class=\"loading\">&nbsp;<\/span>' . _t('newsletter', 'sending_mail') . '");
    
            		$.ajax({
            			type: "POST",
            			url: url,
            			data: "call=ajax",
            			dataType: "json",
            			success: function(data){
            				if(data.status==1) {
            					alertify.success(data.msg);
                                $("#" + id).fadeOut("slow");
            				} else {
            					alertify.error(data.msg);
            				}
            			}
            		});
        		} else {
                    return false;
                }
        	});
            /// end - alertify confirm
            
        }
        
        if(id == "send-test") {
    		alertify.log("<span class=\"loading\">&nbsp;<\/span>' . _t('newsletter', 'sending_mail') . '");
    
    		$.ajax({
    			type: "POST",
    			url: url,
    			data: "call=ajax",
    			dataType: "json",
    			success: function(data){
    				if(data.status==1) {
    					alertify.success(data.msg);
    				} else {
    					alertify.error(data.msg);
    				}
    			}
    		});
        }

		return false;

		});';

footerAddInlineJS($js);
?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"> <?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"> <?php echo _t('menu','newsletter'); ?> </a></li>
	<li><span><?php echo formatNavTitle(_t('newsletter','det') . " : " . $display_title); ?></span></li>
</ul>
</div>
<!--end barre haute -->

<div class="contentcontainer">
<?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<?php

if($newsletter_status == 'D') {
    echo '<div class="mod_link"><a class="big-button send-newsletter" data-clicked="false" id="send-bulk" href="../newsletter/_ajax_send.php?id='.$id.'&token='.SECRET_KEY.'" title="'._t('newsletter','send_now').'"><i class="fa fa-paper-plane-o" aria-hidden="true"></i> '._t('newsletter','send_now').'</a></div>';
}

echo "<h2>";
echo formatTitleh2($display_title);
echo "</h2>\n";

echo '<a class="ico_send2 send-newsletter" id="send-test" href="../newsletter/_ajax_send.php?id='.$id.'&user_email='.$user_email.'&token='.SECRET_KEY.'" title="'.sprintf(_t('newsletter','send_test'), $user_email).'"><i class="icon-mail-1"></i><span>'.sprintf(_t('newsletter','send_test'), $user_email).'</span></a>';
echo "\t<a href=\"" . $link_sup . $id . "\" class=\"ico_sup2\" title=\"" . _t('newsletter','sup') . "\"><i class=\"icon-trash\"></i><span>" . _t('newsletter','sup') . "</span></a>\n";
echo "\t<a href=\"" . $link_mod . $id . "\" class=\"ico_mod2\" title=\"" . _t('newsletter','mod') . "\"><i class=\"icon-pencil\"></i><span>" . _t('newsletter','mod') . "</span></a>\n";



echo "<dl class=\"summary\">\n";
echo "<dt>" . mb_ucfirst(_t('newsletter','title')) . " :</dt>\n";
echo "<dd>" . $display_title . "</dd>\n";
echo "<dt>" . mb_ucfirst(_t('newsletter','body')) . " :</dt>\n";
echo "<dd>" . $display_body . "</dd>\n";
echo "<dt>" . mb_ucfirst(_t('newsletter','author')) . " :</dt>\n";
echo '<dd><a href="?rub=user&amp;todo=det&amp;id='.$newsletter_owner.'">' . $display_user . '</a></dd>'.PHP_EOL;
echo "<dt>" . mb_ucfirst(_t('statut','published_on')) . " :</dt>\n";
echo "<dd>" . $display_published_date . "</dd>\n";
echo "<dt>" . mb_ucfirst(_t('divers','date_crea')) . " :</dt>\n";
echo "<dd>" . $display_date_crea . "</dd>\n";
echo "<dt>" . mb_ucfirst(_t('divers','last_modify')) . " :</dt>\n";
echo "<dd>" . $display_last_modify . "</dd>\n";
echo "<dt>" . mb_ucfirst(_t('divers','statut')) . " :</dt>\n";
echo "<dd>" . $display_statut . "</dd>\n";
echo "</dl>\n";
?>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->