<?php
/**
 * Project module - getting actors by ajax call
 * 
 * Return a json file populating actors field in add/mod project page
 *  
 * @package linea21\modules\project
 * @author $Author$ - Simon Georget <simon@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

$noplugin = true; // flag for ../config/define.php file
include_once('../config/define.php');

//////////// Check Droits utilisateur ////////////
if (!$l21auth->hasRight('project')) ReloadIndex('admin');
////////////

include_once('../project/'.SQL.'.inc.php');


if(isset($_REQUEST['filter'])) $filter = $_REQUEST['filter'];
else $filter = false;

$data = $sql_object->DBSelect(SQL_getActorsList($filter));

$response = array();

if(is_array($data)) {
foreach ($data as $i => $value)
    {
      $fullname = '';
      if(!empty($value['actor_name'])) {
      	$fullname = formatText($value['actor_name'], '2HTML');
      	$str_id = $fullname; // $value['actor_id'];
      }
      // if a filter is passed
      if(isset($value['jpa_type']) && $filter == $value['jpa_type']) $response[] = array($str_id, $fullname, null, $fullname);
      else $response[] = array($str_id, $fullname, null, $fullname);
    }
}

header('Content-type: application/json');
echo json_encode($response);