<?php
/**
 * Comment module
 * 
 * Allow administrator to perform ajax actions 
 * 
 * @package linea21\modules\comment
 * @author $Author$ - Simon Georget <simon@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */
$noplugin = true; // flag for ../config/define.php file
include_once ('../config/define.php');

include_once ('../admin/mysql.inc.php');
include_once ('../project/mysql.inc.php');
include_once ('../class/class.project_task.php');
include_once ('../languages/' . U_L . '/lang_project.' . CHARSET . '.php');
include_once ('../languages/' . U_L . '/lang_common.' . CHARSET . '.php');
include_once (override('../project/common.php'));
include_once ("../lib/input_helpers.php");

$pid = $_REQUEST['pid']; // always passed !
$todo = $_REQUEST['todo']; // always passed !

// ////////// Check Droits utilisateur ////////////
if (! $l21auth->isProjectManager($l21auth->GetSessionElement('id'), $sql_object, $pid) && ! $l21auth->isSuperAdmin())
    ReloadIndex('admin');
// //////////

// print_r($_POST);


$returnValues = false;

$cssfiles = array('css/knacss.css', 'css/admin_common.css', 'css/admin_project.css',  'css/light-ui.css');

$otask = new projectTask();

$a = array(); // array to store post values
$integrity = true;

//a task has been submited, we check validty
// only for 'edit' and 'add' actions
if(isset($_POST['valider'])) {
    
    $a['status'] =  $_POST['task-status'];
    $a['label'] =  $_POST['task-label'];
    $a['reminder_freq_hidden'] =  $_POST['task-reminder-f-hidden'];
    
    // because not sent when <select> is disabled
    if(isset($_POST['task-reminder-f'])) $a['reminder_freq'] =  $_POST['task-reminder-f'];
    else $a['reminder_freq'] =  $_POST['task-reminder-f-hidden'];
    
    $a['user_id'] =  $_POST['user_id'];
    $a['pid'] =  $_POST['pid'];
    
    $integrity = $otask->checkDataIntegrity($a);
    
    // data are ok, we can insert in DB
    if(!is_string($integrity)) {
        
        if ($todo == 'add') {
            $r = $otask->add($a, $GLOBALS['sql_object']);
            if(is_numeric($r)) echo "<script>parent.taskEvent = 'added'; parent.$.fn.colorbox.close(); </script>"; // we set taskEvent value for use with colorbox_closed event and we close colorbox on success
            exit;

        }
        if ($todo == 'edit') {
            $id = $_REQUEST['id'];
            $r = $otask->modify($id, $a, $GLOBALS['sql_object']);
            if($r) echo "<script>parent.taskEvent = 'edited'; parent.$.fn.colorbox.close(); </script>"; // we set taskEvent value for use with colorbox_closed event and we close colorbox on success
            exit;

        }
    }
}

///////////////////////////////
// below, we rely on GET method

if ($todo == 'view') {
    $tasks = $otask->get_project_tasks($pid, $GLOBALS['sql_object']);
    echo get_task_progress_bar($pid);
    echo format_tasks($tasks, true); 
}

if ($todo == 'delete') {
    $id = $_GET['id'];
    $r = $otask->delete($id, $GLOBALS['sql_object']);
    $htmlContent = get_task_progress_bar($pid);
    $msg = _t('task', 'deleted_success');

    $returnValues = true;
}

if ($todo == 'add') {  
    echo generateHTMLPage(get_task_form($pid, false, $a, $integrity), 'admin', $cssfiles);
}

if ($todo == 'edit') {
    $id = $_REQUEST['id'];
    echo generateHTMLPage(get_task_form($pid, $id, $a, $integrity), 'admin', $cssfiles);
}

if($returnValues) {
    if ($r == true) {
        echo '{"status":1,"el": "#task-' . $id . '", "action": "' . $todo . '", "msg": "' . $msg . '", "htmlContent": ' . json_encode($htmlContent) . '}';
    } else {
        echo '{"status":0,"el": "#task-' . $id . '", "action": "' . $todo . '", "msg": "' . $msg . '", "htmlContent": ' . json_encode($htmlContent) . '}';
    }
}
?>