<?php
/**
 * Project module
 *
 * Modify given project from back-office.
 *
 * @package linea21\modules\project
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

if (isset($_GET['id']))	$id=$_GET['id'];
if (isset($_POST['id'])) $id=$_POST['id'];

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isProjectManager($l21auth->GetSessionElement('id'), $sql_object, $id) && !$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////
include_once("../lib/input_helpers.php");
include_once(override('../level/mysql.inc.php', THEME_ADMIN_PATH));


// TextboxList CSS/JS inclusion
addDynamicCSS(THEME_ADMIN_PATH.'css/TextboxList.css');
addDynamicCSS(THEME_ADMIN_PATH.'css/TextboxList.Autocomplete.css');
footerAddJS('../lib/js/TextboxList-jQuery/Source/GrowingInput.js');
footerAddJS('../lib/js/TextboxList-jQuery/Source/TextboxList.js');
footerAddJS('../lib/js/TextboxList-jQuery/Source/TextboxList.Autocomplete.js');

// Multiple select CSS/JS inclusion
addDynamicCSS('../lib/js/multipleSelect/dist/multiple-select.css');
footerAddJS('../lib/js/multipleSelect/dist/multiple-select.js');

include_once('../class/class.tag.php');

// we get available tags list to display to user when hovering 'tags' label
$alltags = new tag();
$availableTags = $alltags->getTags('project', -1, false, ',', true);
$tags_list = '';
if(count($availableTags) > 0) {
	$l = '';
	foreach($availableTags as $item) {
		$l .= '<span class="tag">'.$item['tag_name'].'</span>';
	}
	$tags_list = '<div class="tags-list">'.$l.'</div>';
}

// getting tags from given project
$otag = new tag();
$form_tags = $otag->getTags('project', $id, true);

$project_object = new project;


$mask_statut_P='';
$mask_statut_D='';
$mask_archive_P='';
$mask_archive_D='';
$mask_archive_AA='';
$mask_archive_PA='';

if(isset($_POST['enregistrer'])) {
  $data_table=unserialize(urldecode($_POST['data_table']));
  $result=$project_object->ModifyProject($id, $data_table, $sql_object);
  
  if($result) {
  	$otag->modifyTags('project', $id, $data_table['19']);
  }

  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo;
  if($result) {
      header("Location: ".safe_redirect($link_confirm));
      exit;
  }
  else  system_error();
}

// Titre de l'actu en cours de modification
$requete=SQL_getProjectName($id);
$result=$sql_object->DBSelect($requete);

// Do record exists?
if(!isset($result[0]['project_name'])) redirect_to('@module_default');

$project_current_title=formatText($result[0]['project_name'],'2HTML');



// Obtention des données  de la BDD
$req_det= SQL_getoneCompleteProject($id);
$result=$sql_object->DBSelect($req_det);
if($result==0 || count($result)!=1) exit;

include_once(override('../project/display.php'));
$coordinator = getAssociatedActors($id, 'coordinator');
$partners = getAssociatedActors($id, 'partner');
$targets = getAssociatedActors($id, 'target');
$manager = getAssociatedManagers($id, true);

$form_name=formatText($result[0]['project_name'], '2FIELD');
$form_goal= formatText($result[0]['project_goal'], '2FIELD');
$form_opgoal= formatText($result[0]['project_opgoal'], '2FIELD');
$form_description= formatText($result[0]['project_description'], '2FIELD');
$form_body= formatText($result[0]['project_body'], '2FIELD');
$form_budget=formatText($result[0]['project_budget'], '2FIELD');
$form_budget_comment= formatText($result[0]['project_budget_comment'], '2FIELD');
$form_cal_comment= formatText($result[0]['project_cal_comment'], '2FIELD');
$form_coordinator=$coordinator;
$form_partners=$partners;
$form_targets=$targets;
$form_manager=$manager;
$form_elected= formatText($result[0]['project_elected'], '2FIELD');
$form_team= formatText($result[0]['project_team'], '2FIELD');
$form_comment= formatText($result[0]['project_comment'], '2FIELD');
$form_parent_id = ($result[0]['project_parent_id']==0) ? 0 : $result[0]['project_parent_id'];
$form_level_id = ($result[0]['project_level_id']==0) ? 0 : $result[0]['project_level_id'];
$form_workshop_id = ($result[0]['project_workshop_id']==0) ? 0 : $result[0]['project_workshop_id'];
$form_scale_id= $result[0]['project_scale_id'];
$form_priority_id= $result[0]['project_priority_id'];
$form_begin_date= isNullDate($result[0]['project_begin_date_display']) ? '' : $result[0]['project_begin_date_display'];
$form_estimated_date = isNullDate($result[0]['project_estimated_date_display']) ? '' : $result[0]['project_estimated_date_display'];
$form_end_date = isNullDate($result[0]['project_end_date_display']) ? '' : $result[0]['project_end_date_display'];
$form_progression = $result[0]['project_completed'];
$form_progression_sync = $result[0]['project_completed_sync'];
$form_statut=$result[0]['project_statut'];
$current_status=$result[0]['project_statut'];
$project_owner = $result[0]['project_posted_by'];


if(!empty($result[0]['project_impact'])) {
	$default_impacts = $result[0]['project_impact'];
} else {
	$default_impacts = false;
}

if($form_progression_sync == 'Y') $mask_progression_sync = "checked=\"checked\""; else $mask_progression_sync = '';

$form_finality_id = $id;
$form_finalities=array();

// Indicators select box with associated indicators selected
$data_sdi = $sql_object->DBSelect(SQL_getProjectSdi($id));
$tmp_sdi = array();
if($data_sdi != 0 || is_array($data_sdi)) {
    foreach($data_sdi as $value) {
        array_push($tmp_sdi, $value['sdii_id']);
    }
}

if(isset($_POST['valider'])) {

   // current user has no permissions on indicators
   // we repost current indicators because the field is disabled
   if(!$l21auth->hasRight('sdi')) {
       $form_sdi = $tmp_sdi;
   } else {
    isset($_POST['choose_sdi']) ? $form_sdi=$_POST['choose_sdi'] : $form_sdi=array();
   }

  $a = array();
  $a[0]=$_POST['project_name'];
  $a[1]=$_POST['project_description'];
  $a[2]=$_POST['project_body'];
  $a[3]=$_POST['project_parent_id'];
  $a[4]=$_POST['project_scale_id'];
  $a[5]=$_POST['project_priority_id'];
  $a[6]=$_POST['project_begin_date'];
  $a[7]=$_POST['project_estimated_date'];
  $a[8]=$_POST['project_end_date'];
  $a[9]=$_POST['project_statut'];
  $a[10]=$current_status;
  $a[11]=$_POST['project_level_id'];
  $a[12]=$_POST['project_workshop_id'];
  $a[13]=$form_sdi;
  $a[14]=$_POST['project_progression'];
  $a[15]=$_POST['project_budget'];
  $a[16]=$_POST['project_coordinator'];
  $a[17]=$_POST['project_partners'];
  $a[18]=$_POST['project_manager'];
  $a[19]=$_POST['project_tags'];
  $a['goal'] = $_POST['project_goal'];
  $a['opgoal'] = $_POST['project_opgoal'];
  $a['budget_comment'] = $_POST['project_budget_comment'];
  $a['cal_comment'] = $_POST['project_cal_comment'];
  $a['comment'] = $_POST['project_comment'];
  $a['elected'] = $_POST['project_elected'];
  $a['team'] = $_POST['project_team'];
  $a['finalities'] = isset($_POST['finalities']) ? $_POST['finalities'] : array();
  $a['targets']=$_POST['project_targets'];
  
  $a['progression_sync'] = isset($_POST['project_progression_sync']) ? 'Y' : 'N';
  
  if(isset($_POST['project_impacts'])) {
	  $a['impacts'] = $_POST['project_impacts'];
	  $default_impacts = serialize($_POST['project_impacts']); // we overwrite values
  } else $a['impacts'] = array();
  

  $project_object= new project;
  $integrity=$project_object->CheckDataIntegrity($a, $sql_object);


  if(is_string($integrity)) $text_format='2FIELD';
  else $text_format='2HTML';
  $form_name=formatText($_POST['project_name'],$text_format);
  $form_goal=formatText($_POST['project_goal'],$text_format);
  $form_opgoal=formatText($_POST['project_opgoal'],$text_format);
  $form_description=formatText($_POST['project_description'], $text_format);
  $form_body=formatText($_POST['project_body'], $text_format);
  $form_budget=formatText($_POST['project_budget'], $text_format);
  $form_budget_comment=formatText($_POST['project_budget_comment'], $text_format);
  $form_cal_comment=formatText($_POST['project_cal_comment'], $text_format);
  $form_elected=formatText($_POST['project_elected'], $text_format);
  $form_team=formatText($_POST['project_team'], $text_format);
  $form_comment=formatText($_POST['project_comment'], $text_format);
  $form_coordinator=formatText(str_replace(',', ', ', $_POST['project_coordinator']), $text_format);
  $form_partners=formatText(str_replace(',', ', ', $_POST['project_partners']), $text_format);
  $form_targets=formatText(str_replace(',', ', ', $_POST['project_targets']), $text_format);
  $form_manager=formatText(str_replace(',', ', ', $_POST['project_manager']), $text_format);

  $form_begin_date=$_POST['project_begin_date'];
  $form_estimated_date=$_POST['project_estimated_date'];
  $form_end_date=$_POST['project_end_date'];
  $form_progression=$_POST['project_progression'];
  
  $form_progression_sync = isset($_POST['project_progression_sync']) ? 'Y' : 'N';
  
  // we override completion indicator values if based on tasks sync to be sure
  if($a['progression_sync'] == 'Y') {
      $a[14] = $project_object->getCompletion($id, $sql_object, 'percent');
      $form_progression = $a[14];
  }

  $form_parent_id=$_POST['project_parent_id'];
  $form_level_id=$_POST['project_level_id'];
  $form_workshop_id=$_POST['project_workshop_id'];
  $form_scale_id=$_POST['project_scale_id'];
  $form_priority_id=$_POST['project_priority_id'];
  
  $form_finality_id =  false;
  $form_finalities = isset($_POST['finalities']) ? $_POST['finalities'] : array();

  $form_statut=$_POST['project_statut'];
  $form_tags=$_POST['project_tags'];
  
  $impactsViz = getProjectImpacts(serialize($a['impacts']), false); // we prepare impacts viz for resume
  

  if(isset($_POST['project_progression_sync'])) $mask_progression_sync = "checked=\"checked\""; else $mask_progression_sync = '';
  if($_POST['project_statut']=='D') $mask_statut_D="checked=\"checked\""; else $mask_statut_D='';
  if($_POST['project_statut']=='P') $mask_statut_P="checked=\"checked\""; else $mask_statut_P='';
  $a=urlencode(serialize($a));
}

// checkbox Finalities
$display_finalities=getFinalities($form_finality_id, 'write', $form_finalities);

// select-box des niveaux
$data=$sql_object->DBSelect(SQL_getLevelsList());
$select_level=LevelSelectBox($data, "project_level_id", $form_level_id);

// select-box de workshops
$data=$sql_object->DBSelect($req_list_workshop);
$select_workshop=WorkshopSelectBox($data, "project_workshop_id", $form_workshop_id);

// select-box des projets
$data=$sql_object->DBSelect(SQL_getProjectsList(0,1000, 'all_except_deleted'));
$select_parent=ProjectSelectBox($data, "project_parent_id", $form_parent_id, -1, (array) $id);

// select-box des échelles
$data=$sql_object->DBSelect($req_list_scale);
$select_scale=ScaleSelectBox($data, "project_scale_id", $form_scale_id);

// select-box des priorités
$data=$sql_object->DBSelect($req_list_priority);
$select_priority=PrioritySelectBox($data, "project_priority_id", $form_priority_id);


$data=$sql_object->DBSelect($req_list_sdi);
// current user has no permissions on indicators
// we disable Indicators selectors but we have to be sure current Indicators are passed again !!! see above
(!$l21auth->hasRight('sdi')) ?  $disabled = true : $disabled = false;
$select_sdi=SDIMultiSelectBox($data, "choose_sdi", $tmp_sdi, $disabled);

// select-box statut
if($form_statut=='P') $mask_archive_P=' selected="selected"';
if($form_statut=='D') $mask_archive_D=' selected="selected"';
if($form_statut=='AA') $mask_archive_AA=' selected="selected"';
if($form_statut=='PA') $mask_archive_PA=' selected="selected"';
$select_statut="<select name=\"project_statut\" id=\"project_statut\">\n";
$select_statut.="<option value=\"P\"".$mask_archive_P.">".display_statut('P')."</option>\n";
$select_statut.="<option value=\"D\"".$mask_archive_D.">".display_statut('D')."</option>\n";
$select_statut.="<option value=\"AA\"".$mask_archive_AA.">".display_statut('AA')."</option>\n";
$select_statut.="<option value=\"PA\"".$mask_archive_PA.">".display_statut('PA')."</option>\n";
$select_statut.="</select>\n";

// foundation Datepicker include
addDynamicCSS('../lib/js/foundation-datepicker/stylesheets/foundation-datepicker.css');
footerAddJS('../lib/js/foundation-datepicker/js/foundation-datepicker.js');

$js = "if($('#project_progression_sync').length > 0) {
        $('#project_progression_sync').change(function() {
            if($(this).is(':checked')) {
                var  curval = $('#progressbar-project-container').attr('data-tasks-percentage');
                // var rounded = Math.ceil(curval / ".PROJECT_STEP.")* ".PROJECT_STEP.";
                // console.log('curval : ' + curval + ' - rounded : ' + rounded);
                $('#project_progression').val(curval);
                displayValue(curval);
            }
            });
        }";

footerAddInlineJS($js);
// getting projects tasks if enabled
if(defined('PROJECT_TASK') && PROJECT_TASK == 1) {
    $otask = new projectTask();
    $tasks = $otask->get_project_tasks($id, $sql_object);
}
?>


<div id="chemin">
  <ul>
  	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
  	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','project');?></a></li>
  	<li><span><?php echo formatNavTitle(_t('project','mod'). ' :  '.$project_current_title); ?></span></li>
  </ul>
</div>
<!--end barre haute -->



<?php
if(!isset($integrity) || is_string($integrity)) {
?>
<script>

//flags are necessary to update the RIGHT data on colorbox_closed event 
var taskEvent = null; 
var flags = { "indicator-add": false, "project-add": false, "project-edit": false };

function setColorBoxFlag(el) {
	// console.log(flags);
	// console.log('current : ' + el);
	for (var key in flags) {
	    if(key == el) flags[key] = true;
	    else flags[key] = false;
	}
	return true;
}

function displayValue(val) {
	$('#progression_value').html(val + ' %');
}


    
$(document).ready( function() {

	$("div.see-tags").hover(
		function() {
			$('.tags-list', this).fadeIn();
		},
		function() {
			$('.tags-list', this).hide();
		});
		
	// Behavior for adding indicator and refreshing indicators list 
	var cboxOptions = { href:$('#add-indicator a').attr('href') + '&light-ui=true', iframe:true, innerWidth: '80%', innerHeight: '80%', maxWidth: '85%', maxHeight: '85%', onOpen: function() { setColorBoxFlag('indicator-add'); } }
	$("#add-indicator a").colorbox(cboxOptions);
	$(window).resize(function(){ $.colorbox.resize({ width: window.innerWidth > parseInt(cboxOptions.maxWidth) ? cboxOptions.maxWidth : cboxOptions.width, height: window.innerHeight > parseInt(cboxOptions.maxHeight) ? cboxOptions.maxHeight : cboxOptions.height }); });
	    
    $(document).bind('cbox_closed', function(){
    	// console.log(flags);
		if(flags["indicator-add"]) {
            $.ajax({
    	        url : '../project/_ajax_indicators.php',
    	        type: 'GET',
    	        success: function(data) {
    		        
    	        	var selected = $("#choose_sdi").multipleSelect("getSelects");
    						// console.log(selected);
    			      $('#choose_sdi').html(data).multipleSelect("refresh");
    			      var newval = $("#choose_sdi").multipleSelect("getSelects");
    			      if(newval.length > 0) selected = selected.concat(newval);
    			      if(selected.length > 0) $('#choose_sdi').multipleSelect("setSelects", selected);
    		        
    	      		}
    			});
		}
		<?php if(defined('PROJECT_TASK') && PROJECT_TASK == 1) { ?>
		if(flags["project-add"] || flags["project-edit"]) {
            // update task list
            $.ajax({
    	        url : '../project/_ajax_task.php?todo=view&pid=<?php echo $id; ?>',
    	        type: 'GET',
    	        dataType : 'html',
    	        success: function(data) {
    	        	if(taskEvent != null) $("#task-container").html(data).hide().fadeIn(); // si l'action n'est pas allé au bout, on ne fait rien
    	        	if(taskEvent == 'added') setTimeout(function() { alertify.success('<?php echo _t('task', 'added_success'); ?>'); }, 500);
    	        	if(taskEvent == 'edited') setTimeout(function() { alertify.success('<?php echo _t('task', 'edited_success'); ?>'); }, 500);
    	        	taskEvent = null; // we init taskEvent again !
    	        	$("div.dd").trigger("scroll"); // necessary to bind dynamically nestable

    	        	// if on sync we update completion indicator
    	        	if($('#project_progression_sync').length > 0) {
        	            if($('#project_progression_sync').is(':checked')) {
        	            	var  curval = $('#progressbar-project-container').attr('data-tasks-percentage');
        	                var rounded = Math.ceil(curval / <?php echo PROJECT_STEP; ?>) * <?php echo PROJECT_STEP; ?>;
        	                // console.log('Tasks SYNC / curval : ' + curval + ' - rounded : ' + rounded);
        	                $('#project_progression').val(rounded);
        	                displayValue(rounded);
            	        }
    	        	}
    	      		}
    			});
			}
		<?php } ?>	
    	});
        
    
    
		$("#choose_sdi").multipleSelect({
						placeholder:'<?php echo  mb_ucfirst(_t('divers','select_choice')); ?>',
						formatSelectAll () {
							return '<?php echo mb_ucfirst(_t('divers','select_all')); ?>'
						},
						formatAllSelected () {
							return '<?php echo mb_ucfirst(_t('divers','all_selected')); ?>'
						},
						formatNoMatchesFound () {
							return '<?php echo mb_ucfirst(_t('divers','no_matches')); ?>'
						},
						formatCountSelected (count, total) {
							return '<?php echo mb_ucfirst(_t('divers','n_selected')); ?>'.replace("#", count).replace("%", total);
						},
                        filter: true,
                        multiple: false,
                        minimumCountSelected: 2
     	});

		// Autocomplete initialization
		var t1 = new $.TextboxList('#project_coordinator', {unique: true, plugins: {autocomplete: {onlyFromValues: false, placeholder:"<?php echo _t('textbox_js', 'placeholder')?>"}}});
		var t2 = new $.TextboxList('#project_partners', {unique: true, plugins: {autocomplete: {onlyFromValues: false, placeholder:"<?php echo _t('textbox_js', 'placeholder')?>"}}});
		var t3 = new $.TextboxList('#project_manager', {unique: true, plugins: {autocomplete: {onlyFromValues: true, placeholder:"<?php echo _t('textbox_js', 'placeholder')?>"}}});
		var t4 = new $.TextboxList('#project_tags', {unique: true, plugins: {autocomplete: {onlyFromValues: false, placeholder:"<?php echo _t('textbox_js', 'placeholder')?>"}}});
		var t5 = new $.TextboxList('#project_targets', {unique: true, plugins: {autocomplete: {onlyFromValues: false, placeholder:"<?php echo _t('textbox_js', 'placeholder')?>"}}});
		
		$.ajax({url: '../project/_ajax_actor_autocomplete.php', dataType: 'json', success: function(r){
			t1.plugins['autocomplete'].setValues(r);
			t2.plugins['autocomplete'].setValues(r);
		}});

		$.ajax({url: '../project/_ajax_actor_autocomplete.php', data: {filter : 'target'}, dataType: 'json', success: function(r){
			t5.plugins['autocomplete'].setValues(r);
		}});

		$.ajax({url: '../project/_ajax_user_autocomplete.php', dataType: 'json', success: function(r){
			t3.plugins['autocomplete'].setValues(r);
		}});

		$.ajax({url: '../admin/_ajax_tag_autocomplete.php', dataType: 'json', success: function(r){
			t4.plugins['autocomplete'].setValues(r);
		}});

		$("div.textboxlist").each(function() {
		    $(this).append('<p class="soft-emphase"><?php echo _t('msg','textboxlist_notice') ?><\/p>');
		});

		/** datePicker integration
		---------------------------------------------------*/
		var startDate = $('#project_begin_date').val();
		var estimatedDate = $('#project_estimated_date').val();
		var endDate = $('#project_end_date').val();
		
		if('<?php echo DATE_FORMAT; ?>' == 'dd-mm-yyyy') {
			var startDate = startDate != '' ? new Date(startDate.split("-").reverse().join("/")) : '';
			var estimatedDate = estimatedDate != '' ? new Date(estimatedDate.split("-").reverse().join("/")) : '';
			var endDate = endDate != '' ? new Date(endDate.split("-").reverse().join("/")) : '';
		}
		if('<?php echo DATE_FORMAT; ?>' == 'yyyy-mm-dd') {
			var startDate = startDate != '' ? new Date(startDate) : '';
			var estimatedDate = estimatedDate != '' ? new Date(estimatedDate) : '';
			var endDate = endDate != '' ? new Date(endDate) : '';
		}
		
		//console.log('startDate : ' + startDate);
		//console.log('estimatedDate : ' + estimatedDate);
		//console.log('endDate : ' + endDate);
		
		$('#project_begin_date').fdatepicker({ 
			language: '<?php echo U_L; ?>',
			format: '<?php echo DATE_FORMAT; ?>'
		})
		.on('changeDate', function (ev) {
		if (estimatedDate != '' && ev.date.valueOf() > estimatedDate.valueOf()) {
			alertify.error('<span><?php echo _t('project','inconsistent_date'); ?></span>');
			$('#project_begin_date, #project_estimated_date').addClass('i-error');
		} else {
			$('#project_begin_date, #project_estimated_date').removeClass('i-error');
			startDate = new Date(ev.date);
		}
	});
	$('#project_estimated_date').fdatepicker({ 
		language: '<?php echo U_L; ?>',
		format: '<?php echo DATE_FORMAT; ?>'
	})
		.on('changeDate', function (ev) {
		if (startDate != '' && ev.date.valueOf() < startDate.valueOf()) {
			alertify.error('<span><?php echo _t('project','inconsistent_date'); ?></span>');
			$('#project_begin_date, #project_estimated_date').addClass('i-error');
		} else {
			$('#project_begin_date, #project_estimated_date').removeClass('i-error');
			estimatedDate = new Date(ev.date);
		}
	});
	$('#project_end_date').fdatepicker({ 
		language: '<?php echo U_L; ?>',
		format: '<?php echo DATE_FORMAT; ?>'
	})
		.on('changeDate', function (ev) {
		if (startDate != '' && ev.date.valueOf() < startDate.valueOf()) {
			alertify.error('<span><?php echo _t('project','inconsistent_date'); ?></span>');
			$('#project_begin_date, #project_end_date').addClass('i-error');
		} else {
			$('#project_begin_date, #project_end_date').removeClass('i-error');
			endDate = new Date(ev.date);
		}
	});


    });
</script>

<div class="contentcontainer">
<?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<?php
if(isset($integrity) && is_string($integrity)) display_errors($integrity);
?>
<h2><?php echo formatTitleh2($project_current_title); ?></h2>
<form id="modproject" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
<p>
  <label for="project_name"><?php echo mb_ucfirst(_t('project','name')); ?> : *</label>
  <input name="project_name" type="text" class="textfield" maxlength="400" id="project_name" value="<?php echo $form_name; ?>" />
</p>
<p>
  <label for="project_parent_id"><?php echo mb_ucfirst(_t('project','parent')); ?> : </label>
  <?php echo $select_parent; ?>
</p>
<p>
	<label for="project_targets"><?php echo mb_ucfirst(_t('project','target')); ?> : </label>
	<input name="project_targets" type="text" maxlength="500" id="project_targets" class="textfield" value="<?php echo $form_targets; ?>" />
</p>
<?php if(defined('PROJECT_FINALITIES') && PROJECT_FINALITIES == 1) { ?>
<div>
	<div class="label"><?php echo mb_ucfirst(_t('project','finalities')); ?> :</div>
	<div class="rightpanel">
		<?php echo $display_finalities; ?>
	</div>
</div>
<?php } ?>
<?php if(defined('PROJECT_IMPACTS') && PROJECT_IMPACTS > 0) { ?>
<div class="label"><?php echo mb_ucfirst(_t('project','impacts')); ?> : </div>
<div class="rightpanel">
<?php echo getProjectImpactsForm($default_impacts); ?>
</div>
<?php } ?>
<p>
	<label for="project_goal"><?php echo mb_ucfirst(_t('project','goal')); ?> : </label>
	<textarea id="project_goal" name="project_goal" class="largetextfield" <?php echo AREA_SETTINGS; ?>><?php echo $form_goal; ?></textarea>
</p>
<p>
	<label for="project_opgoal"><?php echo mb_ucfirst(_t('project','opgoal')); ?> : </label>
	<textarea id="project_opgoal" name="project_opgoal" class="largetextfield" <?php echo AREA_SETTINGS; ?>><?php echo $form_opgoal; ?></textarea>
</p>
<p>
  <label for="project_description"><?php echo mb_ucfirst(_t('project','description')); ?> : *</label>
  <textarea id="project_description" name="project_description" class="largetextfield" <?php echo AREA_SETTINGS; ?>><?php echo $form_description; ?></textarea>
</p>
<p>
  <label for="project_body"><?php echo mb_ucfirst(_t('project','body')); ?> : </label>
  <textarea id="project_body" name="project_body" class="largetextfield" <?php echo AREA_SETTINGS; ?>><?php echo $form_body; ?></textarea>
</p>
<p>
  <label for="project_priority_id"><?php echo mb_ucfirst(_t('project','priority')); ?> : *</label>
  <?php echo $select_priority; ?>
</p>
<p>
  <label for="project_level_id"><?php echo mb_ucfirst(_t('project','level')); ?> : *</label>
  <?php echo $select_level; ?>
</p>
<p>
  <label for="project_workshop_id"><?php echo mb_ucfirst(_t('project','workshop')); ?> : </label>
  <?php echo $select_workshop; ?>
</p>
<p>
  <label for="project_scale_id"><?php echo mb_ucfirst(_t('project','scale')); ?> : *</label>
  <?php echo $select_scale; ?>
</p>
<div>
  <div class="see-tags label">
	<label for="project_tags"><i class="icon-tag-1"></i> <?php echo mb_ucfirst(_t('tag','name')); ?> : </label>
	<?php echo $tags_list; ?>
  </div>
  <input name="project_tags" type="text" maxlength="800" id="project_tags" class="textfield" value="<?php echo $form_tags; ?>" />
</div>
<p>
  <label for="choose_sdi"><?php echo mb_ucfirst(_t('project','sdi')); ?> : </label>
  <?php echo $select_sdi; ?>
  <?php if ($l21auth->hasRight('sdi')) { ?>
  <div id="add-indicator"><a title="<?php echo mb_ucfirst(_t('project','add_indicator')); ?>" href="index.php?rub=sdi&amp;todo=add" class="small button regular"><i class="icon-attach"></i> <?php echo mb_ucfirst(_t('project','add_indicator')); ?></a></div>
  <?php } ?>
</p>
<p>
	<label for="project_comment"><?php echo mb_ucfirst(_t('project','comment')); ?> : </label>
	<textarea id="project_comment" name="project_comment" class="largetextfield" <?php echo AREA_SETTINGS; ?>><?php echo $form_comment; ?></textarea>
</p>
<p>
  <label for="project_statut"><?php echo mb_ucfirst(_t('project','statut')); ?> : </label>
  <?php echo $select_statut; ?>
</p>


<?php 
// getting projects tasks if defined
if(defined('PROJECT_TASK') && PROJECT_TASK == 1) {
    $js ='var cboxOptions = { iframe:true, innerWidth: "50%", innerHeight: "80%", maxWidth: "85%", maxHeight: "85%", onOpen: function() { setColorBoxFlag("project-add"); } }
	     $("#add-task a").colorbox(cboxOptions);';
    footerAddInlineJS($js);
?>
<h3 class="part"><?php echo mb_ucfirst(_t('project','tasks_title')); ?></h3>
<div>
<div class="label" id="add-task">
	<a href="../project/_ajax_task.php?todo=add&amp;pid=<?php echo $id; ?>" title="<?php echo _t('task','add'); ?>" class="ico_add2"><i class="icon-plus-circled"></i><span><?php echo _t('task','add'); ?></span></a>
</div>
<div class="rightpanel" id="task-container">
<?php 
echo get_task_progress_bar($id);
echo format_tasks($tasks, true); 
?>
</div>
</div>
    
<?php } ?>

<h3 class="part"><?php echo mb_ucfirst(_t('project','calendar_title')); ?></h3>
<p>
  <label for="project_begin_date"><?php echo mb_ucfirst(_t('project','begin_date')); ?> : </label>
  <input name="project_begin_date" type="text" maxlength="10" id="project_begin_date" class="date-pick shorttextfield" value="<?php echo $form_begin_date; ?>" />
</p>
<p>
  <label for="project_estimated_date"><?php echo mb_ucfirst(_t('project','estimated_date')); ?> : </label>
  <input name="project_estimated_date" type="text" maxlength="10" id="project_estimated_date" class="date-pick shorttextfield" value="<?php echo $form_estimated_date; ?>" />
</p>
<p>
  <label for="project_end_date"><?php echo mb_ucfirst(_t('project','end_date')); ?> : </label>
  <input name="project_end_date" type="text" maxlength="10" id="project_end_date" class="date-pick shorttextfield" value="<?php echo $form_end_date; ?>" />
</p>
<div>
	<label for="project_progression"  class="label"><?php echo mb_ucfirst(_t('project','progression')); ?> : </label>
	<input name="project_progression" id="project_progression" type="range" min="0" max="100" step="<?php echo PROJECT_STEP; ?>" value="<?php echo $form_progression; ?>" class="mts" oninput="displayValue(value)" /> 
	<div id="progression_value" class="mtm"><?php echo $form_progression; ?> %</div>
	<?php if(defined('PROJECT_TASK') && PROJECT_TASK == 1) { ?>
	<div class=" rightpanel progression-sync-container">
			<input class="checkbox-switch" name="project_progression_sync" type="checkbox" id="project_progression_sync" value="1" <?php echo $mask_progression_sync; ?> />
			<label for="project_progression_sync"></label><span><?php echo mb_ucfirst(_t('project','progression_sync')); ?> ?</span>
	</div>
	<?php } ?>
</div>
<p>
	<label for="project_cal_comment"><?php echo mb_ucfirst(_t('project','cal_comment')); ?> : </label>
	<textarea id="project_cal_comment" name="project_cal_comment" class="largetextfield" <?php echo AREA_SETTINGS; ?>><?php echo $form_cal_comment; ?></textarea>
</p>

<h3 class="part"><?php echo mb_ucfirst(_t('project','steering_title')); ?></h3>

<p>
	<label for="project_elected"><?php echo mb_ucfirst(_t('project','elected')); ?> : </label>
	<input name="project_elected" type="text" maxlength="500" id="project_elected" class="textfield" value="<?php echo $form_elected; ?>" />
</p>
<p>
	<label for="project_coordinator"><?php echo mb_ucfirst(_t('project','coordinator')); ?> : </label>
	<input name="project_coordinator" type="text" maxlength="500" id="project_coordinator" class="textfield" value="<?php echo $form_coordinator; ?>" />
</p>
<p>
	<label for="project_manager"><?php echo mb_ucfirst(_t('project','manager')); ?> : </label>
	<input name="project_manager" type="text" maxlength="500" id="project_manager" class="textfield" value="<?php echo $form_manager; ?>" />
</p>
<p>
	<label for="project_team"><?php echo mb_ucfirst(_t('project','team')); ?> : </label>
	<textarea id="project_team" name="project_team" class="largetextfield" <?php echo AREA_SETTINGS; ?>><?php echo $form_team; ?></textarea>
</p>
<p>
	<label for="project_partners"><?php echo mb_ucfirst(_t('project','partners')); ?> : </label>
	<input name="project_partners" type="text" maxlength="500" id="project_partners" class="textfield" value="<?php echo $form_partners; ?>" />
</p>

<h3 class="part"><?php echo mb_ucfirst(_t('project','budget_title')); ?></h3>
<p>
	<label for="project_budget"><?php echo mb_ucfirst(_t('project','budget')); ?> : </label>
	<input name="project_budget" type="text" maxlength="10" id="project_budget" class="textfield" value="<?php echo $form_budget; ?>" />
</p>
<p>
	<label for="project_budget_comment"><?php echo mb_ucfirst(_t('project','budget_comment')); ?> : </label>
	<textarea id="project_budget_comment" name="project_budget_comment" class="largetextfield" <?php echo AREA_SETTINGS; ?>><?php echo $form_budget_comment; ?></textarea>
</p>


<div>
  <input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
  <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
  <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
  <?php echo cancel_button('javascript:history.go(-1);'); ?>
  <input name="valider" type="submit" value="<?php echo _t('btn','valid'); ?>" class="button" id="valider" />
</div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
	<?php
	// Récapitulatif
} else	{
  
	// getting level name
	if($form_level_id==0) $level_name=empty_nc('');
	else {
		$record=$sql_object->DBSelect(SQL_getoneLevel($form_level_id));
		$level_name=formatText($record[0]['level_name'], '2HTML');
	}

  $requete=SQL_getonescaleDenomination($form_scale_id);
  $result=$sql_object->DBSelect($requete);
  if($result==0 || count($result)!=1) die('Scale was not found - (id:'.$form_scale_id.')');
  else $scale_denomination=formatText($result[0]['scale_denomination'], '2HTML');

  $requete=SQL_getonepriorityName($form_priority_id);
  $result=$sql_object->DBSelect($requete);
  if($result==0 || count($result)!=1) die('Priority was not found - (id:'.$form_priority_id.')');
  else $priority_name=formatText($result[0]['priority_name'], '2HTML');

  if($form_parent_id != 0) {
    $requete=SQL_getProjectName($form_parent_id);
    $result=$sql_object->DBSelect($requete);
    if($result==0 || count($result)!=1) die('Parent project was not found - (id:'.$form_parent_id.')');
    else $parent_name=formatText($result[0]['project_name'], '2HTML');
  } else $parent_name=_t('divers','none');

  if($form_workshop_id != 0) {
    $query=SQL_getWorkshopName($form_workshop_id);
    $result=$sql_object->DBSelect($query);
    if($result==0 || count($result)!=1) die('Workshop was not found - (id:'.$form_workshop_id.')');
    else $workshop_name=formatText($result[0]['workshop_denomination'], '2HTML');
  } else $workshop_name=_t('divers','none');

  if(count($form_sdi) > 0) {
    $sdi_list='<ul style="padding:0">';
    foreach ($form_sdi as &$value) {
      $query=SQL_getSdiName($value);
      $result = $sql_object->DBSelect($query);
      if($result==0 || count($result)!=1) die('Indicator was not found - (id:'.$result[0]['sdii_is'].')');
      else $sdi_list.= '<li>'.formatText($result[0]['sdii_name'], '2HTML').'</li>'.PHP_EOL;
    }
    $sdi_list.='</ul>';
  } else $sdi_list=_t('divers','none');
  
  $display_finalities = getFinalities(false, 'read', $form_finalities);

  ?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<h2><?php echo formatTitleh2(_t('recap','title')); ?></h2>
<?php
echo "<dl class=\"summary\">\n";
echo "<dt>".mb_ucfirst(_t('project','name'))." :</dt>\n";
echo "<dd>". $form_name."</dd>\n";
echo "<dt>".mb_ucfirst(_t('project','parent'))." :</dt>\n";
echo "<dd>". $parent_name."</dd>\n";
echo "<dt>".mb_ucfirst(_t('project','target'))." :</dt>\n";
echo "<dd>". $form_targets."</dd>\n";
echo "<dt>".mb_ucfirst(_t('project','goal'))." :</dt>\n";
echo "<dd>". empty_nc($form_goal)."</dd>\n";
echo "<dt>".mb_ucfirst(_t('project','opgoal'))." :</dt>\n";
echo "<dd>". empty_nc($form_opgoal)."</dd>\n";
if(defined('PROJECT_FINALITIES') && PROJECT_FINALITIES == 1) {
	echo "<dt>".mb_ucfirst(_t('project','finalities'))." :</dt>\n";
	echo "<dd>". $display_finalities ."</dd>\n";
}
if(defined('PROJECT_IMPACTS') && PROJECT_IMPACTS > 0) {
    echo "<dt>" . mb_ucfirst(_t('project','impacts')) . " :</dt>\n";
    echo "<dd>" . empty_none($impactsViz) . "</dd>\n";
}
echo "<dt>".mb_ucfirst(_t('project','description')). " :</dt>\n";
echo "<dd>".empty_nc($form_description)."</dd>\n";
echo "<dt>".mb_ucfirst(_t('project','body'))." :</dt>\n";
echo "<dd>".empty_none($form_body)."</dd>\n";
echo "<dt>".mb_ucfirst(_t('project','priority'))." :</dt>\n";
echo "<dd>".$priority_name."</dd>\n";
echo "<dt>".mb_ucfirst(_t('project','level'))." :</dt>\n";
echo "<dd>".$level_name."</dd>\n";
echo "<dt>".mb_ucfirst(_t('project','scale'))." :</dt>\n";
echo "<dd>".$scale_denomination."</dd>\n";
echo "<dt>".mb_ucfirst(_t('tag','name'))." :</dt>\n";
echo "<dd>".empty_none(str_replace(',', ', ', $form_tags))."</dd>\n";
echo "<dt>".mb_ucfirst(_t('project','workshop'))." :</dt>\n";
echo "<dd>".$workshop_name."</dd>\n";
echo "<dt>".mb_ucfirst(_t('project','sdi'))." :</dt>\n";
echo "<dd>".empty_none($sdi_list)."</dd>\n";
echo "<dt>".mb_ucfirst(_t('divers','statut'))." :</dt>\n";
echo "<dd>". display_statut($_POST['project_statut']). "</dd>\n";
echo "</dl>\n";
?>

<?php 
// getting projects tasks if defined
if(defined('PROJECT_TASK') && PROJECT_TASK == 1) {
?>
<h3 class="part"><?php echo mb_ucfirst(_t('project','tasks_title')); ?></h3>
<dl class="summary">
<dt></dt>
<dd>
<?php 
echo get_task_progress_bar($id);
echo format_tasks($tasks); 
?>
</dd>
</dl>
<?php } ?>

<h3 class="part"><?php echo mb_ucfirst(_t('project','calendar_title')); ?></h3>
<dl class="summary">
<dt><?php echo mb_ucfirst(_t('project','begin_date')); ?> : </dt>
<dd><?php echo empty_nc($form_begin_date); ?></dd>
<dt><?php echo mb_ucfirst(_t('project','estimated_date')); ?> : </dt>
<dd><?php echo empty_nc($form_estimated_date); ?></dd>
<dt><?php echo mb_ucfirst(_t('project','end_date')); ?> : </dt>
<dd><?php echo empty_nc($form_end_date); ?></dd>
<dt><?php echo mb_ucfirst(_t('project','progression')); ?> : </dt>
<dd><?php echo getDynamicProgressbar($form_progression); ?></dd>
<dt><?php echo mb_ucfirst(_t('project','progression_sync')); ?> : </dt>
<dd><?php echo $form_progression_sync == 'Y' ? _t('divers', 'yes') : _t('divers', 'no'); ?></dd>
<dt><?php echo mb_ucfirst(_t('project','cal_comment')); ?> : </dt>
<dd><?php echo empty_nc($form_cal_comment); ?></dd>
</dl>

<h3 class="part"><?php echo mb_ucfirst(_t('project','steering_title')); ?></h3>
<dl class="summary">
<dt><?php echo mb_ucfirst(_t('project','elected')); ?> : </dt>
<dd><?php echo empty_nc($form_elected); ?></dd>
<dt><?php echo mb_ucfirst(_t('project','coordinator')); ?> : </dt>
<dd><?php echo empty_nc($form_coordinator); ?></dd>
<dt><?php echo mb_ucfirst(_t('project','manager')); ?> : </dt>
<dd><?php echo empty_nc($form_manager); ?></dd>
<dt><?php echo mb_ucfirst(_t('project','partners')); ?> : </dt>
<dd><?php echo empty_nc($form_partners); ?></dd>
<dt><?php echo mb_ucfirst(_t('project','team')); ?> : </dt>
<dd><?php echo empty_nc($form_team); ?></dd>
</dl>

<h3 class="part"><?php echo mb_ucfirst(_t('project','budget_title')); ?></h3>
<dl class="summary">
<dt><?php echo mb_ucfirst(_t('project','budget')); ?> : </dt>
<dd class="money"><?php echo empty_nc(fnumber_format($form_budget,0, false)); ?></dd>
<dt><?php echo mb_ucfirst(_t('project','budget_comment')); ?> : </dt>
<dd><?php echo empty_none($form_budget_comment); ?></dd>
</dl>

<form id="modscale" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
  <div>
    <input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
    <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
    <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
    <input name="data_table" type="hidden" value="<?php echo $a; ?>" id="data_table" />
    <?php echo cancel_button('?rub=project&amp;todo=list'); ?>
    <input name="retour" type="button" value="<?php echo _t('btn','preview'); ?>" class="button" id="retour" onclick="history.go(-1);" />
    <input name="enregistrer" type="submit" value="<?php echo _t('btn','save'); ?>" class="button" id="valider" />
  </div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php } ?>