<?php
/**
 * Default workgroup subscription template
 * 
 * This file can be overriden. Discover logic and examples on :
 * @url http://dev.linea21.com/projects/linea21/wiki/Override
 * @url http://dev.linea21.com/projects/linea21/wiki/Personnalisation_de_l%27interface_publique
 * 
 * @package linea21\core\public
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once('../class/class.workshop.php');
include_once('../workshop/'.SQL.'.inc.php');

isset($_SESSION['authenticated']) ?  $isAuthentified = true : $isAuthentified = false;

if(isset($_REQUEST['id'])) {
  $_POST['workgroup_'.$_REQUEST['id']] = true;
  $link_back = HrefMaker(array('rub'=>$GLOBALS['links'][U_L]['workgroup']['linkvalue'], 'id'=> $_REQUEST['id']));
}
$link_registration = array('rub'=> $GLOBALS['links'][U_L]['user-registration']['linkvalue']);
$link_account = array('rub'=> $GLOBALS['links'][U_L]['user-prefs']['linkvalue']);

function ischecked($id) {
  if(isset($_POST['workgroup_'.$id]))  return "checked";
  else return "";
}

function isWgselected($workgroups) {
  for($i=0; $i<count($workgroups); $i++) {
    $var = 'workgroup_'.$workgroups[$i]->workshop_id;
    if(isset($_POST[$var])) return true;
  }
  return false;
}

function getSelectedwg($workgroups) {
  $a = array();
  for($i=0; $i<count($workgroups); $i++) {
    $var = 'workgroup_'.$workgroups[$i]->workshop_id;
    if(isset($_POST[$var])) array_push($a, $workgroups[$i]->workshop_id);
  }

  return $a;
}
?>

<?php
// set HTML Title
SetHTMLTitle(_t('workshop','get_involve_long'));
setBreadcrumb(array(ucfirst(_t('workshop', 'section')) => HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['workgroup']['linkvalue']))));
setBreadcrumb(array(_t('workshop','get_involve') => false));

// workshops
$workgroups = $GLOBALS['sql_object']->DBSelect(SQL_Get_WorkshopsNames(), 'OBJECT');
// we init an array to see if user has already subscribed all groups
$subscribed = array();

if(isset($workgroups[0]->workshop_id)) {
	for($i=0; $i<count($workgroups); $i++) {
		
		// we do not test restricted workshop
		if($workgroups[$i]->workshop_restricted == 0) {
		  if($GLOBALS['l21auth']->isWorkgroupUser($workgroups[$i]->workshop_id, $GLOBALS['sql_object']) || $GLOBALS['l21auth']->isWorkgroupPendingUser($workgroups[$i]->workshop_id, $GLOBALS['sql_object'])) {
		    array_push($subscribed, true);
		  } else {
		    array_push($subscribed, false);
		  }
		}
	}
}
?>
<h1><?php echo _t('workshop','get_involve_long'); ?></h1>

<?php 
$slot = get_page_slot('workgroup-sub'); // default slot
if($slot) echo '<div class="sub-title">'.$slot.'</div>'.PHP_EOL;
?>

<div>


<?php
$comment='';

if(isset($_POST['comment'])) {

  $msg='';

  // sélection d'au moins un groupe
  if (!isWgselected($workgroups)) $msg.=_t('workshop','nogroup_selected').'<br />';
  else {
    $allgroups='';
    $data=$GLOBALS['sql_object']->DBSelect(SQL_Get_WorkshopsNames(getSelectedwg($workgroups)), 'OBJECT');

    $a = array();
    foreach($data as $el) {
      $allgroups.= " - ".$el->workshop_denomination. " <i>(id: ".$el->workshop_id.")</i><br />\n";

      // notify moderators by mail if set-up
	  if(defined('ALERT_NEWSUB') && ALERT_NEWSUB == 1) notifyUsersMsg(array('action' => 'workgroup_request','user' => $_SESSION['userlogin'], 'id' => $el->workshop_id, 'moderate_link' => SITE_ROOT_URL . 'admin/index.php#workgroup-users', 'comment' => formatText(strip_tags($_POST['comment']), '2FIELD')));
    }
  }

  if(empty($msg)) {
    $passed = true;
    $class='confirmed';
    $msg .= _t('workshop', 'confirm_request');
    if(isset($link_back)) $msg .= ' <a href="'.$link_back.'" title="'._t('workshop','workshop_back').'" >'._t('workshop','workshop_back').'</a>.'.PHP_EOL;
    
    $workshop_object = new workshop;
    foreach($data as $el) {
    	$workshop_object->AddUserWorkshop($el->workshop_id, $_SESSION['userlogin'], 'A', $GLOBALS['sql_object']);
    }

  } else {
    $passed = false;
    $class='error';
  }
}

if(isset($passed)) echo '<div class="'.$class.'">'.$msg.'</div>';

if(!$isAuthentified) {

  echo '<p class="warning">'._t('workshop','note_account').' ' . '<a href="'.HrefMaker($link_account).'" title="'.formatText(_t('divers','auth'), '2ATT').'" >'._t('divers','auth').'</a>.<br />'.PHP_EOL;
  if(defined('FREE_REGISTRATION') || FREE_REGISTRATION == 1)  echo '<a href="'.HrefMaker($link_registration).'">'._t('user','info_inscription2').' </a>';
  echo '</p>';

} else {
  // affichage s'il manque un champs
  if(!isset($passed) || $passed == false) {

      $listed_workgroups = [];
    // the user has not subscribed all groups, we display the form
    if(in_array(false, $subscribed)) {

    	echo '<form id="wg-subscription" action="'.CURRENT_APP_URL.'index.php" method="post">';
    	echo '<div id="choosegdt">'._t('workshop','subscribe_to').' : </div>';
    	
    	echo '<div class="label-leftmargin mam">';
    	for($i=0; $i<count($workgroups); $i++) {
    	    
    	    if(isset($_REQUEST['id']) && $workgroups[$i]->workshop_id == $_REQUEST['id']) $invisibleWGName = $workgroups[$i]->workshop_denomination;
    	        
    		if(!$GLOBALS['l21auth']->isWorkgroupUser($workgroups[$i]->workshop_id, $GLOBALS['sql_object'])) {
    	
    			// if group is restricted users are not allowed to subscribed
    		    if($workgroups[$i]->workshop_restricted != 1 && $workgroups[$i]->workshop_visible == 1) {
    				// we remove the workgroups user already belongs to
    				echo '<p class="wg-checkbox">';
    				echo '<input name="workgroup_'.$workgroups[$i]->workshop_id.'" id="workgroup_'.$workgroups[$i]->workshop_id.'" value="'.$workgroups[$i]->workshop_id.'" class="cb" type="checkbox" '.ischecked($workgroups[$i]->workshop_id).'>';
    				echo '<label class="labelised autowidth" style="margin-left:1em;" for="workgroup_'.$workgroups[$i]->workshop_id.'">'.$workgroups[$i]->workshop_denomination.'</label>';
    				echo '</p>';
    				array_push($listed_workgroups, $workgroups[$i]->workshop_id);
    			}
    		}
    	}
		echo '</div>';
		// if coming from invisible workshop we let know to user that it is included !!!
		if(isset($_REQUEST['id']) && !in_array($_REQUEST['id'], $listed_workgroups)) echo '<p class="info mal">'.sprintf(_t('workshop','subscribe_to_invisible'), $invisibleWGName).'</p>';

		
		echo '<label class="labelised" for="comment">'.mb_ucfirst(_t('divers', 'comment')).' ('._t('divers', 'optional').') : '.'</label>';
		echo '<textarea name="comment" id="comment" cols="60" rows="10" class="mbm"></textarea>';
		echo '<br />';
		echo '<div class="submit-container"><input value="'._t('btn', 'valid').'" class="submitbut" type="submit"></div>';
		echo '<input name="rub" value="inscription-groupe" type="hidden">';
		if(isset($_REQUEST['id'])) echo '<input name="id" value="'.$_REQUEST['id'].'" type="hidden">';
		echo '</form>';
      	
      // the user already subscribed all groups, we display a warning
    } else {
      echo '<p class="warning">'._t('workshop', 'allgroups_subscribed').'</p>'.PHP_EOL;
    }
  }
}

?></div>