<?php
/**
 * Dashboard module
 *
 * Generate charts displayed in both admin and public UIs
 * Can either display them inline or save them into given folder
 *
 * @package linea21\modules\dashboard
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */


include_once("../config/define.php");
include_once("../dashboard/common.php");
include_once("../dashboard/".SQL.".inc.php");
include_once(override("../dashboard/chart-prepare.php"));
include_once('../languages/' . U_L . '/lang_dashboard.' . CHARSET . '.php');
include_once('../languages/' . U_L . '/lang_sdi.' . CHARSET . '.php');
include_once('../languages/' . U_L . '/lang_common.' . CHARSET . '.php');

if(MOD_DEBUG == 1) $csuffix = '?v='. time(); else $csuffix= '';

// getting chart sizes from config file
list($cwidth, $cheight) = explode('x', CHART_DEFAULT_SIZE);


isset($_GET['id']) && isset($_GET['id'])? $id = formatText($_GET['id'], '2FIELD')  : die('no given id');
if(!is_numeric($_GET['id'])) die ('no way');
isset($_GET['scale']) ? $scale = formatText($_GET['scale'], '2FIELD')  : $scale = 1;
isset($_GET['year']) ? $year = formatText($_GET['year'], '2FIELD')  : $year = null;
isset($_GET['type']) ? $type = formatText($_GET['type'], '2FIELD')  : $type = null;
isset($_GET['width']) ? $width = formatText($_GET['width'], '2FIELD') : $width = $cwidth; // should be '%'
isset($_GET['height']) ? $height = formatText($_GET['height'], '2FIELD') : $height = $cheight;
isset($_GET['unit']) && in_array($_GET['unit'], array('%', 'px')) ? $unit = formatText($_GET['unit'], '2FIELD') : $unit = 'px';// pixel is default unit  
isset($_GET['notitle']) ? $notitle = 1 : $notitle = 0;


// auto values, pixel and % units are supported
if($width != 'auto') {
    // if unit is not set into width / height we set it 
    if(!Stringy\Stringy::create($width, CHARSET)->endsWith('px') && !Stringy\Stringy::create($width, CHARSET)->endsWith('%')) {
        $width .= $unit;
    }
}
if($height != 'auto') {
    // if unit is not set into width / height we set it 
    if(!Stringy\Stringy::create($height, CHARSET)->endsWith('px') && !Stringy\Stringy::create($height, CHARSET)->endsWith('%')) {
        $height .= $unit;
    }
}
// we get indicator's info
$indicator = $sql_object -> DBSelect(SQL_getInfoSdi($id));




// we get indicator's values
$values = $sql_object -> DBSelect(SQL_getAllValue("SCA", $scale, $id));


// we create an array to populate and send to javascript
$obj = [];
$obj['site-language'] = U_L;
$obj['indicator-notitle'] = $notitle;
$obj['indicator-name'] = formatText($indicator[0]['sdii_name'], '2HTML');
$obj['indicator-type'] = $indicator[0]['sdii_value_type'];
$obj['indicator-default-vis'] = $indicator[0]['sdii_detail_viz'];
if(is_null($year)) {
    !is_null($type) && in_array($type, array_keys($GLOBALS['lang']['sdi']['select_detail_viz'])) ? $obj['indicator-wanted-vis'] = $type : $obj['indicator-wanted-vis'] = $indicator[0]['sdii_detail_viz'];
} else { // we try to generate a multiple indicator chart for a given year
    !is_null($type) && in_array($type, array_keys($GLOBALS['lang']['viz'])) ? $obj['indicator-wanted-vis'] = $type : $obj['indicator-wanted-vis'] = array_keys($GLOBALS['lang']['viz'])[1];
    
}
$obj['indicator-wanted-year'] = $year; // if not set, takes null value
$obj['indicator-serie-name']  = formatText(_t('dashboard', 'value'), '2HTML');
$obj['indicator-threshold-name']  = formatText(_t('dashboard', 'threshold_value'), '2HTML');
$obj['indicator-unit'] = $indicator[0]['sdii_unit'];
$obj['indicator-negative-notice'] = formatText(_t('dashboard', 'negative_values_notice'));
$obj['dates'] = array();
$obj['data'] = array();
$obj['thresholds'] = array();

if($obj['indicator-wanted-vis'] == 'donut') {
    $obj['indicator-wanted-vis'] = 'pie';
    $obj['vis-pie-size'] = '60%';
}


$cdata = prepare_chart_data($indicator, $obj, $values);

?>
<!doctype html>
<html lang="<?php echo U_L; ?>">
<head>
<meta charset="<?php echo U_L; ?>" />
<script src="../lib/js/jquery-1.11.3.min.js"></script>
<script src="../lib/js/jquery-browser.js"></script>
<link rel="stylesheet" href="<?php echo PUBLIC_THEME_URL; ?>css/knacss/css/knacss.css" media="all">
<link rel="stylesheet" href="<?php echo PUBLIC_THEME_URL . 'css/style.css' . $csuffix; ?>" media="all" />
<link rel="stylesheet" href="<?php echo SITE_ROOT_URL; ?>lib/vendor/font-awesome/css/font-awesome.min.css">
<title><?php echo $obj['indicator-name'] . ' - ' . SITE_NAME ?></title>
<script>
	var input = <?php echo json_encode($cdata, JSON_NUMERIC_CHECK); ?>;
	// console.log(input);
</script>
<style>
#main-chart-container {
  width:100%;
  min-height:100%;
  height:auto ! important;
}
</style>
</head>
<body>
<div class="chart-container" style="width:<?php echo $width ?>;height:<?php echo $height ?>;margin:0 auto;text-align:center;">
<div id="main-chart-container"></div>
</div>

<?php 
$alt = '';
if(isset($_GET['alternatives'])) {
    $types = array('pie', 'donut', 'treemap');
    
    isset($_GET['share']) ? $suffix = '&share=1' : $suffix = '';
    
    $alt .= '<span>' . _t('viz', 'alternatives'). '</span> : ';
    $sep = '';
    foreach($types as $t) {
        if($t !=  $type) {
            $alt .= $sep . '<a href="'.SITE_ROOT_URL.'public/get-chart.php?id='.$id .'&type='.$t.'&year='.$obj['indicator-wanted-year'].'&alternatives=all'.$suffix.'">'.mb_ucfirst(_t('viz', $t)).'</a>';
            $sep = ' - ';
        }
        
    }
    $alt = sprintf('<div class="alternatives-vis"><i class="fa fa-pie-chart" aria-hidden="true"></i> %s</div>', $alt);
}


if(isset($_GET['share'])) {

    $embedcode = '<iframe src="'.SITE_ROOT_URL.'public/get-chart.php?id='.$id.'&type='.$type.'&year='.$obj['indicator-wanted-year'].'&width='.$cwidth.'&height='.($cheight).'" width="100%" height="'.($cheight+110).'" frameborder="0" style="border:0;" allowfullscreen="" aria-hidden="false" tabindex="0"></iframe>';

    $share  = '<input class="visually-hidden" id="chart-iframe" value="'.htmlentities($embedcode).'" /><button class="copy-chart-iframe button small" data-clipboard-action="copy" data-clipboard-target="#chart-iframe"><i class="fa fa-file-code-o"></i> '._t('copy', 'embedcode') .'</button>';
    $share .= '<script src="../lib/js/clipboard.js-2.0.10/dist/clipboard.min.js"></script>';
    
    $share .= '<script>
            var clipboard = new ClipboardJS(".copy-chart-iframe");
    
            clipboard.on("success", function(e) {
                $("#copy-response").html("'._t('copy', 'embedcode_copy_succeed') .'").hide().fadeIn().delay(2000).fadeOut();
            });
                    
            clipboard.on("error", function(e) {
                $("#copy-response").html("'._t('copy', 'embedcode_copy_failed') .'").hide().fadeIn().delay(2000).fadeOut();
            });
        </script>';
} else $share = '';


if(isset($_GET['alternatives']) || isset($_GET['share'])) {
?>
<div class="flex-container pam">
  <div class="w50"><?php echo $alt; ?></div>
  <div class="item-fluid txtright prs"><span id="copy-response"></span></div>
  <div class="w20 txtright"><?php echo $share; ?></div>
</div>
<?php } ?>
<script src="../lib/js/Highcharts-7.0.3/code/highcharts.js"></script>
<script src="../lib/js/Highcharts-7.0.3/code/modules/heatmap.js"></script>
<script src="../lib/js/Highcharts-7.0.3/code/modules/treemap.js"></script>
<script src="../lib/js/Highcharts-7.0.3/code/modules/exporting.js"></script>
<script src="../lib/js/Highcharts-7.0.3/code/modules/offline-exporting.js"></script>
<script src="../lib/js/generate-chart.js"></script>
</body>
</html>