<?php
/**
 * Scale module
 * 
 * Display scales list in back-office
 * 
 * @package linea21\core\scale
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////

$current_title=_t('scale','list');

footerAddJS('../lib/js/jquery.nestable.js');

$js = '           $("div.dd").nestable({listNodeName: "ul"}).on("change", function() {
                      var json_text = $("div.dd").nestable("serialize");
                      // console.log(json_text);
                      $.get("../admin/_ajax_sort.php", {
                        rub: "'.$rub.'",
                        "sort-table": json_text
                      }, function(data){
                      console.log(data);
                        // replacing data.class by data["class"] for IE8 bug fix
					if(data["class"] == "succeed") {
						alertify.success(data.msg);
					} else {
						alertify.error(data.msg);
					}
                      }, "json");
                    });';
footerAddInlineJS($js);

$result=$sql_object->DBSelect($req_list2);

function display_scale($parent, $dep, $array, $rub_link) {
  $html = "";
  $prev_dep = 0;
  $link_sup=$rub_link."&amp;todo=sup&amp;id=";
  $link_mod=$rub_link."&amp;todo=mod&amp;id=";
  $link_det=$rub_link."&amp;todo=det&amp;id=";

  if (!$dep && !$prev_dep) $html .= "\n<ul>\n";
  foreach ($array as $item) {

    $current_id=$item['scale_id'];
    $current_denomination=formatText($item['scale_denomination'], '2HTML');

    if ($parent == $item['scale_root']) {
      if ($prev_dep < $dep) $html .= "\n<ul>\n";

      $link =	"\t<div class=\"dd-handle\">&nbsp;</div><div class=\"dd-content\">";
      $link .=	"\t<a href=\"".$link_det.$current_id."\">".$current_denomination."</a><div class=\"list-actions\">\n";
      if ($item['scale_root'] != 0) $link.="\t<a href=\"".$link_sup.$current_id."\" class=\"ico_sup\" title=\""._t('scale','sup')."\"><i class=\"icon-trash\"></i><span>" . _t('scale','sup') . "</span></a>\n";
      $link.="\t<a href=\"".$link_mod.$current_id."\" class=\"ico_mod\" title=\""._t('scale','mod')."\"><i class=\"icon-pencil\"></i><span>" . _t('scale','mod') . "</span></a></div>\n";
      $link.="</div>\n";


      $html .= "<li class=\"dd-item li".$dep."\"  data-id=\"".$current_id."\">" . $link;
      $prev_dep = $dep;
      $html .= display_scale($item['scale_id'], ($dep + 1), $array, $rub_link);
    }
  }
  if (($prev_dep == $dep) && ($prev_dep != 0)) $html .= "</ul>\n</li>\n";
  else if ($prev_dep == $dep) $html .= "</ul>\n";
  else $html .= "</li>\n";
  return $html;
}
?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','scale'); ?></a></li>
	<li><span><?php echo formatnavTitle($current_title); ?></span></li>
</ul>
</div>
<!--end barre haute -->

<div class="contentcontainer"><?php	include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));	?>
<div id="content">
	<h2><span class="visually-hidden"><?php echo formatTitleh2($current_title) ;?></span></h2>
	<div id="tree" class="dd">
	<?php echo display_scale(0,0,$result, $rub_link); ?>
	</div>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->