<?php
/**
 * Indicator / SDI module
 * 
 * Display indicators /SDI list in back-office
 * 
 * @package linea21\modules\sdi
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->hasRight('sdi')) ReloadIndex('admin');
////////////
include_once(override('../level/mysql.inc.php', THEME_ADMIN_PATH));

// we get levels
$result=$sql_object->DBSelect(SQL_getLevelsList());
$sdi_object= new sdi;

// we get indicators
$sdi = $sql_object->DBSelect(SQL_getListSdi("R"));


include_once('../class/class.tag.php');

// getting tags menu filter
$otag = new tag();
$tags =$otag->getTags('indicator', -1, false);


footerAddJS('../lib/js/jquery.nestable.js');

$js = '           $("div.dd").nestable({listNodeName: "ul"}).on("change", function() {
                        console.log($(this).prop("id"));
                      var json_text = $("#" + $(this).prop("id")).nestable("serialize");
                      console.log(json_text);
                      $.get("../admin/_ajax_sort.php", {
                        rub: "'.$rub.'",
                        "sort-table": json_text
                      }, function(data){
                      console.log(data);
                        // replacing data.class by data["class"] for IE8 bug fix
					if(data["class"] == "succeed") {
						alertify.success(data.msg);
					} else {
						alertify.error(data.msg);
					}
                      }, "json");
                    });';
footerAddInlineJS($js);

    
    /**
     * getMenuFilter()
     *
     * @param array $tags
     * @return string
     */
    function getMenuFilter ($tags = array()) {
        
        footerAddJS('../lib/js/jquery-tag-filtering/jquery.tagfiltering.simo.js');
        addDynamicCSS('../lib/js/jquery-tag-filtering/jquery.tagfiltering.simo.css');
        
        // one call to apply many filters from several lists (ul) with same css class and using distincts data-* attributes
        // to comment if individual filtering are applied
        footerAddInlineJS('$("ul.filter-menu").tagfiltering({target_attr:"data-tags,data-types,data-strats", separator:";"});');
        
        $filter_menu  = '<div class="toggle_title"><a id="indicator-filter" href="#">'._t('filter', 'content').'</a></div>';
        $filter_menu .= '<div class="contboxwhite filters" style="display:none">';
        $filter_menu .= getStrategicMenuFilter (array(_t('sdi', 'attached_to_dashboard'), _t('sdi', 'not_attached_to_dashboard')));
        $filter_menu .= getTypesMenuFilter ($GLOBALS['lang']['sdi']['select_type']);
        $filter_menu .= getTagsMenuFilter ($tags);
        $filter_menu .= '<div class="end"></div><br class="brendstep" />';
        $filter_menu .= '</div>';
        
        return $filter_menu;
    }

/**
 * getTagsMenuFilter()
 *
 * get tags menu filter
 *
 * @param array $tags
 * @return string
 */
function getTypesMenuFilter($types)
{
    $filter = '';

    // we display filter if at least 1 values exists
    if (count($types) >= 1) {
        $options = '';
        $a = array();
        foreach ($types as $key => $val) {
            if (! in_array($key, $a)) {
                $options .= '<li data-tag="' . formatText(mb_ucfirst($val), '2HTML') . '" id="type-' . $key . '"><a class="facet" href="#">' . formatText(mb_ucfirst($val), '2HTML') . '</a></li>';
                array_push($a, $key);
            }
        }

        $filter .= sprintf('<div class="type-filter item-filter"><h3>%s</h3><ul class="filter-menu types-filter-menu">%s</ul></div>', _t('filter', 'by_type'), $options);
    }
    return $filter;
}

/**
 * getTagsMenuFilter()
 *
 * get tags menu filter
 *
 * @param array $tags
 * @return string
 */
function getStrategicMenuFilter($entries)
{
    $filter = '';
    
    // we display filter if at least 1 values exists
    if (count($entries) >= 1) {
        $options = '';

        foreach ($entries as $key => $val) {
                $options .= '<li data-tag="' . formatText(mb_ucfirst($val), '2HTML') . '" id="strat-' . $key . '"><a class="facet" href="#">' . formatText(mb_ucfirst($val), '2HTML') . '</a></li>';
        }
        
        $filter .= sprintf('<div class="strat-filter item-filter"><h3>%s</h3><ul class="filter-menu strat-filter-menu">%s</ul></div>', _t('filter', 'by_significance'), $options);
    }
    return $filter;
}

/**
 * getTagsMenuFilter()
 *
 * get tags menu filter
 *
 * @param array $tags
 * @return string
 */
function getTagsMenuFilter($tags)
{
    $filter = '';

    // we display filter if at least 2 values exists
    if (count($tags) > 1) {
        $options = '';
        $a = array();
        foreach ($tags as $item) {
            if (! in_array($item['tag_id'], $a)) {
                $options .= '<li data-tag="' . $item['tag_name'] . '" id="tag-' . $item['tag_id'] . '"><a class="facet" href="#">' . $item['tag_name'] . '</a></li>';
                array_push($a, $item['tag_id']);
            }
        }

        $filter .= sprintf('<div class="tag-filter item-filter"><h3>%s</h3><ul class="filter-menu tags-filter-menu">%s</ul></div>', _t('filter', 'by_tag'), $options);
    }
    return $filter;
}
    



function display_level($parent, $dep, $array, $rub_link, $sdi) {
	$html = "";
	$prev_dep = 0;
	$link_sup=$rub_link."&amp;todo=sup&amp;id=";
	$link_mod=$rub_link."&amp;todo=mod&amp;id=";
	$link_det=$rub_link."&amp;todo=det&amp;id=";
	$link_level="index.php?rub=level&amp;todo=det&amp;id=";
	

	if (!$dep && !$prev_dep) $html .= "\n<ul>\n";
	foreach ($array as $item) {

		$current_id = $item['level_id'];
		$current_shortname = formatText($item['level_name'], '2HTML');
		
		if(!empty($item['level_code'])) $code = ' ['.$item['level_code'].'] '; else $code = '';
		$level_label = $item['level_name'] . $code;
		$current_name = '<span class="level-label">' .formatText( $item['level_label'], '2HTML'). '</span> ' . formatText($level_label, '2HTML');
		$current_name_att = formatText($item['level_label'] . ' : ' . $item['level_name'], '2ATT');
		if(defined('DISPLAY_LEVEL_LABEL') && DISPLAY_LEVEL_LABEL == 1) $disp_level_name = $current_name; else $disp_level_name = $current_shortname;
		
		if ($parent == $item['level_parent']) {
			
			// we prepare indicators if they are attached to current level
			$sdi_html = '';
			if(is_array($sdi)) {
				for ($j=0; $j < count($sdi); $j++) {
					if ($current_id == $sdi[$j]['sdii_level']) {
						if(empty($sdi_html)) $sdi_html.="<ul class=\"filter-items\">\n";
						
						// getting tags
						$otag = new tag ();
						$display_tags = $otag->getTags ( 'indicator', $sdi[$j]['sdii_id'], true, ';' );
						$display_types = formatText(mb_ucfirst($GLOBALS['lang']['sdi']['select_type'][$sdi[$j]['sdii_type']]), '2HTML');
						
						if($sdi[$j]['sdii_to_dashboard'] == 'Y') $display_strat = formatText(mb_ucfirst(_t('sdi', 'attached_to_dashboard')), '2HTML');
						else $display_strat = formatText(mb_ucfirst(_t('sdi', 'not_attached_to_dashboard')), '2HTML');
				
						// we populate lists
						
						$sdi_html.="<li class=\"dd-item\" data-strats=\"".$display_strat."\" data-tags=\"".$display_tags."\"  data-types=\"".$display_types."\" data-id=\"".$sdi[$j]['sdii_id']."\">\n";
						$sdi_html.=	"\t<div class=\"dd-handle\">&nbsp;</div><div class=\"dd-content\">";
						$sdi_html.="\t<a href=\"".$link_det.$sdi[$j]['sdii_id']."\" title=\"".formatText($sdi[$j]['sdii_name'], '2HTML')."\">".cutText(formatText($sdi[$j]['sdii_name'], '2HTML'), 200, 1)."</a>\n";
						if ($sdi[$j]['sdii_statut']=='D') $sdi_html.="<span class=\"publication-state\"> / "._t('statut','draft')."</span>";
						if ($sdi[$j]['sdii_to_dashboard']=='N') $sdi_html.="<span class=\"publication-state\"> / "._t('sdi','not_attached_to_dashboard')."</span>";
						if(!empty($display_tags)) $sdi_html.= "<i class=\"icon-tag-1\" style=\"opacity:0.3;margin:0\" title=\"" . formatText ( $display_tags, '2ALT' ) . "\"></i> ";
						if($sdi[$j]['sdii_type'] != 'not-set') $sdi_html.='<span class="indic-type '.$sdi[$j]['sdii_type'].'">'.formatText(mb_ucfirst($GLOBALS['lang']['sdi']['select_type'][$sdi[$j]['sdii_type']]), '2HTML').'</span>';
						$sdi_html.="\t<div class=\"list-actions\"><a href=\"".$link_sup.$sdi[$j]['sdii_id']."\" title=\""._t('sdi','sup')."\" class=\"ico_sup\"><i class=\"icon-trash\"></i><span>" . _t('sdi','sup') . "</span></a>\n";
						$sdi_html.="\t<a href=\"".$link_mod.$sdi[$j]['sdii_id']."\" title=\""._t('sdi','mod')."\" class=\"ico_mod\"><i class=\"icon-pencil\"></i><span>" . _t('sdi','mod') . "</span></a></div>\n";
						$sdi_html.="</div>\n";
						$sdi_html.="</li>\n";
						
					}
				}
			}
			if(!empty($sdi_html)) $sdi_html .= "</ul>\n";
			if(!empty($sdi_html)) $sdi_html = '<div class="dd" id="level-'.$current_id.'">' . $sdi_html . '<div>';
			
			if ($prev_dep < $dep) $html .= "\n<ul>\n";

			$link =	"\t<a href=\"".$link_level.$current_id."\" title=\"".$current_name_att."\">" . $disp_level_name. "</a>\n";

			$html .= "<li class=\"li".$dep."\">" . $link;
			$html .= $sdi_html;
			
			$prev_dep = $dep;
			$html .= display_level($item['level_id'], ($dep + 1), $array, $rub_link, $sdi);
		}
	}
	if (($prev_dep == $dep) && ($prev_dep != 0)) $html .= "</ul>\n</li>\n";
	else if ($prev_dep == $dep) $html .= "</ul>\n";
	else $html .= "</li>\n";
	return $html;
}

$filter_menu = getMenuFilter($tags);

?>
<div id="chemin">
  <ul>
  	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
  	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','sdi');?></a></li>
  	<li><span><?php echo _t('sdi','list'); ?></span></li>
  </ul>
</div>
<!--end barre haute -->

<div class="contentcontainer"><?php	include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));	?>
<div id="content">

	<?php echo $filter_menu; ?>
	<br style="clear: both;margin-bottom:3em" />
	
  <div id="tree">
    <?php echo display_level(0,0,$result, $rub_link, $sdi); ?>
  </div>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->