<?php
/**
 * Indicator / SDI module - modify provider information
 * 
 * Modify given provider indicator from back-office
 * 
 * @package linea21\modules\sdi
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->hasRight('sdi')) ReloadIndex('admin');
////////////

$link_mod_r=$rub_link."&amp;todo=mod_r&amp;id=";
$link_mod_e=$rub_link."&amp;todo=mod_e&amp;id=";
$link_mod=$rub_link."&amp;todo=mod&amp;id=";

if(!isset($_GET['id']) && !isset($_POST['id'])) {
  $id="1";
} else {
  if(isset($_POST['id']))	$id=$_POST['id'];
  if(isset($_GET['id']))	$id=$_GET['id'];
}

if (isset($_POST['enregistrer'])) {
  $data_table = unserialize(urldecode($_POST['data_table']));
  $j=0;
  for ($i=19;$i<27;$i++){
    $data_table_p[$j]=$data_table[$i];
    $j++;
  }
  $sdi_object= new sdi;
  $result=$sdi_object->ModifyParam($id, $data_table_p, "P", $sql_object);
  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo."&id=".$id;
  if(isset($result)) {
      header("Location: ".safe_redirect($link_confirm));
      exit;
  }
  else  system_error();
}

$sdi_object= new sdi;
//$data_provider=$sdi_object->GetProvider($id_idd=$id, $sql_object, $ID="-1");

$req_sdip=SQL_getProvider($id, $sql_object);
$data_provider = $sql_object -> DBSelect($req_sdip);

// Do record exists?
if(!isset($data_provider[0]['sdip_name'])) redirect_to('@module_default');

$form_p_name = formatText($data_provider[0]['sdip_name'], '2FIELD');
$form_p_service  = formatText($data_provider[0]['sdip_service'], '2FIELD');
$form_p_description  = formatText($data_provider[0]['sdip_description'], '2FIELD');
$form_p_incharge  = formatText($data_provider[0]['sdip_incharge'], '2FIELD');
$form_p_address  = formatText($data_provider[0]['sdip_address'], '2FIELD');
$form_p_phone  = $data_provider[0]['sdip_phone'];
$form_p_fax  = $data_provider[0]['sdip_fax'];
$form_p_email = $data_provider[0]['sdip_email'];

if (isset($_POST['valider3'])) {

  //$table = unserialize(urldecode($_POST['table']));
  $table = array();
  $table[19] = $_POST['p_name'];
  $table[20] = $_POST['p_service'];
  $table[21] = $_POST['p_description'];
  $table[22] = $_POST['p_incharge'];
  $table[23] = $_POST['p_address'];
  $table[24] = str_replace(' ', '', $_POST['p_phone']);
  $table[25] = str_replace(' ', '', $_POST['p_fax']);
  $table[26] = $_POST['p_email'];

  $sdi_object = new sdi;
  $integrity3 = $sdi_object -> CheckDataIntegrity_provider($table);

  $form_p_name = formatText($_POST['p_name'], '2FIELD');
  $form_p_service = formatText($_POST['p_service'], '2FIELD');
  $form_p_description = formatText($_POST['p_description'], '2FIELD');
  $form_p_incharge = formatText($_POST['p_incharge'], '2FIELD');
  $form_p_address = formatText($_POST['p_address'], '2FIELD');
  $form_p_phone = str_replace(' ', '', $_POST['p_phone']);
  $form_p_fax = str_replace(' ', '', $_POST['p_fax']);
  $form_p_email = $_POST['p_email'];

  $table = urlencode(serialize($table));
}
$req_list_sdiname=SQL_getOnesdiname($id);
$data_sdi_name = $sql_object -> DBSelect($req_list_sdiname);

// Do record exists?
if(!isset($data_sdi_name[0]['sdii_name'])) redirect_to('@module_default');

$navtitle=_t('sdi','mod_p')." : ".$data_sdi_name[0]['sdii_name'];
?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home') ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','sdi')?></a></li>
	<li><span><?php echo formatnavTitle($navtitle) ?></span></li>
</ul>
</div>
<!--end barre haute -->
<?php
if (!isset($integrity3) || is_string($integrity3)) {
?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));

?>
<div id="content">
<?php
if (isset($integrity3) && is_string($integrity3)) display_errors($integrity3);
?>
<div class="mod_link">
<a href="<?php echo $link_mod.$id ;?>"><?php echo _t('sdi','mod');?></a><!-- @whitespace
--><a href="<?php echo $link_mod_e.$id ;?>"><?php echo _t('sdi','modify_sdi_e');?></a><!-- @whitespace
--><a href="<?php echo $link_mod_r.$id ;?>"><?php echo _t('sdi','modify_sdi_r');?></a>
</div>
<br class="brendstep" />
<h2><?php echo mb_ucfirst(_t('sdi','mod_title3')); ?></h2>
<div class="subtitle" id="indicator-subtitle"><?php echo formatText($data_sdi_name[0]['sdii_name'], '2HTML'); ?></div>
<form id="addsdi3" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
	<p>
		<label for="p_name"><?php echo mb_ucfirst(_t('sdi','p_name')) ?> : </label>
		<input name="p_name" type="text" class="textfield" id="p_name" maxlength="255" value="<?php echo $form_p_name; ?>" />
	</p>
	<p>
		<label for="p_service"><?php echo mb_ucfirst(_t('sdi','p_service')) ?> :</label>
		<input name="p_service" type="text" class="textfield" id="p_service" maxlength="255" value="<?php echo $form_p_service; ?>" />
	</p>
	<p>
		<label for="p_incharge"><?php echo mb_ucfirst(_t('sdi','p_incharge')) ?> :</label>
		<input name="p_incharge" type="text" class="textfield" id="p_incharge" maxlength="150" value="<?php echo $form_p_incharge; ?>" />
	</p>
	<p>
		<label for="p_address"><?php echo mb_ucfirst(_t('sdi','p_address')) ?> : </label>
		<textarea id="p_address" name="p_address" <?php echo AREA_SETTINGS; ?> class="largetextfield"><?php echo $form_p_address; ?></textarea>
	</p>
	<p>
		<label for="p_phone"><?php echo mb_ucfirst(_t('sdi','p_phone')) ?> :</label>
		<input name="p_phone" type="text" class="textfield phone-format" id="p_phone" maxlength="14" value="<?php echo $form_p_phone; ?>" />
	</p>
	<p>
		<label for="p_fax"><?php echo mb_ucfirst(_t('sdi','p_fax')) ?> :</label>
		<input name="p_fax" type="text" class="textfield phone-format" id="p_fax" maxlength="14" value="<?php echo $form_p_fax; ?>" />
	</p>
	<p>
		<label for="p_email"><?php echo mb_ucfirst(_t('sdi','p_email')) ?> : </label>
		<input name="p_email" type="text" class="textfield" id="p_email" maxlength="200" value="<?php echo $form_p_email; ?>" />
	</p>
	<p>
		<label for="p_description"><?php echo mb_ucfirst(_t('sdi','p_description')) ?> :</label>
		<textarea id="p_description" name="p_description" <?php echo AREA_SETTINGS; ?> class="largetextfield">
		<?php echo $form_p_description; ?></textarea>
	</p>
	<div>
		<br />
		<?php echo cancel_button($rub_link."&amp;todo=det&amp;id=".$id); ?>
		<input name="rub" type="hidden" value="<?php echo $rub; ?>"	id="rub" />
		<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
		<input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
		<input name="valider3" type="submit" value="<?php echo _t('btn','valid') ?>" class="button" id="valider" />
	</div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->


<?php
} else {
  if (!isset($integrity5) || is_string($integrity5)) {


    $table=unserialize(urldecode($table));
    $display_p_name = formatText(empty_nc($table[19]), '2HTML');
    $display_p_service = formatText(empty_nc($table[20]), '2HTML');
    $display_p_description =formatText(empty_nc($table[21]), '2HTML');
    $display_p_incharge = formatText(empty_nc($table[22]), '2HTML');
    $display_p_address = formatText(empty_nc($table[23]), '2HTML');
    $display_p_phone = empty_nc($table[24]);
    $display_p_fax = empty_nc($table[25]);
    $display_p_email = empty_nc($table[26]);
    $table = urlencode(serialize($table));

    ?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));

?>
<div id="content">
<h2><?php echo mb_ucfirst(_t('recap','title')); ?></h2>
<div class="subtitle" id="indicator-subtitle"><?php echo formatText($data_sdi_name[0]['sdii_name'], '2HTML'); ?></div>
<dl class="summary">
	<dt><?php echo mb_ucfirst(_t('sdi','p_name'));	?> :</dt>
	<dd><?php echo $display_p_name ;	?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','p_service'));	?> :</dt>
	<dd><?php echo $display_p_service ;	?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','p_description'));	?> :</dt>
	<dd><?php echo $display_p_description ;	?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','p_incharge'));	?> :</dt>
	<dd><?php echo $display_p_incharge ;	?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','p_address'));	?> :</dt>
	<dd><?php echo $display_p_address ;	?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','p_phone'));	?> :</dt>
	<dd class="phone-format"><?php echo $display_p_phone ;	?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','p_fax'));	?> :</dt>
	<dd class="phone-format"><?php echo $display_p_fax ;	?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','p_email'));	?> :</dt>
	<dd><?php echo $display_p_email ;	?></dd>
</dl>
<form id="addsdi5" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>"	method="post">
	<div>
		<input name="rub" type="hidden"	value="<?php echo $rub; ?>" id="rub" />
		<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
		<input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
		<?php echo cancel_button($rub_link."&amp;todo=det&amp;id=".$id); ?>
		<input name="data_table" type="hidden"	value="<?php echo $table; ?>" id="data_table" />
		<input name="retour"	type="button" value="<?php echo _t('btn','preview') ?>" class="button"	id="retour" onclick="history.go(-1);" />
		<input name="enregistrer"	type="submit" value="<?php echo _t('btn','save') ?>" class="button"	id="valider" />
	</div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php
  }
}

if(U_L == 'fr') {
	footerAddJS('../lib/js/jquery-mask-plugin/dist/jquery.mask.min.js');
	footerAddInlineJS("
 		$( '.phone-format').each(function( index ) {
	  if($(this).text() != '".empty_nc('')."') $(this).mask('00 00 00 00 00');
	});");
}
?>