<?php
/**
 * System module - view page
 * 
 * Display settings in back-office (read only)
 * 
 * @package linea21\core\system
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once ("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////

// emails queue information
include_once('../class/class.emailq.php');
$emailqo = new emailq;
$emailqueue = $emailqo->getCountQueue($sql_object);
$email_div_content = '';

if(isset($emailqueue[0]['number'])) $emailsCounter = $emailqueue[0]['number']; else $emailsCounter = 0 ;
$limit = 1000;

if($emailsCounter > 0) {
    $emailrecords = $emailqo->getQueue($sql_object, $limit);
    $separator = " # ";
    
    foreach ($emailrecords as $record) {
        $email_div_content .= '<div class="email-record">'.PHP_EOL;
        $email_div_content .= '<span class="date">' . mb_ucfirst(_t('divers', 'date')) . ' : ' . $record['eq_date_crea'] . '</span>' . $separator . $record['eq_id'] . $separator . _t('contact', 'email') .  ' : <a href="mailto:'.$record['eq_recipient'].'">'. $record['eq_recipient'] . '</a>' .  $separator . '<span class="subject">' .mb_ucfirst(_t('contact', 'subject')) . ' : ' . $record['eq_subject'] .'</span>' . ' <a href="" class="email-body-toggle"><i class="fa fa-arrow-circle-right" aria-hidden="true"></i></a>' ;
        $email_div_content .= '<div class="email-htmlbody">'.PHP_EOL;
        $email_div_content .= $record['eq_htmlbody'];
        $email_div_content .= '</div>'.PHP_EOL;
        $email_div_content .= '</div>'.PHP_EOL;
    }
}


$js = 'var cboxOptions = { innerWidth: "80%", innerHeight: "80%", maxWidth: "80%", maxHeight: "80%"}
        $(".see-logs").colorbox(cboxOptions);
        $(window).resize(function(){ $.colorbox.resize({ width: window.innerWidth > parseInt(cboxOptions.maxWidth) ? cboxOptions.maxWidth : cboxOptions.width, height: window.innerHeight > parseInt(cboxOptions.maxHeight) ? cboxOptions.maxHeight : cboxOptions.height }); });
        ';


$js .= '$("a.purge-log").on( "click", function () {
            var url = $(this).attr("href");
			alertify.set({
				labels : {
					ok: "'._t('divers', 'yes').'", cancel: "'._t('divers', 'no').'" }
			});
			alertify.confirm("'._t('logs', 'purge_confirm').'", function (e) {
			
				if (e) {	
					$.ajax({
						type: "GET",
						url: url,
						data: {mode: "ajax"},
						dataType: "json",
						success: function(data){
							if(data.status==1) {
								alertify.success(data.msg);
							} else {
								alertify.error(data.msg);
							}
						}
					});
					
				}
			});
			return false;
		});'.PHP_EOL;

$js .= '$.ajax({url: "../system/actions_admin.php", method: "POST", data: {action : "version-check"}, dataType: "html", success: function(data){
			$("#version-check-container").delay(600).html(data);
		}});';

footerAddInlineJS($js);


$js = 'var cboxOptions = { inline:true, innerWidth: "80%", innerHeight: "80%", maxWidth: "80%", maxHeight: "80%"}
        $(".cb-inline").colorbox(cboxOptions);
        $(window).resize(function(){ $.colorbox.resize({ width: window.innerWidth > parseInt(cboxOptions.maxWidth) ? cboxOptions.maxWidth : cboxOptions.width, height: window.innerHeight > parseInt(cboxOptions.maxHeight) ? cboxOptions.maxHeight : cboxOptions.height }); });
        ';


footerAddInlineJS($js);

$js = '$(".email-body-toggle").on( "click", function () {
            $(this).next("div.email-htmlbody").slideToggle();
            return false;
        });';

footerAddInlineJS($js);

$js = '$("#purge-emailq").on( "click", function () {
			alertify.set({
				labels : {
					ok: "'._t('divers', 'yes').'", cancel: "'._t('divers', 'no').'" }
			});
			alertify.confirm("'._t('emailq', 'purge_confirm').'", function (e) {
			
				if (e) {	
					$.ajax({
						type: "GET",
						url: "../system/actions_admin.php",
						data: {action: "emailq-purge", mode: "ajax"},
						dataType: "json",
						success: function(data){
							if(data.status==1) {
								$("#emailq-counter").text("0");
								alertify.success(data.msg);
							} else {
								alertify.error(data.msg);
							}
						}
					});
					
				}
			});
			return false;
		});';


footerAddInlineJS($js);

$link_mod=$rub_link."&amp;todo=mod&amp;type=";
$edit_theme=$rub_link."&amp;todo=edit_files";
?>
<div id="chemin">
  <ul>
  	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home') ?></a></li>
  	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"> <?php echo _t('menu','system'); ?> </a></li>
  </ul>
</div>
<!--end barre haute -->
<div class="contentcontainer"><?php include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));?>
<div id="content">

  <div id="define_readonly">
    <h2>LINEA RELEASE</h2>
    <div id="version-check-container"><div id="version-check"><div class="loading">&nbsp;</div></div></div>
    <dl>
    	<dt><?php echo _t('system','LINEA_VERSION'); ?></dt>
    	<dd><?php echo SITE_LINEA_NAME . ' - ' . LINEA_VERSION ?></dd>
    	<dt><?php echo _t('system','SITE_LINEA_URL'); ?></dt>
    	<dd><a href="<?php echo SITE_LINEA_URL; ?>" class="out"><?php echo SITE_LINEA_URL; ?></a></dd>
    	<dt><?php echo _t('system','MAIL_LINEA'); ?></dt>
    	<dd><a href="mailto:<?php echo MAIL_LINEA; ?>"><?php echo MAIL_LINEA; ?></a></dd>
    </dl>
    <br style="clear: both;" />
  </div>

    <div id="permissions_check">
    <h2><?php echo _t('system', 'permission_check'); ?></h2>
    <?php

    function plugins_prefix($item)
    {
    	return '/plugins/'. $item;
    }
    $plugins = array_map('plugins_prefix', availablePlugins());
    $folders = array('/config/config.ini','/config/cron', '/library/userfiles', '/logs', '/tmp', str_replace('..', '', THEME_PUBLIC_PATH), $plugins);

    ?>
    <table>
    	<?php foreach($folders as $folder) { ?>
	    	<?php if(is_string($folder)) {?>
	    	<tr>
	    	<td><?php echo sprintf(_t('system', 'permission_writable'), '<code>'.$folder.'</code>'); ?> : </td>
	    	<td><?php if(is_writable ('..'.$folder)) echo '<div class="permission-ok" title="'._t('system', 'permission_ok').'"><span>'._t('system', 'permission_ok').'</span></div>';  else echo '<div class="permission-warn" title="'._t('system', 'permission_warn').'"><span>'._t('system', 'permission_warn').'</span></div>'; ?></td>
	    	</tr>
	    	<?php } elseif(is_array($folder)) { ?>
	    		<?php foreach($folder as $plugin) { ?>
	    		<tr>
		    	<td><?php echo sprintf(_t('system', 'permission_writable'), '<code>'.$plugin.'</code>'); ?> : </td>
		    	<td><?php if(is_writable ('..'.$plugin)) echo '<div class="permission-ok" title="'._t('system', 'permission_ok').'"><span>'._t('system', 'permission_ok').'</span></div>';  else echo '<div class="permission-warn" title="'._t('system', 'permission_warn').'"><span>'._t('system', 'permission_warn').'</span></div>'; ?></td>
		    	</tr>
	    		<?php } ?>
	    	<?php } ?>
    	<?php } ?>
    </table>
    <br style="clear: both;" />
  </div>

  <div class="toggle_title">
  	<a href="#define_theme"><?php echo _t('system','title_theme'); ?></a>
  </div>

  <div id="define_theme" style="display: none;" class="mtm child">
  	<a href="<?php echo $edit_theme; ?>" class="edit_files"><i class="icon-pencil"></i> <span><?php echo _t('system', 'edit_public'); ?></a>
    <?php echo ("<a href=\"".$link_mod."theme\" title=\""._t('system','mod')."\" class=\"ico_mod2\"><i class=\"icon-wrench-circled\"></i><span>" . _t('system','mod') . "</span></a>"); ?>

    <?php echo ($l21config->getThemeParams()); ?>
    <br style="clear: both;" />
  </div>

  <div class="toggle_title">
  	<a href="#define_release"><?php echo _t('system','title_release'); ?> (<?php echo ($l21config->file_config); ?>)</a>
  </div>

  <div id="define_config" style="display: none;" class="mtm child">
    <?php echo ("<a href=\"".$link_mod."config\" title=\""._t('system','mod')."\" class=\"ico_mod2\"><i class=\"icon-wrench-circled\"></i><span>" . _t('system','mod') . "</span></a>"); ?>
    <?php echo ($l21config->getReleaseParams()); ?>
    <br style="clear: both;" />
  </div>

  <div class="toggle_title">
  	<a href="#database"><?php echo _t('system','title_db'); ?></a>
  </div>

  <div id="define_db" style="display: none;" class="mtm child">
    <?php echo ("<a href=\"".$link_mod."database\" title=\""._t('system','mod')."\" class=\"ico_mod2\"><i class=\"icon-wrench-circled\"></i><span>" . _t('system','mod') . "</span></a>"); ?>
    <?php echo ($l21config->getDatabaseParams()); ?> <br style="clear: both;" />
  </div>
  
  <div class="toggle_title">
  	<a href="#email-queue"><?php echo _t('system','title_eq'); ?></a>
  </div>

  <div id="emails-queue" style="display: none;" class="mtm child">
	<p>
    <?php echo sprintf(_t('emailq', 'in_queue'), '<span id="emailq-counter">'.$emailsCounter . '</span>'); ?> 
    <?php if($emailsCounter > 0) { ?>
    <a href="#emails-queue-content" class="cb-inline"><?php echo _t('emailq', 'see'); ?></a> - <a href="#" id="purge-emailq"><i class="fa fa-trash-o" aria-hidden="true"></i> <?php echo _t('emailq', 'purge'); ?></a><br style="clear: both;" />
    <?php } ?>
    </p>
    <!-- This contains the hidden content for inline calls -->
		<div style="display:none">
			<div id="emails-queue-content" style="padding:10px; background:#fff;">
			<?php echo $email_div_content; ?>
			</div>
		</div>
  </div>
  
  <div class="toggle_title">
  	<a href="#logs-files"><?php echo _t('system','title_logs'); ?></a>
  </div>

  <div id="logs-files" style="display: block;" class="mtm child">

    	<ul>
    		<li>LOG_ACCESS <?php if(file_exists(SITE_PATH . str_replace('../', '', LOG_ACCESS))) echo '('. formatBytes(filesize(LOG_ACCESS), 0).')'; ?> : <a href="../system/actions_admin.php?action=see-logs&file=LOG_ACCESS" class="see-logs"><?php echo _t('logs', 'see'); ?></a> -  <a href="../system/actions_admin.php?action=purge-log&file=LOG_ACCESS" class="purge-log"><i class="fa fa-trash-o" aria-hidden="true"></i> <?php echo _t('logs', 'purge'); ?></a></li>
    		<li>LOG_MAILING <?php if(file_exists(SITE_PATH . str_replace('../', '', LOG_MAILING))) echo '('. formatBytes(filesize(LOG_MAILING), 0).')'; ?> : <a href="../system/actions_admin.php?action=see-logs&file=LOG_MAILING" class="see-logs"><?php echo _t('logs', 'see'); ?></a> -  <a href="../system/actions_admin.php?action=purge-log&file=LOG_MAILING" class="purge-log"><i class="fa fa-trash-o" aria-hidden="true"></i> <?php echo _t('logs', 'purge'); ?></a></li>
    		<li>LOG_MAILER <?php if(file_exists(SITE_PATH . str_replace('../', '', LOG_MAILER))) echo '('. formatBytes(filesize(LOG_MAILER), 0).')'; ?> : <a href="../system/actions_admin.php?action=see-logs&file=LOG_MAILER" class="see-logs"><?php echo _t('logs', 'see'); ?></a> -  <a href="../system/actions_admin.php?action=purge-log&file=LOG_MAILER" class="purge-log"><i class="fa fa-trash-o" aria-hidden="true"></i> <?php echo _t('logs', 'purge'); ?></a></li>
    		<li>LOG_CRONJOBS <?php if(file_exists(SITE_PATH . str_replace('../', '', LOG_CRONJOBS))) echo '('. formatBytes(filesize(LOG_CRONJOBS), 0).')'; ?> : <a href="../system/actions_admin.php?action=see-logs&file=LOG_CRONJOBS" class="see-logs"><?php echo _t('logs', 'see'); ?></a> -  <a href="../system/actions_admin.php?action=purge-log&file=LOG_CRONJOBS" class="purge-log"><i class="fa fa-trash-o" aria-hidden="true"></i> <?php echo _t('logs', 'purge'); ?></a></li>
    		<li>LOG_SQL_QUERIES <?php if(file_exists(SITE_PATH . str_replace('../', '', LOG_SQL_QUERIES))) echo '('. formatBytes(filesize(LOG_SQL_QUERIES), 0).')'; ?> : <a href="../system/actions_admin.php?action=see-logs&file=LOG_SQL_QUERIES" class="see-logs"><?php echo _t('logs', 'see'); ?></a> -  <a href="../system/actions_admin.php?action=purge-log&file=LOG_SQL_QUERIES" class="purge-log"><i class="fa fa-trash-o" aria-hidden="true"></i> <?php echo _t('logs', 'purge'); ?></a></li>
    		<li>LOG_SQL_ERRORS <?php if(file_exists(SITE_PATH . str_replace('../', '', LOG_SQL_ERRORS))) echo '('. formatBytes(filesize(LOG_SQL_ERRORS), 0).')'; ?> : <a href="../system/actions_admin.php?action=see-logs&file=LOG_SQL_ERRORS" class="see-logs"><?php echo _t('logs', 'see'); ?></a> -  <a href="../system/actions_admin.php?action=purge-log&file=LOG_SQL_ERRORS" class="purge-log"><i class="fa fa-trash-o" aria-hidden="true"></i> <?php echo _t('logs', 'purge'); ?></a></li>
    		<li>LOG_MAINFILE <?php if(file_exists(SITE_PATH . str_replace('../', '', LOG_MAINFILE))) echo '('. formatBytes(filesize(LOG_MAINFILE), 0).')'; ?> : <a href="../system/actions_admin.php?action=see-logs&file=LOG_MAINFILE" class="see-logs"><?php echo _t('logs', 'see'); ?></a> -  <a href="../system/actions_admin.php?action=purge-log&file=LOG_MAINFILE" class="purge-log"><i class="fa fa-trash-o" aria-hidden="true"></i> <?php echo _t('logs', 'purge'); ?></a></li>
    		<?php
    		if(file_exists(SITE_PATH . 'logs/PHP_errors.log')) {
    		?>
    		    <li>LOG_PHP_ERRORS <?php echo '('. formatBytes(filesize(SITE_PATH . '/logs/PHP_errors.log'), 0).')'; ?> : <a href="../system/actions_admin.php?action=see-logs&file=LOG_PHP_ERRORS" class="see-logs"><?php echo _t('logs', 'see'); ?></a> -  <a href="../system/actions_admin.php?action=purge-log&file=LOG_PHP_ERRORS" class="purge-log"><i class="fa fa-trash-o" aria-hidden="true"></i> <?php echo _t('logs', 'purge'); ?></a></li>
    		
    		<?php } ?>
    	</ul>
  </div>

  <div class="toggle_title">
  	<a href="#php_info"><?php echo _t('system','title_php_info'); ?></a>
  </div>

  <div id="php_info" style="display: none;" class="mtm child">
    <?php echo ($l21config->getPhpInfo()); ?>
  </div>

</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->