<?php
/**
 * Tag module
 * 
 * Display scales list in back-office
 * 
 * @package linea21\core\tag
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////



$r=$sql_object->DBSelect(SQL_getTags());




?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','tag'); ?></a></li>
	<li><span><?php echo formatNavTitle(_t('tag','list')); ?></span></li>
</ul>
</div>
<!--end barre haute -->
<div class="contentcontainer"><?php	include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));	?>
<div id="content">

<?php

$link_sup=$rub_link."&amp;todo=sup&amp;id=";
$link_mod=$rub_link."&amp;todo=mod&amp;id=";
$link_det=$rub_link."&amp;todo=det&amp;id=";



if($r!=0) {
	
	$total_display = sprintf(_t('tag', 'nb_total'), count($r));
	echo '<p>'.$total_display.'</p>'.PHP_EOL;
	
  echo "<table class=\"multisort\">\n";
  echo "<thead>\n";
  echo "<tr>\n";
  echo "<td>".mb_ucfirst(_t('tag','name'))."</td>\n";
  echo "<td>".mb_ucfirst(_t('tag','occurence')). "</td>\n";
  echo "<td>".mb_ucfirst(_t('divers','date_crea'))."</td>\n";
  echo "<td class=\"sorter-false\">&nbsp;<span class=\"visually-hidden\">".mb_ucfirst(_t('divers','actions'))."</span></td>\n";
  echo "</tr>\n";
  echo "</thead>\n";

  echo "<tbody>\n";
  for($i=0; $i<count($r); $i++) {

    echo "<tr>\n";
    echo "<td><a href=\"".$link_det.$r[$i]['tag_id']."\" title=\"".formatText(_t('tag','det'))."\">" . formatText(cutText($r[$i]['tag_name'],70, 1), '2HTML') . "</a></td>\n";
    echo "<td>".formatText($r[$i]['counter'])."</td>\n";
    echo "<td>".$r[$i]['tag_date_crea_display']."</td>\n";
    echo "<td>\n";
    echo "<div class=\"iconetab\">";
    echo "\t<a href=\"".$link_sup.$r[$i]['tag_id']."\" class=\"ico_sup\" title=\""._t('tag','sup')."\"><i class=\"icon-trash\"></i><span>" . _t('tag','sup') . "</span></a>\n";
    echo "\t<a href=\"".$link_mod.$r[$i]['tag_id']."\" class=\"ico_mod\" title=\""._t('tag','mod')."\"><i class=\"icon-pencil\"></i><span>" . _t('tag','mod') . "</span></a>\n";
    echo "</div>";
    echo "</td>\n";
    echo "</tr>\n";
  }
  echo "</tbody>";
  echo "</table>";
} else {
	
	$total_display = sprintf(_t('tag', 'nb_total'), '0');
	echo '<p>'.$total_display.'</p>'.PHP_EOL;
	
  echo "<div class=\"info\">"._t('divers','no_matches')."</div>";
}

// Ability to sort table
addDynamicCSS('../lib/js/jquery.tablesorter/theme.default.css');
footerAddJS('../lib/js/jquery.tablesorter/jquery.tablesorter.min.js');
$str = '$("table.multisort").tablesorter({	});';
footerAddInlineJS($str);
?>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->