<?php
/**
 * Tag module
 * 
 * Modify given tag from back-office
 * 
 * @package linea21\core\tag
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////

if (isset($_GET['id']))	$id=$_GET['id'];
if (isset($_POST['id'])) $id=$_POST['id'];

$otag= new tag;

$r=$sql_object->DBSelect(SQL_getTag($id), 'OBJECT');

// Do record exists?
if(!isset($r[0]->tag_name)) redirect_to('@module_default');

$display_title=formatText($r[0]->tag_name, '2HTML');
$form_denomination=formatText($r[0]->tag_name, '2FIELD');
$form_comment=formatText($r[0]->tag_comment, '2FIELD');



if(isset($_POST['valider'])) {
  $array = array();
  $array[0]=$_POST['denomination'];
  $array[1]=$_POST['comment'];

  $integrity = $otag->checkDataIntegrity($array);
  
  if(is_string($integrity)) $format_text='2FIELD'; else $format_text='HTML';

  $form_denomination=formatText($_POST['denomination'], $format_text);
  $form_comment=formatText($_POST['comment'], $format_text);

  $array=urlencode(serialize($array));
}

if(isset($_POST['enregistrer'])) {

  $data_table=unserialize(urldecode($_POST['data_table']));
  $result=$otag->ModifyTagById($id, $data_table);

  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo."&id=".$id;
  if($result) {
      header("Location: ".safe_redirect($link_confirm));
      exit;
  }
  else  system_error();
}


?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','tag'); ?></a></li>
	<li><span><?php echo formatNavTitle(_t('tag','mod').' : '.$display_title); ?></span></li>
</ul>
</div>
<!--end barre haute -->
<?php

if(!isset($integrity) || is_string($integrity)) {
  ?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content"><?php
if(isset($integrity) && is_string($integrity)) display_errors($integrity);
?>
<h2><?php echo formatTitleh2($display_title); ?></h2>
<form id="modtag" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
	<p>
		<label for="denomination"><?php echo mb_ucfirst(_t('tag','denomination')); ?> : *</label>
		<input name="denomination" type="text" id="denomination" maxlength="200" value="<?php echo $form_denomination; ?>" class="textfield" required />
	</p>
	<p>
  <label for="comment"><?php echo mb_ucfirst(_t('tag','comment')); ?> : </label>
  <textarea id="comment" name="comment" class="largetextfield" <?php echo AREA_SETTINGS; ?>><?php echo $form_comment; ?></textarea>
</p>
	<div>
		<input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
		<input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
		<?php echo cancel_button('javascript:history.go(-1);'); ?>
		<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
		<input name="valider" type="submit" value="<?php echo _t('btn','valid') ?>" class="button" id="valider" />
	</div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php
// Récapitulatif
} else	{
	
	$display_form_comment =formatText(empty_none($form_comment));
?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<h2><?php echo formatTitleh2(_t('recap','title')); ?></h2>
<dl class="summary">
	<dt><?php echo mb_ucfirst(_t('tag','denomination')); ?> :</dt>
	<dd><?php echo $form_denomination; ?></dd>
	<dt><?php echo mb_ucfirst(_t('tag','comment')); ?> :</dt>
	<dd><?php echo $display_form_comment; ?></dd>
</dl>
<form id="modtag" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
	<div>
	<input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
	<input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
	<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
	<input name="data_table" type="hidden" value="<?php echo $array; ?>" id="data_table" />
	<?php echo cancel_button('?rub=tag&amp;todo=list'); ?>
	<input name="retour" type="button" value="<?php echo _t('btn','preview') ?>" class="button" id="retour" onclick="history.go(-1);" />
	<input name="enregistrer" type="submit" value="<?php echo _t('btn','save') ?>" class="button" id="valider" />
</div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php } ?>