<?php
/**
 * @package linea21\templates\public
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

// do we allow access only to authentified users
if(defined('FORCE_PUBLIC_AUTH') && FORCE_PUBLIC_AUTH == 1) {
	if(!$l21auth->isAuthenticated() && ActiveItemKey($_REQUEST['rub'])!='user-prefs' && ActiveItemKey($_REQUEST['rub'])!='forgot-password') {
	 	header("Location: ".CURRENT_APP_URL."index.php?rub=".$GLOBALS['links'][U_L]['user-prefs']['linkvalue']);
	 	exit;
	}
}
include_once('../class/class.page.php');
include_once(override('../page/display.php'));
include_once(override('../page/'.SQL.'.inc.php'));

if(isset($debugbar)) {
	$debugbar['time']->startMeasure('header', '... loading Header files');
}
?>

<!DOCTYPE html>
<!--[if lte IE 7 ]><html class="no-js ie67 ie678" lang="<?php echo U_L; ?>"> <![endif]-->
<!--[if IE 8 ]><html class="no-js ie8 ie678" lang="<?php echo U_L; ?>"> <![endif]-->
<!--[if IE 9]><html class="no-js ie9" lang="<?php echo U_L; ?>"> <![endif]-->
<!--[if gt IE 9]> <!--><html class="no-js" lang="<?php echo U_L; ?>"> <!--<![endif]-->
<?php distInclude(THEME_PUBLIC_PATH.'header.php', THEME_PUBLIC_DIST); ?>

<?php if(isset($debugbar)) $debugbar['time']->stopMeasure('header'); ?>

<body class="<?php echo getItemId(); ?>">
<div id="logo-header">
	<img src="<?php echo PUBLIC_THEME_URL; ?>/images/logo.png" alt="Logo Linea21" />
 </div>
<?php culture::getInstance()->renderSwitcher(); ?>
<div id="user-menu">
	<div class="w70 center grid-2">
	  <div class="txtleft pts">
		  <div id="printer">
			  <a href="#" title="<?php echo _t('divers','print'); ?>"><i class="fa fa-print fa-2x"></i> <span><?php echo _t('divers','print'); ?></span></a>
		  </div>
		  <?php echo get_search_form() ?>
	  </div>
	  <div class="txtright"><?php echo MyAccountLink(); ?>
		<!-- <a href="<?php echo CURRENT_APP_URL; ?>"><img class="logo" src="<?php echo PUBLIC_THEME_URL; ?>images/logo.png" alt="<?php echo (SITE_NAME); ?>" /></a> -->
</div>
  </div>
</div><!-- End div#user-menu -->
<header id="header" class="pam" style="background-image: url(https://unsplash.it/1920/240?random);"><!-- background-image: url('https://unsplash.it/1920/240?random'); -->
	<div class="w70 center">
		<h3><?php echo (SITE_NAME); ?></h3>
	</div>
</header><!-- End Header -->
<div class="menu-wrap">
	<nav id="menu" class="mw1140p center no-print">
	  <?php 
	  if(function_exists('dynamicMenu')) {
	  	echo dynamicMenu(0);
	  } else {
	  	echo DisplayMenu();
	  } ?>
	</nav>
</div>
<!-- End Menu -->
<?php if(defined('AJAX_LOGIN') && AJAX_LOGIN == 1) prepareAjaxLogin(); ?>
<div id="main-container"> <!-- do not remove / used by default to insert breadcrumb -->
<section id="main-section" role="main" class="pam clear mw1140p center">
<div id="content" class="section_<?php echo ActiveItemKey($GLOBALS['activeitem']); ?> alias_<?php echo ActiveItemAlias($GLOBALS['activeitem']);?> <?php echo getItemId(); ?>">
  <div id="main"><!-- Begin Page -->  	
    	<?php if(isset($debugbar)) $debugbar['time']->startMeasure('template', '... loading main template'); ?>
    	<?php DisplayTemplate(); ?>
    	<?php if(isset($debugbar)) $debugbar['time']->stopMeasure('template'); ?>
  </div> <!-- End Page -->
</div> <!-- End Content -->
</section>

<!-- Footer -->
<?php if(isset($debugbar)) $debugbar['time']->startMeasure('footer', '... loading footer'); ?>
<footer id="footer" class="line pam txtcenter">
<div class="mw1140p center">
  <div class="grid mbl">
	<div class="txtleft">
		<h3>Navigation</h3>
		<?php displayDefaultFooter(true); ?>
	</div>
	<div class="txtleft">
		<?php echo display_newsletter_form(); ?>
	</div>
	<div class="txtleft">
		<h3>Partenaires</h3>
		<p><img src="https://dummyimage.com/350x100/F7F7F7" alt="placeholder image" /></p>
	</div>
  </div>
  <div class="bottom mtm pts grid">
	  <div class="txtleft"><p class="version">Linea21 (v <?php echo LINEA_VERSION; ?>) © 2003-<?php echo date("Y"); ?><br /><?php printf(_t('divers','licence') ,'<a href="http://opensource.org/licenses/gpl-3.0.html" title="GNU GPL v3" class="out">GNU GPL v3</a>'); ?></p></div>
	  <div class="txtright"><p class="credits">Conçu et développé par <a href="https://www.intermezzo-coop.eu" title="Rejoignez le site d'Intermezzo, éditeur du logiciel Linea21 et prestataire"><img src="<?php echo PUBLIC_THEME_URL; ?>/images/logo-intermezzo.png" alt="Logo d'Intermezzo" id="logo-intermezzo" /></a></p></div>
  </div>
</div> <!-- End mw1140p -->
</footer>
<!-- End Footer -->
<?php AddDynamicFooter(); ?>
</div> <!-- End #main-container -->
<?php if(isset($debugbar)) $debugbar['time']->stopMeasure('footer'); ?>
<?php if(isset($debugbar)) echo $debugbarRenderer->render(); ?>
<script>
//Create a clone of the menu, right next to original.
jQuery(function($) {
	$('.menu-wrap').addClass('original').clone().insertAfter('.menu-wrap').addClass('cloned no-print').css('position','fixed').css('top','0').css('margin-top','0').css('z-index','500').removeClass('original').hide();
	scrollIntervalID = setInterval(stickIt, 10);
	
	<?php if(defined('NEW_WIN_PDF') && NEW_WIN_PDF == 1) { ?>
	$(function() {
	    $('a[href$=".pdf"]').prop('target', '_blank');
	});
	<?php } ?>

	<?php if(defined('NEW_WIN_EXTLINK') && NEW_WIN_EXTLINK== 1 && MOD_DEBUG == 0) { ?>
	$('a').each(function() {
		   var a = new RegExp('/' + window.location.host + '/');
		   if(!a.test(this.href)) {
		       $(this).click(function(event) {
		           event.preventDefault();
		           event.stopPropagation();
		           window.open(this.href, '_blank');
		       });
		   }
		});
	<?php } ?>
});


function stickIt() {

	if($( window ).width() < 768) return;
  var orgElementPos = $('.original').offset();
  orgElementTop = orgElementPos.top;               

  if ($(window).scrollTop() >= (orgElementTop)) {
    // scrolled past the original position; now only show the cloned, sticky element.

    // Cloned element should always have same left position and width as original element.     
    orgElement = $('.original');
    coordsOrgElement = orgElement.offset();
    leftOrgElement = coordsOrgElement.left;  
    widthOrgElement = orgElement.css('width');
    $('.cloned').css('left',leftOrgElement+'px').css('top',0).css('width',widthOrgElement).show();
    $('.original').css('visibility','hidden');
    if($( window ).width() > 959) $('#logo-header').fadeIn();
  } else {
    // not scrolled past the menu; only show the original menu.
    $('.cloned').hide();
    $('.original').css('visibility','visible');
    $('#logo-header').hide();
  }
}

//before adding smooth scroll we identify unwanted links
$('li.tab a').addClass('no-scroll');

// Add smooth scrolling to all links
// @todo simo - for web browser native support
// see also https://www.w3schools.com/howto/howto_css_smooth_scroll.asp
// Select all links with hashes
// from https://css-tricks.com/snippets/jquery/smooth-scrolling/
$('a[href*="#"]')
  // Remove links that don't actually link to anything
  .not('[href="#"]')
  .not('[href="#0"]')
  // Remove wanted links
  .not('.no-scroll')
  .click(function(event) {
    // On-page links
    if (
      location.pathname.replace(/^\//, '') == this.pathname.replace(/^\//, '') 
      && 
      location.hostname == this.hostname
    ) {
      // Figure out element to scroll to
      var target = $(this.hash);
      target = target.length ? target : $('[name=' + this.hash.slice(1) + ']');
      // Does a scroll target exist?
      if (target.length) {
        // Only prevent default if animation is actually gonna happen
        event.preventDefault();
        $('html, body').animate({
          scrollTop: target.offset().top - 120
        }, 1000, function() {
          // Callback after animation
          // Must change focus!
          var $target = $(target);
          $target.focus();
          if ($target.is(":focus")) { // Checking if the target was focused
            return false;
          } else {
            $target.attr('tabindex','-1'); // Adding tabindex for elements not focusable
            $target.focus(); // Set focus again
          };
        });
      }
    }
  });  

</script>
<script src="<?php echo SITE_ROOT_URL; ?>lib/js/slick/slick/slick.js"></script>
<script src="<?php echo PUBLIC_THEME_URL; ?>js/slick.js"></script>
<script src="<?php echo PUBLIC_THEME_URL; ?>js/responsive-menu.js"></script>
</body>
</html>