<?php
/**
 * User module
 * 
 * Allow administrator to send new account notification 
 * to existing user (will also change password value) 
 * and to simply change password value 
 * 
 * @package linea21\modules\user
 * @author $Author$ - Simon Georget <simon@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */


$noplugin = true; // flag for ../config/define.php file
include_once('../config/define.php');

include_once('../class/class.user.php');
include_once(override('../user/'.SQL.'.inc.php'));
include_once('../languages/' . U_L . '/lang_common.' . CHARSET . '.php');
include_once('../languages/' . U_L . '/lang_user.' . CHARSET . '.php');

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////

    
$id = $_REQUEST['id'];

if(isset($_REQUEST['mode'])) $mode = $_REQUEST['mode']; else $mode = 'plain';
if(isset($_REQUEST['action'])) $action = $_REQUEST['action']; // ajax mode
if(isset($_REQUEST['todo'])) $action = $_REQUEST['todo'];// default mode



if($action == 'send-notification') {
    $a_action = 'add_user';
    $success_msg = formatText(_t('user', 'notify_add_success'), '2ATT');
}
if($action == 'new-password') {
    $a_action = 'change_pass';
    $success_msg = formatText(_t('user', 'confirm_modpass'), '2ATT');
}



$u = $sql_object -> DBSelect(SQL_getAllUserInfo($id));

if(!isset($u[0]['user_login'])) die('no way !');
if($u[0]['user_password']  == '@ldap_forward') {
    echo '{"status":0, "msg": "User authentication is forwarded to LDAP directory. Option is not available."}';
    exit();
}

// we update password value
$user_object = new user;
$newpass = $user_object -> GetNewPassword();
$changed = $user_object -> UpdateUserPassword($id, $newpass, $sql_object);

/** include envoi de mail */
include_once(override('../mail/mail_actions.php'));
include_once(override('../mail/send.php'));

$a = array();
$a['login'] = $u[0]['user_login'];
$a['password'] = $newpass;
$a['action'] = $a_action;
$a['recipient'] = $u[0]['profile_email'];


// we notify user
$emailContainer = prepare_email($a);
$r = send_email($emailContainer);

if($mode == 'ajax') {
    
    if( is_string($changed) && $r == true )  {
        echo '{"status":1, "msg": "'. $success_msg .'"}';
    } else {
        echo '{"status":0, "msg": "'._t('msg', 'action_failed').'"}';
    }
    
} else {
 
    if( !is_string($changed) || $r == false )  system_error(__FUNCTION__ . ' : Error when processing "' . $a_action . '" on user ID '. $id);
    
    $link_confirm = SITE_ROOT_URL."admin/confirm.php?rub=user&todo=".$action;
    header("Location: ".safe_redirect($link_confirm));
    exit;
}




?>