<?php
/**
 * User module
 * 
 * Set-up module related menu in back-office
 * 
 * @package linea21\core\user
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////

$rub_link_add=$rub_link."&amp;todo=add";
$rub_link_list=$rub_link."&amp;todo=list";
$rub_link_mod=$rub_link."&amp;todo=mod";
$rub_link_det=$rub_link."&amp;todo=det";

$search="search.php?rub=".$rub;
if($todo=='add') $title=_t('user','add');
if($todo=='list') $title=_t('user','list');
if($todo=='mod') $title=_t('user','mod');
if($todo=='sup') $title=_t('user','sup');
if($todo=='det') $title=_t('user','det');
?>
<div id="itemenu">
	<h1><?php echo $title; ?></h1>
	<div class="contentlink">
		<?php $dispatcher->notify(new sfEvent('secondary_menu', 'admin_user.menu_start'));?>
		<a href="<?php echo $rub_link_add; ?>" title="<?php echo _t('user','add');?>"><i class="icon-plus"></i><?php echo _t('user','add');?></a>
		<a href="<?php echo $rub_link_list; ?>" title="<?php echo _t('user','list');?>"><i class="icon-list"></i><?php echo _t('user','list');?></a>
		<a href="<?php echo $search; ?>" title="<?php echo _t('menu','search');?>"><i class="icon-search"></i><?php echo _t('menu','search');?></a>
		<?php $dispatcher->notify(new sfEvent('secondary_menu', 'admin_user.menu_end'));?>
	</div>
</div>