<?php
/**
 * Vote module
 *
 * Allow user to perform ajax vote
 *
 * @package linea21\modules\vote
 * @author $Author$ - Simon Georget <simon@linea21.com>
 * @version $Id$
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

$noplugin = true; // flag for ../config/define.php file
include_once('../config/define.php');

if(!defined('MOD_VOTE') || MOD_VOTE !=1) exit( 'no way');


/** include envoi de mail */
include_once(override('../mail/mail_actions.php'));
include_once(override('../mail/send.php'));
include_once('../class/class.vote.php');
include_once('../vote/mysql.inc.php');
include_once('../admin/mysql.inc.php');
include_once('../languages/' . U_L . '/lang_common.' . CHARSET . '.php');

$o = array();

$vote = new vote;

// canceling unwanted vote (after vote of course)
// Elpased time is set in class.vote.php - By default 30 seconds
if(isset($_GET['vote-id'])) {
    $id = $_GET['vote-id'];
    $res = $vote->delete($id, $GLOBALS['sql_object']);
    if($res) echo json_encode(array('status'=> 'success','msg'=> _t('like', 'canceled_successful') ));
    else echo json_encode(array('status'=> 'error','msg'=> _t('like', 'canceled_too_late') ));
    exit;
}
if(!isset($_POST['module']) || !isset($_POST['module_id'])) exit('no way');

$o['module'] = $_POST['module'];
$o['module_id'] = $_POST['module_id'];



if($GLOBALS['l21auth']->isAuthenticated()) {
    $o['user_id'] = $GLOBALS['l21auth']->GetSessionElement('id');
    $o['user_login'] = $GLOBALS['l21auth']->GetSessionElement('login');
}
else {
    $o['user_id'] = 0; // integer needed
    $o['user_login'] = 'NOT_AUTHENTICATED';
}

$o['user_ip'] = i2c_realip();

// print_r($o);



// we check if user / IP has already voted
if($vote->has_already_voted($o, $GLOBALS['sql_object'])) {
    
    echo json_encode(array('status'=> 'error','msg'=> _t('like', 'already_liked') ));
    exit;
    
} else {
    
    // we add vote to db
    $r = $vote->add($o, $GLOBALS['sql_object']);
    //echo $vote->getVotesCount($o, $GLOBALS['sql_object']);

    
    // and we send email to admin if number of vote is equal to threshold
    // IMPORTANT : Can be sent twice if user cancel vote and a new vote reaching threshold is triggered again 
    if(defined('VOTE_THRESHOLD') && $vote->getVotesCount($o, $GLOBALS['sql_object']) == VOTE_THRESHOLD) {
        
        $link = HrefMaker(array('rub'=> $GLOBALS['links'][U_L][$o['module']]['linkvalue'], 'id'=> $o['module_id']));
        $a['link'] = $link;
        $a['action'] = 'vote_threshold';
        $a['recipient'] = array();
        
        // we send mail to administrators
        $data = $GLOBALS['sql_object']->DBSelect(SQL_getSuperAdmins());     
        // if no administrator we send mail to SITE_MAIL
        if(!isset($data[0]['profile_email'])) $data[0]['profile_email'] = SITE_MAIL;
        foreach($data as $el) {
            if(!in_array($el['profile_email'], $a['recipient'])) array_push($a['recipient'], $el['profile_email']);
        }
       
        $emailContainer = prepare_email($a);
        $r = send_email($emailContainer);
        
    }
    
    if(is_array($r)) echo json_encode(array('status'=> 'success','msg'=> _t('like', 'like_successful'), 'vote_id' => $r['id'] , 'counter' => (int) $r['counter'] ));
    else echo json_encode(array('status'=> 'error','msg'=> _t('like', 'like_failed') ));
    exit;
}

?>