<?php
/**
 * Workshop module - handle notification preferences for individual workgroups
 * 
 * Handle notification preferences for individual workgroups
 *  
 * @package linea21\modules\workshop
 * @author $Author$ - Simon Georget <simon@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */
include_once ('../config/define.php');
include_once ('../class/class.user.php');
include_once ('../languages/' . U_L . '/lang_common.' . CHARSET . '.php');

$a = array( 'file', 'topic', 'post');

$wg_id = $_POST['workgroup']; // we retrieve workgroup id
$item = $_POST['item']; // throught 'post', 'topic', 'file'
$value = $_POST['notification']; // notif value false or true

// we get user id
$user_id = $GLOBALS['l21auth']->GetSessionElement('id');

$options = array();
$options['workgroup_id'] = $wg_id;
$options['user_id'] = $user_id;
$options['type'] = $item;
$options['value'] = $value;

// ////////// Check Droits utilisateur ////////////
if (! $GLOBALS['l21auth']->isWorkgroupUser($wg_id, $GLOBALS['sql_object']) || ! in_array($item, $a))
    return false;
// //////////

include_once ('../class/class.user.php');
$user_object = new user();

$r = $user_object->changeOnebyOneWGNotification($options, $GLOBALS['sql_object']);

// is numeric, everything is fine
if (is_numeric($r)) {
    $status = 1;
    $o = _t('msg', 'update_successful');
} else {
    $status = 0;
    $o = _t('msg', 'update_failed');
}

/* Return json values */
echo json_encode(array('status' => $status, 'msg' => $o ));
exit();
?>