<?php
/**
 * Workshop module - actions on workgroups users
 * 
 * Handle actions on workgroups users
 *  
 * @package linea21\modules\workshop
 * @author $Author$ - Simon Georget <simon@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */
include_once('../config/define.php');
include_once('../class/class.workshop.php');
include_once(override('../workshop/'.SQL.'.inc.php'));
include_once('../class/class.user.php');
include_once('../languages/' . U_L . '/lang_common.' . CHARSET . '.php');
include_once('../languages/' . U_L . '/lang_workshop.' . CHARSET . '.php');

// coming from det.php when a user has a pending subscription

include_once('../admin/'.SQL.'.inc.php');
include_once(override('../mail/mail_actions.php'));
include_once(override('../mail/send.php'));


$id=$_GET['id']; // we retrieve given id
$uid = $_GET['u_id'];
$action = $_GET['action'];
isset($_GET['convert']) ? $convert_to = $_GET['convert'] : $convert_to = '';


//////////// Check Droits utilisateur ////////////
if (!$l21auth->isWorkgroupOrganiser($l21auth->GetSessionElement('id'), $sql_object, $id) && !$l21auth->isSuperAdmin())
	ReloadIndex('admin');
////////////

if(!isset($_GET['mode'])) {
	$mode='plain';
} else {
	$mode='ajax';
}

$workshop_object = new workshop;

$data = $sql_object->DBSelect(SQL_getoneCompleteWorkshop($id));

if(isset($data[0]['workshop_denomination'])) {
	$wgname = formatText($data[0]['workshop_denomination'], '2HTML');
	$wglink = HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['workgroup']['linkvalue'],'id' => $id));
	
	$user = $sql_object->DBSelect(SQL_getoneUser($uid));
	if(isset($user[0]['profile_email'])) $recipient = $user[0]['profile_email'];
	
} else die(ERROR_SYSTEM);


if($_GET['action'] == 'accept') {

	$r = $workshop_object->acceptUser($id, $uid, $sql_object);
	
	$a = array('action' => 'workgroup_response', 'message' => _t('workshop', 'request_accepted'), 'wglink' => $wglink, 'wgname' => $wgname, 'recipient' => $recipient, 'flag' => 'accepted');
	$emailContainer = prepare_email($a);
	$r = send_email($emailContainer);
		

	if($mode == 'plain') {
		$link_confirm = SITE_ROOT_URL."admin/confirm.php?rub=workshop&todo=add_u&id=".$id;
		if($r) {
		    header("Location: ".safe_redirect($link_confirm));
		    exit;
		}
		else  system_error();
		// ajax mode
	} else {
		if($r) {
			$status = 1;
			$o = _t('workshop', 'subscription_confirmed');
		}
		/* Return json values */
		echo json_encode(array('status'=> $status,'msg'=> $o, 'action' => $action));
	}
	// if action == unaccept // not implement yet
} elseif($_GET['action'] == 'unaccept') {
	
	$r = $workshop_object->DeleteUserWorkshop($uid, $id, $sql_object);
	
	$a = array('action' => 'workgroup_response', 'message' => _t('workshop', 'request_unaccepted'), 'wglink' => $wglink, 'wgname' => $wgname, 'recipient' => $recipient, 'flag' => 'unaccepted');
	$emailContainer = prepare_email($a);
	$r = send_email($emailContainer);
	
	if($mode == 'plain') {
		$link_confirm = SITE_ROOT_URL."admin/confirm.php?rub=workshop&todo=sup_u&id=".$id;
		if($r) {
		    header("Location: ".safe_redirect($link_confirm));
		    exit;
		}
		else  system_error();
		// ajax mode
	} else {
		if($r) {
			$status = 1;
			$o = _t('workshop', 'confirm_sup_u');
		}
		/* Return json values */
		echo json_encode(array('status'=> $status,'msg'=> $o, 'action' => $action, 'type' => $convert_to));
	}
} elseif($_GET['action'] == 'changestatus') {
	
	$usero = new user;
	
	$r = $workshop_object->changeUserStatus($id, $uid, $convert_to, $usero, $sql_object);
	
	if($mode == 'plain') {
		$link_confirm = SITE_ROOT_URL."admin/confirm.php?rub=workshop&todo=changestatus&id=".$id;
		if($r) {
		    header("Location: ".safe_redirect($link_confirm));
		    exit;
		}
		else  system_error();
		// ajax mode
	} else {
		if($r) {
			$status = 1;
			$o = _t('workshop', 'confirm_changestatus');
		}
		/* Return json values */
		echo json_encode(array('status'=> $status,'msg'=> $o, 'action' => $action, 'newstatus' => $convert_to));
	}
}
?>