<?php
/**
 * Workgroup module - Add calendar page
 * 
 * Add calendar page
 * 
 * @package linea21\modules\workshop
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

if(isset($_POST['id']))	$id=$_POST['id'];
if(isset($_GET['id']))	$id=$_GET['id'];
//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isWorkgroupOrganiser($l21auth->GetSessionElement('id'), $sql_object, $id) && !$l21auth->isSuperAdmin())
ReloadIndex('admin');
////////////

include_once("../lib/input_helpers.php");

$form_date = '';
$form_task='';
$form_task_details='';
$author=$l21auth->GetSessionElement('id');
$mask = '';
$mask_notify='';

$disabled = !$l21auth->isSuperAdmin() ? ' disabled="disabled"' : '' ;


$link_add_cal = $rub_link . "&amp;todo=add_cal&amp;id=";
$link_det = $rub_link . "&amp;todo=det&amp;id=";



$req_det_workshop= SQL_getoneCompleteWorkshop($id);
$result_workshop=$sql_object->DBSelect($req_det_workshop);
$workshop_denomination=formatText($result_workshop[0]['workshop_denomination'], '2HTML');
$link_cancel=$rub_link."&amp;todo=list_cal&amp;id=".$id;

$calendar_object= new calendar;

if(isset($_POST['enregistrer'])) {

  $data_table=unserialize(urldecode($_POST['data_table']));
  $result=$calendar_object->AddTask($data_table, $sql_object);

  //faire l'ajout de user avec AddUserWorkshop
  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo."&id=".$id;
  if(is_numeric($result)) {
  	// we notify users if needed
  	if($data_table[6]===true) {
  		notifyUsersMsg(array('id' => $id,'user' => $_SESSION['userlogin'],'owner' => $_SESSION['userlogin'], 'action' => 'event_alert', 'task_date' => $data_table[0], 'task_subject' => $data_table[1], 'task_body' => $data_table[2]));
  	}
  	header("Location: ".safe_redirect($link_confirm));
  	exit;
  }
  else  system_error();
}




if(isset($_POST['valider'])) {

  $table = array();
    
  //traitement de la date
  $table[0] = $_POST['date'];
  $table[1] = $_POST['task'];
  $table[2] = $_POST['task_details'];
  $table[3] = $_POST['id'];
  $table[4] = $_POST['author'];
  isset($_POST['is_common']) ? $table[5] = 1 : $table[5] = 0;

  if(isset($_POST['notify-users'])) {
  	$mask_notify=' checked="checked"';
  	$table[6] = true;
  	$notifyusers_display = _t('divers', 'yes');
  } else {
  	$mask_notify='';
  	$table[6] = false;
  	$notifyusers_display = _t('divers', 'no');
  }

  $integrity=$calendar_object->CheckDataIntegrity($table, $sql_object);

  if(is_string($integrity)) {
    $text_format='2FIELD';
  } else {
    $text_format='2HTML';
  }
  $form_task=formatText($_POST['task'], $text_format);
  $form_task_details=formatText($_POST['task_details'], $text_format);
  $form_date = $_POST['date'];
  if(isset($_POST['is_common'])) {
    $mask = 'checked="checked"';
    $form_common = _t('divers', 'yes');
  } else {
    $mask = '';
    $form_common = _t('divers', 'no');
  }

  $table=urlencode(serialize($table));
}
$navtitle=_t('workshop','add_cal')." : ".$workshop_denomination;

// foundation Datepicker include
addDynamicCSS('../lib/js/foundation-datepicker/stylesheets/foundation-datepicker.css');
footerAddJS('../lib/js/foundation-datepicker/js/foundation-datepicker.js');

?>

<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home') ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','workshop')?></a></li>
	<li><span><?php echo formatnavTitle($navtitle); ?></span></li>
</ul>
</div>
<!--end barre haute -->

<script>
	$(function()
	{
		/** datePicker integration
		---------------------------------------------------*/
		$('.date-pick').fdatepicker({ 
			language: '<?php echo U_L; ?>',
			format: '<?php echo DATE_FORMAT; ?>'
		});

    });
</script>


<?php
if(!isset($integrity) || is_string($integrity)) {
  ?>
<div class="contentcontainer">
<?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<?php
if(isset($integrity) && is_string($integrity)) display_errors($integrity);
afflinkbar($todo,$id, $lang);
?>
<h2><?php echo _t('workshop','add_cal'); ?></h2>
<div class="subtitle" id="workshop-subtitle"><?php echo $workshop_denomination; ?></div>

<form id="addtask" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
	<p>
		<label for="task"><?php echo mb_ucfirst(_t('workshop','task')); ?> : *</label>
		<input name="task" type="text" class="textfield" id="task" maxlength="200" value="<?php echo $form_task; ?>" required />
	</p>
	<p>
		<label for="task_details"><?php echo mb_ucfirst(_t('workshop','task_details')); ?> : *</label>
		<textarea id="task_details" name="task_details" <?php echo AREA_SETTINGS; ?> class="largetextfield" required><?php echo $form_task_details; ?></textarea>
	</p>
	<p>
		<label for="date"><?php echo mb_ucfirst(_t('workshop','date')); ?> : *</label>
		<input name="date" type="text" maxlength="10" id="date"	class="date-pick shorttextfield" value="<?php echo $form_date; ?>" required /><br />
	</p>
	<div class="mts">
		<div class="label"><?php echo mb_ucfirst(_t('workshop','task_common')); ?> :</div>
		<div class="rightpanel">
			<input class="checkbox-switch" <?php echo $disabled; ?> name="is_common" type="checkbox" id="is_common" value="1" <?php echo $mask; ?> />
			<label for="is_common"></label>
		</div>
	</div>
	<div>
		<div class="label"><?php echo mb_ucfirst(_t('workshop','com_notify')); ?> :</div>
		<div class="rightpanel">
			<input class="checkbox-switch" type="checkbox" name="notify-users" id="notify-users" value=""<?php echo $mask_notify; ?> />
			<label for="notify-users"></label>
		</div>
	</div>
	<div>
		<input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
		<input name="author" type="hidden" value="<?php echo $author; ?>" id="author" />
		<input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
		<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
		<?php echo cancel_button($link_cancel); ?>
		<input name="valider" type="submit" value="<?php echo _t('btn','valid') ?>" class="button" id="valider" />
	</div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php
// Récapitulatif
} else	{

  $display_form_task=empty_nc(formatText($form_task, $text_format));
  $display_form_task_details=empty_nc(formatText($form_task_details, $text_format));

  ?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content"><?php afflinkbar($todo,$id, $lang); ?>
<h2><?php echo _t('recap','title') ?></h2>
<?php
echo "<dl class=\"summary\">\n";
echo "<dt>".mb_ucfirst(_t('workshop','task'))." :</dt>\n";
echo "<dd>". $display_form_task."</dd>\n";
echo "<dt>". mb_ucfirst(_t('workshop','task_details')). " :</dt>\n";
echo "<dd>".$display_form_task_details."</dd>\n";
echo "<dt>".mb_ucfirst(_t('workshop','date'))." :</dt>\n";
echo "<dd>".$form_date."</dd>\n";
echo "<dt>".mb_ucfirst(_t('workshop','task_common'))." :</dt>\n";
echo "<dd>".$form_common."</dd>\n";
echo "<dt>".mb_ucfirst(_t('workshop','com_notify')) ." : </dt>\n";
echo "<dd>".$notifyusers_display."</dd>\n";
echo "</dl>\n";
?>
<form id="addtask" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
	<div>
		<input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
		<input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
		<?php echo cancel_button($link_cancel); ?>
		<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
		<input name="data_table" type="hidden" value="<?php echo $table; ?>" id="data_table" />
		<input name="retour" type="button" value="<?php echo _t('btn','preview') ?>" class="button" id="retour" onclick="history.go(-1);" />
		<input name="enregistrer" type="submit" value="<?php echo _t('btn','save') ?>" class="button" id="valider" />
	</div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php } ?>