<?php
/**
 * Workgroup module - Add workgroups user
 * 
 * Add workgroups users page
 * 
 * @package linea21\modules\workshop
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */
?>


<?php
if(isset($_POST['id']))	$id=$_POST['id'];
if(isset($_GET['id']))	$id=$_GET['id'];

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isWorkgroupOrganiser($l21auth->GetSessionElement('id'), $sql_object, $id) && !$l21auth->isSuperAdmin())
ReloadIndex('admin');
////////////

// TextboxList CSS/JS inclusion
addDynamicCSS(THEME_ADMIN_PATH.'css/TextboxList.css');
addDynamicCSS(THEME_ADMIN_PATH.'css/TextboxList.Autocomplete.css');
footerAddJS('../lib/js/TextboxList-jQuery/Source/GrowingInput.js');
footerAddJS('../lib/js/TextboxList-jQuery/Source/TextboxList.js');
footerAddJS('../lib/js/TextboxList-jQuery/Source/TextboxList.Autocomplete.js');

$form_user_login='';
$mask_statut_O='';
$mask_statut_U="checked=\"checked\"";

$req_det_workshop= SQL_getoneCompleteWorkshop($id);
$result_workshop=$sql_object->DBSelect($req_det_workshop);
$workshop_denomination=formatText($result_workshop[0]['workshop_denomination'], '2HTML');

$link_cancel=$rub_link."&amp;todo=det&amp;id=".$id;


if(isset($_POST['enregistrer'])) {
  $data_login=$_POST['data_login'];
  $data_statut=$_POST['data_statut'];
  if (!$l21auth->isSuperAdmin())$data_statut='U';
  //faire l'ajout de user avec AddUserWorkshop
  $workshop_object= new workshop;
  $result=$workshop_object->AddUserWorkshop($id, $data_login, $data_statut , $sql_object);
  echo $result;
  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo."&id=".$id;
  if(is_numeric($result)) {
      header("Location: ".safe_redirect($link_confirm));
      exit;
  }
  else  system_error();
}

if(isset($_POST['valider'])) {
  $data_login=$_POST['user_login'];
  $data_statut=$_POST['user_statut'];
  if (!$l21auth->isSuperAdmin())$data_statut='U';
  $workshop_object= new workshop;
  $integrity=$workshop_object->CheckUsersIntegrity($data_login, $id, $sql_object, $data_statut);
  if(is_string($integrity)) {
    $text_format='2FIELD';
  } else {
    $text_format='2HTML';
  }

  $form_user_login=formatText(str_replace(",",", ", $_POST['user_login']), $text_format);
  if($_POST['user_statut']=='U') $mask_statut_U="checked=\"checked\""; else $mask_statut_U='';
  if($_POST['user_statut']=='O') $mask_statut_O="checked=\"checked\""; else $mask_statut_O='';
}

$navtitle=_t('workshop','add_new_user')." : ".$workshop_denomination;
?>

<script>
    $(document).ready( function()
    {
    	function UpdateList() {
    		$("#user_login").val('');
			var type = $("input[name='user_statut']:checked").val(); // we get current Type O || U
			$.ajax({url: '../workshop/_ajax_user_autocomplete.php?type=' + type, dataType: 'json',
				success: function(r){
					t.plugins['autocomplete'].setValues(r);
				}
			});
		}

    	$("input[name='user_statut']").click(function(){
    		UpdateList();
    	});

    	// Autocomplete initialization
		var t = new $.TextboxList('#user_login', {unique: true, plugins: {autocomplete: {onlyFromValues: true, placeholder:"<?php echo _t('textbox_js', 'placeholder')?>"}}});
		$.ajax({url: '../workshop/_ajax_user_autocomplete.php?type=U', dataType: 'json', success: function(r){
			t.plugins['autocomplete'].setValues(r);
		}});

		$("div.textboxlist").each(function() {
		    $(this).append('<p class="soft-emphase"><?php echo _t('msg','textboxlist_notice') ?><\/p>');
		});

    });
</script>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home') ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','workshop')?></a></li>
	<li><span><?php echo formatnavTitle($navtitle); ?></span></li>
</ul>
</div>
<!--end barre haute -->
<?php
if(!isset($integrity) || is_string($integrity)) {
  ?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<?php if(isset($integrity) && is_string($integrity)) display_errors($integrity); ?>
<?php afflinkbar($todo,$id, $lang); ?>
<h2><?php echo formatText(_t('workshop','add_new_user'), 'HTML'); ?></h2>
<div class="subtitle" id="workshop-subtitle"><?php echo $workshop_denomination; ?></div>

<form id="adduserworkshop" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
<p>
  <label for="user_login"><?php echo _t('workshop','add_new_user_login'); ?> * : </label>
  <input name="user_login" type="text" class="textfield" id="user_login" maxlength="150" value="<?php echo $form_user_login; ?>" />
</p>
<?php
if ($l21auth->isSuperAdmin()){
?>

  <div class="label"><?php echo mb_ucfirst(_t('workshop','add_new_user_right')); ?> * : </div>
  <div class="rightpanel">
  <input name="user_statut" type="radio" id="statut_U" value="U" <?php echo $mask_statut_U; ?> />
  <label for="statut_U"><?php echo _t('statut','U'); ?></label>
  <input name="user_statut" type="radio" id="statut_O" value="O" <?php echo $mask_statut_O; ?> />
  <label for="statut_O"><?php echo _t('statut','O'); ?></label>
  </div>
<?php } else { ?>
  <input name="user_statut" type="hidden" value="U" id="todo" />
<?php } ?>

  <div>
    <input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
    <?php echo cancel_button($link_cancel); ?>
    <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
    <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
    <input name="valider" type="submit" value="<?php echo _t('btn','valid') ?>" class="button" id="valider" />
  </div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php
// Récapitulatif
} else	{
  ?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content"><?php afflinkbar($todo,$id, $lang); ?>
<h2><?php echo _t('recap','title') ?></h2>
<?php
echo "<dl class=\"summary\">\n";
echo "<dt>".mb_ucfirst(_t('workshop','add_new_user_login'))." :</dt>\n";
echo "<dd>".$form_user_login."</dd>\n";
echo "<dt>".mb_ucfirst(_t('workshop','add_new_user_right')) ."</dt>\n";
echo "<dd>". display_statut($_POST['user_statut']). "</dd>\n";
echo "</dl>\n";
?>
<form id="addworkshop" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
  <div>
  <input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
  <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
  <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
  <?php echo cancel_button($link_cancel); ?>
  <input name="data_login" type="hidden" value="<?php echo $data_login; ?>" id="data_login" />
  <input name="data_statut" type="hidden" value="<?php echo $data_statut; ?>" id="data_statut" />
  <input name="retour" type="button" value="<?php echo _t('btn','preview') ?>" class="button" id="retour" onclick="history.go(-1);" />
  <input name="enregistrer" type="submit"	value="<?php echo _t('btn','save') ?>" class="button" id="valider" />
  </div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php } ?>