<?php
/**
 * Confirmation page
 *
 * This page is called after an administration action for confirmation
 *
 * @package linea21\core\admin
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */
$noplugin = true; // flag for ../config/define.php file
include_once("../config/define.php");
ob_start();

if(!isset($_GET['rub']) && !isset($_POST['rub'])) {
	die("rub is not set!");
} else {
	if(isset($_POST['rub']))	$rub=strip_tags($_POST['rub']);
	if(isset($_GET['rub']))	$rub=strip_tags($_GET['rub']);
}
if(!isset($_GET['todo']) && !isset($_POST['todo'])) {
	$todo="list";
} else {
	if(isset($_POST['todo']))	$todo=strip_tags($_POST['todo']);
	if(isset($_GET['todo']))	$todo=strip_tags($_GET['todo']);
}

if(isset($_POST['id']))	$id=strip_tags($_POST['id']);
if(isset($_GET['id']))	$id=strip_tags($_GET['id']);

/**
 * language include
 *
 **/
include_once('../languages/'.U_L.'/lang_common.' . CHARSET . '.php');

// necessary because file does not exists when $rub is a plugin
if(file_exists('../languages/'.U_L.'/lang_' .$rub. '.' . CHARSET . '.php')) include_once('../languages/'.U_L.'/lang_' .$rub. '.' . CHARSET . '.php');

IncludeUserfiles();

isset($_SESSION['backlink']) ? $backlink = $_SESSION['backlink'] : $backlink="index.php?rub=".$rub;


if($rub=='project') {
	if($todo=='add') $message=_t('project','confirm_add');
	if($todo=='mod') $message=_t('project','confirm_mod');
	if($todo=='sup') $message=_t('project','confirm_sup');
}

if($rub=='tag') {
	if($todo=='mod')  $message=_t('tag','confirm_mod');
	if($todo=='sup') $message=_t('tag','confirm_sup');
}

if($rub=='scale') {
	if($todo=='add') $message=_t('scale','confirm_add');
	if($todo=='mod')  $message=_t('scale','confirm_mod');
	if($todo=='sup') $message=_t('scale','confirm_sup');
}

if($rub=='level') {
	if($todo=='add') $message=_t('level','confirm_add');
	if($todo=='mod')  $message=_t('level','confirm_mod');
	if($todo=='sup') $message=_t('level','confirm_sup');
}

if($rub=='user') {
	if($todo=='add') $message=_t('user','confirm_add');
	if($todo=='mod')  $message=_t('user','confirm_mod');
	if($todo=='new-password')  $message=_t('user','confirm_modpass');
	if($todo=='send-notification')  $message=_t('user','notify_add_success');
	if($todo=='mod_t')  {
		$message=_t('user','confirm_changetype');
		$backlink="index.php?rub=user&todo=det&id=".$id;
	}
	if($todo=='sup') $message=_t('user','confirm_sup');
	if($todo=='delavatar') {
		$message=_t('user','confirm_delavatar');
		$backlink="index.php?rub=user&todo=mod&id=".$id;
	}
}

if($rub=='news') {
	if($todo=='add') $message=_t('news','confirm_add');
	if($todo=='mod')  $message=_t('news','confirm_mod');
	if($todo=='sup') $message=_t('news','confirm_sup');
}

if($rub=='page') {
	if($todo=='add') $message=_t('page','confirm_add');
	if($todo=='mod')  $message=_t('page','confirm_mod');
	if($todo=='sup') $message=_t('page','confirm_sup');
}

if($rub=='newsletter') {
	if($todo=='add') $message=_t('newsletter','confirm_add');
	if($todo=='mod')  $message=_t('newsletter','confirm_mod');
	if($todo=='sup') $message=_t('newsletter','confirm_sup');
}

if($rub=='yellowpages') {
	if($todo=='add') $message=_t('yp','confirm_add');
	if($todo=='mod')  {
		$message=_t('yp','confirm_mod');
		$backlink="index.php?rub=yellowpages&todo=det&id=".$_GET['id'];
	}
	if($todo=='sup') $message=_t('yp','confirm_sup');
}

if($rub=='dashboard') {
	if($todo=='add') $message=_t('dashboard','confirm_add');
	if($todo=='mod')  $message=_t('dashboard','confirm_mod');
	if($todo=='sup') $message=_t('dashboard','confirm_sup');
	$backlink="index.php?rub=dashboard&todo=det&id=".$_GET['id']."&scale_id=".$_GET['scale_id'];
}
if($rub=='sdi') {
	if($todo=='add') $message=_t('sdi','confirm_add');
	if($todo=='mod')  {
		$message=_t('sdi','confirm_mod');
		$backlink="index.php?rub=sdi&todo=det&id=".$_GET['id'];
	}
	if($todo=='mod_e')
	{  $message=_t('sdi','e_confirm_mod');
	$backlink="index.php?rub=sdi&todo=det&id=".$_GET['id'];
	}
	if($todo=='mod_r'){
		$message=_t('sdi','r_confirm_mod');
		$backlink="index.php?rub=sdi&todo=det&id=".$_GET['id'];
	}
	if($todo=='mod_p'){
		$message=_t('sdi','p_confirm_mod');
		$backlink="index.php?rub=sdi&todo=det&id=".$_GET['id'];
	}
	if($todo=='clone'){
		$message=_t('sdi','confirm_clone');
		$backlink="index.php?rub=sdi&todo=mod&id=".$_GET['id'];
	}
	if($todo=='sup') $message=_t('sdi','confirm_sup');
}
if($rub=='publication') {
	if($todo=='add') $message=_t('publication','confirm_add');
	if($todo=='mod')  $message=_t('publication','confirm_mod');
	if($todo=='sup') $message=_t('publication','confirm_sup');
}

if($rub=='workshop') {
	if($todo=='add') 		$message=_t('workshop','confirm_add');
	if($todo=='sup')		$message=_t('workshop','confirm_sup');
	
	if($todo=='changestatus') {
		$message=_t('workshop','confirm_changestatus');
		$backlink="index.php?rub=workshop&todo=det&id=".$_GET['id'];
	}
	if($todo=='sup_u') {
		$message=_t('workshop','confirm_sup_u');
		$backlink="index.php?rub=workshop&todo=det&id=".$_GET['id'];
	}
	if($todo=='mod')  	{
		$message=_t('workshop','confirm_mod');
		$backlink="index.php?rub=workshop&todo=det&id=".$_GET['id'];
	}
	if($todo=='mod_cal'){
		$message=_t('workshop','confirm_mod_cal');
		$backlink="index.php?rub=workshop&todo=list_cal&id=".$_GET['id'];
	}
	if($todo=='mod_com' || $todo=='lock_com'){
		$message=_t('workshop','confirm_mod_com');
		$backlink="index.php?rub=workshop&todo=det_com&id=".$_GET['id']."&com_id=".$_GET['com_id'];
		if(isset($_GET['mes_id'])) $backlink.="#".$_GET['mes_id'];
	}
	if($todo=='add_cal'){
		$message=_t('workshop','confirm_add_cal');
		$backlink="index.php?rub=workshop&todo=list_cal&id=".$_GET['id'];
	}
	if($todo=='add_u'){
		$message=_t('workshop','confirm_add_u');
		$backlink="index.php?rub=workshop&todo=det&id=".$_GET['id'];
	}
	if($todo=='add_com'){
		$message=_t('workshop','confirm_add_com');
		$backlink="index.php?rub=workshop&todo=det_com&id=".$_GET['id']."&com_id=".$_GET['com_id'];
		if(isset($_GET['mes_id'])) $backlink.="#".$_GET['mes_id'];
	}
	if($todo=='sup_cal'){
		$message=_t('workshop','confirm_sup_cal');
		$backlink="index.php?rub=workshop&todo=list_cal&id=".$_GET['id'];
	}
	if($todo=='sup_com'){
		$message=_t('workshop','confirm_sup_com');
		if(isset($_GET['all'])) $backlink="index.php?rub=workshop&todo=list_com&id=".$_GET['id']."&com_id=".$_GET['com_id'];
		else $backlink="index.php?rub=workshop&todo=det_com&id=".$_GET['id']."&com_id=".$_GET['com_id'];
	}
}

if($rub=='resources') {
	if($todo=='add_l' || $todo=='add_m' || $todo=='add_b') $message=_t('resources','confirm_add');
	if($todo=='mod_l' || $todo=='mod_m' || $todo=='mod_b') $message=_t('resources','confirm_mod');
	if($todo=='sup') $message=_t('resources','confirm_sup');
	if($_GET['type']=='P') $backlink="index.php?rub=publication&todo=det&id=".$_GET['id'];
	if($_GET['type']=='W') $backlink="index.php?rub=workshoprep&todo=det&id=".$_GET['id'];
	
}

if($rub=='contents') {
	if($todo=='add') $message=_t('contents','confirm_add');
	if($todo=='mod') $message=_t('contents','confirm_mod');
	if($todo=='sup') $message=_t('contents','confirm_sup');
	if($_GET['type']=='P') $backlink="index.php?rub=publication&todo=det&id=".$_GET['id'];
	if($_GET['type']=='W') $backlink="index.php?rub=workshoprep&todo=det&id=".$_GET['id'];
}

if($rub=='workshoprep') {
	if($todo=='add') $message=_t('workshoprep','confirm_add');
	if($todo=='mod') $message=_t('workshoprep','confirm_mod');
	if($todo=='sup') {
		$message=_t('workshoprep','confirm_sup');
		$backlink="index.php?rub=workshop&todo=det&id=".$_GET['id'];
	} else {
		$backlink="index.php?rub=".$rub."&todo=det&id=".$_GET['id'];
	}
	
}
if($rub=='system') {
	if($todo=='mod')  $message=_t('system','confirm_mod');
	if($todo=='edit_files') {
		$message=_t('system','confirm_edit');
		$backlink="index.php?rub=system&todo=edit_files&file=".$_GET['file'];
		if(isset($_GET['plugin'])) $backlink .= '&plugin='.$_GET['plugin'];
	}
	if($todo=='ban-ip-add') {
	    $message=sprintf(_t('system','confirm_banned_ip'), $_SESSION['banned_ip']);
	    unset($_SESSION['banned_ip']);
	    $backlink="index.php?rub=system&todo=list";
	}
	if($todo=='ban-ip-del') {
	    $message=sprintf(_t('system','confirm_unbanned_ip'), $_SESSION['banned_ip']);
	    unset($_SESSION['banned_ip']);
	    $backlink="index.php?rub=system&todo=list";
	}
}

// allow plugin to handle confirmation message
if(isset($_GET['local'])) include_once(override('../'.$rub.'/confirm.php'));
?>
<!doctype html>
<html lang="<?php echo U_L; ?>">
<head>
    <meta http-equiv="Refresh" content="<?php echo CONFIRM_REFRESH; ?>;URL=<?php echo $backlink; ?>">
    <meta charset=<?php echo CHARSET; ?>" />
    <title><?php echo _t('header','title'); ?></title>
    <link rel="stylesheet" href="<?php echo THEME_ADMIN_PATH; ?>css/KNACSS/css/knacss.css" />
    <link rel="stylesheet" href="<?php echo THEME_ADMIN_PATH; ?>css/actionconfirm.css" />
</head>
<body>
	<h1 class="txtcenter center w50"><?php echo $message; ?></h1>
</body>
</html>
<?php
ob_end_flush();
?>