<?php
/**
 * banip class
 * 
 * Povides methods related to ban-ip features
 * 
 * @package linea21\modules\system
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * Newsletter Management
 */

class banIP {
  /* @param
   * */
  var $TDB_BANIP = T_BANNED_IP; // nom de la table.
  var $ID;
  var $IP;
  var $USER_ID;
  var $DATE_CREA;
  var $LAST_MODIFY;

  protected $dispatcher = null;

  public function __construct()
  {
    $this->dispatcher = $GLOBALS['dispatcher'];
  }

  public function __call($method, $arguments)
  {
    $event = $this->dispatcher->notifyUntil(new sfEvent($this, 'banIP.extensible_function', array(
      'method'    => $method,
      'arguments' => $arguments
    )));
    if (!$event->isProcessed())
    {
      throw new Exception(sprintf('Call to undefined method %s::%s.', get_class($this), $method));
    }

    return $event->getReturnValue();
  }


    /**
     * banip::updateBannedIP()
     * Mise à jour de la liste des IP bannies
     *
     * @access public
     * @return boolean
     */

    public function updateBannedIP($ip)
    {
        // Notify the beginning of the current method
        $this->dispatcher->notify(new sfEvent($this, 'banip.update', array('ip' => $ip)));

        $a = [];
        $storeIp = $this->getBannedIP();

        if(strlen($ip) > 1) $a = preg_split("/\r\n|\n|\r/", $ip);
        $a = array_map('trim', $a); // we trim values

        // we delete what should be deleted
        $ip2delete = array_diff($storeIp, $a);

        foreach ($ip2delete as $ip) {
            if(strlen($ip) > 4) $this->delete($ip, $GLOBALS['sql_object']);
        }
        // we add what should be added
        foreach ($a as $ip) {
            if(strlen($ip) > 4 && !in_array($ip, $storeIp)) $this->add($ip, $GLOBALS['sql_object']);
        }

        return true;
    }
  /**
   * banip::getBannedIP()
   * Obtention de la liste des IP bannies
   *
   * @access public
   * @return array : liste des IP bannies
   */

  public function getBannedIP()
  {
    // Notify the beginning of the current method
    $this->dispatcher->notify(new sfEvent($this, 'banip.get'));

    $banned = [];
    
  	// we get banned ip
  	$r=$GLOBALS['sql_object']->DBSelect('SELECT ban_ip FROM '.$this->TDB_BANIP.' ORDER BY ban_ip DESC;');
  	
  	if(is_array($r)) {
  	    foreach($r as $k => $v) {
  	        array_push($banned, $v['ban_ip']);
  	    }
  	}

  	return $banned;
  }
  
  /**
   * banip::isBannedIP()
   * Vérifie si une IP est bannie
   *
   * @access public
   * @param string $ip : identifiant de l'enregistrement (IP)
   * @return bool : true or false
   */
  
  public function isBannedIP($cip)
  {
      // Notify the beginning of the current method
      $this->dispatcher->notify(new sfEvent($this, 'banip.is'));
      
      $banned = $this->getBannedIP();
      
      // if(in_array($cip, $banned)) return true;
          
        foreach($banned as $v) {
            $value = str_replace("*", "", $v); // we remove wildcard if needed
            if(Stringy\Stringy::create($cip, CHARSET)->startsWith($value)) {
                logfile ( LOG_MAINFILE, array ('[BANNED IP DETECTED]', $cip, 'matching pattern '. $v, $_SERVER['HTTP_USER_AGENT'], $_SERVER['REQUEST_METHOD'], $_SERVER['REQUEST_URI'], $_SERVER['QUERY_STRING'], $_SERVER['HTTP_COOKIE'], i2c_realip()));
                  
                return true;
            }
         }
      
      return false;
  }

 
  /**
   * banip::delete()
   * suppression d'une IP
   *
   * @access public
   * @param string $ip : identifiant de l'enregistrement (IP)
   * @param object $sql_object
   * @return bool $result
   */

  public function delete($ip, $sql_object)
  {
  	global $l21auth;
  	
  	// Notify the beginning of the current method
  	$this->dispatcher->notify(new sfEvent($this, 'banip.before_delete', array('id' => $ip)));

    $q = "DELETE FROM  " . $this->TDB_BANIP . " WHERE ban_ip='" . $ip . "';";
    $result = $sql_object->DBQuery($q);
    
    // we log delete action
     if($result)	logfile(LOG_MAINFILE, array('[action] delete banip', 'IP='.$ip, 'by_id='.$l21auth->GetSessionElement('id'), 'by_login='.$l21auth->GetSessionElement('login')));
    
    return $result;
  }


  /**
   * banip::add()
   * Ajout d'une adresse IP dans la black-list
   * @access public
   * @param  string $ip IP a ajouter
   * @param object $sql_object
   * @return string $result
   **/
  public function add($ip, $sql_object)
  {
    global $l21auth;
    
    // Notify the beginning of the current method
    $this->dispatcher->notify(new sfEvent($this, 'banip.before_add', array('ip' => $ip)));

    $q = "SELECT ban_id FROM " . $this -> TDB_BANIP . " WHERE ban_ip='" . $ip. "';";
    $data = $sql_object -> DBSelect($q);
    // IP is already banned
    if (is_array($data) && count($data) == 1) {
        logfile(LOG_MAINFILE, array('[action] add banip', 'IP='.$ip, 'IP already banned', 'by_id='.$l21auth->GetSessionElement('id'), 'by_login='.$l21auth->GetSessionElement('login'), 'IP already banned'));
        return 1; // we return a numeric anyway
    } else {
        $q = "INSERT INTO " . $this -> TDB_BANIP . " (ban_ip, ban_user_id,  ban_date_crea) " . "VALUES('" . $ip . "', '" . $l21auth->GetSessionElement('id'). "', NOW());";
      $last_id = $sql_object -> DBInsert ($q, 1);
//       logfile(LOG_MAINFILE, array('[action] add banip', 'IP='.$ip));
      
      if (is_numeric($last_id)) {
          logfile(LOG_MAINFILE, array('[action] add banip', 'IP='.$ip, 'by_id='.$l21auth->GetSessionElement('id'), 'by_login='.$l21auth->GetSessionElement('login')));
          return $last_id;
      } else {
          return false;
      }
    }
  }


}

?>