<?php
/**
 * Comment module
 * 
 * Display a specific comment in back-office
 * 
 * @package linea21\modules\comment
 * @author $Author$ - Simon Georget <simon@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
	include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////

if (isset($_GET['id'])) $id = $_GET['id'];
if (isset($_POST['id'])) $id = $_POST['id'];


$comm = new comment();
$options = array('status' => array('P', 'D', 'E'), 'given_id' => $id);
$data = $comm->get($options, $sql_object);
if ($data == 0 || count($data) != 1) exit;

// we get the current item title for displaying
$options = array('module' => $data[0]['comment_module'], 'module_id' => $data[0]['comment_module_id']);
$r = $comm->getCommentItem($options, $sql_object);
if ($data == 0 || count($data) != 1) exit;
$data[0]['item_title']=$r[0]['item_title'];

$html_comments = getMarkup($data, true);

echo getAjaxFunction(); // for ajax call

?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"> <?php echo _t('way','home'); ?>
	</a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>"
		class="chemin_rub"> <?php echo _t('menu','comment'); ?> </a></li>
	<li><span><?php echo formatNavTitle(_t('comment','det')); ?></span>
	</li>
</ul>
</div>
<!--end barre haute -->

<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<?php
  echo "<h2>";
  echo formatTitleh2(_t('comment','det'));
  echo "</h2>\n";

  echo '<div id="comments">';
  if(!empty($html_comments)) echo $html_comments;
  else echo "<div class=\"info\">"._t('comment','noresult')."</div>";
  echo '</div>';
?>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->