<?php

/**
 * Dashboard module
 * 
 * The function prepare data to generate JS charts
 * 
 * @package linea21\modules\dashboard
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

/**
 * 
 * @param array $indicator // indicator info
 * @param array $obj //  parameters
 * @param array $values // array of values
 * @return array|string
 */
function prepare_chart_data($indicator, $obj, $values)
{
    
    // we check if defined colors are set for given indicator in public theme
    if(file_exists(THEME_PUBLIC_PATH.'indicators-colors.php')) include_once(THEME_PUBLIC_PATH.'indicators-colors.php');
    
    if(empty($values)) return true;
    
    foreach ($values as $rec) {
        // echo print_r($rec);
        // echo "<hr>";
        array_push($obj['dates'], $rec['date_p']);
        array_push($obj['data'], $rec['sdiv_value']);
        array_push($obj['thresholds'], $rec['sdiv_threshold']);
    }

    // if indicator is multiple, we get the given year
    if ($indicator[0]['sdii_value_type'] == 'multiple') {

        // pie chart only - year parameter mandatory !
        if (($obj['indicator-wanted-vis'] == 'pie' || $obj['indicator-wanted-vis'] == 'treemap') && is_null($obj['indicator-wanted-year'])) die('year parameter should be passed for donut / pie charts.');

        // 1 - pie chart only - year parameter mandatory !
        if ($obj['indicator-wanted-vis'] == 'pie') {

            $arr = [];
            $colors = [];

            for ($i = 0; $i < count($values); $i ++) {

                $data = unserialize($values[$i]['sdiv_multivalue']);

                if ($obj['indicator-wanted-year'] == substr(formatDate($values[$i]['date_p'], true), 0, 4)) {
                    foreach ($data as &$val) {
                        $chartvalues = array(
                            formatText($val['label'], '2HTML'),
                            $val['value']
                        );
                        if(isset($val['color'])) array_push($colors, $val['color']);
                        array_push($arr, $chartvalues);
                    }
                }
            }

            $obj['data'] = $arr;
            if(!empty($colors)) $obj['indicator-colors'] = json_encode($colors); // we set colors key if not empty
        }

        // 1 - treemap chart only - year parameter mandatory !
        elseif ($obj['indicator-wanted-vis'] == 'treemap') {

            // do not pass leading '#' character in URL
            // do not pass color as 'orange', 'blue', only hexadecimal !
            isset($_GET['color1']) ? $obj['color1'] = '#' . $_GET['color1'] : $obj['color1'] = '#E6CFF7';
            isset($_GET['color2']) ? $obj['color2'] = '#' . $_GET['color2'] : $obj['color2'] = '#BB93D8';

            $arr = [];

            for ($i = 0; $i < count($values); $i ++) {

                $data = unserialize($values[$i]['sdiv_multivalue']);

                if ($obj['indicator-wanted-year'] == substr(formatDate($values[$i]['date_p'], true), 0, 4)) {

                    // we sort array before display
                    usort($data, function ($a, $b) {
                        return $a['value'] - $b['value'];
                    });
                    $cnt = 1;

                    foreach ($data as &$val) {

                        $item = [];
                        $item["name"] = formatText($val['label'], '2HTML');
                        $item["value"] = $val['value'];
                        $item["colorValue"] = $cnt;
                        array_push($arr, $item);
                        $cnt ++;
                    }
                }
            }

            $obj['data'] = json_encode($arr, JSON_NUMERIC_CHECK);
            // print_r($obj);
        }

        // stacked column charts - we prepare default view with may values (several years)
        else {

            $arr = []; // for multiple only
            $labels = []; // for multiple only
            $colors = []; // for multiple only
            $arrMean =  []; // for multiple only


            for ($i = 0; $i < count($values); $i++) {

                $data = unserialize($values[$i]['sdiv_multivalue']);

                // print_r($data);
                array_push($arrMean, $data[0]['_mean']);

                // first loop to get all labels and colors if set
                foreach ($data as &$val) {
                    if (! in_array(formatText($val['label'], '2HTML'), $labels)) {

                        array_push($labels, formatText($val['label'], '2HTML'));

                    }
                    if (isset($val['color'])) array_push($colors, $val['color']);

                }
            }
            // print_r($labels);

            // second loop on labels
            for ($t = 0; $t < count($labels); $t ++) {
                $label_values = [];

                for ($i = 0; $i < count($values); $i ++) {

                    $flag = 0; // Important flag not found value = 0
                    $data = unserialize($values[$i]['sdiv_multivalue']);



                    // first loop to get all labels
                    foreach ($data as &$val) {
                        if (formatText($val['label'], '2HTML') == $labels[$t]) {
                            array_push($label_values, $val['value']);
                            $flag = 1;
                        }
                    }

                    if ($flag == 0)
                        array_push($label_values, null); // Important flag not found value = 0
                }

                $item = [];
                $item["name"] = $labels[$t];
                $item["data"] = array_reverse($label_values);
                array_push($arr, $item);
            }

            $obj['data'] = json_encode($arr, JSON_NUMERIC_CHECK);
            $obj['data-mean'] = $arrMean;
            if(!empty($colors)) $obj['indicator-colors'] = json_encode($colors); // we set colors key if not empty
            // print_r($obj['data']);
        }
    }
    
    
    return $obj;
}
