<?php
/**
 * Dashboard module
 * 
 * Provides basics methods called from public templates
 * These methods can be overriden. Discover logic and examples on :
 * @url http://dev.linea21.com/projects/linea21/wiki/Override
 * @url http://dev.linea21.com/projects/linea21/wiki/Personnalisation_de_l%27interface_publique
 * 
 * @package linea21\modules\dashboard
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once(override('../dashboard/' . SQL . '.inc.php'));
include_once(override('../project/' . SQL . '.inc.php'));

include_once(override('../dashboard/common.php'));
include_once(override("../dashboard/chart-prepare.php"));
include_once('../class/class.tag.php');

/**
 * DisplayListValuesByLevelsAlt()
 * affichage du tableau de bord alternatif
 * @param integer $id_filter
 * @param integer $filter
 * @return
 **/

if(!function_exists('DisplayListValuesByLevelsAlt')) {
    
    function DisplayListValuesByLevelsAlt($id_filter = -1, $filter = -1, $UI = 'public')
    {
        
        $firstlevels = $GLOBALS['sql_object'] ->DBSelect(SQL_getLevelsList(true));
        
        // quick and dirty ....
        // selecting indicators by tags will remove scale filter
        if(isset($_REQUEST['filter']) && $_REQUEST['filter'] == 'tag') {
            $sdi = $GLOBALS['sql_object'] -> DBSelect(SQL_getListSdi("TAG", $_REQUEST['id']));
        } else {
            if($UI == 'public') $sdi = $GLOBALS['sql_object'] -> DBSelect(SQL_getListSdi("P", $valueparam = 0));
            if($UI == 'admin') $sdi = $GLOBALS['sql_object'] -> DBSelect(SQL_getListSdi("R", $valueparam = 0));
        }
        
        if(!isset($sdi[0]['sdii_id'])) return false;
        $sdi = add_root_level($sdi, 'sdii_level', 'level_root'); // we add extra field with level root

        $listing = '<div class="indicator-switcher-container right"><div class="flex-container"><span class="hint--top hint--large hint--rounded txtcenter mts" aria-label="'._t('sdi', 'strategic_indicators_only_notice').'"><i class="fa fa-info-circle" aria-hidden="true"></i></span><label for="indicator-switcher" class="label autowidth"> '.formatText(_t('sdi', 'strategic_indicators_only'), '2HTML').'<span id="strategic-indic-counter"> (-)</span></label><input name="indicator-switcher" type="checkbox" checked="checked" value="1" id="indicator-switcher" class="switch" /></div></div>' . PHP_EOL;

        $a = array(); // do not display an indicator twice
        
        $current_level = '';
        
        for ($i = 0;$i < count($firstlevels);$i++) {
            if ($firstlevels[$i]['level_id'] != $current_level && $current_level <> '') {
                $listing .= "</div> <!-- we close grid -->" . PHP_EOL;
            }
            if ($firstlevels[$i]['level_id'] != $current_level) {
                
                $current_level = $firstlevels[$i]['level_id'];
                $listing .= "<h2 class=\"dashboard level-".$current_level."\" id=\"title-level-".$current_level."\">" . formatText($firstlevels[$i]['level_name'], '2HTML') . "</h2>".PHP_EOL;
                $listing .= '<div class="grid-3-small-1 has-gutter-xl mtl mbl filter-items">' . PHP_EOL;
                
            }
            for ($j = 0;$j < count($sdi);$j++) {
                if ($firstlevels[$i]['level_id'] == $sdi[$j]['level_root']) {
                    
                    // we display the value only if not yet displayed
                    if (!in_array($sdi[$j]['sdii_id'], $a)) {

                        // getting tags
                        $otag = new tag ();
                        $display_tags = $otag->getTags ( 'indicator', $sdi[$j]['sdii_id'], true, ';' );
                        $display_types = formatText(mb_ucfirst($GLOBALS['lang']['sdi']['select_type'][$sdi[$j]['sdii_type']]), '2HTML');

                        $sclass = ($sdi[$j]['sdii_to_dashboard']=='Y') ? 'strategic' : 'non-strategic';
                        // setting $threshold_value
                        // By default initial value
                        $threshold_value = $sdi[$j]['sdii_threshold_value'];
                        // if set, we get the latest for the given scale
                        $r = $GLOBALS['sql_object'] -> DBSelect(SQL_getlastInsertByPublicationDate($sdi[$j]['sdii_id'], $id_filter));
                        if(isset($r[0]['sdiv_value']) && !is_null($r[0]['sdiv_threshold'])) {
                            $threshold_value = $r[0]['sdiv_threshold'];
                        }
                        
                        if($sdi[$j]['sdii_type'] != 'not-set') $typecontent = '<span class="indic-type '.$sdi[$j]['sdii_type'].'">'.formatText(mb_ucfirst($GLOBALS['lang']['sdi']['select_type'][$sdi[$j]['sdii_type']]), '2HTML').'</span>';
                        else $typecontent ='';
                        
                        $link_det_sdi= HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['dashboard']['linkvalue'],'id'=>$sdi[$j]['sdii_id'], 'parentid'=> $id_filter, 'name' => $sdi[$j]['sdii_name']));

                        if($UI == 'admin')  $link_det_sdi = "index.php?rub=dashboard&amp;todo=det&amp;id=".$sdi[$j]['sdii_id'];
                        $listing .= "<div class=\"pam grid-indicator indicator-".$sdi[$j]['sdii_nature']." ".$sclass."\" data-types=\"".$display_types."\" data-tags=\"".$display_tags."\" data-id=\"".$sdi[$j]['sdii_id']."\">" . PHP_EOL;
                        $listing .= getViz($GLOBALS['sql_object'], $id_filter, $sdi[$j], $threshold_value);
                        $listing .= "<div class=\"indicator-name-cont\">";
                        $listing .= "<a class=\"indicator-name\" href=\"" . $link_det_sdi . "\" title=\"" . formatText($sdi[$j]['sdii_name'], '2ATT') . "\">" . formatText($sdi[$j]['sdii_name'], '2HTML') . "</a>" . PHP_EOL;
                        if($UI == 'admin')  $listing .= '<a href="index.php?rub=dashboard&amp;todo=add&amp;id='.$sdi[$j]['sdii_id'].'&amp;scale_id='.$id_filter.'" class="ico-add" title="'._t('dashboard','add').'"><i class="fa fa-plus-circle" aria-hidden="true"></i><span>'.  _t('dashboard','add').'</span></a>';

                        if ($sdi[$j]['sdii_statut']=='D') $listing.="<span class=\"publication-state\">"._t('statut','draft')."</span>\n";
                        if(!empty($display_tags) && $UI == 'admin') $listing.= "<i class=\"fa fa-tag\" style=\"opacity:0.3;margin:0\" title=\"" . formatText ( $display_tags, '2ATT' ) . "\"></i> ";
                        $listing .= "</div>";
                        if($sclass == 'strategic') $listing .= '<span class="hint--top hint--rounded" aria-label="'._t('sdi', 'attached_to_dashboard').'"><i class="fa fa-star" aria-hidden="true"></i></span>' . PHP_EOL;
                        $listing .= $typecontent . PHP_EOL;

                        $listing .= "<div class=\"indicator-level\">" . formatText($sdi[$j]['level_label'], '2HTML') . " : <span>" . formatText($sdi[$j]['level_name'], '2HTML') . "</span></div>". PHP_EOL;

                        $listing .= "</div>" . PHP_EOL;
                        
                        array_push($a, $sdi[$j]['sdii_id']); // we add the id into array for not displaying it twice
                    }
                }
            }
        }
        $listing .= "</div>" . PHP_EOL;
        
        hoverJsBox();
        
        // including sparkline code based on peity
        footerAddJS('../lib/js/peity-3.3.0/jquery.peity.min.js');
        footerAddInlineJS("$('.dashboard-indicator-sparkline .inlinebar').peity( 'bar', { fill: ['#5EA7AC']});"); // previous color '#8DA8CB'
        footerAddInlineJS('
            $("#indicator-switcher").on("change", function() {
                if(document.getElementById("indicator-switcher").checked) {
                    $("div.non-strategic").fadeOut(); // fadeOut() - hide()
                    $("div.indicator-switcher-container").css("opacity", "1");
                    // console.log("checked" );
                } else {
                    $("div.non-strategic").fadeIn(); // fadeIn() - show()
                    $("div.indicator-switcher-container").css("opacity", "0.5");
                    // console.log("pas checked" );
                }
                setTimeout(function() { // important to wait to get the right count
                  var cnt = $(".grid-indicator:visible").length;
                  // console.log("indicateurs visibles : " + cnt);
                  $("#strategic-indic-counter").text(" (" + cnt + ")");
                }, 1000);
                
            });
            $("#indicator-switcher").trigger("change");
            ');

        echo $listing;

    }
}

/**
 * DisplayListValuesByLevels()
 * affichage du tableau de bord
 * @param integer $id_filter
 * @param integer $filter
 * @return
 **/

if(!function_exists('DisplayListValuesByLevels')) {

	function DisplayListValuesByLevels($id_filter = -1, $filter = -1)
	{  
	    
		$firstlevels = $GLOBALS['sql_object'] ->DBSelect(SQL_getLevelsList(true));
		
		// quick and dirty ....
		// selecting indicators by tags will remove scale filter
		if(isset($_REQUEST['filter']) && $_REQUEST['filter'] == 'tag') {
		    $sdi = $GLOBALS['sql_object'] -> DBSelect(SQL_getListSdi("TAG", $_REQUEST['id']));
		} else {
		    $sdi = $GLOBALS['sql_object'] -> DBSelect(SQL_getListSdi("P", $valueparam = 0));
		}
		
		if(!isset($sdi[0]['sdii_id'])) return false;
		$sdi = add_root_level($sdi, 'sdii_level', 'level_root'); // we add extra field with level root
		
		$listing = "";

		$a = array(); // do not display an indicator twice

		$current_level = '';

		for ($i = 0;$i < count($firstlevels);$i++) {
			if ($firstlevels[$i]['level_id'] != $current_level && $current_level <> '') {
				$listing .= "</tbody>" . PHP_EOL;
				$listing .= "</table>" . PHP_EOL;
			}
			if ($firstlevels[$i]['level_id'] != $current_level) {

				$current_level = $firstlevels[$i]['level_id'];
				$listing .= "<h2 class=\"dashboard level-".$current_level."\">" . formatText($firstlevels[$i]['level_name'], '2HTML') . "</h2>".PHP_EOL;
				$listing .= '<table class="table_dashboard">' . PHP_EOL;
				$listing .= '<thead>' . PHP_EOL;
				$listing .= '<tr>' . PHP_EOL;
				$listing .= '<td class="graphic-values pt2">'.mb_ucfirst(_t('dashboard','graphic_value')).'</td>' . PHP_EOL;
				$listing .= '<td class="pt3">'.mb_ucfirst(_t('dashboard','label_value')).'</td>' . PHP_EOL;
				$listing .= '</tr>' . PHP_EOL;
				$listing .= '</thead>' . PHP_EOL;
				$listing .= '<tbody>' . PHP_EOL;

			}
			for ($j = 0;$j < count($sdi);$j++) {
				if ($firstlevels[$i]['level_id'] == $sdi[$j]['level_root']) {

					// we display the value only if attached to dashboard
					// and if not yet displayed
					if ($sdi[$j]['sdii_to_dashboard']=='Y' && !in_array($sdi[$j]['sdii_id'], $a)) {
						// setting $threshold_value
						// By default initial value
						$threshold_value = $sdi[$j]['sdii_threshold_value'];
						// if set, we get the latest for the given scale
						$r = $GLOBALS['sql_object'] -> DBSelect(SQL_getlastInsertByPublicationDate($sdi[$j]['sdii_id'], $id_filter));
						if(isset($r[0]['sdiv_value']) && !is_null($r[0]['sdiv_threshold'])) {
							$threshold_value = $r[0]['sdiv_threshold'];
						}
						
						if($sdi[$j]['sdii_type'] != 'not-set') $typecontent = '<span class="indic-type '.$sdi[$j]['sdii_type'].'">'.formatText(mb_ucfirst($GLOBALS['lang']['sdi']['select_type'][$sdi[$j]['sdii_type']]), '2HTML').'</span>';
						else $typecontent ='';

						$link_det_sdi= array('rub'=> $GLOBALS['links'][U_L]['dashboard']['linkvalue'],'id'=>$sdi[$j]['sdii_id'], 'parentid'=> $id_filter, 'name' => $sdi[$j]['sdii_name']);
						$listing .= "<tr>" . PHP_EOL;
						$listing .= "<td class=\"graphic-values indicator-".$sdi[$j]['sdii_nature']."\">";
						$listing .= getViz($GLOBALS['sql_object'], $id_filter, $sdi[$j], $threshold_value);
						$listing .= "</td>";
						$listing .= "<td class=\"nomargin\"><a href=\"" . HrefMaker($link_det_sdi) . "\" title=\"" . formatText($sdi[$j]['sdii_name'], '2ATT') . "\">" . formatText($sdi[$j]['sdii_name'], '2HTML') . "</a>".$typecontent."</td>" . PHP_EOL;
						$listing .= "</tr>" . PHP_EOL;

						array_push($a, $sdi[$j]['sdii_id']); // we add the id into array for not displaying it twice
					}
				}
			}
		}
		$listing .= "</tbody>" . PHP_EOL;
		$listing .= "</table>" . PHP_EOL;

		hoverJsBox();

		// including sparkline code based on peity
        footerAddJS('../lib/js/peity-3.3.0/jquery.peity.min.js');
        footerAddInlineJS("$('.dashboard-indicator-sparkline .inlinebar').peity( 'bar', { fill: ['#5EA7AC']});"); // previous color '#8DA8CB'

		echo $listing;
	}
}

/**
 * DisplayListProjectByLevelsWithIndicators()
 * Affichage de la liste des projets publics par niveaux
 *
 * @param string $statut
 * @param integer $filter
 * @param string $id_filter
 * @param integer $debut
 * @return string $content
 */

if(!function_exists('DisplayListProjectByLevelsWithIndicators')) {
    
    function DisplayListProjectByLevelsWithIndicators($statut, $filter, $id_filter)
    {

        
        $data = $GLOBALS['sql_object']->DBSelect(SQL_getLevelsList());
        
        // we retrieve main levels
        if($filter != 'LEVEL') {
            $data = getLevelChildren($data, 0); // 0 is parentid
            $sublevels = $id_filter;
            $depth = 0;
        } else {
            $current = $GLOBALS['sql_object']->DBSelect(SQL_getoneLevel($id_filter));
            
            $data = getLevelChildren($GLOBALS['sql_object']->DBSelect(SQL_getLevelsList()), $id_filter);
            $sublevels =  array_extract($data, 'level_id', true, 'children');
            
            // if there is no sub-menu, we are working on last levels
            // we emulate a level by passing choosen level but 'level_parent' is not set
            if(count($sublevels) == 0) {
                $sublevels = array($id_filter);
                $data = $current;
            }
            
            $content  = '<h2>' . $current[0]['level_name'] . '</h2>' . PHP_EOL;
            $content .= '<p class="description">' . $current[0]['level_desc_project'] . '</p>' . PHP_EOL;
            $depth = 1;
        }
        
        echo '<div class="bylevels">';
        if(isset($content)) echo $content;
        echo generate_html_recursive_with_indicators($data, $statut, $filter, $sublevels, $depth);
        echo '</div>';
        
		// including sparkline code based on peity
        footerAddJS('../lib/js/peity-3.3.0/jquery.peity.min.js');
        footerAddInlineJS("$('.dashboard-indicator-sparkline .inlinebar').peity( 'bar', { fill: ['#5EA7AC']});"); // previous color '#8DA8CB'
        
        hoverJsBox();
        
        return true;

    }
    
}


/**
 * getAssociatedIndicatorsValues()
 *
 * @param  $id
 * @return string
 */
if(!function_exists('getAssociatedIndicatorsValues')) {
    
    function getAssociatedIndicatorsValues($id, $orderedIndicators, $extraclass ='', $cursorcssposition = 0, $addvalues = false)
    {
        global $l21auth;
        global $sql_object;
        
        
        $result_sdi = $GLOBALS['sql_object']->DBSelect(SQL_getProjectSdiValues($id));
        
        $content = '';
        $id_filter= 1; // scale id value
        
        if (CURRENT_APP == 'admin' && ($l21auth->isProjectManager($l21auth->GetSessionElement('id'), $sql_object, $id) || $l21auth->hasRight('sdi'))) {
            $displayLink = true;
        } else {
            $displayLink = false;
        }
        
        if (is_array($result_sdi) && $result_sdi[0]!= 0) {
            
            $ordered_indics = array();
            // we prepare ordered data if given
            // 1 - first data stored in $orderedIndicators, then all data
            if(!is_null($orderedIndicators))  {
				$tmp = unserialize($orderedIndicators);
				if(is_array($tmp)) {
					foreach($tmp as $k => $v) {
						if(is_integer($k)) array_push($ordered_indics, $k); // to be sure it is not empty
					}
				}
            }
            // 2 - then, we iterate on all indicators thare are not already in $ordered_indics
            foreach($result_sdi as $sdi) {
                if($sdi['sdii_statut'] == 'P' && !in_array($sdi['sdii_id'], $ordered_indics)) array_push($ordered_indics, $sdi['sdii_id']); // to be sure it is not empty
            }
            
            $content .= '<div class="project-dashboard '.$extraclass.'" id="project-'.$id.'-dashboard">'.PHP_EOL;
            
            // table header
            $content .= '<table class="table_dashboard">' . PHP_EOL;
            $content .= '<thead class="visually-hidden">' . PHP_EOL;
            $content .= '<tr>' . PHP_EOL;
            $content .= '<td class="graphic-values pt2">'.mb_ucfirst(_t('dashboard','graphic_value')).'</td>' . PHP_EOL;
            //$content .= '<td>'.mb_ucfirst(_t('dashboard','numeric_value')).'</td>' . PHP_EOL;
            $content .= '<td>'.mb_ucfirst(_t('dashboard','label_value')).'</td>' . PHP_EOL;
            if($displayLink === true) $content .= '<td>'.mb_ucfirst(_t('divers','actions')).'</td>' . PHP_EOL;
            $content .= '</tr>' . PHP_EOL;
            $content .= '</thead>' . PHP_EOL;
            $content .= '<tbody>' . PHP_EOL;
            
            
            foreach($ordered_indics as $k => $v) {
                
                // we search for the key of searched element : $j
                // then we display the full record
                $j = array_search($v, array_column($result_sdi, 'sdii_id')); 
                
                // setting $threshold_value
                // By default initial value
                $threshold_value = $result_sdi[$j]['sdii_threshold_value'];
                // if set, we get the latest for the given scale
                $r = $GLOBALS['sql_object'] -> DBSelect(SQL_getlastInsertByPublicationDate($result_sdi[$j]['sdii_id'], 1));
                if(isset($r[0]['sdiv_value']) && !is_null($r[0]['sdiv_threshold'])) {
                    $threshold_value = $r[0]['sdiv_threshold'];
                }
                
                if($displayLink === true) {
                    $link_add_values = './index.php?rub=dashboard&todo=add&id='.$result_sdi[$j]['sdii_id'].'&scale_id='.$id_filter;
                    $addvalues_link  = "<div class=\"iconetab\">\n";
                    $addvalues_link .= "<a href=\"".$link_add_values."\" class=\"ico_add\" title=\"".mb_ucfirst(_t('project','add_indicator_value'))."\"><i class=\"fa fa-plus-circle\" aria-hidden=\"true\"></i><span>" . mb_ucfirst(_t('project','add_indicator_value')) . "</span></a>\n";
                    $addvalues_link .= "</div>\n";
                } else $addvalues_link = '';
                
                
                if(CURRENT_APP == 'admin') {
                    $link_det_sdi = './index.php?rub=dashboard&todo=det&id='.$result_sdi[$j]['sdii_id'].'&scale_id='.$id_filter;
                    
                } else {
                    $link_det_sdi= HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['dashboard']['linkvalue'],'id'=>$result_sdi[$j]['sdii_id'], 'parentid'=> $id_filter, 'name' => $result_sdi[$j]['sdii_name']));
                    
                }
                $content .= "<tr>" . PHP_EOL;
                $content .= "<td class=\"graphic-values indicator-".$result_sdi[$j]['sdii_nature']."\">";
                $content .= getViz($GLOBALS['sql_object'], $id_filter, $result_sdi[$j], $threshold_value, null, $cursorcssposition);
                $content .= "</td>";
                if($displayLink === true || CURRENT_APP != 'admin') $content .= "<td><a href=\"" . $link_det_sdi . "\" title=\"" . formatText($result_sdi[$j]['sdii_name'], '2ATT') . "\">" . formatText(Stringy\Stringy::create($result_sdi[$j]['sdii_name'], CHARSET)->safeTruncate(90, ' ...'), '2HTML') . "</a></td>" . PHP_EOL;
                else $content .= "<td>" . formatText(cutText($result_sdi[$j]['sdii_name'], 53), '2HTML') . "</td>" . PHP_EOL;
                if($displayLink === true) $content .= "<td>" . $addvalues_link . "</td>" . PHP_EOL;
                $content .= "</tr>" . PHP_EOL;
                
                
            }
            
            $content .= "</tbody>" . PHP_EOL;
            $content .= "</table>" . PHP_EOL;
            $content .= "</div>" . PHP_EOL;
        }
        
        return $content;
        
    }
}

/**
 * generate_html_recursive_with_indicators()
 *
 * @see : http://stackoverflow.com/questions/7577396/php-walking-and-print-multi-dimensional-array
 * @param unknown $data
 * @return string
 */
/**
 *
 * @param array $data
 * @param unknown $statut
 * @param unknown $filter
 * @param unknown $id_filter
 * @param unknown $depth
 * @param unknown $display_first
 * @return string
 */
if(!function_exists('generate_html_recursive_with_indicators')) {
    function generate_html_recursive_with_indicators($data, $statut, $filter, $id_filter, $depth, $workshop_id =-1)
    {
        // begin with an empty html string
        $html = '';
        
        // loop through all items in this level
        foreach($data as $key => &$item)
        {
            // echo "$key <br ><br>";
            // where only interested in numeric items
            // as those are the actual children
            if( !is_numeric( $key ) )
            {
                // otherwise continue
                continue;
            }
            
            
            // 'level_parent' attribute is not set when there is no children level
            if(isset($item['level_parent'])) {
                // we display link only on main levels
                $link_level = array('rub' => $GLOBALS['links'][U_L]['project']['linkvalue'], 'filter' => $GLOBALS['filters'][U_L]['level']['linkvalue'], 'id' => $item['level_id'], 'name' => $item['level_name']);
                
                if($item['level_parent'] == 0) {
                    // $html .= '<h2><a href="' . HrefMaker($link_level) . '" title="' . formatText($item['level_name'], '2ATT') . '">' . $item['level_name'] . '</a></h2>' . PHP_EOL;
                    
                    $html .='<div class="grid-6 header-level-' . $depth .'">';
                    $html .='<div class="col-6 title-level-' . $depth .' title-level-'.$depth.'-'.$item['level_id'].'" id="title-level-'.$depth.'-'.$item['level_id'].'">';
                    $html .='<h2><a href="' . HrefMaker($link_level) . '" title="' . formatText($item['level_name'], '2ATT') . '">' . $item['level_name'] . '</a></h2>' . PHP_EOL;
                    $html .='</div>';
                    $html .='</div>';
                    
                    
                } else {
                    
                    $html .='<div class="grid-6 header-level-' . $depth .'">';
                    $html .='<div class="col-6 title-level-' . $depth .' title-level-'.$depth.'-'.$item['level_id'].'" id="title-level-'.$depth.'-'.$item['level_id'].'">';
                    $html .= '<h'.($depth+2).'><a href="' . HrefMaker($link_level) . '" title="' . formatText($item['level_name'], '2ATT') . '">' . $item['level_name'] . '</a></h'.($depth+2).'>' . PHP_EOL;
                    $html .='</div>';
                    $html .='</div>';
                    
                }
                
                $html .= '<div class="level-' . $depth .' level-'.$depth.'-'.$item['level_id'].'" id="level-'.$depth.'-'.$item['level_id'].'">';
                
            }
            
            // echo "<br ><br>";
            
            // 			print_r($data[$j]);
            // 			 echo "<br />";
            // we pass the level ID to the SQL query
            // Dirty but it works .....
            // PRIORITY and SCALE filters are handle later when choosing to displaying or not the project
            // See on the '$projects' loop
            if($filter == 'TAG') {
                $projects = $GLOBALS['sql_object']->DBSelect(SQL_getProjectsList(0, 999, $statut, 'LEVEL_TAG', $item['level_id'], $id_filter, $workshop_id));
            } else {
                $projects = $GLOBALS['sql_object']->DBSelect(SQL_getProjectsList(0, 999, $statut, 'LEVEL', $item['level_id'], $workshop_id));
            }
            
            
            // 			// we sort values on level names
            // 			// Obtain a list of columns
            // 			foreach ($projects as $key => $row) {
            // 				$level[$key]  = $row['level_name'];
            // 			}
            
            // 			// Sort the data with level descending
            // 			// Add $projects as the last parameter, to sort by the common key
            // 			array_multisort($level, SORT_DESC, $projects);
            
            if ($projects != 0) {
                
                $current_link = array('rub' => $GLOBALS['links'][U_L]['project']['linkvalue']);
                $current_level = '';
                
//                 $html .= '<div class="col-6-small-3 ">'.mb_ucfirst(_t('project','name')).'</div>'.PHP_EOL;
//                 $html .= '</div>' . PHP_EOL;
                // <div class="level-0 level-0-5" id="level-0-5">
                // $html .= '<div id="level-'.$depth.'-'.$item['level_id'].'"  class="projects-set level-'.$depth.' '. 'level-'.$depth.'-'.$item['level_id'].'">' . PHP_EOL;
                
                for($i = 0; $i < count($projects); $i++) {
                    
                    $count = $GLOBALS['sql_object']->DBSelect(SQL_getProjectSdiValuesNumber($projects[$i]['project_id']));
                    
                    if($count[0]['number'] > 0) {
                    
                        $html .= '<div class="col-6-small-3 has-gutter mbs dashboard-project-container">' . PHP_EOL;
                        
                        $link_detail = array('rub' => $GLOBALS['links'][U_L]['project']['linkvalue'], 'id' => $projects[$i]['project_id'], 'name' => $projects[$i]['project_name']);
                        
                        $project_name = formatText($projects[$i]['complete_project_name'], '2HTML');
                        
                        if($projects [$i] ['project_parent_id'] != 0)  $class='sub-project'; else $class = 'project';
                        
                        $html .= '<div><a href="' . HrefMaker($link_detail) . '" title="' . formatText($project_name, '2ATT') . '" class="project-name '.$class.'">' . $project_name . '</a></div>' . PHP_EOL;
                        
                        
                        $html .= '<div>' . PHP_EOL;
                        $html .= getAssociatedIndicatorsValues($projects[$i]['project_id'], $projects[$i]['project_indic_order'], $extraclass ='', $cursorcssposition = 0, $addvalues = false);
                        $html .= '</div>';
                        $html .= '</div>' . PHP_EOL; // ferme grid-6-small-3
                    }
                    
                } // boucle projet
                
                
            } // test si projet
            
            // $html .= '</div>' . PHP_EOL;
            
            // call this funcion recursively
            // with the next level ($item)
            // it will figure out again whether that level has numeric children as well
            // returns a new complete set, if applicable, otherwise an empty string
            if(isset($item['children'])) $html .= generate_html_recursive_with_indicators($item['children'], $statut, $filter, $id_filter, $depth+1);
            
            $html .= '</div>'; // on ferme le container des niveaux
            
        }
        
        
        // return the resulting html
        return $html;
    }
}

/**
 * DisplayListValuesByProjects()
 * affichage du tableau de bord
 * kept for compatibility only 
 * @param integer $id_filter
 * @param integer $filter
 * @todo remove - not used anymore ?
 * @return
 **/

if(!function_exists('DisplayListValuesByProjects')) {

	function DisplayListValuesByProjects($id_filter = -1, $filter = -1)
	{
	    DisplayListProjectByLevelsWithIndicators('P', $filter, $id_filter);
	}
}

function hoverJsBox() {
	
	$js = '<script>
							$(document).ready(function() {
                                $(".dashboard-indicator-gauge div.gauge.infobox").removeAttr("title");
								$(".infobox").hover(
									function() {
										$(this).next().fadeIn("fast");
									},
									function() {
										$(this).next().hide();
									}
								);
								});
						</script>';
	footerAddInlineJS($js, 'default', false);
}

/**
 * DisplayOneSdi()
 * affichage d'un indicateur et infos résumé
 * @param $sdi_id
 * @param $scale_id
 * @return
 **/
if(!function_exists('sdi_display_items')) {
    function sdi_display_items($result_r, $result_e, $result_p) {
        
        $flags = [];
        
        if(!empty($result_p[0]['sdip_name']) || !empty($result_p[0]['sdip_description'])) $flags['provider'] = true;
        else $flags['provider'] = false;
        
        if(!empty($result_r[0]['sdir_title']) || !empty($result_r[0]['sdir_body'])) $flags['rules'] = true;
        else $flags['rules'] = false;
        
        if($result_e[0]['sdie_scale_compare'] != 0 || $result_e[0]['sdie_scale_compare'] != 0 || $result_e[0]['sdie_scale_compare'] != 0 || $result_e[0]['sdie_scale_compare'] != 0 || $result_e[0]['sdie_scale_compare'] != 0 || $result_e[0]['sdie_global_performance'] != 0)  $flags['assessment'] = true;
        else $flags['assessment'] = false;
        
        return $flags;        

    }
}

/**
 * DisplayOneSdi()
 * affichage d'un indicateur et infos résumé
 * @param $sdi_id
 * @param $scale_id
 * @return
 **/
if(!function_exists('DisplayOneSdi')) {

	function DisplayOneSdi($sdi_id, $scale_id)
	{
	    $result_r = $GLOBALS['sql_object'] -> DBSelect(SQL_getRules($sdi_id, $GLOBALS['sql_object'], -1));
	    $result_e = $GLOBALS['sql_object'] -> DBSelect(SQL_getEvaluation($sdi_id, $GLOBALS['sql_object'], -1));
	    $result_p = $GLOBALS['sql_object'] -> DBSelect(SQL_getProvider($sdi_id, $GLOBALS['sql_object'], -1));
	    
	    // get flags to be sure there is data to display, if not we don't do it 
	    $display_flags = sdi_display_items($result_r, $result_e, $result_p);
	    
	    if(in_array(true, $display_flags)) $contId = 'tabs';
	    else $contId = 'notab-border';
	    
		echo GetSdiTitle($sdi_id, $scale_id);
		echo '<div id="'.$contId.'">';
		if(in_array(true, $display_flags)) echo getDashboardNavigation($sdi_id, $scale_id, $display_flags);
		echo GetOneSdiInfoAndValues($sdi_id, $scale_id);
		if($display_flags['rules']) echo GetOneSdiRules($sdi_id, $result_r);
		if($display_flags['assessment']) echo GetOneSdiEvaluation($sdi_id, $result_e);
		if($display_flags['provider']) echo GetOneSdiProvider($sdi_id, $result_p);
		echo '</div>';
	}
}


/**
 * GetAllValue()
 * afficahge de l'ensemble des valeurs publiques d'un IDD
 * @param $sdi_id
 * @param $scale_id
 * @return
 **/
if(!function_exists('GetAllValue')) {

	function GetAllValue($sdi_id, $scale_id)
	{

		if(defined('CLIENT_CHARTS') && CLIENT_CHARTS == 1) {
			// footerAddJS('../lib/js/Highcharts-7.0.3/code/themes/grid-light.js');
			includeHighCharts(['exporting', 'offline-exporting']);
			footerAddJS('../lib/js/generate-chart.js');
			
		}
		
		$result_value = $GLOBALS['sql_object'] -> DBSelect(SQL_getAllValue("SCD", $scale_id, $sdi_id));
		$result_sdi_value = $GLOBALS['sql_object'] -> DBSelect(SQL_getInfoSdiforvalue($sdi_id));

		// Préparation de la génération des graphiques
		
		// we create an array to populate and send to javascript
		$obj = [];
		$obj['site-language'] = U_L;
		$obj['indicator-name'] = formatText($result_sdi_value[0]['sdii_name'], '2HTML');
		$obj['indicator-type'] = $result_sdi_value[0]['sdii_value_type'];
		$obj['indicator-multiple-type'] = $result_sdi_value[0]['sdii_multiple_type'];
		$obj['indicator-default-vis'] = $result_sdi_value[0]['sdii_detail_viz'];
		$obj['indicator-wanted-vis'] = $result_sdi_value[0]['sdii_detail_viz'];
		$obj['indicator-wanted-year'] = null;
		$obj['indicator-serie-name']  = formatText(_t('dashboard', 'value'), '2HTML');
		$obj['indicator-serie-color']  = $result_sdi_value[0]['sdii_mcolor'];
		$obj['indicator-threshold-name']  = formatText(_t('dashboard', 'threshold_value'), '2HTML');
		$obj['indicator-mean-name']  = formatText(_t('dashboard', 'multivalue_mean'), '2HTML');
		$obj['indicator-threshold-color']  = $result_sdi_value[0]['sdii_tcolor'];
		$obj['indicator-unit'] = $result_sdi_value[0]['sdii_unit'];
		$obj['indicator-negative-notice'] = formatText(_t('dashboard', 'negative_values_notice'));
		$obj['dates'] = array();
		$obj['data'] = array();
		$obj['data-mean'] = array();
		$obj['thresholds'] = array();
		
		if($obj['indicator-wanted-vis'] == 'donut') {
		    $obj['indicator-wanted-vis'] = 'pie';
		    $obj['vis-pie-size'] = '60%';
		}
		$cdata = prepare_chart_data($result_sdi_value, $obj, $result_value);

		// setting $default_threshold value
		// By default initial value
		$default_threshold = $result_sdi_value[0]['sdii_threshold_value'];
		
		$req_sdii=SQL_getInfoSdi($sdi_id);
		$result_sdii = $GLOBALS['sql_object'] -> DBSelect($req_sdii);
		// we init javascript vars for generating charts
		?>
		<script>
        	var input = <?php echo json_encode($cdata, JSON_NUMERIC_CHECK); ?>;
        	// console.log(input);
        </script>
		<?php

		$content = '<div id="indicator-value">' . PHP_EOL;
		$content .= '<h2 class="visually-hidden pal">'._t('dashboard','historic').'</h2>' . PHP_EOL;

		if ($result_value <> false) {
		    if(defined('CHART_MIN_VALUES') && is_numeric(CHART_MIN_VALUES)) $minChartValues = CHART_MIN_VALUES; else $minChartValues = 2;
		    if (count($result_value) >= $minChartValues) {
				$content .= '<h3 class="visually-hidden">'._t('dashboard','rep_graph').' </h3>' . PHP_EOL;

				if($result_sdi_value[0]['sdii_nature'] == 'quantitative') {
					if(!defined('CLIENT_CHARTS') || CLIENT_CHARTS != 1) {
						$graph_path = override(SITE_ROOT_URL . 'dashboard/graph.php');
						$content .= "<img src=\"".$graph_path."?id=" . $sdi_id . "&amp;scale_id=" . $scale_id . "&amp;display=true\"  id=\"imggraph\" class=\"graph ptl\" alt=\"".formatText(_t('dashboard','rep_graph'), '2ATT')."\"/>" . PHP_EOL;
					} else {
						$content .= '<div id="main-chart-container"></div>';
					}
				}
				
				if($result_sdi_value[0]['sdii_nature'] == 'qualitative') $content .= getQualitativeViz($result_value, $result_sdi_value[0]);
			}
			$content .= '<h3>'.mb_ucfirst(_t('dashboard','all_value')).'</h3>' . PHP_EOL;

			$content .= '<table class="indicator-values">' . PHP_EOL;
			$content .= '<thead>' . PHP_EOL;
			$content .= '<tr>' . PHP_EOL;
			$content .= "<td>".mb_ucfirst(_t('dashboard','date'))."</td>" . PHP_EOL;
			$content .= "<td>".mb_ucfirst(_t('dashboard','value'))." (".$result_sdi_value[0]['sdii_unit'].")</td>" . PHP_EOL;
			$content .= "<td>".mb_ucfirst(_t('dashboard','threshold_value'))."</td>" . PHP_EOL;
			$content .= "<td>".mb_ucfirst(_t('dashboard','rate'))."</td>" . PHP_EOL;
			$content .= "<td>".mb_ucfirst(_t('dashboard','comment'))."</td>" . PHP_EOL;
			$content .= "</tr>" . PHP_EOL;
			$content .= "</thead>" . PHP_EOL;
			$content .= "<tbody>" . PHP_EOL;
			
			for ($i = 0;$i < count($result_value);$i++) {
				$comment = '';
				$current_val = '';
				$data_pie = '';

				// indicator is multivalues
	 			if(!empty($result_value[$i]['sdiv_multivalue'])) {

	  			$data = unserialize($result_value[$i]['sdiv_multivalue']);
				
					foreach($data as &$val) {
						$current_val .= '<p class="indicator-multivalue">';
						if(!empty($val['label'])) $current_val .= '<span class="value-label" data-label="'.formatText($val['label'], '2HTML').'">'.formatText($val['label'], '2HTML'). '</span> : ';
						$current_val .= '<span class="value-value" data-value="'.$val['value'].'">'.fnumber_format($val['value'], 'auto', false). '</span>';
                        if($result_sdi_value[0]['sdii_multiple_type'] == 'sum') $current_val .= '<span class="value-percent"> ('.fnumber_format($val['_percentage'], 2, false).' %)</span>';
						$current_val .= '</p>';
					}
					// we display the total
					if(!defined('CLIENT_CHARTS') || CLIENT_CHARTS != 1) {
					    $chartlink = override(SITE_ROOT_URL . 'dashboard/pie.php').'?id='.$sdi_id.'&amp;value='.$result_value[$i]['sdiv_id'].'&amp;display=true';
					} else {
					    $chartlink = SITE_ROOT_URL .'public/get-chart.php?id='.$sdi_id.'&amp;type=donut&amp;year='.substr(formatDate($result_value[$i]['date_p'], true), 0, 4).'&alternatives=all';
					}
                    if($result_sdi_value[0]['sdii_multiple_type'] == 'sum') {
                        $current_val .= '<p class="value-total indicator-multivalue">';
                        $current_val .= mb_ucfirst(_t('dashboard', 'multivalue_total')) . ' : ' . fnumber_format($data[0]['_total'], 'auto', false);
                        $current_val .= ' <span><a class="see-detail-chart" href="' . $chartlink . '"><i class="fa fa-pie-chart" aria-hidden="true"></i> ' . _t('dashboard', 'to_detail_chart') . '</a></span>';
                        $current_val .= '</p>';
                    }
                    if($result_sdi_value[0]['sdii_multiple_type'] == 'mean') {
                        $current_val .= '<p class="value-mean indicator-multivalue">';
                        $current_val .= mb_ucfirst(_t('dashboard', 'multivalue_mean')) . ' : ' . fnumber_format($data[0]['_mean'], 2, false);
                        $current_val .= '</p>';
                    }

                    if($result_sdi_value[0]['sdii_multiple_type'] == 'sum') $cfield = '_total';
                    if($result_sdi_value[0]['sdii_multiple_type'] == 'mean') $cfield = '_mean';
                    if($result_sdi_value[0]['sdii_multiple_type'] == 'none') $cfield = '_none';

                    //$current_val_raw = $data[0][$cfield];
					
		 			if($i == 0 && $result_sdi_value[0]['sdii_multiple_type'] != 'none') {
				  		$lastValue = $data[0][$cfield]; // we store data to compute TCAM and global rate
				  		$year_end = substr(formatDate($result_value[$i]['date_p'], true), 0, 4);
				  	}
				  	if($i == count($result_value)-1 && $result_sdi_value[0]['sdii_multiple_type'] != 'none') {
				  		$firstValue = $data[0][$cfield]; // we store data to compute TCAM and global rate
				  		$year_start = substr(formatDate($result_value[$i]['date_p'], true), 0, 4);
				  	}
					// we compute rate
					if(isset($result_value[$i+1]['sdiv_multivalue']) && $result_sdi_value[0]['sdii_multiple_type'] != 'none') {
						$dataPlusOne = unserialize($result_value[$i+1]['sdiv_multivalue']);
						$evol = ($data[0][$cfield] - $dataPlusOne[0][$cfield]) / $dataPlusOne[0][$cfield] * 100;
						//_debug('rate : '. fnumber_format($evol, 2). ' %  - details : ('.$data[0]['_total']. ' - ' . $dataPlusOne[0]['_total']. ') / '. $dataPlusOne[0]['_total']);
						$evol = fnumber_format($evol, 2). ' %';
					} else {
						$evol = empty_nc('');
					}

					// indicator is NOT multivalues
				} else {
					
					// If indicator is boolean
					if($result_sdi_value[0]['sdii_nature'] == 'boolean' || $result_sdi_value[0]['sdii_nature'] == 'qualitative') {
						$a = getBooleanValues($result_sdi_value[0]);
						if($a) {
							$current_val .= $a[$result_value[$i]['sdiv_value']];
							$current_val_raw = $result_value[$i]['sdiv_value'];
							
						} else {
							$current_val .= fnumber_format($result_value[$i]['sdiv_value'], 'auto', false);
							$current_val_raw = $result_value[$i]['sdiv_value'];
						}
						 
					} else {
						$current_val .= fnumber_format($result_value[$i]['sdiv_value'], 'auto', false);
						$current_val_raw = $result_value[$i]['sdiv_value'];
						
						if($i == 0) {
				  			$lastValue = $current_val_raw; // we store data to compute TCAM and global rate
				  			$year_end = substr(formatDate($result_value[$i]['date_p'], true), 0, 4);
				  		}
				  		if($i == count($result_value)-1) {
				  			$firstValue = $current_val_raw; // we store data to compute TCAM and global rate
				  			$year_start = substr(formatDate($result_value[$i]['date_p'], true), 0, 4);
				  		}
					}
					
					$evol = empty_nc('');
					// we compute rate
					if($result_sdii[0]['sdii_nature'] == 'quantitative') {
					    if(isset($result_value[$i+1]['sdiv_value']) && is_numeric($result_value[$i+1]['sdiv_value']) && $result_value[$i+1]['sdiv_value'] != 0) {
							$evol = ($result_value[$i]['sdiv_value'] - $result_value[$i+1]['sdiv_value']) / $result_value[$i+1]['sdiv_value'] * 100;
							// _debug('rate : '. fnumber_format($evol, 2). ' %  - details : ('.$result_value[$i]['sdiv_value']. ' - ' . $result_value[$i+1]['sdiv_value']. ') / '. $result_value[$i+1]['sdiv_value']);
							$evol = fnumber_format($evol, 2). ' %';
						} else {
							$evol = empty_nc('');
						}
					}
				}

				// if set, we get it from the table
				$threshold_raw = $default_threshold;
				if(!is_null($result_value[$i]['sdiv_threshold'])) {
					if($result_sdi_value[0]['sdii_nature'] == 'quantitative') {
						$threshold = fnumber_format($result_value[$i]['sdiv_threshold'], 'auto', false);
						$threshold_raw = $result_value[$i]['sdiv_threshold'];
					} else {
						$threshold = $a[$result_value[$i]['sdiv_threshold']];
						$threshold_raw = $result_value[$i]['sdiv_threshold'];
					}
				} else {
					$threshold = empty_none('');
					$threshold_raw = '';
				}
				
				

			  if(!empty($result_value[$i]['sdiv_comment']) && $result_value[$i]['sdiv_comment_display']=='Y') {
			  	$comment  = '<div class="valuecomment">';
			  	$comment .= '<img src="'.PUBLIC_THEME_URL.'images/indic-comment.png" />';
			  	$comment .= '<div class="cont"><strong>'.ucfirst(_t('dashboard', 'comment')).' :</strong> '.$result_value[$i]['sdiv_comment'].'</div>';
			  	$comment .= '</div>';
			  }
			  $content .= "<tr>" . PHP_EOL;
			  $content .= "<td class=\"date\" data-date=\"". formatText($result_value[$i]['date_p'], '2HTML')."\">" . formatText($result_value[$i]['date_p'], '2HTML') . "</td>" . PHP_EOL;
			  $content .= "<td class=\"value\" data-value=\"". $current_val_raw."\">" . formatText($current_val, '2HTML') . "</td>" . PHP_EOL;
			  $content .= "<td class=\"threshold\" data-threshold=\"". $threshold_raw ."\">" . formatText($threshold, '2HTML') . "</td>" . PHP_EOL;
			  $content .= "<td class=\"rate\">". $evol. "</td>" . PHP_EOL;
			  $content .= "<td>". $comment. "</td>" . PHP_EOL;
			  $content .= "</tr>" . PHP_EOL;

			}

			$content .= "</tbody>" . PHP_EOL;
			$content .= "</table>" . PHP_EOL;
			
			if($result_sdii[0]['sdii_nature'] == 'quantitative') $content .= getRates($firstValue, $lastValue, $year_start, $year_end);
			
			if(!empty($default_threshold)) $content .= '<div id="indicator-threshold" class="small txtright mrs">'.mb_ucfirst(_t('sdi','initial_threshold_value')).' : <span>'.$result_sdi_value[0]['sdii_threshold_value'].' '.$result_sdi_value[0]['sdii_unit'].'</span></div>' . PHP_EOL;
				
			$content .= '</div>' . PHP_EOL;
			
			
			return $content;
		}
	}
}

/**
 * GetLastAnalysis()
 * affichage de la dernière analyse à la une
 * @param $sdi_id
 * @param $scale_id
 * @return
 **/
if(!function_exists('GetLastAnalysis')) {

    function GetLastAnalysis($sdi_id, $scale_id)
    {
        $data = $GLOBALS['sql_object'] -> DBSelect(SQL_getlastInsertByPublicationDate($sdi_id, $scale_id));
        if(!is_array($data) ||  empty($data[0]['sdiv_analysis'])) return '';

        return '<div id="indicator-analysis-'.$sdi_id.'" class="indicator-analysis">' . formatText($data[0]['sdiv_analysis'], '2HTML') . '</div>' . PHP_EOL;
    }
}

/**
 * GetSdiTitle()
 * affichage nom d'un indicateur
 * @param $sdi_id
 * @param $scale_id
 * @return
 **/
if(!function_exists('GetSdiTitle')) {

	function GetSdiTitle($sdi_id, $scale_id)
	{
	    // getting tags
	    include_once('../class/class.tag.php');
	    
	    $otag = new tag();
	    $tags = $otag->getTags('indicator', $sdi_id, false);
	    $link_tag = array('rub' => $GLOBALS['links'][U_L][ActiveItemKey($GLOBALS['activeitem'])]['linkvalue'], 'filter' => 'tag');
	    
	    
		$link_self= array('rub'=> $GLOBALS['links'][U_L]['dashboard']['linkvalue'],'id' => $sdi_id, 'parentid' => $_REQUEST['parentid']);
		$data_sdi = $GLOBALS['sql_object'] -> DBSelect(SQL_getOnesdiname($sdi_id, array('P')));

		if($data_sdi == 0) error_redirect();

		$data_scale = $GLOBALS['sql_object'] -> DBSelect(SQL_getonescale($scale_id));
		$sdi_name = formatText($data_sdi[0]['sdii_name'], '2HTML');
		$sdi_description = formatText($data_sdi[0]['sdii_description'], '2HTML');
		$scale_name = formatText(cutText($data_scale[0]['scale_denomination'], 150), '2HTML');
		$content  = '<div id="indicator-main">' . PHP_EOL;
		$content .= '<h1>' . mb_ucfirst($sdi_name) . '</h1>' . PHP_EOL;
        $content .= GetLastAnalysis($sdi_id, $scale_id) . PHP_EOL;
		$content .='<p class="published_by">'.PHP_EOL;
		$content .= formatted_permalink($link_self);
		$content .='</p>'.PHP_EOL;
		$content .= '<div id="indicator-description" class="body clear">' . $sdi_description . '</div>' . PHP_EOL;
		$content .= '<div class="filter_info mbm">';
		$content .= _t('divers', 'scale').' : <span>' . $scale_name . '</span>'  .  PHP_EOL;
		if(!empty($tags)) {
		    $content .= ' <span class="separator">/</span> ' . '<div class="tags">' . PHP_EOL;
		    $content .= mb_ucfirst(_t('tag','name')) . ' : ' . $otag->linkTags($tags, $link_tag). PHP_EOL;
		    $content .= '</div>' . PHP_EOL;
		}
		$content .= '</div>';
		
		$content .= '</div>' . PHP_EOL;

		return $content;
	}
}

/**
 * GetOneSdiInfo()
 * récupération des infos générales d'un indicateur
 * @param $sdi_id
 * @return
 **/
if(!function_exists('GetOneSdiInfoAndValues')) {

	function GetOneSdiInfoAndValues($sdi_id, $scale_id)
	{

		$content = '<div id="indicator-values" class="tab-content current internal-content">' . PHP_EOL;
		$content .= GetAllValue($sdi_id, $scale_id);
		$content .= GetOneSdiInfo($sdi_id);
		$content .= '</div>' . PHP_EOL;
		return $content;
	}
}

/**
 * GetOneSdiInfo()
 * récupération des infos générales d'un indicateur
 * @param $sdi_id
 * @return
 **/
if(!function_exists('GetOneSdiInfo')) {

	function GetOneSdiInfo($sdi_id)
	{
	    
		$data = $GLOBALS['sql_object'] -> DBSelect(SQL_getInfoSdi($sdi_id));

		$sdi_name = formatText($data[0]['sdii_name'], '2HTML');
		$sdi_description = formatText($data[0]['sdii_description'], '2HTML');
		$sdi_comment = formatText($data[0]['sdii_comment'], '2HTML');
		$sdi_goal = formatText($data[0]['sdii_goal'], '2HTML');
		$sdi_consulting = formatText($data[0]['sdii_consulting'], '2HTML');
        
		$content ='';
		if(!empty($sdi_goal) || !empty($sdi_consulting)) {
    		$content .= '<div id="indicator-info">' . PHP_EOL;
    		$content .= '<h2>'.mb_ucfirst(_t('dashboard','det_sdi2')).'</h2>' . PHP_EOL;
    		$content .= '<h3> '.mb_ucfirst(_t('sdi','goal_public')).' </h3>' . PHP_EOL;
    		$content .= '<div id="indicator-goal" class="body">' . $sdi_goal . '</div>' . PHP_EOL;
    		$content .= '<h3>'.mb_ucfirst(_t('sdi','consulting_public')).'</h3>' . PHP_EOL;
    		$content .= '<div id="indicator-advices" class="body clear">' . $sdi_consulting . '</div>' . PHP_EOL;
    		$content .= '</div>' . PHP_EOL;
		}
		return $content;
	}
}

/**
 * GetOneSdiRules()
 * récupération des réglementations d'un indicateur
 * @param $sdi_id
 * @return
 **/
if(!function_exists('GetOneSdiRules')) {

	function GetOneSdiRules($sdi_id, $result_r)
	{
		
		$r_title = formatText($result_r[0]['sdir_title'], '2HTML');
		$r_body = formatText($result_r[0]['sdir_body'], '2HTML');
		if(!empty($result_r[0]['sdir_referer_uri'])) {
			$url = "<a href=\"" . formatText($result_r[0]['sdir_referer_uri'], '2HTML') . "\" title=\"" . formatText($result_r[0]['sdir_mask_uri'], '2ATT') . "\">" . formatText($result_r[0]['sdir_mask_uri'], '2HTML') . "</a>";
		}

		$content = '<div id="indicator-rules" class="tab-content internal-content">' . PHP_EOL;
		$content .= '<h2>'.mb_ucfirst(_t('sdi','r_body')).'</h2>' . PHP_EOL;
		if ($result_r[0]['sdir_title'] == "") {
			$content .= "<p class=\"info\">"._t('divers','nodata')." </p>" . PHP_EOL;
		} else {
			$content .= "<h3>" . $r_title . "</h3>" . PHP_EOL;
			$content .= "<div class=\"body clear\">" . $r_body . "</div>" . PHP_EOL;
			if(isset($url)) {
				$content .= "<p>" . $url . "</p>" . PHP_EOL;
			}
		}
		$content .= '</div>' . PHP_EOL;

		return $content;
	}
}

/**
 * GetOneSdiEvaluation()
 * récupération des critères d'évaluation d'un indicateur
 * @param $sdi_id
 * @return
 **/
if(!function_exists('GetOneSdiEvaluation')) {

    function GetOneSdiEvaluation($sdi_id, $result_e)
	{
		$result_e = $GLOBALS['sql_object'] -> DBSelect(SQL_getEvaluation($sdi_id, $GLOBALS['sql_object'], -1));

		$content = '<div id="indicator-assessment" class="tab-content internal-content">' . PHP_EOL;
		$content .= '<h2>'.mb_ucfirst(_t('sdi','e_title')).'</h2>' . PHP_EOL;
		$content .= '<table class="table_dashboard_det">' . PHP_EOL;
		$content .= '<thead>' . PHP_EOL;
		$content .= '<tr>' . PHP_EOL;
		$content .= "<td>"._t('sdi','e_scale_compare')."</td>" . PHP_EOL;
		$content .= "<td>"._t('sdi','e_fiability')."</td>" . PHP_EOL;
		$content .= "<td>"._t('sdi','e_accessibility')."</td>" . PHP_EOL;
		$content .= "<td>"._t('sdi','e_lisibility')."</td>" . PHP_EOL;
		$content .= "<td>"._t('sdi','e_relevance')."</td>" . PHP_EOL;
		$content .= "<td>"._t('sdi','e_global_performance')."</td>" . PHP_EOL;
		$content .= "</tr>" . PHP_EOL;
		$content .= "</thead>" . PHP_EOL;
		$content .= "<tbody>" . PHP_EOL;
		$content .= "<tr>" . PHP_EOL;
		$content .= "<td>" . $result_e[0]['sdie_scale_compare'] . "</td>" . PHP_EOL;
		$content .= "<td>" . $result_e[0]['sdie_fiability'] . "</td>" . PHP_EOL;
		$content .= "<td>" . $result_e[0]['sdie_accessibility'] . "</td>" . PHP_EOL;
		$content .= "<td>" . $result_e[0]['sdie_lisibility'] . "</td>" . PHP_EOL;
		$content .= "<td>" . $result_e[0]['sdie_relevance'] . "</td>" . PHP_EOL;
		$content .= "<td>" . $result_e[0]['sdie_global_performance'] . "</td>" . PHP_EOL;
		$content .= "</tr>" . PHP_EOL;
		$content .= "</tbody>" . PHP_EOL;
		$content .= "</table>" . PHP_EOL;
		$content .= '</div>' . PHP_EOL;

		return $content;
	}
}

/**
 * GetOneSdiProvider()
 * récupération des infos du fournisseurs d'un indicateur
 * @param $sdi_id
 * @return
 **/
if(!function_exists('GetOneSdiProvider')) {

	function GetOneSdiProvider($sdi_id, $result_p)
	{

		$p_name = formatText($result_p[0]['sdip_name'], '2HTML');
		$p_description = formatText($result_p[0]['sdip_description'], '2HTML');

		$content = '<div id="indicator-provider" class="tab-content internal-content">' . PHP_EOL;
		$content .= '<h2>'.mb_ucfirst(_t('sdi','p_title')).'</h2>' . PHP_EOL;
		if ($result_p[0]['sdip_name'] == "") {
			$content .= "<p class=\"info\">"._t('divers','nodata')." </p>" . PHP_EOL;
		} else {
			$content .= '<p>' . $p_name . '</p>' . PHP_EOL;
			$content .= '<div class="body clear">' . $p_description . '</div>' . PHP_EOL;
		}
		$content .= '</div>' . PHP_EOL;
		return $content;
	}
}

/**
 * getDataVizMode()
 * return a link to switch display mode
 * @param $scale_id
 * @return string
 * @todo remove or use to display tabular data
 **/
if(!function_exists('getDataVizSwitcher')) {

	function getDataVizSwitcher($altmode, $scale_id)
	{
	    $link = array('rub'=> $GLOBALS['links'][U_L]['dashboard']['linkvalue'], 'id' => $scale_id);
		if( $altmode )  {
			$msg = _t('dashboard', 'mode_by_finality');
			$suffix = '';
		} else {
			$suffix = '?altmode=true';
			$msg = _t('dashboard', 'mode_by_project');
		}
		// adding these vars to url allow to display the right scale into filter box
		// @todo filters should be enhanced
// 		if(array_key_exists('filter', $_REQUEST) && $_REQUEST['filter'] == $GLOBALS['filters'][U_L]['scale']['linkvalue']) {
// 			$link = array_merge($link, array('filter' => $GLOBALS['filters'][U_L]['scale']['linkvalue']));
// 		}
		
		
		$str   = '<div class="primary-nav-container"><div class="switchnav">';
		$str  .= '<a class="button" href="'.HrefMaker($link). $suffix. '" title="'.$msg.'">'.$msg.'</a>'.PHP_EOL;
		$str  .= '</div></div>';

		return $str;
	}
}


/**
 * getDashboardNavigation()
 * Return a string with the internal navigation
 * @param int
 * @param int
 * @return string
 **/
if(!function_exists('getDashboardNavigation')) {

	function getDashboardNavigation($sdi_id,$scale_id, $flags)
	{

		// including easyTabs
		footerAddJS('../lib/js/jQuery-EasyTabs/vendor/jquery.hashchange.min.js');
		footerAddJS('../lib/js/jQuery-EasyTabs/lib/jquery.easytabs.min.js');
		footerAddInlineJS("$('#tabs').easytabs({animate:false});");
		
		$content  ="<ul class=\"internal-nav\" id=\"indicator-navigation\">". PHP_EOL;
		$content .="<li class=\"tab\">". PHP_EOL;
		$content .= '<a href="#indicator-values">' . _t('dashboard','mode_aff_info') . '</a>' . PHP_EOL;
		$content .="</li>". PHP_EOL;
		if($flags['rules']) {
		    $content .="<li class=\"tab\">". PHP_EOL;
    		$content .= '<a href="#indicator-rules">' . _t('dashboard','mode_aff_rules') . '</a>' . PHP_EOL;
    		$content .="</li>". PHP_EOL;
		}
		if($flags['provider']) {
    		$content .="<li class=\"tab\">". PHP_EOL;
    		$content .= '<a href="#indicator-provider">' . _t('dashboard','mode_aff_provider') . '</a>' . PHP_EOL;
    		$content .="</li>". PHP_EOL;
		}
		if($flags['assessment']) {
    		$content .="<li class=\"tab\">". PHP_EOL;
    		$content .= '<a href="#indicator-assessment">' . _t('dashboard','mode_aff_evaluation') . '</a>' . PHP_EOL;
    		$content .="</li>". PHP_EOL;
		}
		$content .="</ul>". PHP_EOL;

		return $content;
	}
}

?>
