<?php
/**
 * Export module
 * 
 * Set report options and retrieve data from database
 * 
 * @package linea21\utils\export
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * Define, compose and generate a SDI (Sustainable Development Indicators) PDF report
 */

/////////////////////////////////////////
//	TRAITEMENT DES DONNEES PHP - RAPPORT
/////////////////////////////////////////


if (!isset($_POST['sauver'])) exit;

include_once('../dashboard/'.SQL.'.inc.php');

// paramètres utilisateurs.

$report_settings = array();

$report_settings['file'] = 'D';
$report_settings['title'] = isset($_POST['title_report']) ? html_entity_decode(formatText($_POST['title_report']), ENT_QUOTES) : '';
$report_settings['author'] = isset($_POST['author']) ? html_entity_decode($_POST['author'], ENT_QUOTES) : '';
$report_settings['mail_author'] = isset($_POST['mail_author']) ? html_entity_decode($_POST['mail_author'], ENT_QUOTES) : '';
$report_settings['service_author'] = isset($_POST['service_author']) ? html_entity_decode(formatText($_POST['service_author']), ENT_QUOTES) : '';
$report_settings['adress_author'] = isset($_POST['adress_author']) ? strip_tags(html_entity_decode($_POST['adress_author']), ENT_QUOTES) : ''; // remove HTML tags
$report_settings['adress_author'] = str_replace("\r\n", " ", trim(html_entity_decode($report_settings['adress_author'], ENT_QUOTES)));


$report_settings['quick_export'] = isset($_POST['quick_export']) ? true : false;

$report_settings['graphic_values'] = isset($_POST['graphic']) ? true : false;

$report_settings['table_values'] = isset($_POST['table_value']) ? true : false;

$report_settings['levels'] = isset($_POST['levels_chapters']) ? true : false;

$report_settings['display_empty_levels'] = isset($_POST['empty_levels']) ? false : true;

$report_settings['firstlevel_description'] = isset($_POST['firstlevel_description']) ? true : false;

$report_settings['status'] = isset($_POST['notpublished']) ? 'ALL' : 'PUBLIC';

$report_settings['display_provider'] = isset($_POST['provider']) ? true : false;

$report_settings['display_reglementation'] = isset($_POST['reglementation']) ? true : false;

$report_settings['display_evaluation'] = isset($_POST['evaluation']) ? true : false;

$report_settings['summary'] = isset($_POST['summary']) ? true : false;

$report_settings['publi_infos'] = isset($_POST['publi_info']) ? true : false;

$report_settings['export_module'] = 'dashboard';

// préparation tableau dénomination des échelles.
$scale_temp = $sql_object->DBSelect(SQL_getAllScale());
//print_r($scale_temp);
$scale_denomination_array = array();
for($i=0; $i<count($scale_temp); $i++) {
  $scale_denomination_array[$scale_temp[$i]['scale_id']] = $scale_temp[$i]['scale_denomination'];
}

if ($_POST['scale'] == 'det') {
	// if no scale is selected - we send all
	if(!isset($_POST['eachscale'])) {
		$report_settings['scale'] = 'ALL';
		$sdi_array = -1;
		// initialisation de $scale_array
	    $scale_array = array();
	    for($i=0; $i<count($scale_temp); $i++) {
		  $scale_array[$i] = $scale_temp[$i]['scale_id'];
	    }
	} else {
		$report_settings['scale'] = 'EACH';
		$sdi_array = $_POST['eachscale'];
		// initialisation de $scale_array
        $scale_array = array();
	    for($i=0; $i<count($sdi_array); $i++) {
		  $scale_array[$i] = $sdi_array[$i];
	    }
	}
} else {
  $report_settings['scale'] = 'ALL';
  // initialisation de $scale_array
  $scale_array = array();
  for($i=0; $i<count($scale_temp); $i++) {
    $scale_array[$i] = $scale_temp[$i]['scale_id'];
  }
}




if ($_POST['sdi'] == 'det') {
	// if no indicator is selected - we send all
  if(!isset($_POST['eachsdi'])) {
  	$report_settings['sdi'] = 'ALL';
  	$sdi_array = -1;
  } else {
  	$report_settings['sdi'] = 'EACH';
  	$sdi_array = $_POST['eachsdi'];
  }
} else  {
  $report_settings['sdi'] = 'ALL';
  $sdi_array = -1;
}


/////////////////////////////////////////
//	TRAITEMENT DES DONNEES PHP
/////////////////////////////////////////
$sdi=$sql_object->DBSelect(GetAllIndicatorsInfo ($report_settings['status'], $report_settings['sdi'], $sdi_array));
?>