<?php
/**
 * Export module - word
 * 
 * Write word report last page
 * 
 * @package linea21\utils\export
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * Define, compose and generate a SDI (Sustainable Development Indicators) Word report
 */

///////////////////////////////////
// Récupération de données
///////////////////////////////////


$section = $phpWord->addSection();


$section->addTextBreak(3);
$section->addImage(override('../export/inc_report/logo_p.png'), array('width' => 70, 'align' => 'right'));
$section->addTextBreak(2);

$table = $section->addTable(array('cellMargin' => 25));

$lcellwidth = 0.28;

$fStyle = array('size' => FONT_SIZE_MIN);
$clStyle = array('align' => 'right');
$crStyle = array('align' => 'left');


// row 1
$row = $table->addRow();
$row->addCell(PAGE_WIDTH * $lcellwidth)->addText(mb_ucfirst(esc($lang['report']['title'])) . ' : ', 'softLabelMin', $clStyle);
$row->addCell(PAGE_WIDTH  * (1 - $lcellwidth))->addText(formatText(esc($report_settings['title'])), $fStyle, $crStyle);

// row 2
$row = $table->addRow();
$row->addCell(PAGE_WIDTH * $lcellwidth)->addText(mb_ucfirst(esc($lang['divers']['date_crea'])) . ' : ', 'softLabelMin', $clStyle);
$row->addCell(PAGE_WIDTH * (1 - $lcellwidth))->addText(date("d-m-Y H:i:s"), $fStyle, $crStyle);

// row 3
$row = $table->addRow();
$row->addCell(PAGE_WIDTH * $lcellwidth)->addText(mb_ucfirst(esc($lang['report']['author'])) . ' : ', 'softLabelMin', $clStyle);
$row->addCell(PAGE_WIDTH * (1 - $lcellwidth))->addText(formatText(esc($report_settings['author'])), $fStyle, $crStyle);

// row 4
$row = $table->addRow();
$row->addCell(PAGE_WIDTH * $lcellwidth)->addText(mb_ucfirst(esc($lang['report']['mail_author'])) . ' : ', 'softLabelMin', $clStyle);
$row->addCell(PAGE_WIDTH * (1 - $lcellwidth))->addText(formatText(esc($report_settings['mail_author'])), $fStyle, $crStyle);

// row 5
$row = $table->addRow();
$row->addCell(PAGE_WIDTH * $lcellwidth)->addText(mb_ucfirst(esc($lang['report']['service'])) . ' : ', 'softLabelMin', $clStyle);
$row->addCell(PAGE_WIDTH * (1 - $lcellwidth))->addText(formatText(esc($report_settings['service_author'])), $fStyle, $crStyle);

// row 6
$row = $table->addRow();
$row->addCell(PAGE_WIDTH * $lcellwidth)->addText(mb_ucfirst(esc($lang['report']['address'])) . ' : ', 'softLabelMin', $clStyle);
$row->addCell(PAGE_WIDTH * (1 - $lcellwidth))->addText(formatText(esc($report_settings['adress_author'])), $fStyle, $crStyle);

// row 7
if($report_settings['export_module'] == 'dashboard') {
	$row = $table->addRow();
	$row->addCell(PAGE_WIDTH * $lcellwidth)->addText(mb_ucfirst(esc($lang['report']['selected_indicators'])) . ' : ', 'softLabelMin', $clStyle);
	$cell = $row->addCell(PAGE_WIDTH * (1 - $lcellwidth));
	// displaying plain text
	for($i=0; $i<count($ordered_items); $i++) {
	    $cell->addText(esc($ordered_items[$i]['sdii_name']), $fStyle, $crStyle);
	}
	// for($i=0; $i<count($sdi); $i++) {
	// 	$cell->addListItem($sdi[$i]['sdii_name'], 0, $fStyle);
	// }
}

// row 8
if($report_settings['export_module'] == 'dashboard') {
	$row = $table->addRow();
	$row->addCell(PAGE_WIDTH * $lcellwidth)->addText(mb_ucfirst($lang['report']['selected_scale']) . ' : ', 'softLabelMin', $clStyle);
	$cell = $row->addCell(PAGE_WIDTH * (1 - $lcellwidth));
	// displaying plain text
	for($i=0; $i<count($scale_array); $i++) {
	    $cell->addText(esc($scale_denomination_array[$scale_array[$i]]), $fStyle, $crStyle);
	}
	// alternative - displaying a list
	// for($i=0; $i<count($scale_array); $i++) {
	// 	$cell->addListItem($scale_denomination_array[$scale_array[$i]], 0, $fStyle);
	// }
}

// row 7 - project
if($report_settings['export_module'] == 'project') {
	$row = $table->addRow();
	$row->addCell(PAGE_WIDTH * $lcellwidth)->addText(mb_ucfirst($lang['report']['selected_projects']) . ' : ', 'softLabelMin', $clStyle);
	$cell = $row->addCell(PAGE_WIDTH * (1 - $lcellwidth));
	// displaying plain text
	for($i=0; $i<count($ordered_items); $i++) {
	    $cell->addText(esc($ordered_items[$i]['project_name']), $fStyle, $crStyle);
	}
	// alternative - displaying a list
	// for($i=0; $i<count($scale_array); $i++) {
	// 	$cell->addListItem($scale_denomination_array[$scale_array[$i]], 0, $fStyle);
	// }
}

// row 9
$row = $table->addRow();
$row->addCell(PAGE_WIDTH * 0.33)->addText(mb_ucfirst(esc($lang['report']['generated'].'('.$lang['divers']['seconds'].') : ')), 'softLabelMin', $clStyle);
$row->addCell(PAGE_WIDTH * (1 - $lcellwidth))->addText(round($total_time, 2), $fStyle, $crStyle);


?>