<?php

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// UPDATE FROM VERSION 2.5
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// we perform a big cleaning
@SureRemoveDir('../lib/vendor/cron-expression/', true);
@SureRemoveDir('../lib/vendor/html2text/', true);
@SureRemoveDir('../lib/vendor/intervention/', true);
@SureRemoveDir('../lib/vendor/log-1.0.0/', true);
@SureRemoveDir('../lib/vendor/php-debugbar/', true);
@SureRemoveDir('../lib/vendor/phpdebugbar/', true);
@SureRemoveDir('../lib/vendor/pChart-php7/', true);
@SureRemoveDir('../lib/vendor/pChart/', true);
@SureRemoveDir('../lib/vendor/PHPExcel/', true);
@SureRemoveDir('../lib/vendor/phpspreadsheet-1.20.0/', true);
@SureRemoveDir('../lib/vendor/PHPWord/', true);
@SureRemoveDir('../lib/vendor/phpword-0.16.0/', true);
@SureRemoveDir('../lib/vendor/phpword-0.18.1/', true);
@SureRemoveDir('../lib/vendor/phpword-0.18.3/', true);
@SureRemoveDir('../lib/vendor/Stringy/', true);
@SureRemoveDir('../lib/vendor/swift/', true);
@SureRemoveDir('../lib/vendor/TCPDF/', true);
@SureRemoveDir('../lib/vendor/tcpdf/', true);
@SureRemoveDir('../lib/vendor/wideimage/', true);
@SureRemoveDir('../lib/vendor/fontello/', true);
@SureRemoveDir('../lib/js/Highcharts-7.0.3/', true);
@unlink('../lib/vendor/class.html2text.php');
@unlink('../templates/public/2019/css/newsletter.css');
@unlink('../sdi/mysql.inc.php');

// only if production environnement - not localhost
if(!is_localhost()) {
    @SureRemoveDir('../lib/js/Highcharts-11.2.0/examples/', true);
    @SureRemoveDir('../lib/js/ckeditor/samples/', true);
}



// we replace E_USER_DEPRECATED by E_DEPRECATED in .user.ini file
$f ='../.user.ini';
if(is_writable($f)) {
    $str = file_get_contents($f);
    $str=str_replace('E_USER_DEPRECATED', 'E_DEPRECATED', $str);
    file_put_contents($f, $str);
} else {
    logfile(LOG_MAINFILE, array(sprintf('[UPDATE] unable to open %s file to make changes', $f), __METHOD__, $_SERVER['HTTP_USER_AGENT'], get_referer(), $_SERVER['REQUEST_METHOD'], $_SERVER['REQUEST_URI'], $_SERVER['QUERY_STRING'], $_SERVER['HTTP_COOKIE'], i2c_realip()));
}

// we add instructions to prevent all *.ini files to be read from browser
$f ='../.htaccess';
if(file_exists($f) && is_writable($f)) {
    $data = file_get_contents($f);
    // we test if instructions already exists in current file
    if(strpos($data, '</Files>') === false) {
        $htaccess_update =  $data . '            
                            <Files *.ini>
                            	order deny,allow
                             	Deny from all
                            </Files>';
        
        file_put_contents($f, $htaccess_update);
    }
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Generics actions : Finally we update config.ini and add new constants if necessary
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~




// we parse the current config.ini file (before update)
$config_ini = parse_ini_file("../config/config.ini");


// we set public theme to 2024
// if(isset($config_ini['THEME_PUBLIC'])) $config_ini['THEME_PUBLIC'] = '2024';

$l21config->setParams($config_ini);


// we add REGISTRATION_ANTISPAM constant if needed
if(!isset($config_ini['REGISTRATION_ANTISPAM'])) $l21config->addParams(array(array('MISC_HIDDEN_SETTINGS', 'REGISTRATION_ANTISPAM', 1)));


// we add PROJECT_IMPACTS constant if needed with value = 0
if(!isset($config_ini['PROJECT_IMPACTS'])) $l21config->addParams(array(array('MISC_HIDDEN_SETTINGS', 'PROJECT_IMPACTS', 0)));

// we add API_RETRIEVE constant if needed with value = 0
if(!isset($config_ini['API_RETRIEVE'])) $l21config->addParams(array(array('MISC_HIDDEN_SETTINGS', 'API_RETRIEVE', 0)));

// we add DASHBOARD_DISPLAY constant if needed with value = 0
if(!isset($config_ini['DASHBOARD_DISPLAY'])) $l21config->addParams(array(array('MISC_HIDDEN_SETTINGS', 'DASHBOARD_DISPLAY', "default")));

// we add PROJECT_IMPACTS constant if needed with value = 0
if(!isset($config_ini['PROJECT_TIMELINE'])) $l21config->addParams(array(array('MISC_HIDDEN_SETTINGS', 'PROJECT_TIMELINE', "depth:0|years:2022-2028|year-width:180|subdivision:12|dates-always-visible:0|show-root-timeline:1|show-no-dates:1")));



// we write the new file
if($l21config->writeReleaseParams()) {
	echo "<p><strong>Writing new configuration file : /config/config.ini</strong></p>";
} else {
	echo "<p><strong>Problem writing new configuration file : /config/config.ini</strong></p>";
}

?>