/**
 * Highstock JS v11.2.0 (2023-10-30)
 *
 * Indicator series type for Highcharts Stock
 *
 * (c) 2010-2021 Sebastian Bochan
 *
 * License: www.highcharts.com/license
 */!function(o){"object"==typeof module&&module.exports?(o.default=o,module.exports=o):"function"==typeof define&&define.amd?define("highcharts/indicators/macd",["highcharts","highcharts/modules/stock"],function(t){return o(t),o.Highcharts=t,o}):o("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(o){"use strict";var t=o?o._modules:{};function e(o,t,e,s){o.hasOwnProperty(t)||(o[t]=s.apply(null,e),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:t,module:o[t]}})))}e(t,"Stock/Indicators/MACD/MACDIndicator.js",[t["Core/Globals.js"],t["Core/Series/SeriesRegistry.js"],t["Core/Utilities.js"]],function(o,t,e){var s,i=this&&this.__extends||(s=function(o,t){return(s=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(o,t){o.__proto__=t}||function(o,t){for(var e in t)Object.prototype.hasOwnProperty.call(t,e)&&(o[e]=t[e])})(o,t)},function(o,t){if("function"!=typeof t&&null!==t)throw TypeError("Class extends value "+String(t)+" is not a constructor or null");function e(){this.constructor=o}s(o,t),o.prototype=null===t?Object.create(t):(e.prototype=t.prototype,new e)}),n=o.noop,r=t.seriesTypes,a=(r.column,r.sma),p=e.extend,l=e.correctFloat,h=e.defined,c=e.merge,d=function(e){function s(){var o=null!==e&&e.apply(this,arguments)||this;return o.data=void 0,o.macdZones=void 0,o.options=void 0,o.points=void 0,o.signalZones=void 0,o}return i(s,e),s.prototype.init=function(){t.seriesTypes.sma.prototype.init.apply(this,arguments);var o=this.color;this.options&&(h(this.colorIndex)&&(this.options.signalLine&&this.options.signalLine.styles&&!this.options.signalLine.styles.lineColor&&(this.options.colorIndex=this.colorIndex+1,this.getCyclic("color",void 0,this.chart.options.colors),this.options.signalLine.styles.lineColor=this.color),this.options.macdLine&&this.options.macdLine.styles&&!this.options.macdLine.styles.lineColor&&(this.options.colorIndex=this.colorIndex+1,this.getCyclic("color",void 0,this.chart.options.colors),this.options.macdLine.styles.lineColor=this.color)),this.macdZones={zones:this.options.macdLine.zones,startIndex:0},this.signalZones={zones:this.macdZones.zones.concat(this.options.signalLine.zones),startIndex:this.macdZones.zones.length},this.resetZones=!0),this.color=o},s.prototype.toYData=function(o){return[o.y,o.signal,o.MACD]},s.prototype.translate=function(){var t=this,e=["plotSignal","plotMACD"];o.seriesTypes.column.prototype.translate.apply(t),t.points.forEach(function(o){[o.signal,o.MACD].forEach(function(s,i){null!==s&&(o[e[i]]=t.yAxis.toPixels(s,!0))})})},s.prototype.destroy=function(){this.graph=null,this.graphmacd=this.graphmacd&&this.graphmacd.destroy(),this.graphsignal=this.graphsignal&&this.graphsignal.destroy(),t.seriesTypes.sma.prototype.destroy.apply(this,arguments)},s.prototype.drawGraph=function(){for(var o,e=this,s=e.points,i=e.options,n=e.zones,r={options:{gapSize:i.gapSize}},a=[[],[]],p=s.length;p--;)h((o=s[p]).plotMACD)&&a[0].push({plotX:o.plotX,plotY:o.plotMACD,isNull:!h(o.plotMACD)}),h(o.plotSignal)&&a[1].push({plotX:o.plotX,plotY:o.plotSignal,isNull:!h(o.plotMACD)});["macd","signal"].forEach(function(o,s){e.points=a[s],e.options=c(i[o+"Line"].styles,r),e.graph=e["graph"+o],e.currentLineZone=o+"Zones",e.zones=e[e.currentLineZone].zones,t.seriesTypes.sma.prototype.drawGraph.call(e),e["graph"+o]=e.graph}),e.points=s,e.options=i,e.zones=n,e.currentLineZone=void 0},s.prototype.getZonesGraphs=function(o){var t=e.prototype.getZonesGraphs.call(this,o),s=t;return this.currentLineZone&&((s=t.splice(this[this.currentLineZone].startIndex+1)).length?s.splice(0,0,o[0]):s=[o[0]]),s},s.prototype.applyZones=function(){var o=this.zones;this.zones=this.signalZones.zones,t.seriesTypes.sma.prototype.applyZones.call(this),this.graphmacd&&this.options.macdLine.zones.length&&this.graphmacd.hide(),this.zones=o},s.prototype.getValues=function(o,e){var s,i,n,r=e.longPeriod-e.shortPeriod,a=[],p=[],c=[],d=0,u=[];if(!(o.xData.length<e.longPeriod+e.signalPeriod)){for(n=0,s=t.seriesTypes.ema.prototype.getValues(o,{period:e.shortPeriod,index:e.index}),i=t.seriesTypes.ema.prototype.getValues(o,{period:e.longPeriod,index:e.index}),s=s.values,i=i.values;n<=s.length;n++)h(i[n])&&h(i[n][1])&&h(s[n+r])&&h(s[n+r][0])&&a.push([s[n+r][0],0,null,s[n+r][1]-i[n][1]]);for(n=0;n<a.length;n++)p.push(a[n][0]),c.push([0,null,a[n][3]]);for(n=0,u=(u=t.seriesTypes.ema.prototype.getValues({xData:p,yData:c},{period:e.signalPeriod,index:2})).values;n<a.length;n++)a[n][0]>=u[0][0]&&(a[n][2]=u[d][1],c[n]=[0,u[d][1],a[n][3]],null===a[n][3]?(a[n][1]=0,c[n][0]=0):(a[n][1]=l(a[n][3]-u[d][1]),c[n][0]=l(a[n][3]-u[d][1])),d++);return{values:a,xData:p,yData:c}}},s.defaultOptions=c(a.defaultOptions,{params:{shortPeriod:12,longPeriod:26,signalPeriod:9,period:26},signalLine:{zones:[],styles:{lineWidth:1,lineColor:void 0}},macdLine:{zones:[],styles:{lineWidth:1,lineColor:void 0}},threshold:0,groupPadding:.1,pointPadding:.1,crisp:!1,states:{hover:{halo:{size:0}}},tooltip:{pointFormat:'<span style="color:{point.color}">●</span> <b> {series.name}</b><br/>Value: {point.MACD}<br/>Signal: {point.signal}<br/>Histogram: {point.y}<br/>'},dataGrouping:{approximation:"averages"},minPointLength:0}),s}(a);return p(d.prototype,{nameComponents:["longPeriod","shortPeriod","signalPeriod"],pointArrayMap:["y","signal","MACD"],parallelArrays:["x","y","signal","MACD"],pointValKey:"y",markerAttribs:n,getColumnMetrics:o.seriesTypes.column.prototype.getColumnMetrics,crispCol:o.seriesTypes.column.prototype.crispCol,drawPoints:o.seriesTypes.column.prototype.drawPoints}),t.registerSeriesType("macd",d),d}),e(t,"masters/indicators/macd.src.js",[],function(){})});//# sourceMappingURL=macd.js.map