/**
 * Highcharts JS v11.2.0 (2023-10-30)
 *
 * Boost module
 *
 * (c) 2010-2021 Highsoft AS
 * Author: Torstein Honsi
 *
 * License: www.highcharts.com/license
 */!function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/boost-canvas",["highcharts"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function i(t,e,i,o){t.hasOwnProperty(e)||(t[e]=o.apply(null,i),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:t[e]}})))}i(e,"Extensions/Boost/Boostables.js",[],function(){return["area","areaspline","arearange","column","columnrange","bar","line","scatter","heatmap","bubble","treemap"]}),i(e,"Extensions/Boost/BoostableMap.js",[e["Extensions/Boost/Boostables.js"]],function(t){var e={};return t.forEach(function(t){e[t]=!0}),e}),i(e,"Extensions/Boost/BoostChart.js",[e["Extensions/Boost/BoostableMap.js"],e["Core/Utilities.js"]],function(t,e){var i=e.addEvent,o=e.pick,r=[];function s(e){var i=e.series,r=e.boost=e.boost||{},s=e.options.boost||{},n=o(s.seriesThreshold,50);if(i.length>=n)return!0;if(1===i.length)return!1;var a=s.allowForce;if(void 0===a){a=!0;for(var l=0,h=e.xAxis;l<h.length;l++){var c=h[l];if(o(c.min,-1/0)>o(c.dataMin,-1/0)||o(c.max,1/0)<o(c.dataMax,1/0)){a=!1;break}}}if(void 0!==r.forceChartBoost){if(a)return r.forceChartBoost;r.forceChartBoost=void 0}for(var u,d=0,p=0,f=0;f<i.length;f++){var g=i[f];0!==(u=g.options).boostThreshold&&!1!==g.visible&&"heatmap"!==g.type&&(t[g.type]&&++d,function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];var i=-Number.MAX_VALUE;return t.forEach(function(t){if(null!=t&&void 0!==t.length&&t.length>0)return i=t.length,!0}),i}(g.processedXData,u.data,g.points)>=(u.boostThreshold||Number.MAX_VALUE)&&++p)}return r.forceChartBoost=a&&(d===i.length&&p===d||p>5),r.forceChartBoost}function n(t){i(t,"predraw",function(){t.boost=t.boost||{},t.boost.forceChartBoost=void 0,t.boosted=!1,t.boost.clear&&t.boost.clear(),t.boost.canvas&&t.boost.wgl&&s(t)&&t.boost.wgl.allocateBuffer(t),t.boost.markerGroup&&t.xAxis&&t.xAxis.length>0&&t.yAxis&&t.yAxis.length>0&&t.boost.markerGroup.translate(t.xAxis[0].pos,t.yAxis[0].pos)}),i(t,"render",function(){t.boost&&t.boost.wgl&&s(t)&&t.boost.wgl.render(t)});var e=-1,o=-1;i(t.pointer,"afterGetHoverData",function(){var i=t.hoverSeries;if(t.boost=t.boost||{},t.boost.markerGroup&&i){var r=t.inverted?i.yAxis:i.xAxis,s=t.inverted?i.xAxis:i.yAxis;(r&&r.pos!==e||s&&s.pos!==o)&&(t.boost.markerGroup.translate(r.pos,s.pos),e=r.pos,o=s.pos)}})}return{compose:function(t,i){return i&&e.pushUnique(r,t)&&t.prototype.callbacks.push(n),t},getBoostClipRect:function(t,e){var i={x:t.plotLeft,y:t.plotTop,width:t.plotWidth,height:t.navigator?t.navigator.top+t.navigator.height-t.plotTop:t.plotHeight};if(e.getClipBox){var o=e.xAxis,r=e.yAxis;if(i=e.getClipBox(),t.inverted){var s=i.width;i.width=i.height,i.height=s,i.x=r.pos,i.y=o.pos}else i.x=o.pos,i.y=r.pos}if(e===t){var n=t.inverted?t.xAxis:t.yAxis;n.length<=1&&(i.y=Math.min(n[0].pos,i.y),i.height=n[0].pos-t.plotTop+n[0].len)}return i},isChartSeriesBoosting:s}}),i(e,"Extensions/Boost/WGLDrawMode.js",[],function(){return{area:"LINES",arearange:"LINES",areaspline:"LINES",column:"LINES",columnrange:"LINES",bar:"LINES",line:"LINE_STRIP",scatter:"POINTS",heatmap:"TRIANGLES",treemap:"TRIANGLES",bubble:"POINTS"}}),i(e,"Extensions/Boost/WGLShader.js",[e["Core/Utilities.js"]],function(t){var e=t.clamp,i=t.error,o=t.pick;return function(){function t(t){if(this.errors=[],this.uLocations={},this.gl=t,t&&!this.createShader())return}return t.prototype.bind=function(){this.gl&&this.shaderProgram&&this.gl.useProgram(this.shaderProgram)},t.prototype.createShader=function(){var t=this,e=this.stringToProgram("#version 100\n#define LN10 2.302585092994046\nprecision highp float;\nattribute vec4 aVertexPosition;\nattribute vec4 aColor;\nvarying highp vec2 position;\nvarying highp vec4 vColor;\nuniform mat4 uPMatrix;\nuniform float pSize;\nuniform float translatedThreshold;\nuniform bool hasThreshold;\nuniform bool skipTranslation;\nuniform float xAxisTrans;\nuniform float xAxisMin;\nuniform float xAxisMinPad;\nuniform float xAxisPointRange;\nuniform float xAxisLen;\nuniform bool  xAxisPostTranslate;\nuniform float xAxisOrdinalSlope;\nuniform float xAxisOrdinalOffset;\nuniform float xAxisPos;\nuniform bool  xAxisCVSCoord;\nuniform bool  xAxisIsLog;\nuniform bool  xAxisReversed;\nuniform float yAxisTrans;\nuniform float yAxisMin;\nuniform float yAxisMinPad;\nuniform float yAxisPointRange;\nuniform float yAxisLen;\nuniform bool  yAxisPostTranslate;\nuniform float yAxisOrdinalSlope;\nuniform float yAxisOrdinalOffset;\nuniform float yAxisPos;\nuniform bool  yAxisCVSCoord;\nuniform bool  yAxisIsLog;\nuniform bool  yAxisReversed;\nuniform bool  isBubble;\nuniform bool  bubbleSizeByArea;\nuniform float bubbleZMin;\nuniform float bubbleZMax;\nuniform float bubbleZThreshold;\nuniform float bubbleMinSize;\nuniform float bubbleMaxSize;\nuniform bool  bubbleSizeAbs;\nuniform bool  isInverted;\nfloat bubbleRadius(){\nfloat value = aVertexPosition.w;\nfloat zMax = bubbleZMax;\nfloat zMin = bubbleZMin;\nfloat radius = 0.0;\nfloat pos = 0.0;\nfloat zRange = zMax - zMin;\nif (bubbleSizeAbs){\nvalue = value - bubbleZThreshold;\nzMax = max(zMax - bubbleZThreshold, zMin - bubbleZThreshold);\nzMin = 0.0;\n}\nif (value < zMin){\nradius = bubbleZMin / 2.0 - 1.0;\n} else {\npos = zRange > 0.0 ? (value - zMin) / zRange : 0.5;\nif (bubbleSizeByArea && pos > 0.0){\npos = sqrt(pos);\n}\nradius = ceil(bubbleMinSize + pos * (bubbleMaxSize - bubbleMinSize)) / 2.0;\n}\nreturn radius * 2.0;\n}\nfloat translate(float val,\nfloat pointPlacement,\nfloat localA,\nfloat localMin,\nfloat minPixelPadding,\nfloat pointRange,\nfloat len,\nbool  cvsCoord,\nbool  isLog,\nbool  reversed\n){\nfloat sign = 1.0;\nfloat cvsOffset = 0.0;\nif (cvsCoord) {\nsign *= -1.0;\ncvsOffset = len;\n}\nif (isLog) {\nval = log(val) / LN10;\n}\nif (reversed) {\nsign *= -1.0;\ncvsOffset -= sign * len;\n}\nreturn sign * (val - localMin) * localA + cvsOffset + \n(sign * minPixelPadding);\n}\nfloat xToPixels(float value) {\nif (skipTranslation){\nreturn value;// + xAxisPos;\n}\nreturn translate(value, 0.0, xAxisTrans, xAxisMin, xAxisMinPad, xAxisPointRange, xAxisLen, xAxisCVSCoord, xAxisIsLog, xAxisReversed);// + xAxisPos;\n}\nfloat yToPixels(float value, float checkTreshold) {\nfloat v;\nif (skipTranslation){\nv = value;// + yAxisPos;\n} else {\nv = translate(value, 0.0, yAxisTrans, yAxisMin, yAxisMinPad, yAxisPointRange, yAxisLen, yAxisCVSCoord, yAxisIsLog, yAxisReversed);// + yAxisPos;\nif (v > yAxisLen) {\nv = yAxisLen;\n}\n}\nif (checkTreshold > 0.0 && hasThreshold) {\nv = min(v, translatedThreshold);\n}\nreturn v;\n}\nvoid main(void) {\nif (isBubble){\ngl_PointSize = bubbleRadius();\n} else {\ngl_PointSize = pSize;\n}\nvColor = aColor;\nif (skipTranslation && isInverted) {\ngl_Position = uPMatrix * vec4(aVertexPosition.y + yAxisPos, aVertexPosition.x + xAxisPos, 0.0, 1.0);\n} else if (isInverted) {\ngl_Position = uPMatrix * vec4(yToPixels(aVertexPosition.y, aVertexPosition.z) + yAxisPos, xToPixels(aVertexPosition.x) + xAxisPos, 0.0, 1.0);\n} else {\ngl_Position = uPMatrix * vec4(xToPixels(aVertexPosition.x) + xAxisPos, yToPixels(aVertexPosition.y, aVertexPosition.z) + yAxisPos, 0.0, 1.0);\n}\n}","vertex"),i=this.stringToProgram("precision highp float;\nuniform vec4 fillColor;\nvarying highp vec2 position;\nvarying highp vec4 vColor;\nuniform sampler2D uSampler;\nuniform bool isCircle;\nuniform bool hasColor;\nvoid main(void) {\nvec4 col = fillColor;\nvec4 tcol = texture2D(uSampler, gl_PointCoord.st);\nif (hasColor) {\ncol = vColor;\n}\nif (isCircle) {\ncol *= tcol;\nif (tcol.r < 0.0) {\ndiscard;\n} else {\ngl_FragColor = col;\n}\n} else {\ngl_FragColor = col;\n}\n}","fragment"),o=function(e){return t.gl.getUniformLocation(t.shaderProgram,e)};return e&&i?(this.shaderProgram=this.gl.createProgram(),this.gl.attachShader(this.shaderProgram,e),this.gl.attachShader(this.shaderProgram,i),this.gl.linkProgram(this.shaderProgram),this.gl.getProgramParameter(this.shaderProgram,this.gl.LINK_STATUS))?(this.gl.useProgram(this.shaderProgram),this.gl.bindAttribLocation(this.shaderProgram,0,"aVertexPosition"),this.pUniform=o("uPMatrix"),this.psUniform=o("pSize"),this.fcUniform=o("fillColor"),this.isBubbleUniform=o("isBubble"),this.bubbleSizeAbsUniform=o("bubbleSizeAbs"),this.bubbleSizeAreaUniform=o("bubbleSizeByArea"),this.uSamplerUniform=o("uSampler"),this.skipTranslationUniform=o("skipTranslation"),this.isCircleUniform=o("isCircle"),this.isInverted=o("isInverted"),!0):(this.errors.push(this.gl.getProgramInfoLog(this.shaderProgram)),this.handleErrors(),this.shaderProgram=!1,!1):(this.shaderProgram=!1,this.handleErrors(),!1)},t.prototype.handleErrors=function(){this.errors.length&&i("[highcharts boost] shader error - "+this.errors.join("\n"))},t.prototype.stringToProgram=function(t,e){var i=this.gl.createShader("vertex"===e?this.gl.VERTEX_SHADER:this.gl.FRAGMENT_SHADER);return(this.gl.shaderSource(i,t),this.gl.compileShader(i),this.gl.getShaderParameter(i,this.gl.COMPILE_STATUS))?i:(this.errors.push("when compiling "+e+" shader:\n"+this.gl.getShaderInfoLog(i)),!1)},t.prototype.destroy=function(){this.gl&&this.shaderProgram&&(this.gl.deleteProgram(this.shaderProgram),this.shaderProgram=!1)},t.prototype.fillColorUniform=function(){return this.fcUniform},t.prototype.getProgram=function(){return this.shaderProgram},t.prototype.pointSizeUniform=function(){return this.psUniform},t.prototype.perspectiveUniform=function(){return this.pUniform},t.prototype.reset=function(){this.gl&&this.shaderProgram&&(this.gl.uniform1i(this.isBubbleUniform,0),this.gl.uniform1i(this.isCircleUniform,0))},t.prototype.setBubbleUniforms=function(t,i,r,s){void 0===s&&(s=1);var n=t.options,a=Number.MAX_VALUE,l=-Number.MAX_VALUE;if(this.gl&&this.shaderProgram&&t.is("bubble")){var h=t.getPxExtremes();a=o(n.zMin,e(i,!1===n.displayNegative?n.zThreshold:-Number.MAX_VALUE,a)),l=o(n.zMax,Math.max(l,r)),this.gl.uniform1i(this.isBubbleUniform,1),this.gl.uniform1i(this.isCircleUniform,1),this.gl.uniform1i(this.bubbleSizeAreaUniform,"width"!==t.options.sizeBy),this.gl.uniform1i(this.bubbleSizeAbsUniform,t.options.sizeByAbsoluteValue),this.setUniform("bubbleMinSize",h.minPxSize*s),this.setUniform("bubbleMaxSize",h.maxPxSize*s),this.setUniform("bubbleZMin",a),this.setUniform("bubbleZMax",l),this.setUniform("bubbleZThreshold",t.options.zThreshold)}},t.prototype.setColor=function(t){this.gl&&this.shaderProgram&&this.gl.uniform4f(this.fcUniform,t[0]/255,t[1]/255,t[2]/255,t[3])},t.prototype.setDrawAsCircle=function(t){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.isCircleUniform,t?1:0)},t.prototype.setInverted=function(t){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.isInverted,t)},t.prototype.setPMatrix=function(t){this.gl&&this.shaderProgram&&this.gl.uniformMatrix4fv(this.pUniform,!1,t)},t.prototype.setPointSize=function(t){this.gl&&this.shaderProgram&&this.gl.uniform1f(this.psUniform,t)},t.prototype.setSkipTranslation=function(t){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.skipTranslationUniform,!0===t?1:0)},t.prototype.setTexture=function(t){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.uSamplerUniform,t)},t.prototype.setUniform=function(t,e){if(this.gl&&this.shaderProgram){var i=this.uLocations[t]=this.uLocations[t]||this.gl.getUniformLocation(this.shaderProgram,t);this.gl.uniform1f(i,e)}},t}()}),i(e,"Extensions/Boost/WGLVertexBuffer.js",[],function(){return function(){function t(t,e,i){this.buffer=!1,this.iterator=0,this.preAllocated=!1,this.vertAttribute=!1,this.components=i||2,this.dataComponents=i,this.gl=t,this.shader=e}return t.prototype.allocate=function(t){this.iterator=-1,this.preAllocated=new Float32Array(4*t)},t.prototype.bind=function(){if(!this.buffer)return!1;this.gl.vertexAttribPointer(this.vertAttribute,this.components,this.gl.FLOAT,!1,0,0)},t.prototype.build=function(t,e,i){var o;return(this.data=t||[],this.data&&0!==this.data.length||this.preAllocated)?(this.components=i||this.components,this.buffer&&this.gl.deleteBuffer(this.buffer),this.preAllocated||(o=new Float32Array(this.data)),this.buffer=this.gl.createBuffer(),this.gl.bindBuffer(this.gl.ARRAY_BUFFER,this.buffer),this.gl.bufferData(this.gl.ARRAY_BUFFER,this.preAllocated||o,this.gl.STATIC_DRAW),this.vertAttribute=this.gl.getAttribLocation(this.shader.getProgram(),e),this.gl.enableVertexAttribArray(this.vertAttribute),o=!1,!0):(this.destroy(),!1)},t.prototype.destroy=function(){this.buffer&&(this.gl.deleteBuffer(this.buffer),this.buffer=!1,this.vertAttribute=!1),this.iterator=0,this.components=this.dataComponents||2,this.data=[]},t.prototype.push=function(t,e,i,o){this.preAllocated&&(this.preAllocated[++this.iterator]=t,this.preAllocated[++this.iterator]=e,this.preAllocated[++this.iterator]=i,this.preAllocated[++this.iterator]=o)},t.prototype.render=function(t,e,i){var o=this.preAllocated?this.preAllocated.length:this.data.length;return!!this.buffer&&!!o&&((!t||t>o||t<0)&&(t=0),(!e||e>o)&&(e=o),!(t>=e)&&(i=i||"POINTS",this.gl.drawArrays(this.gl[i],t/this.components,(e-t)/this.components),!0))},t}()}),i(e,"Extensions/Boost/WGLRenderer.js",[e["Core/Color/Color.js"],e["Core/Globals.js"],e["Core/Utilities.js"],e["Extensions/Boost/WGLDrawMode.js"],e["Extensions/Boost/WGLShader.js"],e["Extensions/Boost/WGLVertexBuffer.js"]],function(t,e,i,o,r,s){var n=t.parse,a=e.doc,l=e.win,h=i.isNumber,c=i.isObject,u=i.merge,d=i.objectEach,p=i.pick,f={column:!0,columnrange:!0,bar:!0,area:!0,areaspline:!0,arearange:!0},g={scatter:!0,bubble:!0},m=["webgl","experimental-webgl","moz-webgl","webkit-3d"];return function(){function i(t){this.data=[],this.height=0,this.isInited=!1,this.markerData=[],this.series=[],this.textureHandles={},this.width=0,this.postRenderCallback=t,this.settings={pointSize:1,lineWidth:1,fillColor:"#AA00AA",useAlpha:!0,usePreallocated:!1,useGPUTranslations:!1,debug:{timeRendering:!1,timeSeriesProcessing:!1,timeSetup:!1,timeBufferCopy:!1,timeKDTree:!1,showSkipSummary:!1}}}return i.orthoMatrix=function(t,e){return[2/t,0,0,0,0,-(2/e),0,0,0,0,-2,0,-1,1,-1,1]},i.seriesPointCount=function(t){var e,i,o;return t.boosted?(e=!!t.options.stacking,i=t.xData||t.options.xData||t.processedXData,o=(e?t.data:i||t.options.data).length,"treemap"===t.type?o*=12:"heatmap"===t.type?o*=6:f[t.type]&&(o*=2),o):0},i.prototype.getPixelRatio=function(){return this.settings.pixelRatio||l.devicePixelRatio||1},i.prototype.setOptions=function(t){"pixelRatio"in t||(t.pixelRatio=1),u(!0,this.settings,t)},i.prototype.allocateBuffer=function(t){var e=this.vbuffer,o=0;this.settings.usePreallocated&&(t.series.forEach(function(t){t.boosted&&(o+=i.seriesPointCount(t))}),e&&e.allocate(o))},i.prototype.allocateBufferForSingleSeries=function(t){var e=this.vbuffer,o=0;this.settings.usePreallocated&&(t.boosted&&(o=i.seriesPointCount(t)),e&&e.allocate(o))},i.prototype.clear=function(){var t=this.gl;t&&t.clear(t.COLOR_BUFFER_BIT|t.DEPTH_BUFFER_BIT)},i.prototype.pushSeriesData=function(t,e){var i,o,r,s,a,l,h,u,d=this,p=this.data,g=this.settings,m=this.vbuffer,b=t.pointArrayMap&&"low,high"===t.pointArrayMap.join(","),x=t.chart,v=t.options,A=t.sorted,y=t.xAxis,P=t.yAxis,T=!!v.stacking,E=v.data,S=t.xAxis.getExtremes(),C=S.min,M=S.max,U=t.yAxis.getExtremes(),R=U.min,k=U.max,w=t.xData||v.xData||t.processedXData,B=t.yData||v.yData||t.processedYData,D=t.zData||v.zData||t.processedZData,L=!w||0===w.length,z=v.connectNulls,N=t.points||!1,_=T?t.data:w||E,I={x:Number.MAX_VALUE,y:0},G={x:-Number.MAX_VALUE,y:0},O=void 0===x.index,X=f[t.type],V=v.zoneAxis||"y",j=v.zones||!1,F=v.threshold,H=this.getPixelRatio(),W=t.chart.plotWidth,Y=!1,q=!1,Z=0,K=!1,Q=-1,J=!1,$=!1,tt=!1,te=!1,ti=!1,to=!1,tr=!0,ts=!0,tn=!1,ta=!1,tl=0;if(!v.boostData||!(v.boostData.length>0)){v.gapSize&&(ta="value"!==v.gapUnit?v.gapSize*t.closestPointRange:v.gapSize),j&&(u=[],j.forEach(function(t,e){if(t.color){var i=n(t.color).rgba;i[0]/=255,i[1]/=255,i[2]/=255,u[e]=i,tn||void 0!==t.value||(tn=i)}}),tn||(tn=n(t.pointAttribs&&t.pointAttribs().fill||t.color).rgba,tn[0]/=255,tn[1]/=255,tn[2]/=255)),x.inverted&&(W=t.chart.plotHeight),t.closestPointRangePx=Number.MAX_VALUE;var th=function(t){t&&(e.colorData.push(t[0]),e.colorData.push(t[1]),e.colorData.push(t[2]),e.colorData.push(t[3]))},tc=function(t,i,o,r,s){void 0===r&&(r=1),th(s),1!==H&&(!g.useGPUTranslations||e.skipTranslation)&&(t*=H,i*=H,r*=H),g.usePreallocated&&m?(m.push(t,i,o?1:0,r),tl+=4):(p.push(t),p.push(i),p.push(o?H:0),p.push(r))},tu=function(){e.segments.length&&(e.segments[e.segments.length-1].to=p.length||tl)},td=function(){e.segments.length&&e.segments[e.segments.length-1].from===(p.length||tl)||(tu(),e.segments.push({from:p.length||tl}))},tp=function(t,e,i,o,r){th(r),tc(t+i,e),th(r),tc(t,e),th(r),tc(t,e+o),th(r),tc(t,e+o),th(r),tc(t+i,e+o),th(r),tc(t+i,e)};if(td(),N&&N.length>0){e.skipTranslation=!0,e.drawMode="TRIANGLES",N[0].node&&N[0].node.levelDynamic&&N.sort(function(t,e){if(t.node){if(t.node.levelDynamic>e.node.levelDynamic)return 1;if(t.node.levelDynamic<e.node.levelDynamic)return -1}return 0}),N.forEach(function(e){var i,r,s=e.plotY;if(void 0!==s&&!isNaN(s)&&null!==e.y&&e.shapeArgs){var a=e.shapeArgs,l=a.x,h=void 0===l?0:l,c=a.y,u=void 0===c?0:c,d=a.width,p=void 0===d?0:d,f=a.height,g=void 0===f?0:f;i=(r=x.styledMode?e.series.colorAttribs(e):r=e.series.pointAttribs(e))["stroke-width"]||0,ti=n(r.fill).rgba,ti[0]/=255,ti[1]/=255,ti[2]/=255,t.is("treemap")&&(i=i||1,o=n(r.stroke).rgba,o[0]/=255,o[1]/=255,o[2]/=255,tp(h,u,p,g,o),i/=2),t.is("heatmap")&&x.inverted&&(h=y.len-h,u=P.len-u,p=-p,g=-g),tp(h+i,u+i,p-2*i,g-2*i,ti)}}),tu();return}for(;Q<_.length-1&&"break"!==function(){if(void 0===(a=_[++Q]))return"continue";if(O)return"break";var o,d=E&&E[Q];return(!L&&c(d,!0)&&d.color&&(ti=n(d.color).rgba,ti[0]/=255,ti[1]/=255,ti[2]/=255),L?(r=a[0],s=a[1],_[Q+1]&&($=_[Q+1][0]),_[Q-1]&&(J=_[Q-1][0]),a.length>=3&&(l=a[2],a[2]>e.zMax&&(e.zMax=a[2]),a[2]<e.zMin&&(e.zMin=a[2]))):(r=a,s=B[Q],_[Q+1]&&($=_[Q+1]),_[Q-1]&&(J=_[Q-1]),D&&D.length&&(l=D[Q],D[Q]>e.zMax&&(e.zMax=D[Q]),D[Q]<e.zMin&&(e.zMin=D[Q]))),z||null!==r&&null!==s)?($&&$>=C&&$<=M&&(tt=!0),J&&J>=C&&J<=M&&(te=!0),b?(L&&(s=a.slice(1,3)),h=s[0],s=s[1]):T&&(r=a.x,h=(s=a.stackY)-a.y),null!=R&&null!=k&&(tr=s>=R&&s<=k),r>M&&G.x<M&&(G.x=r,G.y=s),r<C&&I.x>C&&(I.x=r,I.y=s),null===s&&z)?"continue":null!==s&&(tr||tt||te)?(A&&($>=C||r>=C)&&(J<=M||r<=M)&&(to=!0),to||tt||te)?(ta&&r-J>ta&&td(),j&&(j.some(function(t,e){var i=j[e-1];return"x"===V?void 0!==t.value&&r<=t.value&&(u[e]&&(!i||r>=i.value)&&(o=u[e]),!0):void 0!==t.value&&s<=t.value&&(u[e]&&(!i||s>=i.value)&&(o=u[e]),!0)}),ti=o||tn||ti),!g.useGPUTranslations&&(e.skipTranslation=!0,r=y.toPixels(r,!0),s=P.toPixels(s,!0),r>W&&"POINTS"===e.drawMode))?"continue":(e.hasMarkers&&to&&!1!==Y&&(t.closestPointRangePx=Math.min(t.closestPointRangePx,Math.abs(r-Y))),!g.useGPUTranslations&&!g.usePreallocated&&Y&&1>Math.abs(r-Y)&&q&&1>Math.abs(s-q))?(g.debug.showSkipSummary&&++Z,"continue"):void(X&&(i=h,(!1===h||void 0===h)&&(i=s<0?s:0),b||T||(i=Math.max(null===F?R:F,R)),g.useGPUTranslations||(i=P.toPixels(i,!0)),tc(r,i,0,0,ti)),v.step&&!ts&&tc(r,q,0,2,ti),tc(r,s,0,"bubble"===t.type?l||1:2,ti),Y=r,q=s,K=!0,ts=!1):"continue":(td(),"continue"):(td(),"continue")}(););g.debug.showSkipSummary&&console.log("skipped points:",Z);var tf=function(t,i){if(g.useGPUTranslations||(e.skipTranslation=!0,t.x=y.toPixels(t.x,!0),t.y=P.toPixels(t.y,!0)),i){d.data=[t.x,t.y,0,2].concat(d.data);return}tc(t.x,t.y,0,2)};!K&&!1!==z&&"line_strip"===t.drawMode&&(I.x<Number.MAX_VALUE&&tf(I,!0),G.x>-Number.MAX_VALUE&&tf(G)),tu()}},i.prototype.pushSeries=function(t){var e=this.markerData,i=this.series,r=this.settings;i.length>0&&i[i.length-1].hasMarkers&&(i[i.length-1].markerTo=e.length),r.debug.timeSeriesProcessing&&console.time("building "+t.type+" series");var s={segments:[],markerFrom:e.length,colorData:[],series:t,zMin:Number.MAX_VALUE,zMax:-Number.MAX_VALUE,hasMarkers:!!t.options.marker&&!1!==t.options.marker.enabled,showMarkers:!0,drawMode:o[t.type]||"LINE_STRIP"};t.index>=i.length?i.push(s):i[t.index]=s,this.pushSeriesData(t,s),r.debug.timeSeriesProcessing&&console.timeEnd("building "+t.type+" series")},i.prototype.flush=function(){var t=this.vbuffer;this.data=[],this.markerData=[],this.series=[],t&&t.destroy()},i.prototype.setXAxis=function(t){var e=this.shader;if(e){var i=this.getPixelRatio();e.setUniform("xAxisTrans",t.transA*i),e.setUniform("xAxisMin",t.min),e.setUniform("xAxisMinPad",t.minPixelPadding*i),e.setUniform("xAxisPointRange",t.pointRange),e.setUniform("xAxisLen",t.len*i),e.setUniform("xAxisPos",t.pos*i),e.setUniform("xAxisCVSCoord",!t.horiz),e.setUniform("xAxisIsLog",!!t.logarithmic),e.setUniform("xAxisReversed",!!t.reversed)}},i.prototype.setYAxis=function(t){var e=this.shader;if(e){var i=this.getPixelRatio();e.setUniform("yAxisTrans",t.transA*i),e.setUniform("yAxisMin",t.min),e.setUniform("yAxisMinPad",t.minPixelPadding*i),e.setUniform("yAxisPointRange",t.pointRange),e.setUniform("yAxisLen",t.len*i),e.setUniform("yAxisPos",t.pos*i),e.setUniform("yAxisCVSCoord",!t.horiz),e.setUniform("yAxisIsLog",!!t.logarithmic),e.setUniform("yAxisReversed",!!t.reversed)}},i.prototype.setThreshold=function(t,e){var i=this.shader;i&&(i.setUniform("hasThreshold",t),i.setUniform("translatedThreshold",e))},i.prototype.renderChart=function(o){var r=this,a=this.gl,l=this.settings,c=this.shader,u=this.vbuffer,d=this.getPixelRatio();if(!o)return!1;this.width=o.chartWidth*d,this.height=o.chartHeight*d;var f=this.height,m=this.width;if(!a||!c||!m||!f)return!1;l.debug.timeRendering&&console.time("gl rendering"),a.canvas.width=m,a.canvas.height=f,c.bind(),a.viewport(0,0,m,f),c.setPMatrix(i.orthoMatrix(m,f)),l.lineWidth>1&&!e.isMS&&a.lineWidth(l.lineWidth),u&&(u.build(this.data,"aVertexPosition",4),u.bind()),c.setInverted(o.inverted),this.series.forEach(function(e,i){var f,m,b,x=e.series.options,v=x.marker,A=void 0!==x.lineWidth?x.lineWidth:1,y=x.threshold,P=h(y),T=e.series.yAxis.getThreshold(y),E=p(x.marker?x.marker.enabled:null,!!e.series.xAxis.isRadial||null,e.series.closestPointRangePx>2*((x.marker?x.marker.radius:10)||10)),S=r.textureHandles[v&&v.symbol||e.series.symbol]||r.textureHandles.circle,C=[];if(0!==e.segments.length&&e.segments[0].from!==e.segments[0].to&&(S.isReady&&(a.bindTexture(a.TEXTURE_2D,S.handle),c.setTexture(S.handle)),o.styledMode?b=e.series.markerGroup&&e.series.markerGroup.getStyle("fill"):(b="POINTS"===e.drawMode&&e.series.pointAttribs&&e.series.pointAttribs().fill||e.series.color,x.colorByPoint&&(b=e.series.chart.options.colors[i])),e.series.fillOpacity&&x.fillOpacity&&(b=new t(b).setOpacity(p(x.fillOpacity,1)).get()),C=n(b).rgba,l.useAlpha||(C[3]=1),"LINES"===e.drawMode&&l.useAlpha&&C[3]<1&&(C[3]/=10),"add"===x.boostBlending?(a.blendFunc(a.SRC_ALPHA,a.ONE),a.blendEquation(a.FUNC_ADD)):"mult"===x.boostBlending||"multiply"===x.boostBlending?a.blendFunc(a.DST_COLOR,a.ZERO):"darken"===x.boostBlending?(a.blendFunc(a.ONE,a.ONE),a.blendEquation(a.FUNC_MIN)):a.blendFuncSeparate(a.SRC_ALPHA,a.ONE_MINUS_SRC_ALPHA,a.ONE,a.ONE_MINUS_SRC_ALPHA),c.reset(),e.colorData.length>0?(c.setUniform("hasColor",1),(m=new s(a,c)).build(Array(e.segments[0].from).concat(e.colorData),"aColor",4),m.bind()):(c.setUniform("hasColor",0),a.disableVertexAttribArray(a.getAttribLocation(c.getProgram(),"aColor"))),c.setColor(C),r.setXAxis(e.series.xAxis),r.setYAxis(e.series.yAxis),r.setThreshold(P,T),"POINTS"===e.drawMode&&c.setPointSize(2*p(x.marker&&x.marker.radius,.5)*d),c.setSkipTranslation(e.skipTranslation),"bubble"===e.series.type&&c.setBubbleUniforms(e.series,e.zMin,e.zMax,d),c.setDrawAsCircle(g[e.series.type]||!1),u)){if(A>0||"LINE_STRIP"!==e.drawMode)for(f=0;f<e.segments.length;f++)u.render(e.segments[f].from,e.segments[f].to,e.drawMode);if(e.hasMarkers&&E)for(c.setPointSize(2*p(x.marker&&x.marker.radius,5)*d),c.setDrawAsCircle(!0),f=0;f<e.segments.length;f++)u.render(e.segments[f].from,e.segments[f].to,"POINTS")}}),l.debug.timeRendering&&console.timeEnd("gl rendering"),this.postRenderCallback&&this.postRenderCallback(this),this.flush()},i.prototype.render=function(t){var e=this;if(this.clear(),t.renderer.forExport)return this.renderChart(t);this.isInited?this.renderChart(t):setTimeout(function(){e.render(t)},1)},i.prototype.setSize=function(t,e){var o=this.shader;o&&(this.width!==t||this.height!==e)&&(this.width=t,this.height=e,o.bind(),o.setPMatrix(i.orthoMatrix(t,e)))},i.prototype.init=function(t,e){var i=this,o=this.settings;if(this.isInited=!1,!t)return!1;o.debug.timeSetup&&console.time("gl setup");for(var n=0;n<m.length&&(this.gl=t.getContext(m[n],{}),!this.gl);++n);var l=this.gl;if(!l)return!1;e||this.flush(),l.enable(l.BLEND),l.blendFunc(l.SRC_ALPHA,l.ONE_MINUS_SRC_ALPHA),l.disable(l.DEPTH_TEST),l.depthFunc(l.LESS);var h=this.shader=new r(l);if(!h)return!1;this.vbuffer=new s(l,h);var c=function(t,e){var o={isReady:!1,texture:a.createElement("canvas"),handle:l.createTexture()},r=o.texture.getContext("2d");i.textureHandles[t]=o,o.texture.width=512,o.texture.height=512,r.mozImageSmoothingEnabled=!1,r.webkitImageSmoothingEnabled=!1,r.msImageSmoothingEnabled=!1,r.imageSmoothingEnabled=!1,r.strokeStyle="rgba(255, 255, 255, 0)",r.fillStyle="#FFF",e(r);try{l.activeTexture(l.TEXTURE0),l.bindTexture(l.TEXTURE_2D,o.handle),l.texImage2D(l.TEXTURE_2D,0,l.RGBA,l.RGBA,l.UNSIGNED_BYTE,o.texture),l.texParameteri(l.TEXTURE_2D,l.TEXTURE_WRAP_S,l.CLAMP_TO_EDGE),l.texParameteri(l.TEXTURE_2D,l.TEXTURE_WRAP_T,l.CLAMP_TO_EDGE),l.texParameteri(l.TEXTURE_2D,l.TEXTURE_MAG_FILTER,l.LINEAR),l.texParameteri(l.TEXTURE_2D,l.TEXTURE_MIN_FILTER,l.LINEAR),l.bindTexture(l.TEXTURE_2D,null),o.isReady=!0}catch(t){}};return c("circle",function(t){t.beginPath(),t.arc(256,256,256,0,2*Math.PI),t.stroke(),t.fill()}),c("square",function(t){t.fillRect(0,0,512,512)}),c("diamond",function(t){t.beginPath(),t.moveTo(256,0),t.lineTo(512,256),t.lineTo(256,512),t.lineTo(0,256),t.lineTo(256,0),t.fill()}),c("triangle",function(t){t.beginPath(),t.moveTo(0,512),t.lineTo(256,0),t.lineTo(512,512),t.lineTo(0,512),t.fill()}),c("triangle-down",function(t){t.beginPath(),t.moveTo(0,0),t.lineTo(256,512),t.lineTo(512,0),t.lineTo(0,0),t.fill()}),this.isInited=!0,o.debug.timeSetup&&console.timeEnd("gl setup"),!0},i.prototype.destroy=function(){var t=this.gl,e=this.shader,i=this.vbuffer;this.flush(),i&&i.destroy(),e&&e.destroy(),t&&(d(this.textureHandles,function(e){e.handle&&t.deleteTexture(e.handle)}),t.canvas.width=1,t.canvas.height=1)},i}()}),i(e,"Extensions/Boost/BoostSeries.js",[e["Extensions/Boost/BoostableMap.js"],e["Extensions/Boost/Boostables.js"],e["Extensions/Boost/BoostChart.js"],e["Core/Defaults.js"],e["Core/Globals.js"],e["Core/Utilities.js"],e["Extensions/Boost/WGLRenderer.js"]],function(t,e,i,o,r,s,n){var a,l,h=i.getBoostClipRect,c=i.isChartSeriesBoosting,u=o.getOptions,d=r.doc,p=r.noop,f=r.win,g=s.addEvent,m=s.error,b=s.extend,x=s.fireEvent,v=s.isArray,A=s.isNumber,y=s.pick,P=s.wrap,T=s.defined,E=[];function S(t,e){var i=e.boost;t&&i&&i.target&&i.canvas&&!c(e.chart)&&t.allocateBufferForSingleSeries(e)}function C(t){return y(t&&t.options&&t.options.boost&&t.options.boost.enabled,!0)}function M(t,e){var i=t.constructor,o=t.seriesGroup||e.group,r=t.chartWidth,s=t.chartHeight,a=t,u="undefined"!=typeof SVGForeignObjectElement,p=(a=c(t)?t:e).boost=a.boost||{};return u=!1,l||(l=d.createElement("canvas")),!p.target&&(p.canvas=l,t.renderer.forExport||!u?(a.renderTarget=p.target=t.renderer.image("",0,0,r,s).addClass("highcharts-boost-canvas").add(o),p.clear=function(){p.target.attr({href:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII="})},p.copy=function(){p.resize(),p.target.attr({href:p.canvas.toDataURL("image/png")})}):(p.targetFo=t.renderer.createElement("foreignObject").add(o),a.renderTarget=p.target=d.createElement("canvas"),p.targetCtx=p.target.getContext("2d"),p.targetFo.element.appendChild(p.target),p.clear=function(){p.target.width=p.canvas.width,p.target.height=p.canvas.height},p.copy=function(){p.target.width=p.canvas.width,p.target.height=p.canvas.height,p.targetCtx.drawImage(p.canvas,0,0)}),p.resize=function(){r=t.chartWidth,s=t.chartHeight,(p.targetFo||p.target).attr({x:0,y:0,width:r,height:s}).css({pointerEvents:"none",mixedBlendMode:"normal",opacity:1}),a instanceof i&&a.boost.markerGroup.translate(t.plotLeft,t.plotTop)},p.clipRect=t.renderer.clipRect(),(p.targetFo||p.target).attr({zIndex:e.options.zIndex}).clip(p.clipRect),a instanceof i&&(a.boost.markerGroup=a.renderer.g().add(o).translate(e.xAxis.pos,e.yAxis.pos))),p.canvas.width=r,p.canvas.height=s,p.clipRect&&p.clipRect.attr(h(t,a)),p.resize(),p.clear(),!p.wgl&&(p.wgl=new n(function(t){t.settings.debug.timeBufferCopy&&console.time("buffer copy"),p.copy(),t.settings.debug.timeBufferCopy&&console.timeEnd("buffer copy")}),p.wgl.init(p.canvas)||m("[highcharts boost] - unable to init WebGL renderer"),p.wgl.setOptions(t.options.boost||{}),a instanceof i&&p.wgl.allocateBuffer(t)),p.wgl.setSize(r,s),p.wgl}function U(t){var e=t.points;if(e){var i=void 0,o=void 0;for(o=0;o<e.length;o+=1)(i=e[o])&&i.destroyElements&&i.destroyElements()}["graph","area","tracker"].forEach(function(e){var i=t[e];i&&(t[e]=i.destroy())}),t.getZonesGraphs&&t.getZonesGraphs([["graph","highcharts-graph"]]).forEach(function(e){var i=t[e[0]];i&&(t[e[0]]=i.destroy())})}function R(t,e,i,o,r,s){for(var n=(r=r||0)+(o=o||3e3),a=!0;a&&r<n&&r<t.length;)a=e(t[r],r),++r;a&&(r<t.length?s?R(t,e,i,o,r,s):f.requestAnimationFrame?f.requestAnimationFrame(function(){R(t,e,i,o,r)}):setTimeout(R,0,t,e,i,o,r):i&&i())}function k(t,e){var i=t.options,o=i.data,r=t.xAxis&&t.xAxis.options,s=t.yAxis&&t.yAxis.options,n=t.colorAxis&&t.colorAxis.options;return o.length>(i.boostThreshold||Number.MAX_VALUE)&&A(s.min)&&A(s.max)&&(!e||A(r.min)&&A(r.max))&&(!n||A(n.min)&&A(n.max))}function w(){var t=this,e=t.chart;e.boost&&e.boost.markerGroup===t.markerGroup&&(t.markerGroup=null),e.hoverPoints&&(e.hoverPoints=e.hoverPoints.filter(function(e){return e.series===t})),e.hoverPoint&&e.hoverPoint.series===t&&(e.hoverPoint=null)}function B(){var t=this.boost;t&&t.canvas&&t.target&&(t.wgl&&t.wgl.clear(),t.clear&&t.clear())}function D(t){var e=t.boost;e&&e.canvas&&e.target&&e.wgl&&!c(t.chart)&&e.wgl.render(t.chart)}function L(t,e){var i=t.options,o=t.xAxis,r=t.pointClass;if(e instanceof r)return e;var s=t.xData||i.xData||t.processedXData||!1,n=new r().init(t,t.options.data[e.i],s?s[e.i]:void 0);return n.category=y(o.categories?o.categories[n.x]:n.x,n.x),n.dist=e.dist,n.distX=e.distX,n.plotX=e.plotX,n.plotY=e.plotY,n.index=e.i,n.percentage=e.percentage,n.isInside=t.isPointInside(n),n}function z(){var t,e,i,o,r,s=this,n=this.options||{},l=this.chart,h=this.xAxis,u=this.yAxis,d=n.xData||this.processedXData,f=n.yData||this.processedYData,g=n.data,m=h.getExtremes(),b=m.min,v=m.max,A=u.getExtremes(),y=A.min,P=A.max,E={},C=!!this.sampling,k=n.enableMouseTracking,w=n.threshold,B=this.pointArrayMap&&"low,high"===this.pointArrayMap.join(","),L=!!n.stacking,z=this.cropStart||0,N=this.requireSorting,_=!d,I="x"===n.findNearestPointBy,G=this.xData||this.options.xData||this.processedXData||!1,O=!1,X=u.getThreshold(w);if(O=M(l,this),l.boosted=!0,this.visible){(this.points||this.graph)&&U(this),c(l)?(this.markerGroup&&this.markerGroup!==l.boost.markerGroup&&this.markerGroup.destroy(),this.markerGroup=l.boost.markerGroup,this.boost&&this.boost.target&&(this.renderTarget=this.boost.target=this.boost.target.destroy())):(l.boost&&this.markerGroup===l.boost.markerGroup&&(this.markerGroup=void 0),this.markerGroup=this.plotGroup("markerGroup","markers",!0,1,l.seriesGroup));var V=this.points=[],j=function(t,e,i,o){var r=!!G&&G[z+i],s=function(t){l.inverted&&(t=h.len-t,e=u.len-e),V.push({destroy:p,x:r,clientX:t,plotX:t,plotY:e,i:z+i,percentage:o})};t=Math.ceil(t),a=I?t:t+","+e,k&&(E[a]?r===G[G.length-1]&&(V.length--,s(t)):(E[a]=!0,s(t)))};this.buildKDTree=p,O&&(S(O,this),O.pushSeries(this),D(this));var F=O.settings;l.renderer.forExport||(F.debug.timeKDTree&&console.time("kd tree building"),R(L?this.data:d||g,function(s,n){var a,c,d,p,g,m=void 0===l.index,x=!1,A=!0;return!T(s)||(!m&&(_?(a=s[0],c=s[1]):(a=s,c=f[n]),B?(_&&(c=s.slice(1,3)),x=c[0],c=c[1]):L&&(a=s.x,x=(c=s.stackY)-s.y,g=s.percentage),N||(A=(c||0)>=y&&c<=P),null!==c&&a>=b&&a<=v&&A&&(d=h.toPixels(a,!0),C?((void 0===o||d===t)&&(B||(x=c),(void 0===r||c>i)&&(i=c,r=n),(void 0===o||x<e)&&(e=x,o=n)),I&&d===t||(void 0!==o&&(p=u.toPixels(i,!0),X=u.toPixels(e,!0),j(d,p,r,g),X!==p&&j(d,X,o,g)),o=r=void 0,t=d)):j(d,p=Math.ceil(u.toPixels(c,!0)),n,g))),!m)},function(){x(s,"renderedCanvas"),delete s.buildKDTree,s.buildKDTree(),F.debug.timeKDTree&&console.timeEnd("kd tree building")}))}}function N(t){var e=!0;if(this.chart.options&&this.chart.options.boost&&(e=void 0===this.chart.options.boost.enabled||this.chart.options.boost.enabled),!e||!this.boosted)return t.call(this);this.chart.boosted=!0;var i=M(this.chart,this);i&&(S(i,this),i.pushSeries(this)),D(this)}function _(t){return this.boosted&&k(this)?{}:t.apply(this,[].slice.call(arguments,1))}function I(e){var i=this,o=this.options.data,r=function(t){return!i.forceCrop&&(c(i.chart)||(t?t.length:0)>=(i.options.boostThreshold||Number.MAX_VALUE))};if(C(this.chart)&&t[this.type]){if(r(o)&&"heatmap"!==this.type&&"treemap"!==this.type&&!this.options.stacking&&k(this,!0)||(e.apply(this,[].slice.call(arguments,1)),o=this.processedXData),this.boosted=r(o),this.boosted){var s,n,a,l,h=void 0;this.options.data&&this.options.data.length&&!A(h=this.getFirstValidPoint(this.options.data))&&!v(h)&&m(12,!1,this.chart),a=this,a.boost=a.boost||{getPoint:function(t){return L(a,t)}},l=a.boost.altered=[],["allowDG","directTouch","stickyTracking"].forEach(function(t){l.push({prop:t,val:a[t],own:Object.hasOwnProperty.call(a,t)})}),a.allowDG=!1,a.directTouch=!1,a.stickyTracking=!0,a.finishedAnimating=!0,a.labelBySeries&&(a.labelBySeries=a.labelBySeries.destroy())}else s=this,(n=s.boost)&&((n.altered||[]).forEach(function(t){t.own?s[t.prop]=t.val:delete s[t.prop]}),n.clear&&n.clear())}else e.apply(this,[].slice.call(arguments,1))}function G(t){var e=t.apply(this,[].slice.call(arguments,1));return this.boost&&e?this.boost.getPoint(e):e}return{compose:function(i,o,r){if(s.pushUnique(E,i)){g(i,"destroy",w),g(i,"hide",B);var n=i.prototype;r&&(n.renderCanvas=z),P(n,"getExtremes",_),P(n,"processData",I),P(n,"searchPoint",G),["translate","generatePoints","drawTracker","drawPoints","render"].forEach(function(e){return function(e,i,o){function r(e){var i=this.options.stacking&&("translate"===o||"generatePoints"===o);this.boosted&&!i&&C(this.chart)&&"heatmap"!==this.type&&"treemap"!==this.type&&t[this.type]&&0!==this.options.boostThreshold?"render"===o&&this.renderCanvas&&this.renderCanvas():e.call(this)}P(e,o,r),"translate"===o&&["column","arearange","columnrange","heatmap","treemap"].forEach(function(t){i[t]&&P(i[t].prototype,o,r)})}(n,o,e)})}if(s.pushUnique(E,u)){var a=u().plotOptions;e.forEach(function(t){var e=a[t];e&&(e.boostThreshold=5e3,e.boostData=[],o[t].prototype.fillOpacity=!0)})}if(r){var l=o.area,h=o.areaspline,c=o.bubble,d=o.column,p=o.heatmap,f=o.scatter,m=o.treemap;if(l&&s.pushUnique(E,l)&&b(l.prototype,{fill:!0,fillOpacity:!0,sampling:!0}),h&&s.pushUnique(E,h)&&b(h.prototype,{fill:!0,fillOpacity:!0,sampling:!0}),c&&s.pushUnique(E,c)){var x=c.prototype;delete x.buildKDTree,P(x,"markerAttribs",function(t){return!this.boosted&&t.apply(this,[].slice.call(arguments,1))})}d&&s.pushUnique(E,d)&&b(d.prototype,{fill:!0,sampling:!0}),f&&s.pushUnique(E,f)&&(f.prototype.fill=!0),[p,m].forEach(function(t){t&&s.pushUnique(E,t)&&P(t.prototype,"drawPoints",N)})}return i},destroyGraphics:U,eachAsync:R,getPoint:L}}),i(e,"Extensions/BoostCanvas.js",[e["Extensions/Boost/BoostChart.js"],e["Extensions/Boost/BoostSeries.js"],e["Core/Chart/Chart.js"],e["Core/Color/Color.js"],e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e,i,o,r,s){var n,a=t.getBoostClipRect,l=t.isChartSeriesBoosting,h=e.destroyGraphics,c=o.parse,u=r.doc,d=r.noop,p=s.addEvent,f=s.fireEvent,g=s.isNumber,m=s.merge,b=s.pick,x=s.pushUnique,v=s.wrap;return function(t){var r,n="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII=",A=[];function y(t,e,i,o,r){r&&e!==r.clientX&&(t.moveTo(r.clientX,r.yBottom),t.lineTo(r.clientX,r.plotY),t.lineTo(e,i),t.lineTo(e,o))}function P(t,e,i,o,r){t.moveTo(e,i),t.arc(e,i,this.radii&&this.radii[r],0,2*Math.PI,!1)}function T(t,e,i,o){t.rect(e-1,i,1,o-i)}function E(){this.boost&&this.boost.copy&&this.boost.copy()}function S(){var t=this.boost||{};t.target&&t.target.attr({href:n}),t.canvas&&t.canvas.getContext("2d").clearRect(0,0,t.canvas.width,t.canvas.height)}function C(){l(this.chart)?this.boost&&this.boost.clear&&this.boost.clear():this.boost&&this.boost.copy?this.boost.copy():this.chart.boost&&this.chart.boost.copy&&this.chart.boost.copy()}function M(t,e,i){t.lineTo(e,i)}function U(){var t,e=this.chart,i=l(e)?e:this,o=i===e?e.seriesGroup:e.seriesGroup||this.group,r=e.chartWidth,s=e.chartHeight,h=function(t,e,i,o,r,s,n){t.call(this,i,e,o,r,s,n)},c=i.boost=i.boost||{};return t=c.targetCtx,c.canvas||(c.canvas=u.createElement("canvas"),c.target=e.renderer.image("",0,0,r,s).addClass("highcharts-boost-canvas").add(o),t=c.targetCtx=c.canvas.getContext("2d"),e.inverted&&["moveTo","lineTo","rect","arc"].forEach(function(e){v(t,e,h)}),c.copy=function(){c.target.attr({href:c.canvas.toDataURL("image/png")})},c.clear=function(){t.clearRect(0,0,c.canvas.width,c.canvas.height),i===c.target&&c.target.attr({href:n})},c.clipRect=e.renderer.clipRect(),c.target.clip(c.clipRect)),c.canvas.width!==r&&(c.canvas.width=r),c.canvas.height!==s&&(c.canvas.height=s),c.target.attr({x:0,y:0,width:r,height:s,style:"pointer-events: none",href:n}),c.clipRect&&c.clipRect.attr(a(e,i)),t}function R(){var t=this,i=t.options,a=t.chart,l=t.xAxis,u=t.yAxis,x=a.options.boost||{},v={timeRendering:x.timeRendering||!1,timeSeriesProcessing:x.timeSeriesProcessing||!1,timeSetup:x.timeSetup||!1},A=t.processedXData,y=t.processedYData,P=i.data,T=l.getExtremes(),E=T.min,S=T.max,C=u.getExtremes(),M=C.min,U=C.max,R={},k=!!t.sampling,w=i.marker&&i.marker.radius,B=t.cvsStrokeBatch||1e3,D=i.enableMouseTracking,L=i.threshold,z=g(L),N=u.getThreshold(L),_=t.fill,I=t.pointArrayMap&&"low,high"===t.pointArrayMap.join(","),G=!!i.stacking,O=t.cropStart||0,X=a.options.loading,V=t.requireSorting,j=i.connectNulls,F=!A,H=G?t.data:A||P,W=t.fillOpacity?o.parse(t.color).setOpacity(b(i.fillOpacity,.75)).get():t.color,Y="x"===i.findNearestPointBy,q=this.boost||{},Z=t.cvsDrawPoint,K=i.lineWidth?t.cvsLineTo:void 0,Q=w&&w<=1?t.cvsMarkerSquare:t.cvsMarkerCircle;q.target&&q.target.attr({href:n}),(t.points||t.graph)&&h(t),t.plotGroup("group","series",t.visible?"visible":"hidden",i.zIndex,a.seriesGroup),t.markerGroup=t.group,p(t,"destroy",function(){t.markerGroup=null});var J=this.points=[],$=this.getContext();if(t.buildKDTree=d,q.clear&&q.clear(),t.visible){P.length>99999&&(a.options.loading=m(X,{labelStyle:{backgroundColor:c("#ffffff").setOpacity(.75).get(),padding:"1em",borderRadius:"0.5em"},style:{backgroundColor:"none",opacity:1}}),s.clearTimeout(r),a.showLoading("Drawing..."),a.options.loading=X),v.timeRendering&&console.time("canvas rendering");var tt,te,ti,to,tr,ts,tn,ta,tl=0,th=N,tc=function(){_?($.fillStyle=W,$.fill()):($.strokeStyle=t.color,$.lineWidth=i.lineWidth,$.stroke())},tu=function(e,i,o,r){0===tl&&($.beginPath(),K&&($.lineJoin="round")),a.scroller&&"highcharts-navigator-series"===t.options.className?(i+=a.scroller.top,o&&(o+=a.scroller.top)):i+=a.plotTop,e+=a.plotLeft,ti?$.moveTo(e,i):Z?Z($,e,i,o,te):K?K($,e,i):Q&&Q.call(t,$,e,i,w,r),(tl+=1)===B&&(tc(),tl=0),te={clientX:e,plotY:i,yBottom:o}},td=this.xData||this.options.xData||this.processedXData||!1,tp=function(t,e,i){ta=Y?t:t+","+e,D&&!R[ta]&&(R[ta]=!0,a.inverted&&(t=l.len-t,e=u.len-e),J.push({x:!!td&&td[O+i],clientX:t,plotX:t,plotY:e,i:O+i}))};e.eachAsync(H,function(e,i){var o,r,s,n,h,c,d=void 0===a.index,p=!1,f=!1,g=NaN,m=NaN,b=!0;return!d&&(F?(o=e[0],r=e[1],H[i+1]&&(g=H[i+1][0]),H[i-1]&&(m=H[i-1][0])):(o=e,r=y[i],H[i+1]&&(g=H[i+1]),H[i-1]&&(m=H[i-1])),g&&g>=E&&g<=S&&(p=!0),m&&m>=E&&m<=S&&(f=!0),I?(F&&(r=e.slice(1,3)),c=r[0],r=r[1]):G&&(o=e.x,c=(r=e.stackY)-e.y),h=null===r,V||(b=r>=M&&r<=U),!h&&(o>=E&&o<=S&&b||p||f)&&(s=Math.round(l.toPixels(o,!0)),k?((void 0===ts||s===tt)&&(I||(c=r),(void 0===tn||r>tr)&&(tr=r,tn=i),(void 0===ts||c<to)&&(to=c,ts=i)),s!==tt&&(void 0!==ts&&(n=u.toPixels(tr,!0),th=u.toPixels(to,!0),tu(s,z?Math.min(n,N):n,z?Math.max(th,N):th,i),tp(s,n,tn),th!==n&&tp(s,th,ts)),ts=tn=void 0,tt=s)):(tu(s,n=Math.round(u.toPixels(r,!0)),th,i),tp(s,n,i))),ti=h&&!j,i%5e4==0&&(t.boost&&t.boost.copy?t.boost.copy():t.chart.boost&&t.chart.boost.copy&&t.chart.boost.copy())),!d},function(){var e=a.loadingDiv,i=a.loadingShown;tc(),t.canvasToSVG(),v.timeRendering&&console.timeEnd("canvas rendering"),f(t,"renderedCanvas"),i&&(e.style.transition="opacity 250ms",e.opacity=0,a.loadingShown=!1,r=setTimeout(function(){e.parentNode&&e.parentNode.removeChild(e),a.loadingDiv=a.loadingSpan=null},250)),delete t.buildKDTree,t.buildKDTree()},a.renderer.forExport?Number.MAX_VALUE:void 0)}}function k(t,e,i,o){t.moveTo(e,i),t.arc(e,i,o,0,2*Math.PI,!1)}function w(t,e,i,o){t.rect(e-o,i-o,2*o,2*o)}function B(){var t=this.chart,e=this.getContext(),i=this.chart.inverted,o=this.xAxis,r=this.yAxis;e?(this.points.forEach(function(s){var n,a=s.plotY;if(void 0!==a&&!isNaN(a)&&null!==s.y&&e){var l=s.shapeArgs||{},h=l.x,c=void 0===h?0:h,u=l.y,d=void 0===u?0:u,p=l.width,f=void 0===p?0:p,g=l.height,m=void 0===g?0:g;n=t.styledMode?s.series.colorAttribs(s):s.series.pointAttribs(s),e.fillStyle=n.fill,i?e.fillRect(r.len-d+o.left,o.len-c+r.top,-m,-f):e.fillRect(c+o.left,d+r.top,f,m)}}),this.canvasToSVG()):this.chart.showLoading("Your browser doesn't support HTML5 canvas, <br>please use a modern browser")}t.compose=function(t,e,o){if(x(A,t)&&i.prototype.callbacks.push(function(t){p(t,"predraw",S),p(t,"render",E)}),x(A,e)){var r=e.prototype;r.canvasToSVG=C,r.cvsLineTo=M,r.getContext=U,r.renderCanvas=R}var s=o.area,n=o.bubble,a=o.column,l=o.heatmap,h=o.scatter;if(s&&x(A,s)){var c=s.prototype;c.cvsDrawPoint=y,c.fill=!0,c.fillOpacity=!0,c.sampling=!0}if(n&&x(A,n)){var u=n.prototype;u.cvsMarkerCircle=P,u.cvsStrokeBatch=1}if(a&&x(A,a)){var d=a.prototype;d.cvsDrawPoint=T,d.fill=!0,d.sampling=!0}if(l&&x(A,l)&&v(l.prototype,"drawPoints",B),h&&x(A,h)){var f=h.prototype;f.cvsMarkerCircle=k,f.cvsMarkerSquare=w,f.fill=!0}}}(n||(n={})),n}),i(e,"masters/modules/boost-canvas.src.js",[e["Core/Globals.js"],e["Extensions/BoostCanvas.js"]],function(t,e){t.initCanvasBoost=function(){e.compose(t.Chart,t.Series,t.seriesTypes)}})});//# sourceMappingURL=boost-canvas.js.map