/**
 * Highcharts JS v11.2.0 (2023-10-30)
 *
 * ColorAxis module
 *
 * (c) 2012-2021 Pawel Potaczek
 *
 * License: www.highcharts.com/license
 */!function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/color-axis",["highcharts"],function(o){return t(o),t.Highcharts=o,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var o=t?t._modules:{};function e(t,o,e,i){t.hasOwnProperty(o)||(t[o]=i.apply(null,e),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:o,module:t[o]}})))}e(o,"Core/Axis/Color/ColorAxisComposition.js",[o["Core/Color/Color.js"],o["Core/Utilities.js"]],function(t,o){var e,i=t.parse,s=o.addEvent,r=o.extend,n=o.merge,l=o.pick,a=o.splat;return function(t){var e,h=[];function c(){var t=this,o=this.options;this.colorAxis=[],o.colorAxis&&(o.colorAxis=a(o.colorAxis),o.colorAxis.map(function(o){return new e(t,o)}))}function d(t){var o,e,i=this,s=this.chart.colorAxis||[],r=function(o){var e=t.allItems.indexOf(o);-1!==e&&(i.destroyItem(t.allItems[e]),t.allItems.splice(e,1))},n=[];for(s.forEach(function(t){(o=t.options)&&o.showInLegend&&(o.dataClasses&&o.visible?n=n.concat(t.getDataClassLegendSymbols()):o.visible&&n.push(t),t.series.forEach(function(t){(!t.options.showInLegend||o.dataClasses)&&("point"===t.options.legendType?t.points.forEach(function(t){r(t)}):r(t))}))}),e=n.length;e--;)t.allItems.unshift(n[e])}function p(t){t.visible&&t.item.legendColor&&t.item.legendItem.symbol.attr({fill:t.item.legendColor})}function u(t){var o;null===(o=this.chart.colorAxis)||void 0===o||o.forEach(function(o){o.update({},t.redraw)})}function f(){(this.chart.colorAxis&&this.chart.colorAxis.length||this.colorAttribs)&&this.translateColors()}function g(){var t=this.axisTypes;t?-1===t.indexOf("colorAxis")&&t.push("colorAxis"):this.axisTypes=["colorAxis"]}function m(t){var o=this,e=t?"show":"hide";o.visible=o.options.visible=!!t,["graphic","dataLabel"].forEach(function(t){o[t]&&o[t][e]()}),this.series.buildKDTree()}function y(){var t=this,o=this.data.length?this.data:this.points,e=this.options.nullColor,i=this.colorAxis,s=this.colorKey;o.forEach(function(o){var r=o.getNestedProperty(s),n=o.options.color||(o.isNull||null===o.value?e:i&&void 0!==r?i.toColor(r,o):o.color||t.color);n&&o.color!==n&&(o.color=n,"point"===t.options.legendType&&o.legendItem&&o.legendItem.label&&t.chart.legend.colorizeItem(o,o.visible))})}function x(){this.elem.attr("fill",i(this.start).tweenTo(i(this.end),this.pos),void 0,!0)}function C(){this.elem.attr("stroke",i(this.start).tweenTo(i(this.end),this.pos),void 0,!0)}t.compose=function(t,i,a,v,b){if(e||(e=t),o.pushUnique(h,i)){var A,I=i.prototype;I.collectionsWithUpdate.push("colorAxis"),I.collectionsWithInit.colorAxis=[I.addColorAxis],s(i,"afterGetAxes",c),A=i.prototype.createAxis,i.prototype.createAxis=function(t,o){if("colorAxis"!==t)return A.apply(this,arguments);var i=new e(this,n(o.axis,{index:this[t].length,isX:!1}));return this.isDirtyLegend=!0,this.axes.forEach(function(t){t.series=[]}),this.series.forEach(function(t){t.bindAxes(),t.isDirtyData=!0}),l(o.redraw,!0)&&this.redraw(o.animation),i}}if(o.pushUnique(h,a)){var L=a.prototype;L.fillSetter=x,L.strokeSetter=C}o.pushUnique(h,v)&&(s(v,"afterGetAllItems",d),s(v,"afterColorizeItem",p),s(v,"afterUpdate",u)),o.pushUnique(h,b)&&(r(b.prototype,{optionalAxis:"colorAxis",translateColors:y}),r(b.prototype.pointClass.prototype,{setVisible:m}),s(b,"afterTranslate",f,{order:1}),s(b,"bindAxes",g))},t.pointSetVisible=m}(e||(e={})),e}),e(o,"Core/Axis/Color/ColorAxisDefaults.js",[],function(){return{lineWidth:0,minPadding:0,maxPadding:0,gridLineColor:"#ffffff",gridLineWidth:1,tickPixelInterval:72,startOnTick:!0,endOnTick:!0,offset:0,marker:{animation:{duration:50},width:.01,color:"#999999"},labels:{distance:8,overflow:"justify",rotation:0},minColor:"#e6e9ff",maxColor:"#0022ff",tickLength:5,showInLegend:!0}}),e(o,"Core/Axis/Color/ColorAxisLike.js",[o["Core/Color/Color.js"],o["Core/Utilities.js"]],function(t,o){var e,i,s=t.parse,r=o.merge;return(e=i||(i={})).initDataClasses=function(t){var o,e,i,n=this.chart,l=this.legendItem=this.legendItem||{},a=this.options,h=t.dataClasses||[],c=n.options.chart.colorCount,d=0;this.dataClasses=e=[],l.labels=[];for(var p=0,u=h.length;p<u;++p)o=r(o=h[p]),e.push(o),(n.styledMode||!o.color)&&("category"===a.dataClassColor?(n.styledMode||(c=(i=n.options.colors||[]).length,o.color=i[d]),o.colorIndex=d,++d===c&&(d=0)):o.color=s(a.minColor).tweenTo(s(a.maxColor),u<2?.5:p/(u-1)))},e.initStops=function(){for(var t=this.options,o=this.stops=t.stops||[[0,t.minColor||""],[1,t.maxColor||""]],e=0,i=o.length;e<i;++e)o[e].color=s(o[e][1])},e.normalizedValue=function(t){var o=this.max||0,e=this.min||0;return this.logarithmic&&(t=this.logarithmic.log2lin(t)),1-(o-t)/(o-e||1)},e.toColor=function(t,o){var e,i,s,r,n,l,a=this.dataClasses,h=this.stops;if(a){for(l=a.length;l--;)if(i=(n=a[l]).from,s=n.to,(void 0===i||t>=i)&&(void 0===s||t<=s)){r=n.color,o&&(o.dataClass=l,o.colorIndex=n.colorIndex);break}}else{for(e=this.normalizedValue(t),l=h.length;l--&&!(e>h[l][0]););i=h[l]||h[l+1],e=1-((s=h[l+1]||i)[0]-e)/(s[0]-i[0]||1),r=i.color.tweenTo(s.color,e)}return r},i}),e(o,"Core/Axis/Color/ColorAxis.js",[o["Core/Axis/Axis.js"],o["Core/Axis/Color/ColorAxisComposition.js"],o["Core/Axis/Color/ColorAxisDefaults.js"],o["Core/Axis/Color/ColorAxisLike.js"],o["Core/Legend/LegendSymbol.js"],o["Core/Series/SeriesRegistry.js"],o["Core/Utilities.js"]],function(t,o,e,i,s,r,n){var l,a=this&&this.__extends||(l=function(t,o){return(l=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,o){t.__proto__=o}||function(t,o){for(var e in o)Object.prototype.hasOwnProperty.call(o,e)&&(t[e]=o[e])})(t,o)},function(t,o){if("function"!=typeof o&&null!==o)throw TypeError("Class extends value "+String(o)+" is not a constructor or null");function e(){this.constructor=t}l(t,o),t.prototype=null===o?Object.create(o):(e.prototype=o.prototype,new e)}),h=r.series,c=n.extend,d=n.fireEvent,p=n.isArray,u=n.isNumber,f=n.merge,g=n.pick,m=function(t){function i(o,e){var i=t.call(this,o,e)||this;return i.beforePadding=!1,i.chart=void 0,i.coll="colorAxis",i.dataClasses=void 0,i.options=void 0,i.stops=void 0,i.visible=!0,i.init(o,e),i}return a(i,t),i.compose=function(t,e,s,r){o.compose(i,t,e,s,r)},i.prototype.init=function(o,e){var s=o.options.legend||{},r=e.layout?"vertical"!==e.layout:"vertical"!==s.layout,n=e.visible,l=f(i.defaultColorAxisOptions,e,{showEmpty:!1,title:null,visible:s.enabled&&!1!==n});this.side=e.side||r?2:1,this.reversed=e.reversed||!r,this.opposite=!r,t.prototype.init.call(this,o,l,"colorAxis"),this.userOptions=e,p(o.userOptions.colorAxis)&&(o.userOptions.colorAxis[this.index]=e),e.dataClasses&&this.initDataClasses(e),this.initStops(),this.horiz=r,this.zoomEnabled=!1},i.prototype.hasData=function(){return!!(this.tickPositions||[]).length},i.prototype.setTickPositions=function(){if(!this.dataClasses)return t.prototype.setTickPositions.call(this)},i.prototype.setOptions=function(o){t.prototype.setOptions.call(this,o),this.options.crosshair=this.options.marker},i.prototype.setAxisSize=function(){var t,o,e,s,r=this.legendItem&&this.legendItem.symbol,n=this.chart,l=n.options.legend||{};r?(this.left=t=r.attr("x"),this.top=o=r.attr("y"),this.width=e=r.attr("width"),this.height=s=r.attr("height"),this.right=n.chartWidth-t-e,this.bottom=n.chartHeight-o-s,this.len=this.horiz?e:s,this.pos=this.horiz?t:o):this.len=(this.horiz?l.symbolWidth:l.symbolHeight)||i.defaultLegendLength},i.prototype.getOffset=function(){var o=this.legendItem&&this.legendItem.group,e=this.chart.axisOffset[this.side];if(o){this.axisParent=o,t.prototype.getOffset.call(this);var s=this.chart.legend;s.allItems.forEach(function(t){t instanceof i&&t.drawLegendSymbol(s,t)}),s.render(),this.chart.getMargins(!0),this.added||(this.added=!0,this.labelLeft=0,this.labelRight=this.width),this.chart.axisOffset[this.side]=e}},i.prototype.setLegendColor=function(){var t=this.horiz,o=this.reversed,e=o?1:0,i=o?0:1,s=t?[e,0,i,0]:[0,i,0,e];this.legendColor={linearGradient:{x1:s[0],y1:s[1],x2:s[2],y2:s[3]},stops:this.stops}},i.prototype.drawLegendSymbol=function(t,o){var e,s=o.legendItem||{},r=t.padding,n=t.options,l=this.options.labels,a=g(n.itemDistance,10),h=this.horiz,c=g(n.symbolWidth,h?i.defaultLegendLength:12),d=g(n.symbolHeight,h?12:i.defaultLegendLength),p=g(n.labelPadding,h?16:30);this.setLegendColor(),s.symbol||(s.symbol=this.chart.renderer.symbol("roundedRect",0,t.baseline-11,c,d,{r:null!==(e=n.symbolRadius)&&void 0!==e?e:3}).attr({zIndex:1}).add(s.group)),s.labelWidth=c+r+(h?a:g(l.x,l.distance)+this.maxLabelLength),s.labelHeight=d+r+(h?p:0)},i.prototype.setState=function(t){this.series.forEach(function(o){o.setState(t)})},i.prototype.setVisible=function(){},i.prototype.getSeriesExtremes=function(){var t,o,e,i,s,r,n,l,a=this.series,c=a.length;for(this.dataMin=1/0,this.dataMax=-1/0;c--;){if(o=(r=a[c]).colorKey=g(r.options.colorKey,r.colorKey,r.pointValKey,r.zoneAxis,"y"),i=r.pointArrayMap,s=r[o+"Min"]&&r[o+"Max"],r[o+"Data"])t=r[o+"Data"];else if(i){if(t=[],e=i.indexOf(o),n=r.yData,e>=0&&n)for(l=0;l<n.length;l++)t.push(g(n[l][e],n[l]))}else t=r.yData;if(s)r.minColorValue=r[o+"Min"],r.maxColorValue=r[o+"Max"];else{var d=h.prototype.getExtremes.call(r,t);r.minColorValue=d.dataMin,r.maxColorValue=d.dataMax}void 0!==r.minColorValue&&(this.dataMin=Math.min(this.dataMin,r.minColorValue),this.dataMax=Math.max(this.dataMax,r.maxColorValue)),s||h.prototype.applyExtremes.call(r)}},i.prototype.drawCrosshair=function(o,e){var i,s=this.legendItem||{},r=e&&e.plotX,n=e&&e.plotY,l=this.pos,a=this.len;e&&((i=this.toPixels(e.getNestedProperty(e.series.colorKey)))<l?i=l-2:i>l+a&&(i=l+a+2),e.plotX=i,e.plotY=this.len-i,t.prototype.drawCrosshair.call(this,o,e),e.plotX=r,e.plotY=n,this.cross&&!this.cross.addedToColorAxis&&s.group&&(this.cross.addClass("highcharts-coloraxis-marker").add(s.group),this.cross.addedToColorAxis=!0,this.chart.styledMode||"object"!=typeof this.crosshair||this.cross.attr({fill:this.crosshair.color})))},i.prototype.getPlotLinePath=function(o){var e=this.left,i=o.translatedValue,s=this.top;return u(i)?this.horiz?[["M",i-4,s-6],["L",i+4,s-6],["L",i,s],["Z"]]:[["M",e,i],["L",e-6,i+6],["L",e-6,i-6],["Z"]]:t.prototype.getPlotLinePath.call(this,o)},i.prototype.update=function(o,e){var i=this.chart.legend;this.series.forEach(function(t){t.isDirtyData=!0}),(o.dataClasses&&i.allItems||this.dataClasses)&&this.destroyItems(),t.prototype.update.call(this,o,e),this.legendItem&&this.legendItem.label&&(this.setLegendColor(),i.colorizeItem(this,!0))},i.prototype.destroyItems=function(){var t=this.chart,o=this.legendItem||{};if(o.label)t.legend.destroyItem(this);else if(o.labels)for(var e=0,i=o.labels;e<i.length;e++){var s=i[e];t.legend.destroyItem(s)}t.isDirtyLegend=!0},i.prototype.destroy=function(){this.chart.isDirtyLegend=!0,this.destroyItems(),t.prototype.destroy.apply(this,[].slice.call(arguments))},i.prototype.remove=function(o){this.destroyItems(),t.prototype.remove.call(this,o)},i.prototype.getDataClassLegendSymbols=function(){var t,o=this,e=o.chart,i=o.legendItem&&o.legendItem.labels||[],r=e.options.legend,n=g(r.valueDecimals,-1),l=g(r.valueSuffix,""),a=function(t){return o.series.reduce(function(o,e){return o.push.apply(o,e.points.filter(function(o){return o.dataClass===t})),o},[])};return i.length||o.dataClasses.forEach(function(r,h){var p=r.from,u=r.to,f=e.numberFormatter,g=!0;t="",void 0===p?t="< ":void 0===u&&(t="> "),void 0!==p&&(t+=f(p,n)+l),void 0!==p&&void 0!==u&&(t+=" - "),void 0!==u&&(t+=f(u,n)+l),i.push(c({chart:e,name:t,options:{},drawLegendSymbol:s.rectangle,visible:!0,isDataClass:!0,setState:function(t){for(var o=0,e=a(h);o<e.length;o++)e[o].setState(t)},setVisible:function(){this.visible=g=o.visible=!g;for(var t=[],i=0,s=a(h);i<s.length;i++){var r=s[i];r.setVisible(g),-1===t.indexOf(r.series)&&t.push(r.series)}e.legend.colorizeItem(this,g),t.forEach(function(t){d(t,"afterDataClassLegendClick")})}},r))}),i},i.defaultColorAxisOptions=e,i.defaultLegendLength=200,i.keepProps=["legendItem"],i}(t);return c(m.prototype,i),Array.prototype.push.apply(t.keepProps,m.keepProps),m}),e(o,"masters/modules/coloraxis.src.js",[o["Core/Globals.js"],o["Core/Axis/Color/ColorAxis.js"]],function(t,o){t.ColorAxis=o,o.compose(t.Chart,t.Fx,t.Legend,t.Series)})});//# sourceMappingURL=coloraxis.js.map