/**
 * Highstock JS v11.2.0 (2023-10-30)
 *
 * Data grouping module
 *
 * (c) 2010-2021 Torstein Hønsi
 *
 * License: www.highcharts.com/license
 */!function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/datagrouping",["highcharts"],function(i){return t(i),t.Highcharts=i,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var i=t?t._modules:{};function o(t,i,o,a){t.hasOwnProperty(i)||(t[i]=a.apply(null,o),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:i,module:t[i]}})))}o(i,"Extensions/DataGrouping/ApproximationRegistry.js",[],function(){return{}}),o(i,"Extensions/DataGrouping/ApproximationDefaults.js",[i["Extensions/DataGrouping/ApproximationRegistry.js"],i["Core/Utilities.js"]],function(t,i){var o=i.arrayMax,a=i.arrayMin,e=i.correctFloat,n=i.extend,r=i.isNumber;function s(t){var i=t.length,o=p(t);return r(o)&&i&&(o=e(o/i)),o}function p(t){var i,o=t.length;if(!o&&t.hasNulls)i=null;else if(o)for(i=0;o--;)i+=t[o];return i}var u={average:s,averages:function(){var t=[];return[].forEach.call(arguments,function(i){t.push(s(i))}),void 0===t[0]?void 0:t},close:function(t){return t.length?t[t.length-1]:t.hasNulls?null:void 0},high:function(t){return t.length?o(t):t.hasNulls?null:void 0},hlc:function(i,o,a){if(i=t.high(i),o=t.low(o),a=t.close(a),r(i)||r(o)||r(a))return[i,o,a]},low:function(t){return t.length?a(t):t.hasNulls?null:void 0},ohlc:function(i,o,a,e){if(i=t.open(i),o=t.high(o),a=t.low(a),e=t.close(e),r(i)||r(o)||r(a)||r(e))return[i,o,a,e]},open:function(t){return t.length?t[0]:t.hasNulls?null:void 0},range:function(i,o){return(i=t.low(i),o=t.high(o),r(i)||r(o))?[i,o]:null===i&&null===o?null:void 0},sum:p};return n(t,u),u}),o(i,"Extensions/DataGrouping/DataGroupingDefaults.js",[],function(){return{common:{groupPixelWidth:2,dateTimeLabelFormats:{millisecond:["%A, %e %b, %H:%M:%S.%L","%A, %e %b, %H:%M:%S.%L","-%H:%M:%S.%L"],second:["%A, %e %b, %H:%M:%S","%A, %e %b, %H:%M:%S","-%H:%M:%S"],minute:["%A, %e %b, %H:%M","%A, %e %b, %H:%M","-%H:%M"],hour:["%A, %e %b, %H:%M","%A, %e %b, %H:%M","-%H:%M"],day:["%A, %e %b %Y","%A, %e %b","-%A, %e %b %Y"],week:["Week from %A, %e %b %Y","%A, %e %b","-%A, %e %b %Y"],month:["%B %Y","%B","-%B %Y"],year:["%Y","%Y","-%Y"]}},seriesSpecific:{line:{},spline:{},area:{},areaspline:{},arearange:{},column:{groupPixelWidth:10},columnrange:{groupPixelWidth:10},candlestick:{groupPixelWidth:10},ohlc:{groupPixelWidth:5},hlc:{groupPixelWidth:5},heikinashi:{groupPixelWidth:10}},units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1]],["week",[1]],["month",[1,3,6]],["year",null]]}}),o(i,"Extensions/DataGrouping/DataGroupingAxisComposition.js",[i["Extensions/DataGrouping/DataGroupingDefaults.js"],i["Core/Utilities.js"]],function(t,i){var o,a=i.addEvent,e=i.extend,n=i.merge,r=i.pick,s=[];function p(t){var i=this,o=i.series;o.forEach(function(t){t.groupPixelWidth=void 0}),o.forEach(function(o){o.groupPixelWidth=i.getGroupPixelWidth&&i.getGroupPixelWidth(),o.groupPixelWidth&&(o.hasProcessed=!0),o.applyGrouping(!!t.hasExtremesChanged)})}function u(){for(var i,o,a=this.series,e=a.length,n=0,s=!1;e--;)(o=a[e].options.dataGrouping)&&(n=Math.max(n,r(o.groupPixelWidth,t.common.groupPixelWidth)),i=(a[e].processedXData||a[e].data).length,(a[e].groupPixelWidth||i>this.chart.plotSizeX/n||i&&o.forced)&&(s=!0));return s?n:0}function l(){this.series.forEach(function(t){t.hasProcessed=!1})}function h(t,i){var a;if(i=r(i,!0),t||(t={forced:!1,units:null}),this instanceof o)for(a=this.series.length;a--;)this.series[a].update({dataGrouping:t},!1);else this.chart.options.series.forEach(function(i){i.dataGrouping="boolean"==typeof t?t:n(t,i.dataGrouping)});this.ordinal&&(this.ordinal.slope=void 0),i&&this.chart.redraw()}return{compose:function(t){o=t,i.pushUnique(s,t)&&(a(t,"afterSetScale",l),a(t,"postProcessData",p),e(t.prototype,{applyGrouping:p,getGroupPixelWidth:u,setDataGrouping:h}))}}}),o(i,"Extensions/DataGrouping/DataGroupingSeriesComposition.js",[i["Extensions/DataGrouping/ApproximationRegistry.js"],i["Extensions/DataGrouping/DataGroupingDefaults.js"],i["Core/Axis/DateTimeAxis.js"],i["Core/Defaults.js"],i["Core/Series/SeriesRegistry.js"],i["Core/Utilities.js"]],function(t,i,o,a,e,n){var r=e.series.prototype,s=n.addEvent,p=n.defined,u=n.error,l=n.extend,h=n.isNumber,d=n.merge,g=n.pick,c=r.generatePoints,f=[];function m(t){var a,e,n=this.chart,s=this.options.dataGrouping,l=!1!==this.allowDG&&s&&g(s.enabled,n.options.isStock),d=this.reserveSpace(),c=this.currentDataGrouping,f=!1;l&&!this.requireSorting&&(this.requireSorting=f=!0);var m=!1==!(this.isCartesian&&!this.isDirty&&!this.xAxis.isDirty&&!this.yAxis.isDirty&&!t)||!l;if(f&&(this.requireSorting=!1),!m){this.destroyGroupedData();var x=s.groupAll?this.xData:this.processedXData,D=s.groupAll?this.yData:this.processedYData,G=n.plotSizeX,v=this.xAxis,y=v.options.ordinal,M=this.groupPixelWidth,A=void 0,S=void 0;if(M&&x&&x.length&&G){S=!0,this.isDirty=!0,this.points=null;var E,P=v.getExtremes(),b=P.min,j=P.max,C=y&&v.ordinal&&v.ordinal.getGroupIntervalFactor(b,j,this)||1,W=M*(j-b)/G*C,k=v.getTimeTicks(o.Additions.prototype.normalizeTimeTickInterval(W,s.units||i.units),Math.min(b,x[0]),Math.max(j,x[x.length-1]),v.options.startOfWeek,x,this.closestPointRange),H=r.groupData.apply(this,[x,D,k,s.approximation]),F=H.groupedXData,T=H.groupedYData,Y=0;for(s&&s.smoothed&&F.length&&(s.firstAnchor="firstPoint",s.anchor="middle",s.lastAnchor="lastPoint",u(32,!1,n,{"dataGrouping.smoothed":"use dataGrouping.anchor"})),A=1;A<k.length;A++)k.info.segmentStarts&&-1!==k.info.segmentStarts.indexOf(A)||(Y=Math.max(k[A]-k[A-1],Y));(a=k.info).gapSize=Y,this.closestPointRange=k.info.totalRange,this.groupMap=H.groupMap,this.currentDataGrouping=a,function(t,i,o){var a,e=t.options.dataGrouping,n=t.currentDataGrouping&&t.currentDataGrouping.gapSize;if(e&&t.xData&&n&&t.groupMap){var r=i.length-1,s=e.anchor,p=g(e.firstAnchor,s),u=g(e.lastAnchor,s);if(s&&"start"!==s){var l=n*({middle:.5,end:1})[s];for(a=i.length-1;a--&&a>0;)i[a]+=l}if(p&&"start"!==p&&t.xData[0]>=i[0]){var d=t.groupMap[0].start,c=t.groupMap[0].length,f=void 0;h(d)&&h(c)&&(f=d+(c-1)),i[0]=({middle:i[0]+.5*n,end:i[0]+n,firstPoint:t.xData[0],lastPoint:f&&t.xData[f]})[p]}if(u&&"start"!==u&&n&&i[r]>=o-n){var m=t.groupMap[t.groupMap.length-1].start;i[r]=({middle:i[r]+.5*n,end:i[r]+n,firstPoint:m&&t.xData[m],lastPoint:t.xData[t.xData.length-1]})[u]}}}(this,F,j),d&&(p((E=F)[0])&&h(v.min)&&h(v.dataMin)&&E[0]<v.min&&((!p(v.options.min)&&v.min<=v.dataMin||v.min===v.dataMin)&&(v.min=Math.min(E[0],v.min)),v.dataMin=Math.min(E[0],v.dataMin)),p(E[E.length-1])&&h(v.max)&&h(v.dataMax)&&E[E.length-1]>v.max&&((!p(v.options.max)&&h(v.dataMax)&&v.max>=v.dataMax||v.max===v.dataMax)&&(v.max=Math.max(E[E.length-1],v.max)),v.dataMax=Math.max(E[E.length-1],v.dataMax))),s.groupAll&&(this.allGroupedData=T,F=(e=this.cropData(F,T,v.min,v.max)).xData,T=e.yData,this.cropStart=e.start),this.processedXData=F,this.processedYData=T}else this.groupMap=null;this.hasGroupedData=S,this.preventGraphAnimation=(c&&c.totalRange)!==(a&&a.totalRange)}}function x(){this.groupedData&&(this.groupedData.forEach(function(t,i){t&&(this.groupedData[i]=t.destroy?t.destroy():null)},this),this.groupedData.length=0)}function D(){c.apply(this),this.destroyGroupedData(),this.groupedData=this.hasGroupedData?this.points:null}function G(){return this.is("arearange")?"range":this.is("ohlc")?"ohlc":this.is("hlc")?"hlc":this.is("column")||this.options.cumulative?"sum":"average"}function v(i,o,a,e){var n,r,s,u=this,l=u.data,g=u.options&&u.options.data,c=[],f=[],m=[],x=i.length,D=!!o,G=[],v=u.pointArrayMap,y=v&&v.length,M=["x"].concat(v||["y"]),A=this.options.dataGrouping&&this.options.dataGrouping.groupAll,S=0,E=0,P="function"==typeof e?e:e&&t[e]?t[e]:t[u.getDGApproximation&&u.getDGApproximation()||"average"];if(y)for(var b=v.length;b--;)G.push([]);else G.push([]);for(var j=y||1,C=0;C<=x;C++)if(!(i[C]<a[0])){for(;void 0!==a[S+1]&&i[C]>=a[S+1]||C===x;){n=a[S],u.dataGroupInfo={start:A?E:u.cropStart+E,length:G[0].length},s=P.apply(u,G),u.pointClass&&!p(u.dataGroupInfo.options)&&(u.dataGroupInfo.options=d(u.pointClass.prototype.optionsToObject.call({series:u},u.options.data[u.cropStart+E])),M.forEach(function(t){delete u.dataGroupInfo.options[t]})),void 0!==s&&(c.push(n),f.push(s),m.push(u.dataGroupInfo)),E=C;for(var W=0;W<j;W++)G[W].length=0,G[W].hasNulls=!1;if(S+=1,C===x)break}if(C===x)break;if(v)for(var k=u.options.dataGrouping&&u.options.dataGrouping.groupAll?C:u.cropStart+C,H=l&&l[k]||u.pointClass.prototype.applyOptions.apply({series:u},[g[k]]),F=void 0,W=0;W<y;W++)h(F=H[v[W]])?G[W].push(F):null===F&&(G[W].hasNulls=!0);else h(r=D?o[C]:null)?G[0].push(r):null===r&&(G[0].hasNulls=!0)}return{groupedXData:c,groupedYData:f,groupMap:m}}function y(t){var o=t.options,e=this.type,n=this.chart.options.plotOptions,r=this.useCommonDataGrouping&&i.common,s=i.seriesSpecific,p=a.defaultOptions.plotOptions[e].dataGrouping;if(n&&(s[e]||r)){var u=this.chart.rangeSelector;p||(p=d(i.common,s[e])),o.dataGrouping=d(r,p,n.series&&n.series.dataGrouping,n[e].dataGrouping,this.userOptions.dataGrouping,!o.isInternal&&u&&h(u.selected)&&u.buttonOptions[u.selected].dataGrouping)}}return{compose:function(t){var i=t.prototype.pointClass;n.pushUnique(f,i)&&s(i,"update",function(){if(this.dataGroup)return u(24,!1,this.series.chart),!1}),n.pushUnique(f,t)&&(s(t,"afterSetOptions",y),s(t,"destroy",x),l(t.prototype,{applyGrouping:m,destroyGroupedData:x,generatePoints:D,getDGApproximation:G,groupData:v}))},groupData:v}}),o(i,"Extensions/DataGrouping/DataGrouping.js",[i["Extensions/DataGrouping/DataGroupingAxisComposition.js"],i["Extensions/DataGrouping/DataGroupingDefaults.js"],i["Extensions/DataGrouping/DataGroupingSeriesComposition.js"],i["Core/Templating.js"],i["Core/Utilities.js"]],function(t,i,o,a,e){var n=a.format,r=e.addEvent,s=e.extend,p=e.isNumber,u=[];function l(t){var o,a,e,r,u,l=this.chart,h=l.time,d=t.labelConfig,g=d.series,c=g.options,f=g.tooltipOptions,m=c.dataGrouping,x=g.xAxis,D=f.xDateFormat,G=f[t.isFooter?"footerFormat":"headerFormat"];x&&"datetime"===x.options.type&&m&&p(d.key)&&(a=g.currentDataGrouping,e=m.dateTimeLabelFormats||i.common.dateTimeLabelFormats,a?(r=e[a.unitName],1===a.count?D=r[0]:(D=r[1],o=r[2])):!D&&e&&x.dateTime&&(D=x.dateTime.getXDateFormat(d.x,f.dateTimeLabelFormats)),u=h.dateFormat(D,d.key),o&&(u+=h.dateFormat(o,d.key+a.totalRange-1)),g.chart.styledMode&&(G=this.styledModeFormat(G)),t.text=n(G,{point:s(d.point,{key:u}),series:g},l),t.preventDefault())}return{compose:function(i,a,n){t.compose(i),o.compose(a),n&&e.pushUnique(u,n)&&r(n,"headerFormatter",l)},groupData:o.groupData}}),o(i,"masters/modules/datagrouping.src.js",[i["Core/Globals.js"],i["Extensions/DataGrouping/ApproximationDefaults.js"],i["Extensions/DataGrouping/ApproximationRegistry.js"],i["Extensions/DataGrouping/DataGrouping.js"]],function(t,i,o,a){t.dataGrouping={approximationDefaults:i,approximations:o},a.compose(t.Axis,t.Series,t.Tooltip)})});//# sourceMappingURL=datagrouping.js.map