/**
 * Highstock JS v11.2.0 (2023-10-30)
 *
 * Drag-panes module
 *
 * (c) 2010-2021 Highsoft AS
 * Author: Kacper Madej
 *
 * License: www.highcharts.com/license
 */!function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/drag-panes",["highcharts","highcharts/modules/stock"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function s(t,e,s,i){t.hasOwnProperty(e)||(t[e]=i.apply(null,s),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:t[e]}})))}s(e,"Extensions/DragPanes/AxisResizerDefaults.js",[],function(){return{minLength:"10%",maxLength:"100%",resize:{controlledAxis:{next:[],prev:[]},enabled:!1,cursor:"ns-resize",lineColor:"#cccccc",lineDashStyle:"Solid",lineWidth:4,x:0,y:0}}}),s(e,"Extensions/DragPanes/AxisResizer.js",[e["Extensions/DragPanes/AxisResizerDefaults.js"],e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e,s){var i=e.hasTouch,o=s.addEvent,n=s.clamp,r=s.isNumber,a=s.relativeLength;return function(){function e(t){this.axis=void 0,this.controlLine=void 0,this.lastPos=void 0,this.options=void 0,this.init(t)}return e.prototype.init=function(t,e){this.axis=t,this.options=t.options.resize||{},this.render(),e||this.addMouseEvents()},e.prototype.render=function(){var t=this.axis,e=t.chart,s=this.options,i=s.x||0,o=s.y,r=n(t.top+t.height+o,e.plotTop,e.plotTop+e.plotHeight),a={};e.styledMode||(a={cursor:s.cursor,stroke:s.lineColor,"stroke-width":s.lineWidth,dashstyle:s.lineDashStyle}),this.lastPos=r-o,this.controlLine||(this.controlLine=e.renderer.path().addClass("highcharts-axis-resizer")),this.controlLine.add(t.axisGroup);var h=e.styledMode?this.controlLine.strokeWidth():s.lineWidth;a.d=e.renderer.crispLine([["M",t.left+i,r],["L",t.left+t.width+i,r]],h),this.controlLine.attr(a)},e.prototype.addMouseEvents=function(){var t,e,s,n=this,r=n.controlLine.element,a=n.axis.chart.container,h=[];n.mouseMoveHandler=t=function(t){return n.onMouseMove(t)},n.mouseUpHandler=e=function(t){return n.onMouseUp(t)},n.mouseDownHandler=s=function(t){return n.onMouseDown(t)},h.push(o(a,"mousemove",t),o(a.ownerDocument,"mouseup",e),o(r,"mousedown",s)),i&&h.push(o(a,"touchmove",t),o(a.ownerDocument,"touchend",e),o(r,"touchstart",s)),n.eventsToUnbind=h},e.prototype.onMouseMove=function(t){(!t.touches||0!==t.touches[0].pageX)&&this.grabbed&&(this.hasDragged=!0,this.updateAxes(this.axis.chart.pointer.normalize(t).chartY-this.options.y))},e.prototype.onMouseUp=function(t){this.hasDragged&&this.updateAxes(this.axis.chart.pointer.normalize(t).chartY-this.options.y),this.grabbed=this.hasDragged=this.axis.chart.activeResizer=void 0},e.prototype.onMouseDown=function(t){this.axis.chart.pointer.reset(!1,0),this.grabbed=this.axis.chart.activeResizer=!0},e.prototype.updateAxes=function(t){var e=this.axis.chart,s=this.options.controlledAxis,i=0===s.next.length?[e.yAxis.indexOf(this.axis)+1]:s.next,o=[this.axis].concat(s.prev),h=[],u=e.plotTop,c=e.plotHeight,d=u+c,p=function(t){return 100*t/c+"%"},l=function(t,e,s){return Math.round(n(t,e,s))};t=n(t,u,d);var f=!1,v=t-this.lastPos;if(!(v*v<1)){for(var x=!0,g=0,y=[o,i];g<y.length;g++)for(var m=y[g],z=0;z<m.length;z++){var D=m[z],M=r(D)?e.yAxis[D]:x?D:e.get(D),P=M&&M.options,b={},E=void 0,L=void 0;if(!P||"navigator-y-axis"===P.id){x=!1;continue}L=M.top;var w=Math.round(a(P.minLength||NaN,c)),A=Math.round(a(P.maxLength||NaN,c));if(x)(E=l(t-L,w,A))===A&&(f=!0),t=L+E,h.push({axis:M,options:{height:p(E)}});else{if(v=t-this.lastPos,E=l(M.len-v,w,A),(L=M.top+v)+E>d){var j=d-E-L;t+=j,L+=j}L<u&&(L=u)+E>d&&(E=c),E===w&&(f=!0),h.push({axis:M,options:{top:p(L-u),height:p(E)}})}x=!1,b.height=E}if(!f){for(var R=0;R<h.length;R++){var U=h[R];U.axis.update(U.options,!1)}e.redraw(!1)}}},e.prototype.destroy=function(){var t=this.axis;delete t.resizer,this.eventsToUnbind&&this.eventsToUnbind.forEach(function(t){return t()}),this.controlLine.destroy();for(var e=0,s=Object.keys(this);e<s.length;e++)this[s[e]]=null},e.resizerOptions=t,e}()}),s(e,"Extensions/DragPanes/DragPanes.js",[e["Extensions/DragPanes/AxisResizer.js"],e["Core/Utilities.js"]],function(t,e){var s=e.addEvent,i=e.merge,o=e.wrap,n=[];function r(){var e=this.resizer,s=this.options.resize;if(s){var i=!1!==s.enabled;e?i?e.init(this,!0):e.destroy():i&&(this.resizer=new t(this))}}function a(t){!t.keepEvents&&this.resizer&&this.resizer.destroy()}function h(t){this.chart.activeResizer||t.apply(this,[].slice.call(arguments,1))}function u(t){this.chart.activeResizer||t.apply(this,[].slice.call(arguments,1))}return{compose:function(c,d){e.pushUnique(n,c)&&(i(!0,c.defaultOptions,t.resizerOptions),c.keepProps.push("resizer"),s(c,"afterRender",r),s(c,"destroy",a)),e.pushUnique(n,d)&&(o(d.prototype,"runPointActions",u),o(d.prototype,"drag",h))}}}),s(e,"masters/modules/drag-panes.src.js",[e["Core/Globals.js"],e["Extensions/DragPanes/AxisResizer.js"],e["Extensions/DragPanes/DragPanes.js"]],function(t,e,s){t.AxisResizer=e,s.compose(t.Axis,t.Pointer)})});//# sourceMappingURL=drag-panes.js.map