/**
 * Highcharts JS v11.2.0 (2023-10-30)
 *
 * Force directed graph module
 *
 * (c) 2010-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */!function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/networkgraph",["highcharts"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function i(t,e,i,o){t.hasOwnProperty(e)||(t[e]=o.apply(null,i),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:t[e]}})))}i(e,"Series/DragNodesComposition.js",[e["Core/Utilities.js"]],function(t){var e=t.addEvent,i=[];function o(){var t,i,o,s=this;s.container&&(t=e(s.container,"mousedown",function(t){var r=s.hoverPoint;r&&r.series&&r.series.hasDraggableNodes&&r.series.options.draggable&&(r.series.onMouseDown(r,t),i=e(s.container,"mousemove",function(t){return r&&r.series&&r.series.onMouseMove(r,t)}),o=e(s.container.ownerDocument,"mouseup",function(t){return i(),o(),r&&r.series&&r.series.onMouseUp(r,t)}))})),e(s,"destroy",function(){t()})}return{compose:function(s){t.pushUnique(i,s)&&e(s,"load",o)},onMouseDown:function(t,e){var i=this.chart.pointer.normalize(e);t.fixedPosition={chartX:i.chartX,chartY:i.chartY,plotX:t.plotX,plotY:t.plotY},t.inDragMode=!0},onMouseMove:function(t,e){if(t.fixedPosition&&t.inDragMode){var i=this.chart,o=i.pointer.normalize(e),s=t.fixedPosition.chartX-o.chartX,r=t.fixedPosition.chartY-o.chartY,n=i.graphLayoutsLookup,a=void 0,h=void 0;(Math.abs(s)>5||Math.abs(r)>5)&&(a=t.fixedPosition.plotX-s,h=t.fixedPosition.plotY-r,i.isInsidePlot(a,h)&&(t.plotX=a,t.plotY=h,t.hasDragged=!0,this.redrawHalo(t),n.forEach(function(t){t.restartSimulation()})))}},onMouseUp:function(t,e){t.fixedPosition&&(t.hasDragged&&(this.layout.enableSimulation?this.layout.start():this.chart.redraw()),t.inDragMode=t.hasDragged=!1,this.options.fixedDraggable||delete t.fixedPosition)},redrawHalo:function(t){t&&this.halo&&this.halo.attr({d:t.haloPath(this.options.states.hover.halo.size)})}}}),i(e,"Series/GraphLayoutComposition.js",[e["Core/Animation/AnimationUtilities.js"],e["Core/Utilities.js"]],function(t,e){var i=t.setAnimation,o=e.addEvent,s=[];function r(){this.graphLayoutsLookup&&(this.graphLayoutsLookup.forEach(function(t){t.updateSimulation()}),this.redraw())}function n(){this.graphLayoutsLookup&&(this.graphLayoutsLookup.forEach(function(t){t.updateSimulation(!1)}),this.redraw())}function a(){this.graphLayoutsLookup&&this.graphLayoutsLookup.forEach(function(t){t.stop()})}function h(){var t,e=!1,o=function(i){i.maxIterations--&&isFinite(i.temperature)&&!i.isStable()&&!i.enableSimulation&&(i.beforeStep&&i.beforeStep(),i.step(),t=!1,e=!0)};if(this.graphLayoutsLookup){for(i(!1,this),this.graphLayoutsLookup.forEach(function(t){return t.start()});!t;)t=!0,this.graphLayoutsLookup.forEach(o);e&&this.series.forEach(function(t){t&&t.layout&&t.render()})}}return{compose:function(t){e.pushUnique(s,t)&&(o(t,"afterPrint",r),o(t,"beforePrint",n),o(t,"predraw",a),o(t,"render",h))},integrations:{},layouts:{}}}),i(e,"Series/NodesComposition.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var i,o=t.series,s=o.prototype,r=o.prototype.pointClass.prototype,n=e.defined,a=e.extend,h=e.find,p=e.merge,d=e.pick;return function(t){var i=[];function o(){return this.data=[].concat(this.points||[],this.nodes),s.destroy.apply(this,arguments)}function l(){this.nodes&&(this.nodes.forEach(function(t){t.destroy()}),this.nodes.length=0),s.setData.apply(this,arguments)}function u(t){var e=arguments,i=this.isNode?this.linksTo.concat(this.linksFrom):[this.fromNode,this.toNode];"select"!==t&&i.forEach(function(t){t&&t.series&&(r.setState.apply(t,e),!t.isNode&&(t.fromNode.graphic&&r.setState.apply(t.fromNode,e),t.toNode&&t.toNode.graphic&&r.setState.apply(t.toNode,e)))}),r.setState.apply(this,e)}function c(t,e,i,o){var s=this,n=this.series.options.nodes,a=this.series.options.data,h=a&&a.length||0,l=a&&a[this.index];if(r.update.call(this,t,!this.isNode&&e,i,o),this.isNode){var u=(n||[]).reduce(function(t,e,i){return s.id===e.id?i:t},-1),c=p(n&&n[u]||{},a&&a[this.index]||{});a&&(l?a[this.index]=l:a.length=h),n?u>=0?n[u]=c:n.push(c):this.series.options.nodes=[c],d(e,!0)&&this.series.chart.redraw(i)}}t.compose=function(t,s){if(e.pushUnique(i,t)){var r=t.prototype;r.setNodeState=u,r.setState=u,r.update=c}if(e.pushUnique(i,s)){var n=s.prototype;n.destroy=o,n.setData=l}return s},t.createNode=function(t){var e,i=this.pointClass,o=function(t,e){return h(t,function(t){return t.id===e})},s=o(this.nodes,t);if(!s){e=this.options.nodes&&o(this.options.nodes,t);var r=new i().init(this,a({className:"highcharts-node",isNode:!0,id:t,y:1},e));r.linksTo=[],r.linksFrom=[],r.getSum=function(){var t=0,e=0;return r.linksTo.forEach(function(e){t+=e.weight||0}),r.linksFrom.forEach(function(t){e+=t.weight||0}),Math.max(t,e)},r.offset=function(t,e){for(var i=0,o=0;o<r[e].length;o++){if(r[e][o]===t)return i;i+=r[e][o].weight}},r.hasShape=function(){var t=0;return r.linksTo.forEach(function(e){e.outgoing&&t++}),!r.linksTo.length||t!==r.linksTo.length},r.index=this.nodes.push(r)-1,s=r}return s.formatPrefix="node",s.name=s.name||s.options.id||"",s.mass=d(s.options.mass,s.options.marker&&s.options.marker.radius,this.options.marker&&this.options.marker.radius,4),s},t.destroy=o,t.generatePoints=function(){var t=this,e=this.chart,i={};s.generatePoints.call(this),this.nodes||(this.nodes=[]),this.colorCounter=0,this.nodes.forEach(function(t){t.linksFrom.length=0,t.linksTo.length=0,t.level=t.options.level}),this.points.forEach(function(o){n(o.from)&&(i[o.from]||(i[o.from]=t.createNode(o.from)),i[o.from].linksFrom.push(o),o.fromNode=i[o.from],e.styledMode?o.colorIndex=d(o.options.colorIndex,i[o.from].colorIndex):o.color=o.options.color||i[o.from].color),n(o.to)&&(i[o.to]||(i[o.to]=t.createNode(o.to)),i[o.to].linksTo.push(o),o.toNode=i[o.to]),o.name=o.name||o.id},this),this.nodeLookup=i},t.setNodeState=u,t.updateNode=c}(i||(i={})),i}),i(e,"Series/Networkgraph/NetworkgraphPoint.js",[e["Series/NodesComposition.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,i){var o,s=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function i(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)}),r=e.series,n=r.prototype,a=r.prototype.pointClass,h=i.addEvent,p=i.css,d=i.defined,l=i.extend,u=i.pick,c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return s(e,t),e.prototype.destroy=function(){return this.isNode&&this.linksFrom.concat(this.linksTo).forEach(function(t){t.destroyElements&&t.destroyElements()}),this.series.layout.removeElementFromCollection(this,this.series.layout[this.isNode?"nodes":"links"]),a.prototype.destroy.apply(this,arguments)},e.prototype.getDegree=function(){var t=this.isNode?this.linksFrom.length+this.linksTo.length:0;return 0===t?1:t},e.prototype.getLinkAttributes=function(){var t=this.series.options.link,e=this.options;return{"stroke-width":u(e.width,t.width),stroke:e.color||t.color,dashstyle:e.dashStyle||t.dashStyle,opacity:u(e.opacity,t.opacity,1)}},e.prototype.getLinkPath=function(){var t=this.fromNode,e=this.toNode;return t.plotX>e.plotX&&(t=this.toNode,e=this.fromNode),[["M",t.plotX||0,t.plotY||0],["L",e.plotX||0,e.plotY||0]]},e.prototype.getMass=function(){var t=this.fromNode.mass,e=this.toNode.mass,i=t+e;return{fromNode:1-t/i,toNode:1-e/i}},e.prototype.init=function(e,i,o){return t.prototype.init.call(this,e,i,o),this.series.options.draggable&&!this.series.chart.styledMode&&(h(this,"mouseOver",function(){p(this.series.chart.container,{cursor:"move"})}),h(this,"mouseOut",function(){p(this.series.chart.container,{cursor:"default"})})),this},e.prototype.isValid=function(){return!this.isNode||d(this.id)},e.prototype.redrawLink=function(){var t,e=this.getLinkPath();if(this.graphic){this.shapeArgs={d:e},this.series.chart.styledMode||(t=this.series.pointAttribs(this),this.graphic.attr(t),(this.dataLabels||[]).forEach(function(e){e&&e.attr({opacity:t.opacity})})),this.graphic.animate(this.shapeArgs);var i=e[0],o=e[1];"M"===i[0]&&"L"===o[0]&&(this.plotX=(i[1]+o[1])/2,this.plotY=(i[2]+o[2])/2)}},e.prototype.remove=function(t,e){var i,o=this.series,s=o.options.nodes||[],r=s.length;if(this.isNode){for(o.points=[],[].concat(this.linksFrom).concat(this.linksTo).forEach(function(t){(i=t.fromNode.linksFrom.indexOf(t))>-1&&t.fromNode.linksFrom.splice(i,1),(i=t.toNode.linksTo.indexOf(t))>-1&&t.toNode.linksTo.splice(i,1),n.removePoint.call(o,o.data.indexOf(t),!1,!1)}),o.points=o.data.slice(),o.nodes.splice(o.nodes.indexOf(this),1);r--;)if(s[r].id===this.options.id){o.options.nodes.splice(r,1);break}this&&this.destroy(),o.isDirty=!0,o.isDirtyData=!0,t&&o.chart.redraw(t)}else o.removePoint(o.data.indexOf(this),t,e)},e.prototype.renderLink=function(){var t;this.graphic||(this.graphic=this.series.chart.renderer.path(this.getLinkPath()).addClass(this.getClassName(),!0).add(this.series.group),this.series.chart.styledMode||(t=this.series.pointAttribs(this),this.graphic.attr(t),(this.dataLabels||[]).forEach(function(e){e&&e.attr({opacity:t.opacity})})))},e}(a);return l(c.prototype,{setState:t.setNodeState}),c}),i(e,"Series/Networkgraph/NetworkgraphSeriesDefaults.js",[],function(){return{stickyTracking:!1,inactiveOtherPoints:!0,marker:{enabled:!0,states:{inactive:{opacity:.3,animation:{duration:50}}}},states:{inactive:{linkOpacity:.3,animation:{duration:50}}},dataLabels:{formatter:function(){return this.key},linkFormatter:function(){return this.point.fromNode.name+"<br>"+this.point.toNode.name},linkTextPath:{enabled:!0},textPath:{enabled:!1},style:{transition:"opacity 2000ms"},defer:!0,animation:{defer:1e3}},link:{color:"rgba(100, 100, 100, 0.5)",width:1},draggable:!0,layoutAlgorithm:{initialPositions:"circle",initialPositionRadius:1,enableSimulation:!1,theta:.5,maxSpeed:10,approximation:"none",type:"reingold-fruchterman",integration:"euler",maxIterations:1e3,gravitationalConstant:.0625,friction:-.981},showInLegend:!1}}),i(e,"Series/Networkgraph/EulerIntegration.js",[],function(){return{attractive:function(t,e,i,o){var s=t.getMass(),r=i.x/o*e,n=i.y/o*e;t.fromNode.fixedPosition||(t.fromNode.dispX-=r*s.fromNode/t.fromNode.degree,t.fromNode.dispY-=n*s.fromNode/t.fromNode.degree),t.toNode.fixedPosition||(t.toNode.dispX+=r*s.toNode/t.toNode.degree,t.toNode.dispY+=n*s.toNode/t.toNode.degree)},attractiveForceFunction:function(t,e){return t*t/e},barycenter:function(){var t=this.options.gravitationalConstant,e=this.barycenter.xFactor,i=this.barycenter.yFactor;this.nodes.forEach(function(o){if(!o.fixedPosition){var s=o.getDegree(),r=s*(1+s/2);o.dispX+=(e-o.plotX)*t*r/o.degree,o.dispY+=(i-o.plotY)*t*r/o.degree}})},getK:function(t){return Math.pow(t.box.width*t.box.height/t.nodes.length,.3)},integrate:function(t,e){var i;e.dispX+=e.dispX*t.options.friction,e.dispY+=e.dispY*t.options.friction,0!==(i=e.temperature=t.vectorLength({x:e.dispX,y:e.dispY}))&&(e.plotX+=e.dispX/i*Math.min(Math.abs(e.dispX),t.temperature),e.plotY+=e.dispY/i*Math.min(Math.abs(e.dispY),t.temperature))},repulsive:function(t,e,i,o){t.dispX+=i.x/o*e/t.degree,t.dispY+=i.y/o*e/t.degree},repulsiveForceFunction:function(t,e){return e*e/t}}}),i(e,"Series/Networkgraph/QuadTreeNode.js",[],function(){return function(){function t(t){this.body=!1,this.isEmpty=!1,this.isInternal=!1,this.nodes=[],this.box=t,this.boxSize=Math.min(t.width,t.height)}return t.prototype.divideBox=function(){var e=this.box.width/2,i=this.box.height/2;this.nodes[0]=new t({left:this.box.left,top:this.box.top,width:e,height:i}),this.nodes[1]=new t({left:this.box.left+e,top:this.box.top,width:e,height:i}),this.nodes[2]=new t({left:this.box.left+e,top:this.box.top+i,width:e,height:i}),this.nodes[3]=new t({left:this.box.left,top:this.box.top+i,width:e,height:i})},t.prototype.getBoxPosition=function(t){var e=t.plotX<this.box.left+this.box.width/2,i=t.plotY<this.box.top+this.box.height/2;return e?i?0:3:i?1:2},t.prototype.insert=function(e,i){var o;this.isInternal?this.nodes[this.getBoxPosition(e)].insert(e,i-1):(this.isEmpty=!1,this.body?i?(this.isInternal=!0,this.divideBox(),!0!==this.body&&(this.nodes[this.getBoxPosition(this.body)].insert(this.body,i-1),this.body=!0),this.nodes[this.getBoxPosition(e)].insert(e,i-1)):((o=new t({top:e.plotX||NaN,left:e.plotY||NaN,width:.1,height:.1})).body=e,o.isInternal=!1,this.nodes.push(o)):(this.isInternal=!1,this.body=e))},t.prototype.updateMassAndCenter=function(){var t=0,e=0,i=0;if(this.isInternal){for(var o=0,s=this.nodes;o<s.length;o++){var r=s[o];r.isEmpty||(t+=r.mass,e+=r.plotX*r.mass,i+=r.plotY*r.mass)}e/=t,i/=t}else this.body&&(t=this.body.mass,e=this.body.plotX,i=this.body.plotY);this.mass=t,this.plotX=e,this.plotY=i},t}()}),i(e,"Series/Networkgraph/QuadTree.js",[e["Series/Networkgraph/QuadTreeNode.js"]],function(t){return function(){function e(e,i,o,s){this.box={left:e,top:i,width:o,height:s},this.maxDepth=25,this.root=new t(this.box),this.root.isInternal=!0,this.root.isRoot=!0,this.root.divideBox()}return e.prototype.calculateMassAndCenter=function(){this.visitNodeRecursive(null,null,function(t){t.updateMassAndCenter()})},e.prototype.insertNodes=function(t){for(var e=0;e<t.length;e++){var i=t[e];this.root.insert(i,this.maxDepth)}},e.prototype.visitNodeRecursive=function(t,e,i){var o;if(t||(t=this.root),t===this.root&&e&&(o=e(t)),!1!==o){for(var s=0,r=t.nodes;s<r.length;s++){var n=r[s];if(n.isInternal){if(e&&(o=e(n)),!1===o)continue;this.visitNodeRecursive(n,e,i)}else n.body&&e&&e(n.body);i&&i(n)}t===this.root&&i&&i(t)}},e}()}),i(e,"Series/Networkgraph/VerletIntegration.js",[],function(){return{attractive:function(t,e,i){var o=t.getMass(),s=-i.x*e*this.diffTemperature,r=-i.y*e*this.diffTemperature;t.fromNode.fixedPosition||(t.fromNode.plotX-=s*o.fromNode/t.fromNode.degree,t.fromNode.plotY-=r*o.fromNode/t.fromNode.degree),t.toNode.fixedPosition||(t.toNode.plotX+=s*o.toNode/t.toNode.degree,t.toNode.plotY+=r*o.toNode/t.toNode.degree)},attractiveForceFunction:function(t,e){return(e-t)/t},barycenter:function(){var t=this.options.gravitationalConstant,e=this.barycenter.xFactor,i=this.barycenter.yFactor;e=(e-(this.box.left+this.box.width)/2)*t,i=(i-(this.box.top+this.box.height)/2)*t,this.nodes.forEach(function(t){t.fixedPosition||(t.plotX-=e/t.mass/t.degree,t.plotY-=i/t.mass/t.degree)})},getK:function(t){return Math.pow(t.box.width*t.box.height/t.nodes.length,.5)},integrate:function(t,e){var i=-t.options.friction,o=t.options.maxSpeed,s=e.prevX,r=e.prevY,n=(e.plotX+e.dispX-s)*i,a=(e.plotY+e.dispY-r)*i,h=Math.abs,p=h(n)/(n||1),d=h(a)/(a||1);n=p*Math.min(o,Math.abs(n)),a=d*Math.min(o,Math.abs(a)),e.prevX=e.plotX+e.dispX,e.prevY=e.plotY+e.dispY,e.plotX+=n,e.plotY+=a,e.temperature=t.vectorLength({x:n,y:a})},repulsive:function(t,e,i){var o=e*this.diffTemperature/t.mass/t.degree;t.fixedPosition||(t.plotX+=i.x*o,t.plotY+=i.y*o)},repulsiveForceFunction:function(t,e){return(e-t)/t*(e>t?1:0)}}}),i(e,"Series/Networkgraph/ReingoldFruchtermanLayout.js",[e["Series/Networkgraph/EulerIntegration.js"],e["Core/Globals.js"],e["Series/GraphLayoutComposition.js"],e["Series/Networkgraph/QuadTree.js"],e["Core/Utilities.js"],e["Series/Networkgraph/VerletIntegration.js"]],function(t,e,i,o,s,r){var n=e.win,a=s.clamp,h=s.defined,p=s.isFunction,d=s.fireEvent,l=s.pick;return function(){function e(){this.attractiveForce=void 0,this.box={},this.currentStep=0,this.initialRendering=!0,this.integration=void 0,this.links=[],this.nodes=[],this.options=void 0,this.quadTree=void 0,this.repulsiveForce=void 0,this.series=[],this.simulation=!1}return e.compose=function(o){i.compose(o),i.integrations.euler=t,i.integrations.verlet=r,i.layouts["reingold-fruchterman"]=e},e.prototype.init=function(t){this.options=t,this.nodes=[],this.links=[],this.series=[],this.box={x:0,y:0,width:0,height:0},this.setInitialRendering(!0),this.integration=i.integrations[t.integration],this.enableSimulation=t.enableSimulation,this.attractiveForce=l(t.attractiveForce,this.integration.attractiveForceFunction),this.repulsiveForce=l(t.repulsiveForce,this.integration.repulsiveForceFunction),this.approximation=t.approximation},e.prototype.updateSimulation=function(t){this.enableSimulation=l(t,this.options.enableSimulation)},e.prototype.start=function(){var t=this.series,e=this.options;this.currentStep=0,this.forces=t[0]&&t[0].forces||[],this.chart=t[0]&&t[0].chart,this.initialRendering&&(this.initPositions(),t.forEach(function(t){t.finishedAnimating=!0,t.render()})),this.setK(),this.resetSimulation(e),this.enableSimulation&&this.step()},e.prototype.step=function(){var t=this,e=this.series;this.currentStep++,"barnes-hut"===this.approximation&&(this.createQuadTree(),this.quadTree.calculateMassAndCenter());for(var i=0,o=this.forces||[];i<o.length;i++)this[o[i]+"Forces"](this.temperature);if(this.applyLimits(),this.temperature=this.coolDown(this.startTemperature,this.diffTemperature,this.currentStep),this.prevSystemTemperature=this.systemTemperature,this.systemTemperature=this.getSystemTemperature(),this.enableSimulation){for(var s=0;s<e.length;s++){var r=e[s];r.chart&&r.render()}this.maxIterations--&&isFinite(this.temperature)&&!this.isStable()?(this.simulation&&n.cancelAnimationFrame(this.simulation),this.simulation=n.requestAnimationFrame(function(){return t.step()})):(this.simulation=!1,this.series.forEach(function(t){d(t,"afterSimulation")}))}},e.prototype.stop=function(){this.simulation&&n.cancelAnimationFrame(this.simulation)},e.prototype.setArea=function(t,e,i,o){this.box={left:t,top:e,width:i,height:o}},e.prototype.setK=function(){this.k=this.options.linkLength||this.integration.getK(this)},e.prototype.addElementsToCollection=function(t,e){for(var i=0;i<t.length;i++){var o=t[i];-1===e.indexOf(o)&&e.push(o)}},e.prototype.removeElementFromCollection=function(t,e){var i=e.indexOf(t);-1!==i&&e.splice(i,1)},e.prototype.clear=function(){this.nodes.length=0,this.links.length=0,this.series.length=0,this.resetSimulation()},e.prototype.resetSimulation=function(){this.forcedStop=!1,this.systemTemperature=0,this.setMaxIterations(),this.setTemperature(),this.setDiffTemperature()},e.prototype.restartSimulation=function(){this.simulation?this.resetSimulation():(this.setInitialRendering(!1),this.enableSimulation?this.start():this.setMaxIterations(1),this.chart&&this.chart.redraw(),this.setInitialRendering(!0))},e.prototype.setMaxIterations=function(t){this.maxIterations=l(t,this.options.maxIterations)},e.prototype.setTemperature=function(){this.temperature=this.startTemperature=Math.sqrt(this.nodes.length)},e.prototype.setDiffTemperature=function(){this.diffTemperature=this.startTemperature/(this.options.maxIterations+1)},e.prototype.setInitialRendering=function(t){this.initialRendering=t},e.prototype.createQuadTree=function(){this.quadTree=new o(this.box.left,this.box.top,this.box.width,this.box.height),this.quadTree.insertNodes(this.nodes)},e.prototype.initPositions=function(){var t=this.options.initialPositions;if(p(t)){t.call(this);for(var e=0,i=this.nodes;e<i.length;e++){var o=i[e];h(o.prevX)||(o.prevX=o.plotX),h(o.prevY)||(o.prevY=o.plotY),o.dispX=0,o.dispY=0}}else"circle"===t?this.setCircularPositions():this.setRandomPositions()},e.prototype.setCircularPositions=function(){for(var t,e=this.box,i=this.nodes,o=2*Math.PI/(i.length+1),s=i.filter(function(t){return 0===t.linksTo.length}),r={},n=this.options.initialPositionRadius,a=function(t){for(var e=0,i=t.linksFrom||[];e<i.length;e++){var o=i[e];r[o.toNode.id]||(r[o.toNode.id]=!0,h.push(o.toNode),a(o.toNode))}},h=[],p=0;p<s.length;p++){var d=s[p];h.push(d),a(d)}if(h.length)for(var u=0;u<i.length;u++){var c=i[u];-1===h.indexOf(c)&&h.push(c)}else h=i;for(var f=0,m=h.length;f<m;++f)(t=h[f]).plotX=t.prevX=l(t.plotX,e.width/2+n*Math.cos(f*o)),t.plotY=t.prevY=l(t.plotY,e.height/2+n*Math.sin(f*o)),t.dispX=0,t.dispY=0},e.prototype.setRandomPositions=function(){for(var t,e=this.box,i=this.nodes,o=i.length+1,s=function(t){var e=t*t/Math.PI;return e-Math.floor(e)},r=0,n=i.length;r<n;++r)(t=i[r]).plotX=t.prevX=l(t.plotX,e.width*s(r)),t.plotY=t.prevY=l(t.plotY,e.height*s(o+r)),t.dispX=0,t.dispY=0},e.prototype.force=function(t){for(var e=[],i=1;i<arguments.length;i++)e[i-1]=arguments[i];this.integration[t].apply(this,e)},e.prototype.barycenterForces=function(){this.getBarycenter(),this.force("barycenter")},e.prototype.getBarycenter=function(){for(var t=0,e=0,i=0,o=0,s=this.nodes;o<s.length;o++){var r=s[o];e+=r.plotX*r.mass,i+=r.plotY*r.mass,t+=r.mass}return this.barycenter={x:e,y:i,xFactor:e/t,yFactor:i/t},this.barycenter},e.prototype.barnesHutApproximation=function(t,e){var i,o,s=this.getDistXY(t,e),r=this.vectorLength(s);return t!==e&&0!==r&&(e.isInternal?e.boxSize/r<this.options.theta&&0!==r?(o=this.repulsiveForce(r,this.k),this.force("repulsive",t,o*e.mass,s,r),i=!1):i=!0:(o=this.repulsiveForce(r,this.k),this.force("repulsive",t,o*e.mass,s,r))),i},e.prototype.repulsiveForces=function(){var t=this;if("barnes-hut"===this.approximation)for(var e=function(e){i.quadTree.visitNodeRecursive(null,function(i){return t.barnesHutApproximation(e,i)})},i=this,o=0,s=this.nodes;o<s.length;o++){var r=s[o];e(r)}else for(var n=void 0,a=void 0,h=void 0,p=0,d=this.nodes;p<d.length;p++)for(var r=d[p],l=0,u=this.nodes;l<u.length;l++){var c=u[l];r===c||r.fixedPosition||(h=this.getDistXY(r,c),0!==(a=this.vectorLength(h))&&(n=this.repulsiveForce(a,this.k),this.force("repulsive",r,n*c.mass,h,a)))}},e.prototype.attractiveForces=function(){for(var t,e,i,o=0,s=this.links;o<s.length;o++){var r=s[o];r.fromNode&&r.toNode&&(t=this.getDistXY(r.fromNode,r.toNode),0!==(e=this.vectorLength(t))&&(i=this.attractiveForce(e,this.k),this.force("attractive",r,i,t,e)))}},e.prototype.applyLimits=function(){for(var t=this.nodes,e=0;e<t.length;e++){var i=t[e];if(i.fixedPosition)return;this.integration.integrate(this,i),this.applyLimitBox(i,this.box),i.dispX=0,i.dispY=0}},e.prototype.applyLimitBox=function(t,e){var i=t.radius;t.plotX=a(t.plotX,e.left+i,e.width-i),t.plotY=a(t.plotY,e.top+i,e.height-i)},e.prototype.coolDown=function(t,e,i){return t-e*i},e.prototype.isStable=function(){return 1e-5>Math.abs(this.systemTemperature-this.prevSystemTemperature)||this.temperature<=0},e.prototype.getSystemTemperature=function(){for(var t=0,e=0,i=this.nodes;e<i.length;e++)t+=i[e].temperature;return t},e.prototype.vectorLength=function(t){return Math.sqrt(t.x*t.x+t.y*t.y)},e.prototype.getDistR=function(t,e){var i=this.getDistXY(t,e);return this.vectorLength(i)},e.prototype.getDistXY=function(t,e){var i=t.plotX-e.plotX,o=t.plotY-e.plotY;return{x:i,y:o,absX:Math.abs(i),absY:Math.abs(o)}},e}()}),i(e,"Series/SimulationSeriesUtilities.js",[e["Core/Utilities.js"],e["Core/Animation/AnimationUtilities.js"]],function(t,e){var i=t.syncTimeout,o=e.animObject;return{initDataLabels:function(){var t=this.options.dataLabels;if(!this.dataLabelsGroup){var e=this.initDataLabelsGroup();return!this.chart.styledMode&&(null==t?void 0:t.style)&&e.css(t.style),e.attr({opacity:0}),this.visible&&e.show(),e}return this.dataLabelsGroup.attr({opacity:1}),this.dataLabelsGroup},initDataLabelsDefer:function(){var t,e=this,s=this.options.dataLabels;(null==s?void 0:s.defer)&&(null===(t=this.options.layoutAlgorithm)||void 0===t?void 0:t.enableSimulation)?i(function(){e.deferDataLabels=!1},s?o(s.animation).defer:0):this.deferDataLabels=!1}}}),i(e,"Series/Networkgraph/NetworkgraphSeries.js",[e["Series/DragNodesComposition.js"],e["Series/GraphLayoutComposition.js"],e["Core/Globals.js"],e["Series/Networkgraph/NetworkgraphPoint.js"],e["Series/Networkgraph/NetworkgraphSeriesDefaults.js"],e["Series/NodesComposition.js"],e["Series/Networkgraph/ReingoldFruchtermanLayout.js"],e["Core/Series/SeriesRegistry.js"],e["Series/SimulationSeriesUtilities.js"],e["Core/Utilities.js"]],function(t,e,i,o,s,r,n,a,h,p){var d,l=this&&this.__extends||(d=function(t,e){return(d=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function i(){this.constructor=t}d(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)}),u=i.noop,c=a.series,f=a.seriesTypes,m=f.column.prototype,y=f.line.prototype,g=h.initDataLabels,v=h.initDataLabelsDefer,b=p.addEvent,x=p.defined,k=p.extend,N=p.merge,w=p.pick,S=function(i){function o(){var t=null!==i&&i.apply(this,arguments)||this;return t.data=void 0,t.nodes=void 0,t.options=void 0,t.points=void 0,t.deferDataLabels=!0,t}return l(o,i),o.compose=function(e){t.compose(e),n.compose(e)},o.prototype.deferLayout=function(){var t,i=this.options.layoutAlgorithm,o=this.chart.graphLayoutsStorage,s=this.chart.graphLayoutsLookup,r=this.chart.options.chart;this.visible&&(o||(this.chart.graphLayoutsStorage=o={},this.chart.graphLayoutsLookup=s=[]),(t=o[i.type])||(i.enableSimulation=x(r.forExport)?!r.forExport:i.enableSimulation,o[i.type]=t=new e.layouts[i.type],t.init(i),s.splice(t.index,0,t)),this.layout=t,t.setArea(0,0,this.chart.plotWidth,this.chart.plotHeight),t.addElementsToCollection([this],t.series),t.addElementsToCollection(this.nodes,t.nodes),t.addElementsToCollection(this.points,t.links))},o.prototype.destroy=function(){this.layout&&this.layout.removeElementFromCollection(this,this.layout.series),r.destroy.call(this)},o.prototype.drawDataLabels=function(){if(!this.deferDataLabels){var t,e=this.options.dataLabels;(null==e?void 0:e.textPath)&&(t=e.textPath),c.prototype.drawDataLabels.call(this,this.nodes),(null==e?void 0:e.linkTextPath)&&(e.textPath=e.linkTextPath),c.prototype.drawDataLabels.call(this,this.data),(null==e?void 0:e.textPath)&&(e.textPath=t)}},o.prototype.generatePoints=function(){var t,e;for(r.generatePoints.apply(this,arguments),this.options.nodes&&this.options.nodes.forEach(function(t){this.nodeLookup[t.id]||(this.nodeLookup[t.id]=this.createNode(t.id))},this),e=this.nodes.length-1;e>=0;e--)(t=this.nodes[e]).degree=t.getDegree(),t.radius=w(t.marker&&t.marker.radius,this.options.marker&&this.options.marker.radius,0),this.nodeLookup[t.id]||t.remove();this.data.forEach(function(t){t.formatPrefix="link"}),this.indexateNodes()},o.prototype.getPointsCollection=function(){return this.nodes||[]},o.prototype.indexateNodes=function(){this.nodes.forEach(function(t,e){t.index=e})},o.prototype.init=function(t,e){var o=this;return i.prototype.init.call(this,t,e),v.call(this),b(this,"updatedData",function(){o.layout&&o.layout.stop()}),b(this,"afterUpdate",function(){o.nodes.forEach(function(t){t&&t.series&&t.resolveColor()})}),b(this,"afterSimulation",function(){this.deferDataLabels=!1,this.drawDataLabels()}),this},o.prototype.markerAttribs=function(t,e){var i=c.prototype.markerAttribs.call(this,t,e);return x(t.plotY)||(i.y=0),i.x=(t.plotX||0)-(i.width||0)/2,i},o.prototype.pointAttribs=function(t,e){var i=e||t&&t.state||"normal",o=c.prototype.pointAttribs.call(this,t,i),s=this.options.states[i];return t&&!t.isNode&&(o=t.getLinkAttributes(),s&&(o={stroke:s.linkColor||o.stroke,dashstyle:s.linkDashStyle||o.dashstyle,opacity:w(s.linkOpacity,o.opacity),"stroke-width":s.linkColor||o["stroke-width"]})),o},o.prototype.render=function(){var t=this.points,e=this.chart.hoverPoint,i=[];this.points=this.nodes,y.render.call(this),this.points=t,t.forEach(function(t){t.fromNode&&t.toNode&&(t.renderLink(),t.redrawLink())}),e&&e.series===this&&this.redrawHalo(e),this.chart.hasRendered&&!this.options.dataLabels.allowOverlap&&(this.nodes.concat(this.points).forEach(function(t){t.dataLabel&&i.push(t.dataLabel)}),this.chart.hideOverlappingLabels(i))},o.prototype.setState=function(t,e){e?(this.points=this.nodes.concat(this.data),c.prototype.setState.apply(this,arguments),this.points=this.data):c.prototype.setState.apply(this,arguments),this.layout.simulation||t||this.render()},o.prototype.translate=function(){this.processedXData||this.processData(),this.generatePoints(),this.deferLayout(),this.nodes.forEach(function(t){t.isInside=!0,t.linksFrom.forEach(function(t){t.shapeType="path",t.y=1})})},o.defaultOptions=N(c.defaultOptions,s),o}(c);return k(S.prototype,{pointClass:o,animate:void 0,directTouch:!0,drawGraph:void 0,forces:["barycenter","repulsive","attractive"],hasDraggableNodes:!0,isCartesian:!1,noSharedTooltip:!0,pointArrayMap:["from","to"],requireSorting:!1,trackerGroups:["group","markerGroup","dataLabelsGroup"],initDataLabels:g,buildKDTree:u,createNode:r.createNode,drawTracker:m.drawTracker,onMouseDown:t.onMouseDown,onMouseMove:t.onMouseMove,onMouseUp:t.onMouseUp,redrawHalo:t.redrawHalo}),a.registerSeriesType("networkgraph",S),S}),i(e,"masters/modules/networkgraph.src.js",[e["Core/Globals.js"],e["Series/Networkgraph/NetworkgraphSeries.js"]],function(t,e){e.compose(t.Chart)})});//# sourceMappingURL=networkgraph.js.map