/**
 * Highcharts JS v11.2.0 (2023-10-30)
 *
 * Module for adding patterns and images as point fills.
 *
 * (c) 2010-2021 Highsoft AS
 * Author: Torstein Hønsi, Øystein Moseng
 *
 * License: www.highcharts.com/license
 */!function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/pattern-fill",["highcharts"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function r(t,e,r,i){t.hasOwnProperty(e)||(t[e]=i.apply(null,r),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:t[e]}})))}r(e,"Extensions/PatternFill.js",[e["Core/Animation/AnimationUtilities.js"],e["Core/Chart/Chart.js"],e["Core/Globals.js"],e["Core/Defaults.js"],e["Core/Series/Point.js"],e["Core/Series/Series.js"],e["Core/Renderer/SVG/SVGRenderer.js"],e["Core/Utilities.js"]],function(t,e,r,i,a,n,o,s){var h,c,d=t.animObject,p=i.getOptions,l=s.addEvent,f=s.defined,u=s.erase,g=s.merge,m=s.pick,y=s.removeEvent,x=s.wrap,w=r.patterns=(h=[],c=p().colors,["M 0 0 L 5 5 M 4.5 -0.5 L 5.5 0.5 M -0.5 4.5 L 0.5 5.5","M 0 5 L 5 0 M -0.5 0.5 L 0.5 -0.5 M 4.5 5.5 L 5.5 4.5","M 2 0 L 2 5 M 4 0 L 4 5","M 0 2 L 5 2 M 0 4 L 5 4","M 0 1.5 L 2.5 1.5 L 2.5 0 M 2.5 5 L 2.5 3.5 L 5 3.5"].forEach(function(t,e){h.push({path:t,color:c[e],width:5,height:5,patternTransform:"scale(1.4 1.4)"})}),["M 0 0 L 5 10 L 10 0","M 3 3 L 8 3 L 8 8 L 3 8 Z","M 5 5 m -4 0 a 4 4 0 1 1 8 0 a 4 4 0 1 1 -8 0","M 0 0 L 10 10 M 9 -1 L 11 1 M -1 9 L 1 11","M 0 10 L 10 0 M -1 1 L 1 -1 M 9 11 L 11 9"].forEach(function(t,e){h.push({path:t,color:c[e+5],width:10,height:10})}),h);function M(t,e){var r,i=JSON.stringify(t),a=i.length||0,n=0,o=0;if(e){r=Math.max(Math.floor(a/500),1);for(var s=0;s<a;s+=r)n+=i.charCodeAt(s);n&=n}for(;o<a;++o)n=(n<<5)-n+i.charCodeAt(o),n&=n;return n.toString(16).replace("-","1")}a.prototype.calculatePatternDimensions=function(t){if(!t.width||!t.height){var e=this.graphic&&(this.graphic.getBBox&&this.graphic.getBBox(!0)||this.graphic.element&&this.graphic.element.getBBox())||{},r=this.shapeArgs;if(r&&(e.width=r.width||e.width,e.height=r.height||e.height,e.x=r.x||e.x,e.y=r.y||e.y),t.image){if(!e.width||!e.height){t._width="defer",t._height="defer";var i=this.series.chart.mapView&&this.series.chart.mapView.getSVGTransform().scaleY;f(i)&&i<0&&(t._inverted=!0);return}t.aspectRatio&&(e.aspectRatio=e.width/e.height,t.aspectRatio>e.aspectRatio?e.aspectWidth=e.height*t.aspectRatio:e.aspectHeight=e.width/t.aspectRatio),t._width=t.width||Math.ceil(e.aspectWidth||e.width),t._height=t.height||Math.ceil(e.aspectHeight||e.height)}t.width||(t._x=t.x||0,t._x+=e.x-Math.round(e.aspectWidth?Math.abs(e.aspectWidth-e.width)/2:0)),t.height||(t._y=t.y||0,t._y+=e.y-Math.round(e.aspectHeight?Math.abs(e.aspectHeight-e.height)/2:0))}},o.prototype.addPattern=function(t,e){var r,i,a,n=m(e,!0),o=d(n),h=t.width||t._width||32,c=t.height||t._height||32,p=t.color||"#343434",l=t.id,f=this;if(!l&&(this.idCounter=this.idCounter||0,l="highcharts-pattern-"+this.idCounter+"-"+(this.chartIndex||0),++this.idCounter),this.forExport&&(l+="-export"),this.defIds=this.defIds||[],!(this.defIds.indexOf(l)>-1)){this.defIds.push(l);var u={id:l,patternUnits:"userSpaceOnUse",patternContentUnits:t.patternContentUnits||"userSpaceOnUse",width:h,height:c,x:t._x||t.x||0,y:t._y||t.y||0};return t._inverted&&(u.patternTransform="scale(1, -1)",t.patternTransform&&(t.patternTransform+=" scale(1, -1)")),t.patternTransform&&(u.patternTransform=t.patternTransform),(r=this.createElement("pattern").attr(u).add(this.defs)).id=l,t.path?(i=s.isObject(t.path)?t.path:{d:t.path},t.backgroundColor&&function(t){f.rect(0,0,h,c).attr({fill:t}).add(r)}(t.backgroundColor),a={d:i.d},this.styledMode||(a.stroke=i.stroke||p,a["stroke-width"]=m(i.strokeWidth,2),a.fill=i.fill||"none"),i.transform&&(a.transform=i.transform),this.createElement("path").attr(a).add(r),r.color=p):t.image&&(n?this.image(t.image,0,0,h,c,function(){this.animate({opacity:m(t.opacity,1)},o),y(this.element,"load")}).attr({opacity:0}).add(r):this.image(t.image,0,0,h,c).add(r)),t.image&&n||void 0===t.opacity||[].forEach.call(r.element.childNodes,function(e){e.setAttribute("opacity",t.opacity)}),this.patternElements=this.patternElements||{},this.patternElements[l]=r,r}},x(n.prototype,"getColor",function(t){var e=this.options.color;e&&e.pattern&&!e.pattern.color?(delete this.options.color,t.apply(this,Array.prototype.slice.call(arguments,1)),e.pattern.color=this.color,this.color=this.options.color=e):t.apply(this,Array.prototype.slice.call(arguments,1))}),l(n,"render",function(){var t=this.chart.isResizing;(this.isDirtyData||t||!this.chart.hasRendered)&&(this.points||[]).forEach(function(e){var r=e.options&&e.options.color;r&&r.pattern&&(t&&!(e.shapeArgs&&e.shapeArgs.width&&e.shapeArgs.height)?(r.pattern._width="defer",r.pattern._height="defer"):e.calculatePatternDimensions(r.pattern))})}),l(a,"afterInit",function(){var t=this.options.color;t&&t.pattern&&("string"==typeof t.pattern.path&&(t.pattern.path={d:t.pattern.path}),this.color=this.options.color=g(this.series.options.color,t))}),l(o,"complexColor",function(t){var e=t.args[0],r=t.args[1],i=t.args[2],n=this.chartIndex||0,o=e.pattern,s="#343434";if(void 0!==e.patternIndex&&w&&(o=w[e.patternIndex]),!o)return!0;if(o.image||"string"==typeof o.path||o.path&&o.path.d){var h=i.parentNode&&i.parentNode.getAttribute("class");h=h&&h.indexOf("highcharts-legend")>-1,("defer"===o._width||"defer"===o._height)&&a.prototype.calculatePatternDimensions.call({graphic:{element:i}},o),(h||!o.id)&&((o=g({},o)).id="highcharts-pattern-"+n+"-"+M(o)+M(o,!0)),this.addPattern(o,!this.forExport&&m(o.animation,this.globalAnimation,{duration:100})),s="url(".concat(this.url,"#").concat(o.id+(this.forExport?"-export":""),")")}else s=o.color||s;return i.setAttribute(r,s),e.toString=function(){return s},!1}),l(e,"endResize",function(){(this.renderer&&this.renderer.defIds||[]).filter(function(t){return t&&t.indexOf&&0===t.indexOf("highcharts-pattern-")}).length&&(this.series.forEach(function(t){t.visible&&t.points.forEach(function(t){var e=t.options&&t.options.color;e&&e.pattern&&(e.pattern._width="defer",e.pattern._height="defer")})}),this.redraw(!1))}),l(e,"redraw",function(){var t={},e=this.renderer,r=(e.defIds||[]).filter(function(t){return t.indexOf&&0===t.indexOf("highcharts-pattern-")});r.length&&([].forEach.call(this.renderTo.querySelectorAll('[color^="url("], [fill^="url("], [stroke^="url("]'),function(r){var i=r.getAttribute("fill")||r.getAttribute("color")||r.getAttribute("stroke");i&&(t[i.replace(e.url,"").replace("url(#","").replace(")","")]=!0)}),r.forEach(function(r){!t[r]&&(u(e.defIds,r),e.patternElements[r]&&(e.patternElements[r].destroy(),delete e.patternElements[r]))}))})}),r(e,"masters/modules/pattern-fill.src.js",[],function(){})});//# sourceMappingURL=pattern-fill.js.map