/**
 * Highcharts JS v11.2.0 (2023-10-30)
 *
 * Sonification module
 *
 * (c) 2010-2022 Highsoft AS
 * Author: Øystein Moseng
 *
 * License: www.highcharts.com/license
 */!function(e){"object"==typeof module&&module.exports?(e.default=e,module.exports=e):"function"==typeof define&&define.amd?define("highcharts/modules/sonification",["highcharts"],function(t){return e(t),e.Highcharts=t,e}):e("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(e){"use strict";var t=e?e._modules:{};function i(e,t,i,n){e.hasOwnProperty(t)||(e[t]=n.apply(null,i),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:t,module:e[t]}})))}i(t,"Extensions/Sonification/Options.js",[],function(){return{sonification:{enabled:!0,duration:6e3,afterSeriesWait:700,updateInterval:200,masterVolume:.7,order:"sequential",showTooltip:!0,showCrosshair:!0,pointGrouping:{enabled:!0,groupTimespan:15,algorithm:"minmax",prop:"y"},defaultInstrumentOptions:{roundToMusicalNotes:!0,instrument:"piano",mapping:{time:"x",pan:"x",noteDuration:200,pitch:{mapTo:"y",min:"c2",max:"c6",within:"yAxis"},gapBetweenNotes:100}},defaultSpeechOptions:{language:"en-US",mapping:{time:"x",rate:1.3,volume:.4},pointGrouping:{algorithm:"last"}}},exporting:{menuItemDefinitions:{downloadMIDI:{textKey:"downloadMIDI",onclick:function(){this.sonification&&this.sonification.downloadMIDI()}},playAsSound:{textKey:"playAsSound",onclick:function(){var e=this.sonification;e&&e.isPlaying()?e.cancel():this.sonify()}}}},lang:{downloadMIDI:"Download MIDI",playAsSound:"Play as sound"}}}),i(t,"Extensions/Sonification/SynthPatch.js",[t["Core/Utilities.js"]],function(e){var t=this&&this.__assign||function(){return(t=Object.assign||function(e){for(var t,i=1,n=arguments.length;i<n;i++)for(var o in t=arguments[i])Object.prototype.hasOwnProperty.call(t,o)&&(e[o]=t[o]);return e}).apply(this,arguments)},i=e.clamp,n=e.defined,o=e.pick;function s(e,t){return(.2414*e-.2414)*Math.log(t)+(3.5-1.7*e)/1.8}function a(e,t,i){e.gain.cancelScheduledValues(t),e.gain.setTargetAtTime(i,t,u.stopRampTime/4),e.gain.setValueAtTime(i,t+u.stopRampTime)}function r(e,t,i,n,o){void 0===o&&(o=1);var s="attack"===t,r=n.gain;if(r.cancelScheduledValues(i),!e.length){a(n,i,s?o:0);return}e[0].t>1&&e.unshift({t:0,vol:s?0:1}),e.forEach(function(t,n){var s=e[n-1],a=s?(t.t-s.t)/1e3:0,l=i+(s?s.t/1e3+u.stopRampTime:0);r.setTargetAtTime(t.vol*o,l,Math.max(a,u.stopRampTime)/2)})}var l=function(){function e(e,t){this.pulseWidth=Math.min(Math.max(0,t.pulseWidth||.5));var i=function(){return new OscillatorNode(e,{type:"sawtooth",detune:t.detune,frequency:Math.max(1,t.frequency||350)})};this.sawOscA=i(),this.sawOscB=i(),this.phaseInverter=new GainNode(e,{gain:-1}),this.masterGain=new GainNode(e),this.delayNode=new DelayNode(e,{delayTime:this.pulseWidth/this.sawOscA.frequency.value}),this.sawOscA.connect(this.masterGain),this.sawOscB.connect(this.phaseInverter),this.phaseInverter.connect(this.delayNode),this.delayNode.connect(this.masterGain)}return e.prototype.connect=function(e){this.masterGain.connect(e)},e.prototype.getFrequencyFacade=function(){var e=this;return{cancelScheduledValues:function(t){return e.sawOscA.frequency.cancelScheduledValues(t),e.sawOscB.frequency.cancelScheduledValues(t),e.delayNode.delayTime.cancelScheduledValues(t),e.sawOscA.frequency},setValueAtTime:function(t,i){return this.cancelScheduledValues(i),e.sawOscA.frequency.setValueAtTime(t,i),e.sawOscB.frequency.setValueAtTime(t,i),e.delayNode.delayTime.setValueAtTime(Math.round(1e4*e.pulseWidth/t)/1e4,i),e.sawOscA.frequency},setTargetAtTime:function(t,i,n){return this.cancelScheduledValues(i),e.sawOscA.frequency.setTargetAtTime(t,i,n),e.sawOscB.frequency.setTargetAtTime(t,i,n),e.delayNode.delayTime.setTargetAtTime(Math.round(1e4*e.pulseWidth/t)/1e4,i,n),e.sawOscA.frequency}}},e.prototype.getPWMTarget=function(){return this.delayNode.delayTime},e.prototype.start=function(){this.sawOscA.start(),this.sawOscB.start()},e.prototype.stop=function(e){this.sawOscA.stop(e),this.sawOscB.stop(e)},e}(),c=function(){function e(e,t,i){this.audioContext=e,this.options=t,this.fmOscillatorIx=t.fmOscillator,this.vmOscillatorIx=t.vmOscillator,this.createSoundSource(),this.createGain(),this.createFilters(),this.createVolTracking(),i&&this.connect(i)}return e.prototype.connect=function(e){[this.lowpassNode,this.highpassNode,this.volTrackingNode,this.vmNode,this.gainNode,this.whiteNoise,this.pulseNode,this.oscNode].reduce(function(e,t){return t?(t.connect(e),t):e},e)},e.prototype.start=function(){this.oscNode&&this.oscNode.start(),this.whiteNoise&&this.whiteNoise.start(),this.pulseNode&&this.pulseNode.start()},e.prototype.stopAtTime=function(e){this.oscNode&&this.oscNode.stop(e),this.whiteNoise&&this.whiteNoise.stop(e),this.pulseNode&&this.pulseNode.stop(e)},e.prototype.setFreqAtTime=function(e,t,n){void 0===n&&(n=0);var s=this.options,a=i(o(s.fixedFrequency,t)*(s.freqMultiplier||1),0,21e3),r=this.getOscTarget(),l=n/5e3;r&&(r.cancelScheduledValues(e),n&&e-(this.lastUpdateTime||-1)>.01?(r.setTargetAtTime(a,e,l),r.setValueAtTime(a,e+l)):r.setValueAtTime(a,e)),this.scheduleVolTrackingChange(a,e,n),this.scheduleFilterTrackingChange(a,e,n),this.lastUpdateTime=e},e.prototype.getFMTarget=function(){return this.oscNode&&this.oscNode.detune||this.whiteNoise&&this.whiteNoise.detune||this.pulseNode&&this.pulseNode.getPWMTarget()},e.prototype.getVMTarget=function(){return this.vmNode&&this.vmNode.gain},e.prototype.runEnvelopeAtTime=function(e,t){this.gainNode&&r(("attack"===e?this.options.attackEnvelope:this.options.releaseEnvelope)||[],e,t,this.gainNode,this.options.volume)},e.prototype.cancelScheduled=function(){this.gainNode&&this.gainNode.gain.cancelScheduledValues(this.audioContext.currentTime);var e=this.getOscTarget();e&&e.cancelScheduledValues(0),this.lowpassNode&&this.lowpassNode.frequency.cancelScheduledValues(0),this.highpassNode&&this.highpassNode.frequency.cancelScheduledValues(0),this.volTrackingNode&&this.volTrackingNode.gain.cancelScheduledValues(0)},e.prototype.scheduleVolTrackingChange=function(e,t,i){if(this.volTrackingNode){var n=s(this.options.volumePitchTrackingMultiplier||1,e),o=i?i/1e3:u.stopRampTime;this.volTrackingNode.gain.cancelScheduledValues(t),this.volTrackingNode.gain.setTargetAtTime(n,t,o/5),this.volTrackingNode.gain.setValueAtTime(n,t+o)}},e.prototype.scheduleFilterTrackingChange=function(e,t,n){var o=this.options,a=n?n/1e3:u.stopRampTime,r=function(n,o){var r=s(o.frequencyPitchTrackingMultiplier||1,e),l=i((o.frequency||1e3)*r,0,21e3);n.frequency.cancelScheduledValues(t),n.frequency.setTargetAtTime(l,t,a/5),n.frequency.setValueAtTime(l,t+a)};this.lowpassNode&&o.lowpass&&r(this.lowpassNode,o.lowpass),this.highpassNode&&o.highpass&&r(this.highpassNode,o.highpass)},e.prototype.createGain=function(){var e=this.options;(n(e.volume)||e.attackEnvelope&&e.attackEnvelope.length||e.releaseEnvelope&&e.releaseEnvelope.length)&&(this.gainNode=new GainNode(this.audioContext,{gain:o(e.volume,1)})),this.vmNode=new GainNode(this.audioContext)},e.prototype.createSoundSource=function(){var e=this.options,t=this.audioContext,i=(e.fixedFrequency||0)*(e.freqMultiplier||1);if("whitenoise"===e.type){for(var n=2*t.sampleRate,o=t.createBuffer(1,n,t.sampleRate),s=o.getChannelData(0),a=0;a<n;++a)s[a]=1.2*Math.random()-.6;var r=this.whiteNoise=t.createBufferSource();r.buffer=o,r.loop=!0}else"pulse"===e.type?this.pulseNode=new l(t,{detune:e.detune,pulseWidth:e.pulseWidth,frequency:i}):this.oscNode=new OscillatorNode(t,{type:e.type||"sine",detune:e.detune,frequency:i})},e.prototype.createFilters=function(){var e=this.options;e.lowpass&&e.lowpass.frequency&&(this.lowpassNode=new BiquadFilterNode(this.audioContext,{type:"lowpass",Q:e.lowpass.Q||1,frequency:e.lowpass.frequency})),e.highpass&&e.highpass.frequency&&(this.highpassNode=new BiquadFilterNode(this.audioContext,{type:"highpass",Q:e.highpass.Q||1,frequency:e.highpass.frequency}))},e.prototype.createVolTracking=function(){var e=this.options;e.volumePitchTrackingMultiplier&&1!==e.volumePitchTrackingMultiplier&&(this.volTrackingNode=new GainNode(this.audioContext,{gain:1}))},e.prototype.getOscTarget=function(){return this.oscNode?this.oscNode.frequency:this.pulseNode&&this.pulseNode.getFrequencyFacade()},e}(),u=function(){function e(e,t){var i=this;this.audioContext=e,this.options=t,this.eqNodes=[],this.midiInstrument=t.midiInstrument||1,this.outputNode=new GainNode(e,{gain:0}),this.createEqChain(this.outputNode);var o=this.eqNodes.length?this.eqNodes[0]:this.outputNode;this.oscillators=(this.options.oscillators||[]).map(function(t){return new c(e,t,n(t.fmOscillator)||n(t.vmOscillator)?void 0:o)}),this.oscillators.forEach(function(e){var t=function(t,i){if(i){var n=i[t]();n&&e.connect(n)}};n(e.fmOscillatorIx)&&t("getFMTarget",i.oscillators[e.fmOscillatorIx]),n(e.vmOscillatorIx)&&t("getVMTarget",i.oscillators[e.vmOscillatorIx])})}return e.prototype.startSilently=function(){this.outputNode.gain.value=0,this.oscillators.forEach(function(e){return e.start()})},e.prototype.stop=function(){var t=this.audioContext.currentTime,i=t+e.stopRampTime;a(this.outputNode,t,0),this.oscillators.forEach(function(e){return e.stopAtTime(i)}),this.outputNode.disconnect()},e.prototype.silenceAtTime=function(e){if(!e&&this.outputNode.gain.value<.01){this.outputNode.gain.value=0;return}this.releaseAtTime((e||0)+this.audioContext.currentTime)},e.prototype.mute=function(){this.cancelScheduled(),a(this.outputNode,this.audioContext.currentTime,0)},e.prototype.playFreqAtTime=function(e,t,i){var n=(e||0)+this.audioContext.currentTime,o=this.options;this.oscillators.forEach(function(e){e.setFreqAtTime(n,t,o.noteGlideDuration),e.runEnvelopeAtTime("attack",n)}),r(o.masterAttackEnvelope||[],"attack",n,this.outputNode,o.masterVolume),i&&this.releaseAtTime(n+i/1e3)},e.prototype.cancelScheduled=function(){this.outputNode.gain.cancelScheduledValues(this.audioContext.currentTime),this.oscillators.forEach(function(e){return e.cancelScheduled()})},e.prototype.connect=function(e){return this.outputNode.connect(e)},e.prototype.createEqChain=function(e){var i=this;this.eqNodes=(this.options.eq||[]).map(function(e){return new BiquadFilterNode(i.audioContext,t({type:"peaking"},e))}),this.eqNodes.reduceRight(function(e,t){return t.connect(e),t},e)},e.prototype.releaseAtTime=function(e){var t=0;this.oscillators.forEach(function(i){var n=i.options.releaseEnvelope;n&&n.length&&(t=Math.max(t,n[n.length-1].t),i.runEnvelopeAtTime("release",e))});var i=this.options.masterReleaseEnvelope||[];i.length&&(r(i,"release",e,this.outputNode,this.options.masterVolume),t=Math.max(t,i[i.length-1].t)),a(this.outputNode,e+t/1e3,0)},e.stopRampTime=.012,e}();return u}),i(t,"Extensions/Sonification/InstrumentPresets.js",[],function(){return{piano:{masterVolume:.45,masterAttackEnvelope:[{t:1,vol:.71},{t:40,vol:.79},{t:82,vol:.64},{t:147,vol:.29},{t:260,vol:.15},{t:417,vol:.05},{t:589,vol:0}],eq:[{frequency:200,Q:.7,gain:6},{frequency:450,gain:6},{frequency:1300,gain:2},{frequency:2600,Q:.8,gain:8},{frequency:3500,Q:.8,gain:6},{frequency:6200,Q:.8,gain:10},{frequency:8e3,gain:-23},{frequency:1e4,Q:.4,gain:-12}],oscillators:[{type:"pulse",volume:.5,pulseWidth:.55,volumePitchTrackingMultiplier:.1,lowpass:{frequency:4.5,frequencyPitchTrackingMultiplier:900,Q:-2},highpass:{frequency:270},attackEnvelope:[{t:1,vol:1}],releaseEnvelope:[{t:1,vol:1},{t:282,vol:.64},{t:597,vol:0}]},{type:"whitenoise",volume:.8,lowpass:{frequency:400},highpass:{frequency:300},attackEnvelope:[{t:1,vol:1},{t:19,vol:0}]}]},plucked:{masterVolume:.5,midiInstrument:25,masterAttackEnvelope:[{t:1,vol:.71},{t:4,vol:.71},{t:31,vol:.4},{t:109,vol:.12},{t:234,vol:.04},{t:442,vol:0}],eq:[{frequency:800,gain:-8},{frequency:1400,Q:4,gain:4},{frequency:1600,gain:-14},{frequency:2200,gain:-8},{frequency:3600,gain:-2},{frequency:6400,Q:2,gain:-6}],oscillators:[{type:"sawtooth",volume:.9,volumePitchTrackingMultiplier:.6,highpass:{frequency:100},lowpass:{frequency:8e3},releaseEnvelope:[{t:1,vol:1},{t:315,vol:.56},{t:550,vol:0}]}]},flute:{masterVolume:1.1,midiInstrument:74,noteGlideDuration:30,masterAttackEnvelope:[{t:0,vol:0},{t:29,vol:1},{t:76,vol:.48},{t:600,vol:.36}],masterReleaseEnvelope:[{t:1,vol:.36},{t:24,vol:.15},{t:119,vol:0}],eq:[{frequency:150,Q:.6,gain:-10},{frequency:500,gain:4},{frequency:1100,gain:-4},{frequency:2200,gain:-14},{frequency:5e3,gain:8},{frequency:6400,gain:10},{frequency:8e3,gain:12},{frequency:10800,gain:8}],oscillators:[{type:"triangle",volume:1,volumePitchTrackingMultiplier:.4,lowpass:{frequency:12,frequencyPitchTrackingMultiplier:100},highpass:{frequency:200}},{type:"sine",fixedFrequency:5,volume:.2,vmOscillator:0,attackEnvelope:[{t:1,vol:1},{t:48,vol:0},{t:225,vol:.05},{t:600,vol:.77}]},{type:"whitenoise",volume:.13,lowpass:{frequency:9e3,Q:3},highpass:{frequency:6e3,Q:3},vmOscillator:0,attackEnvelope:[{t:0,vol:0},{t:26,vol:1},{t:93,vol:.8}]}]},lead:{masterVolume:1,midiInstrument:20,masterAttackEnvelope:[{t:1,vol:.81},{t:98,vol:.5},{t:201,vol:.18},{t:377,vol:.04},{t:586,vol:0},{t:586,vol:0}],eq:[{frequency:200,gain:-6},{frequency:400,gain:-8},{frequency:800,Q:.5,gain:-10},{frequency:1200,gain:4},{frequency:3600,gain:-4},{frequency:4200,gain:-12},{frequency:7400,gain:-14},{frequency:1e4,gain:2}],oscillators:[{type:"triangle",volume:1.1,volumePitchTrackingMultiplier:.6,lowpass:{frequency:5e3},highpass:{frequency:100}},{type:"sawtooth",volume:.4,lowpass:{frequency:7e3},highpass:{frequency:800,Q:6},releaseEnvelope:[{t:0,vol:.99},{t:200,vol:.83},{t:495,vol:0}]}]},vibraphone:{masterVolume:1,midiInstrument:12,masterAttackEnvelope:[{t:1,vol:0},{t:10,vol:.63},{t:82,vol:.64},{t:149,vol:.26},{t:600,vol:0}],eq:[{frequency:200,Q:.8,gain:-12},{frequency:400,gain:-4},{frequency:1600,Q:.5,gain:6},{frequency:2200,Q:.5,gain:6},{frequency:6400,gain:4},{frequency:12800,gain:4}],oscillators:[{type:"sine",volume:1.5,volumePitchTrackingMultiplier:1e-7,attackEnvelope:[{t:1,vol:1}],releaseEnvelope:[{t:1,vol:1},{t:146,vol:.39},{t:597,vol:0}]},{type:"whitenoise",volume:.03,volumePitchTrackingMultiplier:1e-4,lowpass:{frequency:900},highpass:{frequency:800},attackEnvelope:[{t:1,vol:1},{t:9,vol:0}]},{type:"sine",freqMultiplier:4,volume:.15,volumePitchTrackingMultiplier:1e-4},{type:"sine",fixedFrequency:3,volume:6,fmOscillator:0,releaseEnvelope:[{t:1,vol:1},{t:190,vol:.41},{t:600,vol:0}]},{type:"sine",fixedFrequency:6,volume:3,fmOscillator:2},{type:"sine",freqMultiplier:9,volume:5e-4,volumePitchTrackingMultiplier:1e-4,releaseEnvelope:[{t:1,vol:.97},{t:530,vol:0}]}]},saxophone:{masterVolume:1,midiInstrument:67,noteGlideDuration:10,masterAttackEnvelope:[{t:1,vol:.57},{t:35,vol:1},{t:87,vol:.84},{t:111,vol:.6},{t:296,vol:.49},{t:600,vol:.58}],masterReleaseEnvelope:[{t:1,vol:.58},{t:47,vol:.16},{t:119,vol:0}],eq:[{frequency:200,gain:-2},{frequency:600,gain:2},{frequency:800,gain:-10},{frequency:1100,gain:-2},{frequency:2200,gain:-2},{frequency:3500,gain:10},{frequency:12800,gain:4}],oscillators:[{type:"sawtooth",volume:.45,volumePitchTrackingMultiplier:.06,lowpass:{frequency:18,frequencyPitchTrackingMultiplier:200},highpass:{frequency:300}},{type:"whitenoise",fixedFrequency:1,volume:.4,highpass:{frequency:7e3},vmOscillator:0,attackEnvelope:[{t:1,vol:1},{t:51,vol:1},{t:86,vol:.84},{t:500,vol:.78}]},{type:"sine",fixedFrequency:4,volume:2,fmOscillator:0,attackEnvelope:[{t:0,vol:0},{t:15,vol:.94},{t:79,vol:1},{t:172,vol:.47},{t:500,vol:.26}]},{type:"sine",fixedFrequency:7,volume:6,fmOscillator:0,attackEnvelope:[{t:0,vol:0},{t:25,vol:.99},{t:85,vol:0},{t:85,vol:0},{t:387,vol:.02},{t:511,vol:.43},{t:600,vol:0}]}]},trumpet:{masterVolume:.3,midiInstrument:57,noteGlideDuration:40,masterAttackEnvelope:[{t:1,vol:0},{t:17,vol:1},{t:42,vol:.85},{t:76,vol:1},{t:202,vol:.65},{t:226,vol:.86},{t:282,vol:.63}],masterReleaseEnvelope:[{t:1,vol:.62},{t:34,vol:.14},{t:63,vol:.21},{t:96,vol:0}],eq:[{frequency:200,Q:.6,gain:10},{frequency:600,Q:.5,gain:6},{frequency:1500,Q:.7,gain:14},{frequency:3200,Q:2,gain:8},{frequency:3800,Q:.8,gain:10},{frequency:6200,gain:12},{frequency:8400,gain:-20},{frequency:12800,Q:.5,gain:-18}],oscillators:[{type:"sawtooth",volume:.15,pulseWidth:.5,volumePitchTrackingMultiplier:.5,lowpass:{frequency:1900,Q:3}},{type:"sine",fixedFrequency:6,volume:.2,vmOscillator:0,attackEnvelope:[{t:1,vol:1},{t:102,vol:.13},{t:556,vol:.24}]},{type:"whitenoise",volume:.45,highpass:{frequency:7e3,Q:9},vmOscillator:0,attackEnvelope:[{t:1,vol:1},{t:89,vol:.51},{t:577,vol:.29}]},{type:"sine",fixedFrequency:5.7,volume:20,fmOscillator:0,attackEnvelope:[{t:1,vol:1},{t:89,vol:1},{t:137,vol:.46},{t:283,vol:.15},{t:600,vol:.28}]}]},sawsynth:{masterVolume:.3,midiInstrument:51,noteGlideDuration:40,masterAttackEnvelope:[{t:0,vol:.6},{t:9,vol:1},{t:102,vol:.48}],eq:[{frequency:200,gain:-6}],oscillators:[{type:"sawtooth",volume:.4,volumePitchTrackingMultiplier:.3},{type:"sawtooth",volume:.4,detune:11,volumePitchTrackingMultiplier:.3},{type:"sawtooth",volume:.4,detune:-11,volumePitchTrackingMultiplier:.3}]},basic1:{masterVolume:1,noteGlideDuration:0,masterReleaseEnvelope:[{t:1,vol:.36},{t:24,vol:.15},{t:119,vol:0}],eq:[{frequency:150,Q:.6,gain:-12},{frequency:1100,gain:-2},{frequency:2200,gain:-16},{frequency:5e3,gain:8},{frequency:6400,gain:10},{frequency:8e3,gain:12},{frequency:10800,gain:8}],oscillators:[{type:"triangle",volume:1,volumePitchTrackingMultiplier:.05,lowpass:{frequency:17,frequencyPitchTrackingMultiplier:100},highpass:{frequency:200}},{type:"whitenoise",volume:.04,lowpass:{frequency:9e3,Q:3},highpass:{frequency:6e3,Q:3},vmOscillator:0,attackEnvelope:[{t:0,vol:0},{t:26,vol:1},{t:71,vol:.73}]}]},basic2:{masterVolume:.3,eq:[{frequency:200,Q:.7,gain:6},{frequency:450,gain:2},{frequency:1300,gain:-2},{frequency:2600,Q:.8,gain:6},{frequency:3500,Q:.8,gain:6},{frequency:6200,Q:.8,gain:10},{frequency:8e3,gain:-18},{frequency:1e4,Q:.4,gain:-12}],oscillators:[{type:"pulse",volume:.4,pulseWidth:.55,volumePitchTrackingMultiplier:.1,lowpass:{frequency:4.5,frequencyPitchTrackingMultiplier:900,Q:-2},highpass:{frequency:270}}]},chord:{masterVolume:1,masterAttackEnvelope:[{t:1,vol:.79},{t:27,vol:.86},{t:62,vol:.81},{t:150,vol:.35},{t:408,vol:.04},{t:600,vol:0}],eq:[{frequency:200,gain:-8},{frequency:600,Q:2,gain:4},{frequency:800,gain:-10},{frequency:1600,gain:-2},{frequency:2200,gain:-6},{frequency:3600,Q:.7,gain:-2},{frequency:6400,gain:6},{frequency:12800,gain:6}],oscillators:[{type:"triangle",volume:1.1,volumePitchTrackingMultiplier:.05,lowpass:{frequency:8e3},highpass:{frequency:100},releaseEnvelope:[{t:1,vol:1},{t:315,vol:.56},{t:540,vol:0}]},{type:"triangle",freqMultiplier:1.17,volume:.4,volumePitchTrackingMultiplier:.07,lowpass:{frequency:5e3},highpass:{frequency:100},releaseEnvelope:[{t:0,vol:1},{t:476,vol:0}]},{type:"triangle",freqMultiplier:1.58333,volume:.7,volumePitchTrackingMultiplier:.02,highpass:{frequency:200},releaseEnvelope:[{t:0,vol:1},{t:422,vol:.56},{t:577,vol:0}]},{type:"sine",fixedFrequency:10,volume:4,fmOscillator:0,attackEnvelope:[{t:1,vol:1},{t:157,vol:.65}]},{type:"sine",fixedFrequency:5,volume:.3,vmOscillator:2,attackEnvelope:[{t:1,vol:1},{t:155,vol:.91},{t:289,vol:.78}]}]},wobble:{masterVolume:.9,masterReleaseEnvelope:[{t:1,vol:.36},{t:24,vol:.15},{t:119,vol:0}],eq:[{frequency:150,Q:.6,gain:-12},{frequency:1100,gain:-2},{frequency:2200,gain:-16},{frequency:5e3,gain:8},{frequency:6400,gain:10},{frequency:8e3,gain:12},{frequency:10800,gain:8}],oscillators:[{type:"triangle",volume:.9,volumePitchTrackingMultiplier:.1,lowpass:{frequency:17,frequencyPitchTrackingMultiplier:100},highpass:{frequency:200}},{type:"whitenoise",volume:.04,lowpass:{frequency:9e3,Q:3},highpass:{frequency:6e3,Q:3},vmOscillator:0,attackEnvelope:[{t:0,vol:0},{t:26,vol:1},{t:71,vol:.73}]},{type:"sine",freqMultiplier:.011,volume:30,fmOscillator:0}]},sine:{masterVolume:1,oscillators:[{type:"sine",volumePitchTrackingMultiplier:.07}]},sineGlide:{masterVolume:1,noteGlideDuration:100,oscillators:[{type:"sine",volumePitchTrackingMultiplier:.07}]},triangle:{masterVolume:.5,oscillators:[{type:"triangle",volume:1,volumePitchTrackingMultiplier:.07}]},sawtooth:{masterVolume:.25,midiInstrument:82,oscillators:[{type:"sawtooth",volume:.3,volumePitchTrackingMultiplier:.07}]},square:{masterVolume:.3,midiInstrument:81,oscillators:[{type:"square",volume:.2,volumePitchTrackingMultiplier:.07}]},chop:{masterVolume:1,midiInstrument:116,masterAttackEnvelope:[{t:1,vol:1},{t:44,vol:0}],oscillators:[{type:"whitenoise",volume:1,lowpass:{frequency:600},highpass:{frequency:200}}]},shaker:{masterVolume:.4,midiInstrument:116,masterAttackEnvelope:[{t:1,vol:1},{t:44,vol:0}],oscillators:[{type:"whitenoise",volume:1,lowpass:{frequency:6500},highpass:{frequency:5e3}}]},step:{masterVolume:1,midiInstrument:116,masterAttackEnvelope:[{t:1,vol:1},{t:44,vol:0}],eq:[{frequency:200,gain:-1},{frequency:400,gain:-14},{frequency:800,gain:8},{frequency:1e3,Q:5,gain:-24},{frequency:1600,gain:8},{frequency:2200,gain:-10},{frequency:5400,gain:4},{frequency:12800,gain:-36}],oscillators:[{type:"whitenoise",volume:1.5,lowpass:{frequency:300},highpass:{frequency:100,Q:6}}]},kick:{masterVolume:.55,masterAttackEnvelope:[{t:1,vol:.8},{t:15,vol:1},{t:45,vol:.35},{t:121,vol:.11},{t:242,vol:0}],eq:[{frequency:50,gain:6},{frequency:400,gain:-18},{frequency:1600,gain:18}],oscillators:[{type:"triangle",fixedFrequency:90,volume:1,lowpass:{frequency:300},attackEnvelope:[{t:1,vol:1},{t:6,vol:1},{t:45,vol:.01}]},{type:"whitenoise",volume:.4,lowpass:{frequency:200},attackEnvelope:[{t:1,vol:1},{t:30,vol:0}]},{type:"triangle",freqMultiplier:.1,volume:1,lowpass:{frequency:200}}]},shortnote:{masterVolume:.8,midiInstrument:116,masterAttackEnvelope:[{t:1,vol:1},{t:15,vol:0}],eq:[{frequency:400,gain:-4},{frequency:800,gain:-12},{frequency:2400,gain:4},{frequency:7200,gain:-20},{frequency:1e3,Q:5,gain:-12},{frequency:5400,gain:-32},{frequency:12800,gain:-14}],oscillators:[{type:"sawtooth",volume:.6,lowpass:{frequency:1e3}},{type:"whitenoise",volume:.2,lowpass:{frequency:1e4},highpass:{frequency:7e3},attackEnvelope:[{t:1,vol:1},{t:10,vol:0}]},{type:"whitenoise",volume:1.3,lowpass:{frequency:700,Q:4},highpass:{frequency:250}}]},noise:{masterVolume:.3,midiInstrument:122,oscillators:[{type:"whitenoise"}]},filteredNoise:{masterVolume:.3,midiInstrument:122,eq:[{frequency:1600,gain:-8},{frequency:2200,gain:-4}],oscillators:[{type:"whitenoise",lowpass:{frequency:5,frequencyPitchTrackingMultiplier:1300,Q:6},highpass:{frequency:5,frequencyPitchTrackingMultiplier:300,Q:6}}]},wind:{masterVolume:.75,midiInstrument:122,noteGlideDuration:150,masterReleaseEnvelope:[{t:0,vol:1},{t:124,vol:.24},{t:281,vol:0}],oscillators:[{type:"whitenoise",volume:1,lowpass:{frequency:100,frequencyPitchTrackingMultiplier:6,Q:23},highpass:{frequency:170,frequencyPitchTrackingMultiplier:6}},{type:"sine",freqMultiplier:.016,volume:1e3,fmOscillator:0}]}}}),i(t,"Extensions/Sonification/SonificationInstrument.js",[t["Extensions/Sonification/SynthPatch.js"],t["Extensions/Sonification/InstrumentPresets.js"],t["Core/Utilities.js"]],function(e,t,i){var n=i.defined,o=i.extend;return function(){function i(i,n,s){this.audioContext=i,this.curParams={},this.midiTrackName=s.midiTrackName,this.masterVolNode=new GainNode(i),this.masterVolNode.connect(n),this.volumeNode=new GainNode(i),this.createNodesFromCapabilities(o({pan:!0},s.capabilities||{})),this.connectCapabilityNodes(this.volumeNode,this.masterVolNode),this.synthPatch=new e(i,"string"==typeof s.synthPatch?t[s.synthPatch]:s.synthPatch),this.midiInstrument=this.synthPatch.midiInstrument||1,this.synthPatch.startSilently(),this.synthPatch.connect(this.volumeNode)}return i.prototype.setMasterVolume=function(e){this.masterVolNode.gain.setTargetAtTime(e,0,i.rampTime)},i.prototype.scheduleEventAtTime=function(e,t){var s=o(this.curParams,t),a=n(t.frequency)?t.frequency:n(t.note)?i.musicalNoteToFrequency(t.note):220;n(a)&&this.synthPatch.playFreqAtTime(e,a,s.noteDuration),(n(s.tremoloDepth)||n(s.tremoloSpeed))&&this.setTremoloAtTime(e,s.tremoloDepth,s.tremoloSpeed),n(s.pan)&&this.setPanAtTime(e,s.pan),n(s.volume)&&this.setVolumeAtTime(e,s.volume),(n(s.lowpassFreq)||n(s.lowpassResonance))&&this.setFilterAtTime("lowpass",e,s.lowpassFreq,s.lowpassResonance),(n(s.highpassFreq)||n(s.highpassResonance))&&this.setFilterAtTime("highpass",e,s.highpassFreq,s.highpassResonance)},i.prototype.silenceAtTime=function(e){this.synthPatch.silenceAtTime(e)},i.prototype.cancel=function(){this.synthPatch.mute(),[this.tremoloDepth&&this.tremoloDepth.gain,this.tremoloOsc&&this.tremoloOsc.frequency,this.lowpassNode&&this.lowpassNode.frequency,this.lowpassNode&&this.lowpassNode.Q,this.highpassNode&&this.highpassNode.frequency,this.highpassNode&&this.highpassNode.Q,this.panNode&&this.panNode.pan,this.volumeNode.gain].forEach(function(e){return e&&e.cancelScheduledValues(0)})},i.prototype.destroy=function(){this.cancel(),this.synthPatch.stop(),this.tremoloOsc&&this.tremoloOsc.stop(),[this.tremoloDepth,this.tremoloOsc,this.lowpassNode,this.highpassNode,this.panNode,this.volumeNode,this.masterVolNode].forEach(function(e){return e&&e.disconnect()})},i.prototype.setPanAtTime=function(e,t){this.panNode&&this.panNode.pan.setTargetAtTime(t,e+this.audioContext.currentTime,i.rampTime)},i.prototype.setFilterAtTime=function(e,t,o,s){var a=this[e+"Node"],r=this.audioContext.currentTime+t;a&&(n(s)&&a.Q.setTargetAtTime(s,r,i.rampTime),n(o)&&a.frequency.setTargetAtTime(o,r,i.rampTime))},i.prototype.setVolumeAtTime=function(e,t){this.volumeNode&&this.volumeNode.gain.setTargetAtTime(t,e+this.audioContext.currentTime,i.rampTime)},i.prototype.setTremoloAtTime=function(e,t,o){var s=this.audioContext.currentTime+e;this.tremoloDepth&&n(t)&&this.tremoloDepth.gain.setTargetAtTime(t,s,i.rampTime),this.tremoloOsc&&n(o)&&this.tremoloOsc.frequency.setTargetAtTime(15*o,s,i.rampTime)},i.prototype.createNodesFromCapabilities=function(e){var t=this.audioContext;e.pan&&(this.panNode=new StereoPannerNode(t)),e.tremolo&&(this.tremoloOsc=new OscillatorNode(t,{type:"sine",frequency:3}),this.tremoloDepth=new GainNode(t),this.tremoloOsc.connect(this.tremoloDepth),this.tremoloDepth.connect(this.masterVolNode.gain),this.tremoloOsc.start()),e.filters&&(this.lowpassNode=new BiquadFilterNode(t,{type:"lowpass",frequency:2e4}),this.highpassNode=new BiquadFilterNode(t,{type:"highpass",frequency:0}))},i.prototype.connectCapabilityNodes=function(e,t){[this.panNode,this.lowpassNode,this.highpassNode,e].reduce(function(e,t){return t?(t.connect(e),t):e},t)},i.noteStringToC0Distance=function(e){var t=e.match(/^([a-g][#b]?)([0-8])$/i),i=t?t[1]:"a",n=i[0].toLowerCase(),o=i[1];return(({c:0,d:2,e:4,f:5,g:7,a:9,b:11})[n]||0)+("#"===o?1:"b"===o?-1:0)+12*(t?parseInt(t[2],10):4)},i.musicalNoteToFrequency=function(e){return 16.3516*Math.pow(2,Math.min("string"==typeof e?this.noteStringToC0Distance(e):e,107)/12)},i.rampTime=e.stopRampTime/4,i}()}),i(t,"Extensions/Sonification/SonificationSpeaker.js",[t["Core/Utilities.js"]],function(e){var t=e.pick;return function(){function e(e){this.options=e,this.masterVolume=1,this.synthesis=window.speechSynthesis,void 0!==speechSynthesis.onvoiceschanged&&(speechSynthesis.onvoiceschanged=this.setVoice.bind(this)),this.setVoice(),this.scheduled=[]}return e.prototype.say=function(e,i){if(this.synthesis){this.synthesis.cancel();var n=new SpeechSynthesisUtterance(e);this.voice&&(n.voice=this.voice),n.rate=i&&i.rate||this.options.rate||1,n.pitch=i&&i.pitch||this.options.pitch||1,n.volume=t(i&&i.volume,this.options.volume,1)*this.masterVolume,this.synthesis.speak(n)}},e.prototype.sayAtTime=function(e,t,i){this.scheduled.push(setTimeout(this.say.bind(this,t,i),e))},e.prototype.cancel=function(){this.scheduled.forEach(clearTimeout),this.scheduled=[],this.synthesis.cancel()},e.prototype.destroy=function(){this.cancel()},e.prototype.setMasterVolume=function(e){this.masterVolume=e},e.prototype.setVoice=function(){if(this.synthesis){for(var e=this.options.name,t=this.options.language||"en-US",i=this.synthesis.getVoices(),n=i.length,o=void 0,s=0;s<n;++s){if(e&&i[s].name===e){this.voice=i[s];return}if(!o&&i[s].lang===t&&(o=i[s],!e))break}this.voice=o}},e}()}),i(t,"Extensions/Sonification/TimelineChannel.js",[],function(){return function(){function e(e,t,i,n,o){void 0===i&&(i=!1),this.type=e,this.engine=t,this.showPlayMarker=i,this.muted=o,this.events=n||[]}return e.prototype.addEvent=function(e){var t=this.events[this.events.length-1];if(t&&e.time<t.time){for(var i=this.events.length;i--&&this.events[i].time>e.time;);this.events.splice(i+1,0,e)}else this.events.push(e);return e},e.prototype.mute=function(){this.muted=!0},e.prototype.unmute=function(){this.muted=!1},e.prototype.cancel=function(){this.engine.cancel()},e.prototype.destroy=function(){this.engine.destroy()},e}()}),i(t,"Extensions/Sonification/MIDI.js",[t["Extensions/Sonification/SonificationInstrument.js"],t["Core/Utilities.js"]],function(e,t){var i=t.pick,n=function(e,t){return t>>>8*e&255},o=[0,255,81,3,7,161,32],s=function(e){for(var t=127&e,i=[];e>>=7;)t<<=8,t|=127&e|128;for(;;)if(i.push(255&t),128&t)t>>=8;else break;return i},a=function(t){var n,o,s=[],a=function(e){for(var t=s.length;t--&&s[t].timeMS>e.timeMS;);s.splice(t+1,0,e)};return t.forEach(function(t){var s=t.instrumentEventOptions||{},r=t.time,l=o=i(s.noteDuration,o),c=l&&t.time+l,u=[{valMap:function(e){return 64+63*e&127},data:{10:s.pan,92:s.tremoloDepth,93:s.tremoloSpeed}},{valMap:function(e){return 127*e/2e4&127},data:{74:s.lowpassFreq,75:s.highpassFreq}},{valMap:function(e){return 63*Math.min(18,Math.max(-18,e))/18+63&127},data:{71:s.lowpassResonance,76:s.highpassResonance}}],h=n=void 0===s.volume?i(n,127):127*s.volume&127,p=s.frequency,m=s.note||0,f=12+(p?Math.round(12*Math.log(p)/Math.LN2-48.37632):"string"==typeof m?e.noteStringToC0Distance(m):m)&127;u.forEach(function(e){return Object.keys(e.data).forEach(function(t){var i=e.data[t];void 0!==i&&a({timeMS:r,type:"CTRL_CHG",data:[176,parseInt(t,10),e.valMap(i)]})})}),c&&(a({timeMS:r,type:"NON",data:[144,f,h]}),a({timeMS:c,type:"NOF",data:[128,f,h]}))}),s},r=function(e,t){var i=[];if(t&&i.push(0,192,127&t),e){for(var n=[],o=0;o<e.length;++o){var a=e.charCodeAt(o);a<128&&n.push(a)}return i.concat([0,255,3],s(n.length),n)}return i},l=function(e,t,i,l){var c=0,u=r(i,l),h=a(e).reduce(function(e,t){var i=s(t.timeMS-c);return c=t.timeMS,e.concat(i,t.data)},[]),p=[0,255,47,0],m=(t?o.length:0)+u.length+h.length+p.length;return[77,84,114,107,n(3,m),n(2,m),n(1,m),n(0,m)].concat(t?o:[],u,h,p)};return function(e){var t,i=e.filter(function(e){return!!e.events.length}),o=i.length,s=o>1;return new Uint8Array([77,84,104,100,0,0,0,6,0,(t=s?o+1:o)>1?1:0,n(1,t),n(0,t),1,244].concat(s?l([],!0):[],i.reduce(function(e,t){var i=t.engine;return e.concat(l(t.events,!s,i.midiTrackName,i.midiInstrument))},[])))}}),i(t,"Extensions/DownloadURL.js",[t["Core/Globals.js"]],function(e){var t=e.isSafari,i=e.win,n=e.win.document,o=i.URL||i.webkitURL||i;function s(e){var t=e.replace(/filename=.*;/,"").match(/data:([^;]*)(;base64)?,([0-9A-Za-z+/]+)/);if(t&&t.length>3&&i.atob&&i.ArrayBuffer&&i.Uint8Array&&i.Blob&&o.createObjectURL){for(var n=i.atob(t[3]),s=new i.ArrayBuffer(n.length),a=new i.Uint8Array(s),r=0;r<a.length;++r)a[r]=n.charCodeAt(r);return o.createObjectURL(new i.Blob([a],{type:t[1]}))}}return{dataURLtoBlob:s,downloadURL:function(e,o){var a=i.navigator,r=n.createElement("a");if("string"!=typeof e&&!(e instanceof String)&&a.msSaveOrOpenBlob){a.msSaveOrOpenBlob(e,o);return}e=""+e;var l=/Edge\/\d+/.test(a.userAgent);if((t&&"string"==typeof e&&0===e.indexOf("data:application/pdf")||l||e.length>2e6)&&!(e=s(e)||""))throw Error("Failed to convert to blob");if(void 0!==r.download)r.href=e,r.download=o,n.body.appendChild(r),r.click(),n.body.removeChild(r);else try{if(!i.open(e,"chart"))throw Error("Failed to open window")}catch(t){i.location.href=e}}}}),i(t,"Extensions/Sonification/SonificationTimeline.js",[t["Extensions/Sonification/TimelineChannel.js"],t["Extensions/Sonification/MIDI.js"],t["Extensions/DownloadURL.js"],t["Core/Utilities.js"]],function(e,t,i,n){var o=i.downloadURL,s=n.defined,a=n.find,r=n.merge;return function(){function i(e,t){this.chart=t,this.isPaused=!1,this.isPlaying=!1,this.channels=[],this.scheduledCallbacks=[],this.playTimestamp=0,this.resumeFromTime=0,this.options=e||{}}return i.prototype.addChannel=function(t,i,n,o){if(void 0===n&&(n=!1),"instrument"===t&&!i.scheduleEventAtTime||"speech"===t&&!i.sayAtTime)throw Error("Highcharts Sonification: Invalid channel engine.");var s=new e(t,i,n,o);return this.channels.push(s),s},i.prototype.play=function(t,i,n,o){var s,l,c=this;void 0===i&&(i=!0),void 0===n&&(n=!0),this.isPlaying?this.cancel():this.clearScheduledCallbacks(),this.onEndArgument=o,this.playTimestamp=Date.now(),this.resumeFromTime=0,this.isPaused=!1,this.isPlaying=!0;var u=this.options.skipThreshold||2,h=this.options.onPlay,p=this.options.showTooltip,m=this.options.showCrosshair,f=t?(l=(s=(this.playingChannels||this.channels).map(function(e){return e.cancel(),{channel:e,filteredEvents:e.muted?[]:e.events.filter(t)}})).reduce(function(e,t){return Math.min(e,t.filteredEvents.length?t.filteredEvents[0].time:1/0)},1/0),s.map(function(t){return new e(t.channel.type,t.channel.engine,t.channel.showPlayMarker,t.filteredEvents.map(function(e){return r(e,{time:e.time-l})}),t.channel.muted)})):this.channels,d=[];i&&(this.playingChannels=f),h&&h({chart:this.chart,timeline:this});var y=0;f.forEach(function(e){if(!e.muted){var t=e.events.length,i=-1/0,n=-1/0,o="";y=Math.max(e.events[t-1]&&e.events[t-1].time||0,y);for(var s=0;s<t;++s)!function(s){var r=e.events[s],l=Object.keys(r.speechOptions||{}).concat(Object.keys(r.instrumentEventOptions||{})).join();if(l!==o||!(r.time-n<u)){o=l,n=r.time,"instrument"===e.type?e.engine.scheduleEventAtTime(r.time/1e3,r.instrumentEventOptions||{}):e.engine.sayAtTime(r.time,r.message||"",r.speechOptions||{});var h=r.relatedPoint,f=h&&h.series&&h.series.chart,y=r.callback||h&&(p||m)&&!1!==e.showPlayMarker&&(r.time-i>50||s===t-1);h&&d.push(h),y&&(c.scheduledCallbacks.push(setTimeout(function(){if(r.callback&&r.callback(),h){if(m){var e=h.series;e&&e.xAxis&&e.xAxis.crosshair&&e.xAxis.drawCrosshair(void 0,h),e&&e.yAxis&&e.yAxis.crosshair&&e.yAxis.drawCrosshair(void 0,h)}p&&!(f&&f.hoverPoints&&f.hoverPoints.length>1&&a(f.hoverPoints,function(e){return e===h})&&h.onMouseOver)&&h.onMouseOver()}},r.time)),i=r.time)}}(s)}});var v=this.options.onEnd,g=this.options.onStop;this.scheduledCallbacks.push(setTimeout(function(){var e=c.chart,t={chart:e,timeline:c,pointsPlayed:d};c.isPlaying=!1,n&&c.resetPlayState(),g&&g(t),v&&v(t),o&&o(t),e&&(e.tooltip&&e.tooltip.hide(0),e.hoverSeries&&e.hoverSeries.onMouseOut(),e.axes.forEach(function(e){return e.hideCrosshair()}))},y+250)),this.resumeFromTime=i?y:this.getLength()},i.prototype.pause=function(){return this.isPaused=!0,this.cancel(),this.resumeFromTime=Date.now()-this.playTimestamp-10,this.resumeFromTime},i.prototype.getCurrentTime=function(){return this.isPlaying?Date.now()-this.playTimestamp:this.resumeFromTime},i.prototype.getLength=function(){return this.channels.reduce(function(e,t){var i=t.events[t.events.length-1];return i?Math.max(i.time,e):e},0)},i.prototype.resume=function(){if(this.playingChannels){var e=this.resumeFromTime-50;this.play(function(t){return t.time>e},!1,!1,this.onEndArgument),this.playTimestamp-=e}else this.play(void 0,!1,!1,this.onEndArgument)},i.prototype.anchorPlayMoment=function(e,t){this.isPlaying&&this.pause();var i=0;this.play(function(t,n,o){var s=e(t,n,o);return s&&t.time>i&&(i=t.time),s},!1,!1,t),this.playingChannels=this.playingChannels||this.channels,this.isPaused=!0,this.isPlaying=!1,this.resumeFromTime=i},i.prototype.playAdjacent=function(e,t,i,n){this.isPlaying&&this.pause();var o=this.resumeFromTime,s=this.channels.reduce(function(t,i){for(var s=n?i.events.filter(n):i.events,a=0,r=s.length,l=t;a<r;){var c=a+r>>1,u=s[c].time,h=u-o;h>0?(e&&u<l&&(l=u),r=c):h<0?(!e&&u>l&&(l=u),a=c+1):e?a=c+1:r=c}return l},e?1/0:-1/0);if(s===1/0||s===-1/0){i&&i({chart:this.chart,timeline:this,attemptedNext:e});return}this.anchorPlayMoment(function(t,i,a){var r=e?t.time>o&&t.time<=s+.02:t.time<o&&t.time>=s-.02;return n?r&&n(t,i,a):r},t)},i.prototype.playClosestToPropValue=function(e,t,i,n,o){var a=1/0,r=null;(this.playingChannels||this.channels).forEach(function(i){for(var n=i.events,l=n.length;l--;)if(c=n[l],u=l,o?!!o(c,u,n)&&!!c.relatedPoint:!!c.relatedPoint){var c,u,h=n[l].relatedPoint[e],p=s(h)&&Math.abs(t-h);!1!==p&&p<a&&(a=p,r=n[l])}}),r?(this.play(function(e){return!!(r&&e.time<r.time+1&&e.time>r.time-1&&e.relatedPoint===r.relatedPoint)},!1,!1,i),this.playingChannels=this.playingChannels||this.channels,this.isPaused=!0,this.isPlaying=!1,this.resumeFromTime=r.time):n&&n({chart:this.chart,timeline:this})},i.prototype.getEventsForPoint=function(e){return this.channels.reduce(function(t,i){var n=i.events.filter(function(t){return t.relatedPoint===e});return t.concat(n)},[])},i.prototype.playSegment=function(e,t){var i={first:1/0,last:-1/0};if(this.channels.forEach(function(e){e.events.length&&(i.first=Math.min(e.events[0].time,i.first),i.last=Math.max(e.events[e.events.length-1].time,i.last))}),i.first<1/0){var n=(i.last-i.first)/100,o=i.first+e*n,s=o+n;if(!this.channels.some(function(e){for(var t=e.events,i=0,n=t.length;i<n;){var a=i+n>>1,r=t[a].time;if(r<o)i=a+1;else{if(!(r>s))return!0;n=a}}return!1}))return;this.play(function(e){return e.time>=o&&e.time<=s},!1,!1,t),this.playingChannels=this.playingChannels||this.channels,this.isPaused=!0,this.isPlaying=!1,this.resumeFromTime=s}},i.prototype.getLastPlayedPoint=function(e){var t=this.getCurrentTime(),i=this.playingChannels||this.channels,n=1/0,o=null;return i.forEach(function(i){var s=i.events.filter(function(i,n,o){return!!(i.relatedPoint&&i.time<=t&&(!e||e(i,n,o)))}),a=s[s.length-1];if(a){var r=Math.abs(a.time-t);r<n&&(n=r,o=a.relatedPoint)}}),o},i.prototype.reset=function(){this.isPlaying&&this.cancel(),this.resetPlayState()},i.prototype.cancel=function(){var e=this.options.onStop;e&&e({chart:this.chart,timeline:this}),this.isPlaying=!1,this.channels.forEach(function(e){return e.cancel()}),this.playingChannels&&this.playingChannels!==this.channels&&this.playingChannels.forEach(function(e){return e.cancel()}),this.clearScheduledCallbacks(),this.resumeFromTime=0},i.prototype.destroy=function(){this.cancel(),this.playingChannels&&this.playingChannels!==this.channels&&this.playingChannels.forEach(function(e){return e.destroy()}),this.channels.forEach(function(e){return e.destroy()})},i.prototype.setMasterVolume=function(e){this.channels.forEach(function(t){return t.engine.setMasterVolume(e)})},i.prototype.getMIDIData=function(){return t(this.channels.filter(function(e){return"instrument"===e.type}))},i.prototype.downloadMIDI=function(e){var t=this.getMIDIData(),i=(e||this.chart&&this.chart.options.title&&this.chart.options.title.text||"chart")+".mid",n=new Blob([t],{type:"application/octet-stream"}),s=window.URL.createObjectURL(n);o(s,i),window.URL.revokeObjectURL(s)},i.prototype.resetPlayState=function(){delete this.playingChannels,delete this.onEndArgument,this.playTimestamp=this.resumeFromTime=0,this.isPaused=!1},i.prototype.clearScheduledCallbacks=function(){this.scheduledCallbacks.forEach(clearTimeout),this.scheduledCallbacks=[]},i}()}),i(t,"Extensions/Sonification/TimelineFromChart.js",[t["Extensions/Sonification/SonificationTimeline.js"],t["Extensions/Sonification/SonificationInstrument.js"],t["Extensions/Sonification/SonificationSpeaker.js"],t["Core/Utilities.js"],t["Core/Templating.js"]],function(e,t,i,n,o){var s=this&&this.__assign||function(){return(s=Object.assign||function(e){for(var t,i=1,n=arguments.length;i<n;i++)for(var o in t=arguments[i])Object.prototype.hasOwnProperty.call(t,o)&&(e[o]=t[o]);return e}).apply(this,arguments)},a=n.clamp,r=n.defined,l=n.extend,c=n.getNestedProperty,u=n.merge,h=n.pick,p=o.format,m=function(e){return/^([a-g][#b]?)[0-8]$/i.test(e)};function f(e,t){var i;if(t){if("number"==typeof(i=e[t]))return i;i=c(t,e)}return"number"==typeof i?i:void 0}function d(e,t,i,n,o){var s=t.max-t.min;if(s<=0)return i.min;var r=i.max-i.min,l=r*(e-t.min)/s;if(o){var c=t.min>0?function(e){return Math.log(e)/Math.LOG10E}:function(e){var t=Math.abs(e);t<10&&(t+=(10-t)/10);var i=Math.log(t)/Math.LN10;return e<0?-i:i},u=c(t.min);l=r*(c(e)-u)/(c(t.max)-u)}return a(n?i.max-l:i.min+l,i.min,i.max)}function y(e,t,i,n,o,s,a){return h(function(e,t,i,n,o,s){if("number"==typeof o)return o;if("function"==typeof o)return o(l({time:0},e));var a,u=o,p=n.mapFunction,m=n.min,f=n.max,y=n.within;if("object"==typeof o&&(u=o.mapTo,p=o.mapFunction||p,m=h(o.min,m),f=h(o.max,f),y=o.within||n.within,a=o.scale),!u)return null;var v="-"===u.charAt(0);v&&(u=u.slice(1));var g=e.value,q="value"===u&&void 0!==g&&s;if(!q){var T=o.value;if(void 0!==T)g=T;else{if(!e.point)return null;g=e.point[u]}void 0===g&&(g=c(u,e.point))}if("number"!=typeof g||null===g)return null;var w=null;if(e.point){if("xAxis"===y||"yAxis"===y){var x=e.point.series[y];x&&r(x.dataMin)&&r(x.dataMax)&&(w={min:x.dataMin,max:x.dataMax})}else("series"===y||i)&&e.point.series&&(w=t.seriesExtremes[e.point.series.index][q?s:u])}if(w||(w=t.globalExtremes[q?s:u]),a){for(var E=[],S=Math.floor(m/12),N=Math.ceil(f/12)+1,P=a.length,k=S;k<N;++k)for(var M=0;M<P;++M){var b=12*k+a[M];b>=m&&b<=f&&E.push(b)}var C=d(g,w,{min:0,max:E.length-1},v,"logarithmic"===p);return E[Math.round(C)]}return d(g,w,{min:m,max:f},v,"logarithmic"===p)}(e,t,i,l({min:0,max:1,mapTo:"y",mapFunction:"linear",within:"chart"},s||{}),n,a),o)}function v(e,n,o,s){var a=s.mapping||{},r="speech"===s.type?new i({language:s.language,name:s.preferredVoice}):new t(n,o,{capabilities:{pan:!!a.pan,tremolo:!!a.tremolo,filters:!!(a.highpass||a.lowpass)},synthPatch:s.instrument,midiTrackName:s.midiName});return e.addChannel(s.type||"instrument",r,h(s.showPlayMarker,!0))}function g(e,i,n,o,s,a){var r=function(t,i,s,r){return y(e,o,!1,(r||n)[t],i,s,a)},c=[],u={noteDuration:r("noteDuration",200,{min:40,max:1e3}),pan:r("pan",0,{min:-1,max:1}),volume:r("volume",1,{min:.1,max:1})};n.frequency&&(u.frequency=r("frequency",440,{min:50,max:6e3})),n.lowpass&&(u.lowpassFreq=r("frequency",2e4,{min:0,max:2e4},n.lowpass),u.lowpassResonance=r("resonance",0,{min:-6,max:12},n.lowpass)),n.highpass&&(u.highpassFreq=r("frequency",2e4,{min:0,max:2e4},n.highpass),u.highpassResonance=r("resonance",0,{min:-6,max:12},n.highpass)),n.tremolo&&(u.tremoloDepth=r("depth",0,{min:0,max:.8},n.tremolo),u.tremoloSpeed=r("speed",0,{min:0,max:.8},n.tremolo));var h=r("gapBetweenNotes",150,{min:50,max:1e3}),p=r("playDelay",0,{max:200}),f=function(n,r){void 0===r&&(r=0);var f=n;n.mapTo?("string"==typeof n.min&&(f.min=t.noteStringToC0Distance(n.min)),"string"==typeof n.max&&(f.max=t.noteStringToC0Distance(n.max))):"string"==typeof n&&m(n)&&(f=t.noteStringToC0Distance(n)),u.note=y(e,o,!1,f,-1,{min:0,max:107},a),u.note>-1&&(s&&(u.note=Math.round(u.note)),c.push(i.addEvent({time:e.time+p+h*r,relatedPoint:e.point,instrumentEventOptions:void 0!==r?l({},u):u})))};return n.pitch&&n.pitch.constructor===Array?n.pitch.forEach(f):n.pitch?f(n.pitch):n.frequency&&c.push(i.addEvent({time:e.time+p,relatedPoint:e.point,instrumentEventOptions:u})),c}function q(e,t,i,n,o){var s,a=function(t,s,a){return y(e,n,!1,i[t],s,a,o)},r=a("playDelay",0,{max:200}),l=a("pitch",1,{min:.3,max:2}),c=a("rate",1,{min:.4,max:4}),u=a("volume",1,{min:.1}),h=p("function"==typeof(s=i.text)?s(e):s,e,e.point&&e.point.series.chart);if(h)return t.addEvent({time:e.time+r,relatedPoint:e.point,speechOptions:{pitch:l,rate:c,volume:u},message:h})}function T(e,t,i){if("function"==typeof t)return t(e);if("object"==typeof t){var n=t.prop,o=h(e.value,e.point&&f(e.point,n));if("number"!=typeof o)return!1;var s=!0,a=t.crossingUp,r=t.crossingDown,l="number"==typeof i;s=a&&r?l&&(i<a&&o>=a||i>r&&o<=r):(void 0===a||l&&i<a&&o>=a)&&(void 0===r||l&&i>r&&o<=r);var c=h(t.max,1/0),u=h(t.min,-1/0);return o<=c&&o>=u&&s}return!0}return function(t,i,n){var o,a,r,p,w,x,E,S,N,P,k,M,b=n.options.sonification||{},C=b.defaultInstrumentOptions,A=b.defaultSpeechOptions,O=u({enabled:!0,groupTimespan:15,algorithm:"minmax",prop:"y"},b.pointGrouping),I=b.globalTracks||[],V=b.globalContextTracks||[],j="sequential"===b.order,F=Math.max(50,b.duration-300),D=b.afterSeriesWait,Q=b.events||{},R=(a=((o=n.options.sonification||{}).defaultInstrumentOptions||{}).mapping||{time:"x",pitch:"y"},r=o.defaultSpeechOptions&&o.defaultSpeechOptions.mapping||{},p=[],w={},x=function(e,t){null!==t?(p[t]=p[t]||{},p[t][e]=!0):w[e]=!0},E={},S={},N=function(e,t,i){var n=function(e){return"-"===e.charAt(0)?e.slice(1):e};if("string"==typeof t&&"text"!==e){if("pitch"===e&&m(t))return;"time"===e&&(S[t]=!0,x(t,i)),E[n(t)]=!0;return}if(t&&t.mapTo&&"string"==typeof t.mapTo){var o=n(t.mapTo);"time"===e&&x(o,i),("time"===e||"series"===t.within)&&(S[o]=!0),E[o]=!0;return}["tremolo","lowpass","highpass"].indexOf(e)>-1&&"object"==typeof t&&Object.keys(t).forEach(function(e){return N(e,t[e],i)})},P=function(e,t){Object.keys(e).forEach(function(i){return N(i,e[i],t)})},k=function(e){return e.forEach(function(e){E[e.valueProp||"x"]=S[e.valueProp||"x"]=!0})},P(a,null),P(r,null),k(o.globalContextTracks||[]),M=Object.keys(w).length,n.series.forEach(function(e){var t=e.options.sonification;if(e.visible&&!(t&&!1===t.enabled)&&(M&&(p[e.index]=u(w)),t)){var i=(t.defaultInstrumentOptions||{}).mapping,n=(t.defaultSpeechOptions||{}).mapping;i&&P(i,e.index),n&&P(n,e.index),k(t.contextTracks||[]),(t.tracks||[]).concat(t.contextTracks||[]).forEach(function(t){t.mapping&&P(t.mapping,e.index)})}}),s({seriesTimeProps:p},function(e,t,i){for(var n=e.series,o=t.length,s=i.length,a=function(e){return e.reduce(function(e,t){return e[t]={min:1/0,max:-1/0},e},{})},r=function(e,t,i){var n=t[i];void 0===n&&(n=c(i,t)),"number"==typeof n&&(e[i].min=Math.min(e[i].min,n),e[i].max=Math.max(e[i].max,n))},l=a(t),u=n.length,h=Array(u);u--;){var p=a(i),m=n[u].options;if(n[u].visible&&(!m||!m.sonification||!1!==m.sonification.enabled)){for(var f=n[u].points||[],d=f.length;d--;){for(var y=o;y--;)r(l,f[d],t[y]);for(y=s;y--;)r(p,f[d],i[y])}h[u]=p}}return{globalExtremes:l,seriesExtremes:h}}(n,Object.keys(E),Object.keys(S)))),U=new e({onPlay:Q.onPlay,onEnd:Q.onEnd,onStop:Q.onStop,showCrosshair:b.showCrosshair,showTooltip:b.showTooltip},n);n.sonification&&(n.sonification.propMetrics=R);var G=0;return n.series.forEach(function(e,n){var o=e.options.sonification||{};if(e.visible&&!1!==o.enabled){var s,a=j?function(e,t,i,n){var o,s,a=t-(e.chart.series.length-1)*n;if(i.seriesTimeProps.every(function(e){var t=Object.keys(e);return!(t.length>1)&&(o||(o=t[0]),o===t[0])})){var r=i.seriesExtremes[e.index][o];s=Math.round((r.max-r.min)/i.seriesExtremes.reduce(function(e,t){return t[o]?e+t[o].max-t[o].min:e},0)*a)}else{var l=e.chart.series.reduce(function(e,t){return e+t.points.length},0);s=Math.round((e.points||[]).length/l*a)}return Math.max(50,s)}(e,F,R,D):F,r=u(C,o.defaultInstrumentOptions),c=u(A,o.defaultSpeechOptions),p=u(O,o.pointGrouping),m=(o.tracks||[r]).concat(I),w=U.channels.length&&!j?o.contextTracks||[]:(o.contextTracks||[]).concat(V),x=[];m.forEach(function(n){var o=u({pointGrouping:p,midiName:n.midiName||e.name},"speech"===n.type?c:r,n),l=o.pointGrouping,m=o.activeWhen,d=function(e){"object"==typeof m&&m.prop&&(s=f(e,m.prop))},w=v(U,t,i,o),E=function(e){return x.push.apply(x,function(e,t,i,n){var o=[];if("speech"===i.type&&i.mapping){var s=q(e,t,i.mapping,n);s&&(o=[s])}else i.mapping&&(o=g(e,t,i.mapping,n,h(i.roundToMusicalNotes,!0)));return o}(e,w,o,R))},S=[],N=0,P=function(e){if(1===S.length)E({point:S[0].point,time:N+e/2});else{var t=function(e,t){var i=e.algorithm||"minmax",n=function(e){return t[e]?[t[e].point]:[]};if("first"===i)return n(0);if("last"===i)return n(t.length-1);if("middle"===i)return n(t.length>>1);if("firstlast"===i)return n(0).concat(n(t.length-1));if("minmax"===i){var o,s,a,r,l=e.prop||"y";if(t.forEach(function(e){var t=f(e.point,l);void 0!==t&&((!o||t<a)&&(o=e,a=t),(!s||t>r)&&(s=e,r=t))}),o&&s)return o.point===s.point?[o.point]:o.time>s.time?[s.point,o.point]:[o.point,s.point]}return[]}(l,S),i=e/t.length;t.forEach(function(e,t){return E({point:e,time:N+i/2+i*t})})}S=[]};(e.points||[]).forEach(function(t,i){var n,r=i===e.points.length-1,c=(n=G,y({point:t,time:0},R,j,o.mapping&&o.mapping.time||0,0,{min:0,max:a,mapTo:"x"})+n),u={point:t,time:c};if(!o.mapping||!T(u,m,s)){d(t),r&&S.length&&P(S[S.length-1].time-S[0].time);return}if(d(t),l.enabled){var h=c-N,p=l.groupTimespan,f=r&&h<=p?h:p;r||h>p?(h<=p&&S.push(u),P(f),N=Math.floor(c/p)*p,r&&h>p?E({point:u.point,time:N+f/2}):S=[u]):S.push(u)}else E(u)})});var E=x.reduce(function(e,t){return t.time<e.time?t:e},{time:1/0}),S=x.reduce(function(e,t){return t.time>e.time?t:e},{time:-1/0});E.callback=Q.onSeriesStart?Q.onSeriesStart.bind(null,{series:e,timeline:U}):void 0,S.callback=Q.onSeriesEnd?Q.onSeriesEnd.bind(null,{series:e,timeline:U}):void 0,w.forEach(function(e){var o="speech"===e.type?u(A,e):u(C,{mapping:{pitch:{mapTo:"value"}}},e),r=v(U,t,i,o);s=void 0;var c=o.timeInterval,p=o.valueInterval,m=o.valueProp||"x",f=o.activeWhen,y=R.seriesExtremes[n][m],w=function(e,t){if(!o.mapping||!T({time:e,value:t},"object"==typeof f?l({prop:m},f):f,s)){s=t;return}s=t,"speech"===o.type?q({time:e,value:t},r,o.mapping,R,m):g({time:e,value:t},r,o.mapping,R,h(o.roundToMusicalNotes,!0),m)};if(c)for(var x=0;x<=a;){var E=d(x,{min:0,max:a},y);w(x+G,E),x+=c}if(p)for(var E=y.min;E<=y.max;){var x=d(E,y,{min:0,max:a},!1,"logarithmic"===o.valueMapFunction);w(x+G,E),E+=p}}),j&&(G+=a+D)}}),U}}),i(t,"Extensions/Sonification/Sonification.js",[t["Core/Defaults.js"],t["Core/Utilities.js"],t["Core/Globals.js"],t["Extensions/Sonification/Options.js"],t["Extensions/Sonification/SonificationInstrument.js"],t["Extensions/Sonification/SonificationSpeaker.js"],t["Extensions/Sonification/SynthPatch.js"],t["Extensions/Sonification/InstrumentPresets.js"],t["Extensions/Sonification/TimelineFromChart.js"]],function(e,t,i,n,o,s,a,r,l){var c=e.defaultOptions,u=e.getOptions,h=t.addEvent,p=t.extend,m=t.fireEvent,f=t.merge,d=t.pick,y=i.doc,v=i.win,g=function(){function e(e){this.chart=e,this.retryContextCounter=0,this.lastUpdate=0,this.unbindKeydown=h(y,"keydown",function(t){e&&e.sonification&&("Esc"===t.key||"Escape"===t.key)&&e.sonification.cancel()});try{this.audioContext=new v.AudioContext,this.audioContext.suspend(),this.audioDestination=this.audioContext.destination}catch(e){}}return e.prototype.setAudioDestination=function(e){this.audioDestination=e,this.update()},e.prototype.isPlaying=function(){return!!this.timeline&&this.timeline.isPlaying},e.prototype.playSegment=function(e,t){this.ready(this.playSegment.bind(this,e,t))&&this.timeline&&this.timeline.playSegment(e,t)},e.prototype.playAdjacent=function(e,t,i){var n=this;if(this.ready(this.playAdjacent.bind(this,e,t,i))&&this.timeline){var o=this.chart.options.sonification,s=o&&o.events&&o.events.onBoundaryHit;s||this.initBoundaryInstrument(),this.timeline.playAdjacent(e,t,s||function(){n.defaultBoundaryHit()},i)}},e.prototype.playAdjacentSeries=function(e,t,i){void 0===t&&(t="x");var n=this.getLastPlayedPoint();if(n){var o=n.series.index+(e?1:-1);return this.playClosestToProp(t,n[t],function(e){return!!e.relatedPoint&&e.relatedPoint.series.index===o},i),this.chart.series[o]||null}return null},e.prototype.playClosestToProp=function(e,t,i,n){var o=this;if(this.ready(this.playClosestToProp.bind(this,e,t,i,n))&&this.timeline){var s=this.chart.options.sonification,a=s&&s.events&&s.events.onBoundaryHit;a||this.initBoundaryInstrument(),this.timeline.playClosestToPropValue(e,t,n,a||function(){return o.defaultBoundaryHit()},i)}},e.prototype.getLastPlayedPoint=function(){return this.timeline?this.timeline.getLastPlayedPoint():null},e.prototype.playNote=function(e,t,i){if(void 0===i&&(i=0),this.ready(this.playNote.bind(this,e,t))){var n=t.noteDuration=t.noteDuration||500,s=new o(this.audioContext,this.audioDestination,{synthPatch:e,capabilities:{filters:!0,tremolo:!0,pan:!0}});s.scheduleEventAtTime(i/1e3,t),setTimeout(function(){return s&&s.destroy()},i+n+500)}},e.prototype.speak=function(e,t,i){void 0===i&&(i=0),new s(f({language:"en-US",rate:1.5,volume:.4},t||{})).sayAtTime(i,e)},e.prototype.cancel=function(){this.timeline&&this.timeline.cancel(),m(this,"cancel")},e.prototype.downloadMIDI=function(){this.ready(this.downloadMIDI.bind(this))&&this.timeline&&(this.timeline.reset(),this.timeline.downloadMIDI())},e.prototype.sonifyChart=function(e,t){this.ready(this.sonifyChart.bind(this,e,t))&&this.timeline&&(this.timeline.reset(),this.beforePlay(),this.timeline.play(void 0,void 0,e,t))},e.prototype.sonifySeries=function(e,t,i){this.ready(this.sonifySeries.bind(this,e,t,i))&&this.timeline&&(this.timeline.reset(),this.beforePlay(),this.timeline.play(function(t){return!!t.relatedPoint&&t.relatedPoint.series===e},void 0,t,i))},e.prototype.sonifyPoint=function(e,t){this.ready(this.sonifyPoint.bind(this,e,t))&&this.timeline&&(this.timeline.reset(),this.beforePlay(),this.timeline.anchorPlayMoment(function(t){return t.relatedPoint===e},t))},e.prototype.setMasterVolume=function(e){this.timeline&&this.timeline.setMasterVolume(e)},e.prototype.destroy=function(){this.unbindKeydown(),this.timeline&&(this.timeline.destroy(),delete this.timeline),this.boundaryInstrument&&this.boundaryInstrument.stop(),this.audioContext&&(this.audioContext.close(),delete this.audioContext)},e.prototype.update=function(){var e=this.chart.options&&this.chart.options.sonification;if(this.ready(this.update.bind(this))&&e){var t=Date.now(),i=e.updateInterval;if(t-this.lastUpdate<i&&!this.forceReady){clearTimeout(this.scheduledUpdate),this.scheduledUpdate=setTimeout(this.update.bind(this),i/2);return}var n=e.events||{};if(n.beforeUpdate&&n.beforeUpdate({chart:this.chart,timeline:this.timeline}),this.lastUpdate=t,this.timeline&&this.timeline.destroy(),this.audioContext&&this.audioDestination){this.timeline=l(this.audioContext,this.audioDestination,this.chart);var o=this.chart.options.sonification;this.timeline.setMasterVolume(d(o&&o.masterVolume,1))}n.afterUpdate&&n.afterUpdate({chart:this.chart,timeline:this.timeline})}},e.prototype.ready=function(e){var t=this;return!!this.audioContext&&!!this.audioDestination&&!!this.chart.options&&(!this.chart.options.sonification||!1!==this.chart.options.sonification.enabled)&&("suspended"!==this.audioContext.state||this.forceReady?(this.retryContextCounter=0,!0):(this.retryContextCounter++<20&&setTimeout(function(){t.audioContext&&"suspended"===t.audioContext.state?t.audioContext.resume().then(e):e()},5),!1))},e.prototype.beforePlay=function(){var e=this.chart.options.sonification,t=e&&e.events&&e.events.beforePlay;t&&t({chart:this.chart,timeline:this.timeline})},e.prototype.initBoundaryInstrument=function(){this.boundaryInstrument||(this.boundaryInstrument=new a(this.audioContext,f(r.chop,{masterVolume:.3})),this.boundaryInstrument.startSilently(),this.boundaryInstrument.connect(this.audioDestination))},e.prototype.defaultBoundaryHit=function(){this.boundaryInstrument&&(this.boundaryInstrument.playFreqAtTime(.1,1,200),this.boundaryInstrument.playFreqAtTime(.2,1,200))},e}();return function(e){var t=[];function i(){var t=this.sonification,i=this.options&&this.options.sonification;i&&i.enabled?t?t.update():(this.sonification=new e(this),this.sonification.update()):t&&(t.destroy(),delete this.sonification)}function n(){this&&this.sonification&&this.sonification.destroy()}function o(){this.updateSonificationEnabled&&this.updateSonificationEnabled()}function s(e){var t=e.options.sonification;t&&(f(!0,this.options.sonification,t),o.call(this))}e.compose=function(e,a,r){-1===t.indexOf(e)&&(t.push(e),p(e.prototype,{updateSonificationEnabled:i,sonify:function(e){this.sonification&&this.sonification.sonifyChart(!1,e)},toggleSonify:function(e,t){if(void 0===e&&(e=!0),this.sonification){var i=this.sonification.timeline;v.speechSynthesis&&v.speechSynthesis.cancel(),i&&this.sonification.isPlaying()?e?this.sonification.cancel():i.pause():i&&i.isPaused?i.resume():this.sonification.sonifyChart(e,t)}}}),h(e,"destroy",n),h(e,"render",o),h(e,"update",s)),-1===t.indexOf(a)&&(t.push(a),a.prototype.sonify=function(e){this.chart.sonification&&this.chart.sonification.sonifySeries(this,!1,e)}),-1===t.indexOf(r)&&(t.push(r),r.prototype.sonify=function(e){this.series.chart.sonification&&this.series.chart.sonification.sonifyPoint(this,e)});var l=u().exporting;l&&l.buttons&&l.buttons.contextButton.menuItems&&l.buttons.contextButton.menuItems.push("separator","downloadMIDI","playAsSound")}}(g||(g={})),f(!0,c,n),g}),i(t,"Extensions/Sonification/Scales.js",[],function(){return{minor:[0,2,3,5,7,8,10],dorian:[0,2,3,5,7,9,10],harmonicMinor:[0,2,3,5,7,8,11],phrygian:[0,1,3,5,7,8,11],major:[0,2,4,5,7,9,11],lydian:[0,2,4,6,7,9,11],mixolydian:[0,2,4,5,7,9,10],majorPentatonic:[0,2,4,7,9],minorPentatonic:[0,3,5,7,10]}}),i(t,"masters/modules/sonification.src.js",[t["Core/Globals.js"],t["Extensions/Sonification/Sonification.js"],t["Extensions/Sonification/SynthPatch.js"],t["Extensions/Sonification/InstrumentPresets.js"],t["Extensions/Sonification/Scales.js"],t["Extensions/Sonification/SonificationInstrument.js"],t["Extensions/Sonification/SonificationSpeaker.js"],t["Extensions/Sonification/SonificationTimeline.js"]],function(e,t,i,n,o,s,a,r){e.sonification={InstrumentPresets:n,Scales:o,SynthPatch:i,SonificationInstrument:s,SonificationSpeaker:a,SonificationTimeline:r,Sonification:t},t.compose(e.Chart,e.Series,e.Point)})});//# sourceMappingURL=sonification.js.map