/**
 * Highcharts JS v11.2.0 (2023-10-30)
 *
 * Pictorial graph series type for Highcharts
 *
 * (c) 2010-2022 Torstein Honsi, Magdalena Gut
 *
 * License: www.highcharts.com/license
 */!function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/pictorial",["highcharts"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function i(t,e,i,r){t.hasOwnProperty(e)||(t[e]=r.apply(null,i),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:t[e]}})))}i(e,"Extensions/PatternFill.js",[e["Core/Animation/AnimationUtilities.js"],e["Core/Chart/Chart.js"],e["Core/Globals.js"],e["Core/Defaults.js"],e["Core/Series/Point.js"],e["Core/Series/Series.js"],e["Core/Renderer/SVG/SVGRenderer.js"],e["Core/Utilities.js"]],function(t,e,i,r,s,a,o,n){let{animObject:h}=t,{getOptions:l}=r,{addEvent:d,defined:p,erase:c,merge:f,pick:u,removeEvent:g,wrap:m}=n,x=i.patterns=(()=>{let t=[],e=l().colors;return["M 0 0 L 5 5 M 4.5 -0.5 L 5.5 0.5 M -0.5 4.5 L 0.5 5.5","M 0 5 L 5 0 M -0.5 0.5 L 0.5 -0.5 M 4.5 5.5 L 5.5 4.5","M 2 0 L 2 5 M 4 0 L 4 5","M 0 2 L 5 2 M 0 4 L 5 4","M 0 1.5 L 2.5 1.5 L 2.5 0 M 2.5 5 L 2.5 3.5 L 5 3.5"].forEach((i,r)=>{t.push({path:i,color:e[r],width:5,height:5,patternTransform:"scale(1.4 1.4)"})}),["M 0 0 L 5 10 L 10 0","M 3 3 L 8 3 L 8 8 L 3 8 Z","M 5 5 m -4 0 a 4 4 0 1 1 8 0 a 4 4 0 1 1 -8 0","M 0 0 L 10 10 M 9 -1 L 11 1 M -1 9 L 1 11","M 0 10 L 10 0 M -1 1 L 1 -1 M 9 11 L 11 9"].forEach((i,r)=>{t.push({path:i,color:e[r+5],width:10,height:10})}),t})();function w(t,e){let i=JSON.stringify(t),r=i.length||0,s=0,a=0,o;if(e){o=Math.max(Math.floor(r/500),1);for(let t=0;t<r;t+=o)s+=i.charCodeAt(t);s&=s}for(;a<r;++a)s=(s<<5)-s+i.charCodeAt(a),s&=s;return s.toString(16).replace("-","1")}s.prototype.calculatePatternDimensions=function(t){if(t.width&&t.height)return;let e=this.graphic&&(this.graphic.getBBox&&this.graphic.getBBox(!0)||this.graphic.element&&this.graphic.element.getBBox())||{},i=this.shapeArgs;if(i&&(e.width=i.width||e.width,e.height=i.height||e.height,e.x=i.x||e.x,e.y=i.y||e.y),t.image){if(!e.width||!e.height){t._width="defer",t._height="defer";let e=this.series.chart.mapView&&this.series.chart.mapView.getSVGTransform().scaleY;p(e)&&e<0&&(t._inverted=!0);return}t.aspectRatio&&(e.aspectRatio=e.width/e.height,t.aspectRatio>e.aspectRatio?e.aspectWidth=e.height*t.aspectRatio:e.aspectHeight=e.width/t.aspectRatio),t._width=t.width||Math.ceil(e.aspectWidth||e.width),t._height=t.height||Math.ceil(e.aspectHeight||e.height)}t.width||(t._x=t.x||0,t._x+=e.x-Math.round(e.aspectWidth?Math.abs(e.aspectWidth-e.width)/2:0)),t.height||(t._y=t.y||0,t._y+=e.y-Math.round(e.aspectHeight?Math.abs(e.aspectHeight-e.height)/2:0))},o.prototype.addPattern=function(t,e){let i,r=u(e,!0),s=h(r),a,o=t.width||t._width||32,l=t.height||t._height||32,d=t.color||"#343434",p=t.id,c=this,f;if(!p&&(this.idCounter=this.idCounter||0,p="highcharts-pattern-"+this.idCounter+"-"+(this.chartIndex||0),++this.idCounter),this.forExport&&(p+="-export"),this.defIds=this.defIds||[],this.defIds.indexOf(p)>-1)return;this.defIds.push(p);let m={id:p,patternUnits:"userSpaceOnUse",patternContentUnits:t.patternContentUnits||"userSpaceOnUse",width:o,height:l,x:t._x||t.x||0,y:t._y||t.y||0};return t._inverted&&(m.patternTransform="scale(1, -1)",t.patternTransform&&(t.patternTransform+=" scale(1, -1)")),t.patternTransform&&(m.patternTransform=t.patternTransform),(i=this.createElement("pattern").attr(m).add(this.defs)).id=p,t.path?(a=n.isObject(t.path)?t.path:{d:t.path},t.backgroundColor&&function(t){c.rect(0,0,o,l).attr({fill:t}).add(i)}(t.backgroundColor),f={d:a.d},this.styledMode||(f.stroke=a.stroke||d,f["stroke-width"]=u(a.strokeWidth,2),f.fill=a.fill||"none"),a.transform&&(f.transform=a.transform),this.createElement("path").attr(f).add(i),i.color=d):t.image&&(r?this.image(t.image,0,0,o,l,function(){this.animate({opacity:u(t.opacity,1)},s),g(this.element,"load")}).attr({opacity:0}).add(i):this.image(t.image,0,0,o,l).add(i)),t.image&&r||void 0===t.opacity||[].forEach.call(i.element.childNodes,function(e){e.setAttribute("opacity",t.opacity)}),this.patternElements=this.patternElements||{},this.patternElements[p]=i,i},m(a.prototype,"getColor",function(t){let e=this.options.color;e&&e.pattern&&!e.pattern.color?(delete this.options.color,t.apply(this,Array.prototype.slice.call(arguments,1)),e.pattern.color=this.color,this.color=this.options.color=e):t.apply(this,Array.prototype.slice.call(arguments,1))}),d(a,"render",function(){let t=this.chart.isResizing;(this.isDirtyData||t||!this.chart.hasRendered)&&(this.points||[]).forEach(function(e){let i=e.options&&e.options.color;i&&i.pattern&&(t&&!(e.shapeArgs&&e.shapeArgs.width&&e.shapeArgs.height)?(i.pattern._width="defer",i.pattern._height="defer"):e.calculatePatternDimensions(i.pattern))})}),d(s,"afterInit",function(){let t=this.options.color;t&&t.pattern&&("string"==typeof t.pattern.path&&(t.pattern.path={d:t.pattern.path}),this.color=this.options.color=f(this.series.options.color,t))}),d(o,"complexColor",function(t){let e=t.args[0],i=t.args[1],r=t.args[2],a=this.chartIndex||0,o=e.pattern,n="#343434";if(void 0!==e.patternIndex&&x&&(o=x[e.patternIndex]),!o)return!0;if(o.image||"string"==typeof o.path||o.path&&o.path.d){let t=r.parentNode&&r.parentNode.getAttribute("class");t=t&&t.indexOf("highcharts-legend")>-1,("defer"===o._width||"defer"===o._height)&&s.prototype.calculatePatternDimensions.call({graphic:{element:r}},o),(t||!o.id)&&((o=f({},o)).id="highcharts-pattern-"+a+"-"+w(o)+w(o,!0)),this.addPattern(o,!this.forExport&&u(o.animation,this.globalAnimation,{duration:100})),n=`url(${this.url}#${o.id+(this.forExport?"-export":"")})`}else n=o.color||n;return r.setAttribute(i,n),e.toString=function(){return n},!1}),d(e,"endResize",function(){(this.renderer&&this.renderer.defIds||[]).filter(function(t){return t&&t.indexOf&&0===t.indexOf("highcharts-pattern-")}).length&&(this.series.forEach(function(t){t.visible&&t.points.forEach(function(t){let e=t.options&&t.options.color;e&&e.pattern&&(e.pattern._width="defer",e.pattern._height="defer")})}),this.redraw(!1))}),d(e,"redraw",function(){let t={},e=this.renderer,i=(e.defIds||[]).filter(function(t){return t.indexOf&&0===t.indexOf("highcharts-pattern-")});i.length&&([].forEach.call(this.renderTo.querySelectorAll('[color^="url("], [fill^="url("], [stroke^="url("]'),function(i){let r=i.getAttribute("fill")||i.getAttribute("color")||i.getAttribute("stroke");if(r){let i=r.replace(e.url,"").replace("url(#","").replace(")","");t[i]=!0}}),i.forEach(function(i){!t[i]&&(c(e.defIds,i),e.patternElements[i]&&(e.patternElements[i].destroy(),delete e.patternElements[i]))}))})}),i(e,"Series/Pictorial/PictorialUtilities.js",[e["Core/Utilities.js"]],function(t){let{defined:e}=t;return{rescalePatternFill:function(t,e,i,r,s=1){let a=t&&t.attr("fill"),o=a&&a.match(/url\(([^)]+)\)/);if(o){let a=document.querySelector(`${o[1]} path`);if(a){let o=a.getBBox();if(0===o.width){let e=a.parentElement;t.renderer.box.appendChild(a),o=a.getBBox(),e.appendChild(a)}let n=1/(o.width+s),h=e/r/o.height,l=o.width/o.height,d=i/e,p=-o.width/2;l<d&&(n=n*l/d),a.setAttribute("stroke-width",s/(i*n)),a.setAttribute("transform",`translate(0.5, 0)scale(${n} ${h}) translate(${p+s*n/2}, ${-o.y})`)}}},invertShadowGroup:function(t,e){let i=e.chart.inverted;i&&t.attr({rotation:i?90:0,scaleX:i?-1:1})},getStackMetrics:function(t,i){let r=t.len,s=0;return i&&e(i.max)&&(s=t.toPixels(i.max,!0),r=t.len-s),{height:r,y:s}}}}),i(e,"Series/Pictorial/PictorialPoint.js",[e["Core/Series/SeriesRegistry.js"],e["Series/Pictorial/PictorialUtilities.js"]],function(t,e){let i=t.seriesTypes.column.prototype.pointClass,{rescalePatternFill:r,getStackMetrics:s}=e;return class extends i{constructor(){super(...arguments),this.options=void 0,this.series=void 0,this.pathDef=void 0}setState(){super.setState.apply(this,arguments);let t=this.series,e=t.options.paths;if(this.graphic&&this.shapeArgs&&e){let i=e[this.index%e.length];r(this.graphic,s(t.yAxis,i).height,this.shapeArgs.width||0,this.shapeArgs.height||1/0,this.series.options.borderWidth||0)}}}}),i(e,"Series/Pictorial/PictorialSeries.js",[e["Core/Animation/AnimationUtilities.js"],e["Core/Chart/Chart.js"],e["Series/Pictorial/PictorialPoint.js"],e["Series/Pictorial/PictorialUtilities.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Axis/Stacking/StackItem.js"],e["Core/Utilities.js"]],function(t,e,i,r,s,a,o){let n=s.seriesTypes.column,{animObject:h}=t,{getStackMetrics:l,invertShadowGroup:d,rescalePatternFill:p}=r,{addEvent:c,defined:f,merge:u,objectEach:g,pick:m}=o;class x extends n{constructor(){super(...arguments),this.paths=void 0,this.data=void 0,this.options=void 0,this.points=void 0}animate(t){let{chart:e,group:i}=this,r=h(this.options.animation),s=[this.getSharedClipKey(),r.duration,r.easing,r.defer].join(","),a=e.sharedClips[s];if(t&&i){let t=this.getClipBox();a||(t.y=t.height,t.height=0,a=e.renderer.clipRect(t),e.sharedClips[s]=a),i.clip(a)}else if(a&&!a.hasClass("highcharts-animating")){let t=this.getClipBox();a.addClass("highcharts-animating").animate(t,r)}}animateDrilldown(){}animateDrillupFrom(){}pointAttribs(t){let e=super.pointAttribs.apply(this,arguments),i=this.options,r=i.paths;if(t&&t.shapeArgs&&r){let i=r[t.index%r.length],{y:s,height:a}=l(this.yAxis,i),o=i.definition;o!==t.pathDef?(t.pathDef=o,e.fill={pattern:{path:{d:o,fill:e.fill,strokeWidth:e["stroke-width"],stroke:e.stroke},x:t.shapeArgs.x,y:s,width:t.shapeArgs.width||0,height:a,patternContentUnits:"objectBoundingBox",backgroundColor:"none",color:"#ff0000"}}):t.pathDef&&t.graphic&&delete e.fill}return delete e.stroke,delete e.strokeWidth,e}getExtremes(){let t=super.getExtremes.apply(this,arguments),e=this.options.paths;return e&&e.forEach(function(e){f(e.max)&&f(t.dataMax)&&e.max>t.dataMax&&(t.dataMax=e.max)}),t}}function w(t){let e=Object.keys(t.points).filter(t=>t.split(",").length>1),i=t.axis.chart.series,r=e.map(t=>parseFloat(t.split(",")[0])),s=-1;r.forEach(t=>{i[t]&&i[t].visible&&(s=t)});let a=t.axis.chart.series[s];if(a&&a.is("pictorial")&&t.axis.hasData()&&a.xAxis.hasData()){let e=a.xAxis,i=t.axis.options,r=t.axis.chart,s=t.shadow,o=e.toPixels(t.x,!0),n=r.inverted?e.len-o:o,h=a.options.paths||[],c=t.x%h.length,f=h[c],u=a.getColumnMetrics&&a.getColumnMetrics().width,{height:g,y:x}=l(a.yAxis,f),w=i.stackShadow,y=m(w&&w.borderWidth,a.options.borderWidth,1);if(!s&&w&&w.enabled&&f)t.shadowGroup||(t.shadowGroup=r.renderer.g("shadow-group").add()),t.shadowGroup.attr({translateX:r.inverted?t.axis.pos:e.pos,translateY:r.inverted?e.pos:t.axis.pos}),t.shadow=r.renderer.rect(n,x,u,g).attr({fill:{pattern:{path:{d:f.definition,fill:w.color||"#dedede",strokeWidth:y,stroke:w.borderColor||"transparent"},x:n,y:x,width:u,height:g,patternContentUnits:"objectBoundingBox",backgroundColor:"none",color:"#dedede"}}}).add(t.shadowGroup),d(t.shadowGroup,t.axis),p(t.shadow,g,u,g,y),t.setOffset(a.pointXOffset||0,a.barW||0);else if(s&&t.shadowGroup){s.animate({x:n,y:x,width:u,height:g});let i=s.attr("fill"),o=i&&i.match(/url\(([^)]+)\)/);o&&r.renderer.patternElements&&r.renderer.patternElements[o[1].slice(1)].animate({x:n,y:x,width:u,height:g}),t.shadowGroup.animate({translateX:r.inverted?t.axis.pos:e.pos,translateY:r.inverted?e.pos:t.axis.pos}),d(t.shadowGroup,t.axis),p(s,g,u,g,y),t.setOffset(a.pointXOffset||0,a.barW||0)}}else t.shadow&&t.shadowGroup&&(t.shadow.destroy(),t.shadow=void 0,t.shadowGroup.destroy(),t.shadowGroup=void 0)}function y(t,e){t.axes&&t.axes.forEach(function(t){if(!t.stacking)return;let i=t.stacking.stacks;g(i,function(t){g(t,function(t){e(t)})})})}function C(t){y(t,function(t){t.shadow&&t.shadowGroup&&(t.shadow.destroy(),t.shadowGroup.destroy(),delete t.shadow,delete t.shadowGroup)})}return x.defaultOptions=u(n.defaultOptions,{borderWidth:0}),c(x,"afterRender",function(){let t=this,e=t.options.paths,i=/url\(([^)]+)\)/;t.points.forEach(function(r){if(r.graphic&&r.shapeArgs&&e){let s=e[r.index%e.length],a=r.graphic.attr("fill"),o=a&&a.match(i),{y:n,height:h}=l(t.yAxis,s);if(o&&t.chart.renderer.patternElements){let e=t.chart.renderer.patternElements[o[1].slice(1)];e&&e.animate({x:r.shapeArgs.x,y:n,width:r.shapeArgs.width||0,height:h})}p(r.graphic,l(t.yAxis,s).height,r.shapeArgs.width||0,r.shapeArgs.height||1/0,t.options.borderWidth||0)}})}),c(e,"render",function(){y(this,w)}),c(a,"afterSetOffset",function(t){if(this.shadow){let{chart:e,len:i}=this.axis,{xOffset:r,width:s}=t,a=e.inverted?r-e.xAxis[0].len:r,o=e.inverted?-i:0;this.shadow.attr({translateX:a,translateY:o}),this.shadow.animate({width:s})}}),c(e,"afterDrilldown",function(t){C(this)}),c(e,"afterDrillUp",function(t){C(this)}),x.prototype.pointClass=i,s.registerSeriesType("pictorial",x),x}),i(e,"masters/modules/pictorial.src.js",[],function(){})});//# sourceMappingURL=pictorial.js.map