/**
 * Highstock JS v11.2.0 (2023-10-30)
 *
 * Highcharts Stock as a plugin for Highcharts
 *
 * (c) 2010-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */!function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/stock",["highcharts"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function i(t,e,i,s){t.hasOwnProperty(e)||(t[e]=s.apply(null,i),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:t[e]}})))}i(e,"Core/Axis/BrokenAxis.js",[e["Core/Axis/Stacking/StackItem.js"],e["Core/Utilities.js"]],function(t,e){var i;let{addEvent:s,find:o,fireEvent:r,isArray:n,isNumber:a,pick:l}=e;return function(i){let h=[];function d(){void 0!==this.brokenAxis&&this.brokenAxis.setBreaks(this.options.breaks,!1)}function p(){this.brokenAxis?.hasBreaks&&(this.options.ordinal=!1)}function c(){let t=this.brokenAxis;if(t?.hasBreaks){let e=this.tickPositions,i=this.tickPositions.info,s=[];for(let i=0;i<e.length;i++)t.isInAnyBreak(e[i])||s.push(e[i]);this.tickPositions=s,this.tickPositions.info=i}}function u(){this.brokenAxis||(this.brokenAxis=new v(this))}function g(){let{isDirty:t,options:{connectNulls:e},points:i,xAxis:s,yAxis:o}=this;if(t){let t=i.length;for(;t--;){let r=i[t],n=null===r.y&&!1===e,a=!n&&(s?.brokenAxis?.isInAnyBreak(r.x,!0)||o?.brokenAxis?.isInAnyBreak(r.y,!0));r.visible=!a&&!1!==r.options.visible}}}function f(){this.drawBreaks(this.xAxis,["x"]),this.drawBreaks(this.yAxis,l(this.pointArrayMap,["y"]))}function x(t,e){let i,s,o;let n=this,h=n.points;if(t?.brokenAxis?.hasBreaks){let d=t.brokenAxis;e.forEach(function(e){i=d?.breakArray||[],s=t.isXAxis?t.min:l(n.options.threshold,t.min);let p=t?.options?.breaks?.filter(function(t){let e=!0;for(let s=0;s<i.length;s++){let o=i[s];if(o.from===t.from&&o.to===t.to){e=!1;break}}return e});h.forEach(function(n){o=l(n["stack"+e.toUpperCase()],n[e]),i.forEach(function(e){if(a(s)&&a(o)){let i="";s<e.from&&o>e.to||s>e.from&&o<e.from?i="pointBreak":(s<e.from&&o>e.from&&o<e.to||s>e.from&&o>e.to&&o<e.from)&&(i="pointInBreak"),i&&r(t,i,{point:n,brk:e})}}),p?.forEach(function(e){r(t,"pointOutsideOfBreak",{point:n,brk:e})})})})}}function m(){let e=this.currentDataGrouping,i=e?.gapSize,s=this.points.slice(),o=this.yAxis,r=this.options.gapSize,n=s.length-1;if(r&&n>0){let e,a;for("value"!==this.options.gapUnit&&(r*=this.basePointRange),i&&i>r&&i>=this.basePointRange&&(r=i);n--;)if(a&&!1!==a.visible||(a=s[n+1]),e=s[n],!1!==a.visible&&!1!==e.visible){if(a.x-e.x>r){let i=(e.x+a.x)/2;s.splice(n+1,0,{isNull:!0,x:i}),o.stacking&&this.options.stacking&&((o.stacking.stacks[this.stackKey][i]=new t(o,o.options.stackLabels,!1,i,this.stack)).total=0)}a=e}}return this.getGraphPath(s)}i.compose=function(t,i){if(e.pushUnique(h,t)&&(t.keepProps.push("brokenAxis"),s(t,"init",u),s(t,"afterInit",d),s(t,"afterSetTickPositions",c),s(t,"afterSetOptions",p)),e.pushUnique(h,i)){let t=i.prototype;t.drawBreaks=x,t.gappedPath=m,s(i,"afterGeneratePoints",g),s(i,"afterRender",f)}return t};class v{static isInBreak(t,e){let i=t.repeat||1/0,s=t.from,o=t.to-t.from,r=e>=s?(e-s)%i:i-(s-e)%i;return t.inclusive?r<=o:r<o&&0!==r}static lin2Val(t){let e=this.brokenAxis,i=e&&e.breakArray;if(!i||!a(t))return t;let s=t,o,r;for(r=0;r<i.length&&!((o=i[r]).from>=s);r++)o.to<s?s+=o.len:v.isInBreak(o,s)&&(s+=o.len);return s}static val2Lin(t){let e=this.brokenAxis,i=e&&e.breakArray;if(!i||!a(t))return t;let s=t,o,r;for(r=0;r<i.length;r++)if((o=i[r]).to<=t)s-=o.len;else if(o.from>=t)break;else if(v.isInBreak(o,t)){s-=t-o.from;break}return s}constructor(t){this.hasBreaks=!1,this.axis=t}findBreakAt(t,e){return o(e,function(e){return e.from<t&&t<e.to})}isInAnyBreak(t,e){let i=this.axis,s=i.options.breaks||[],o=s.length,r,n,h;if(o&&a(t)){for(;o--;)v.isInBreak(s[o],t)&&(r=!0,n||(n=l(s[o].showPoints,!i.isXAxis)));h=r&&e?r&&!n:r}return h}setBreaks(t,e){let i=this,s=i.axis,o=n(t)&&!!t.length&&!!Object.keys(t[0]).length;s.isDirty=i.hasBreaks!==o,i.hasBreaks=o,t!==s.options.breaks&&(s.options.breaks=s.userOptions.breaks=t),s.forceRedraw=!0,s.series.forEach(function(t){t.isDirty=!0}),o||s.val2lin!==v.val2Lin||(delete s.val2lin,delete s.lin2val),o&&(s.userOptions.ordinal=!1,s.lin2val=v.lin2Val,s.val2lin=v.val2Lin,s.setExtremes=function(t,e,o,r,n){if(i.hasBreaks){let s;let o=this.options.breaks||[];for(;s=i.findBreakAt(t,o);)t=s.to;for(;s=i.findBreakAt(e,o);)e=s.from;e<t&&(e=t)}s.constructor.prototype.setExtremes.call(this,t,e,o,r,n)},s.setAxisTranslation=function(){if(s.constructor.prototype.setAxisTranslation.call(this),i.unitLength=void 0,i.hasBreaks){let t=s.options.breaks||[],e=[],o=[],n=l(s.pointRangePadding,0),h=0,d,p,c=s.userMin||s.min,u=s.userMax||s.max,g,f;t.forEach(function(t){p=t.repeat||1/0,a(c)&&a(u)&&(v.isInBreak(t,c)&&(c+=t.to%p-c%p),v.isInBreak(t,u)&&(u-=u%p-t.from%p))}),t.forEach(function(t){if(g=t.from,p=t.repeat||1/0,a(c)&&a(u)){for(;g-p>c;)g-=p;for(;g<c;)g+=p;for(f=g;f<u;f+=p)e.push({value:f,move:"in"}),e.push({value:f+t.to-t.from,move:"out",size:t.breakSize})}}),e.sort(function(t,e){return t.value===e.value?("in"===t.move?0:1)-("in"===e.move?0:1):t.value-e.value}),d=0,g=c,e.forEach(function(t){1===(d+="in"===t.move?1:-1)&&"in"===t.move&&(g=t.value),0===d&&a(g)&&(o.push({from:g,to:t.value,len:t.value-g-(t.size||0)}),h+=t.value-g-(t.size||0))}),i.breakArray=o,a(c)&&a(u)&&a(s.min)&&(i.unitLength=u-c-h+n,r(s,"afterBreaks"),s.staticScale?s.transA=s.staticScale:i.unitLength&&(s.transA*=(u-s.min+n)/i.unitLength),n&&(s.minPixelPadding=s.transA*(s.minPointOffset||0)),s.min=c,s.max=u)}}),l(e,!0)&&s.chart.redraw()}}i.Additions=v}(i||(i={})),i}),i(e,"masters/modules/broken-axis.src.js",[e["Core/Globals.js"],e["Core/Axis/BrokenAxis.js"]],function(t,e){e.compose(t.Axis,t.Series)}),i(e,"Extensions/DataGrouping/ApproximationRegistry.js",[],function(){return{}}),i(e,"Extensions/DataGrouping/ApproximationDefaults.js",[e["Extensions/DataGrouping/ApproximationRegistry.js"],e["Core/Utilities.js"]],function(t,e){let{arrayMax:i,arrayMin:s,correctFloat:o,extend:r,isNumber:n}=e;function a(t){let e=t.length,i=l(t);return n(i)&&e&&(i=o(i/e)),i}function l(t){let e=t.length,i;if(!e&&t.hasNulls)i=null;else if(e)for(i=0;e--;)i+=t[e];return i}let h={average:a,averages:function(){let t=[];return[].forEach.call(arguments,function(e){t.push(a(e))}),void 0===t[0]?void 0:t},close:function(t){return t.length?t[t.length-1]:t.hasNulls?null:void 0},high:function(t){return t.length?i(t):t.hasNulls?null:void 0},hlc:function(e,i,s){if(e=t.high(e),i=t.low(i),s=t.close(s),n(e)||n(i)||n(s))return[e,i,s]},low:function(t){return t.length?s(t):t.hasNulls?null:void 0},ohlc:function(e,i,s,o){if(e=t.open(e),i=t.high(i),s=t.low(s),o=t.close(o),n(e)||n(i)||n(s)||n(o))return[e,i,s,o]},open:function(t){return t.length?t[0]:t.hasNulls?null:void 0},range:function(e,i){return(e=t.low(e),i=t.high(i),n(e)||n(i))?[e,i]:null===e&&null===i?null:void 0},sum:l};return r(t,h),h}),i(e,"Extensions/DataGrouping/DataGroupingDefaults.js",[],function(){return{common:{groupPixelWidth:2,dateTimeLabelFormats:{millisecond:["%A, %e %b, %H:%M:%S.%L","%A, %e %b, %H:%M:%S.%L","-%H:%M:%S.%L"],second:["%A, %e %b, %H:%M:%S","%A, %e %b, %H:%M:%S","-%H:%M:%S"],minute:["%A, %e %b, %H:%M","%A, %e %b, %H:%M","-%H:%M"],hour:["%A, %e %b, %H:%M","%A, %e %b, %H:%M","-%H:%M"],day:["%A, %e %b %Y","%A, %e %b","-%A, %e %b %Y"],week:["Week from %A, %e %b %Y","%A, %e %b","-%A, %e %b %Y"],month:["%B %Y","%B","-%B %Y"],year:["%Y","%Y","-%Y"]}},seriesSpecific:{line:{},spline:{},area:{},areaspline:{},arearange:{},column:{groupPixelWidth:10},columnrange:{groupPixelWidth:10},candlestick:{groupPixelWidth:10},ohlc:{groupPixelWidth:5},hlc:{groupPixelWidth:5},heikinashi:{groupPixelWidth:10}},units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1]],["week",[1]],["month",[1,3,6]],["year",null]]}}),i(e,"Extensions/DataGrouping/DataGroupingAxisComposition.js",[e["Extensions/DataGrouping/DataGroupingDefaults.js"],e["Core/Utilities.js"]],function(t,e){let i;let{addEvent:s,extend:o,merge:r,pick:n}=e,a=[];function l(t){let e=this,i=e.series;i.forEach(function(t){t.groupPixelWidth=void 0}),i.forEach(function(i){i.groupPixelWidth=e.getGroupPixelWidth&&e.getGroupPixelWidth(),i.groupPixelWidth&&(i.hasProcessed=!0),i.applyGrouping(!!t.hasExtremesChanged)})}function h(){let e=this.series,i=e.length,s=0,o=!1,r,a;for(;i--;)(a=e[i].options.dataGrouping)&&(s=Math.max(s,n(a.groupPixelWidth,t.common.groupPixelWidth)),r=(e[i].processedXData||e[i].data).length,(e[i].groupPixelWidth||r>this.chart.plotSizeX/s||r&&a.forced)&&(o=!0));return o?s:0}function d(){this.series.forEach(function(t){t.hasProcessed=!1})}function p(t,e){let s;if(e=n(e,!0),t||(t={forced:!1,units:null}),this instanceof i)for(s=this.series.length;s--;)this.series[s].update({dataGrouping:t},!1);else this.chart.options.series.forEach(function(e){e.dataGrouping="boolean"==typeof t?t:r(t,e.dataGrouping)});this.ordinal&&(this.ordinal.slope=void 0),e&&this.chart.redraw()}return{compose:function(t){i=t,e.pushUnique(a,t)&&(s(t,"afterSetScale",d),s(t,"postProcessData",l),o(t.prototype,{applyGrouping:l,getGroupPixelWidth:h,setDataGrouping:p}))}}}),i(e,"Extensions/DataGrouping/DataGroupingSeriesComposition.js",[e["Extensions/DataGrouping/ApproximationRegistry.js"],e["Extensions/DataGrouping/DataGroupingDefaults.js"],e["Core/Axis/DateTimeAxis.js"],e["Core/Defaults.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,i,s,o,r){let{series:{prototype:n}}=o,{addEvent:a,defined:l,error:h,extend:d,isNumber:p,merge:c,pick:u}=r,g=n.generatePoints,f=[];function x(t){var s;let o=this.chart,r=this.options,a=r.dataGrouping,d=!1!==this.allowDG&&a&&u(a.enabled,o.options.isStock),c=this.reserveSpace(),g=this.currentDataGrouping,f,x,m=!1;d&&!this.requireSorting&&(this.requireSorting=m=!0);let v=!1==!(this.isCartesian&&!this.isDirty&&!this.xAxis.isDirty&&!this.yAxis.isDirty&&!t)||!d;if(m&&(this.requireSorting=!1),!v){let t,r;this.destroyGroupedData();let d=a.groupAll?this.xData:this.processedXData,m=a.groupAll?this.yData:this.processedYData,v=o.plotSizeX,b=this.xAxis,y=b.options.ordinal,M=this.groupPixelWidth;if(M&&d&&d.length&&v){r=!0,this.isDirty=!0,this.points=null;let g=b.getExtremes(),S=g.min,A=g.max,k=y&&b.ordinal&&b.ordinal.getGroupIntervalFactor(S,A,this)||1,C=M*(A-S)/v*k,D=b.getTimeTicks(i.Additions.prototype.normalizeTimeTickInterval(C,a.units||e.units),Math.min(S,d[0]),Math.max(A,d[d.length-1]),b.options.startOfWeek,d,this.closestPointRange),w=n.groupData.apply(this,[d,m,D,a.approximation]),E=w.groupedXData,B=w.groupedYData,O=0;for(a&&a.smoothed&&E.length&&(a.firstAnchor="firstPoint",a.anchor="middle",a.lastAnchor="lastPoint",h(32,!1,o,{"dataGrouping.smoothed":"use dataGrouping.anchor"})),t=1;t<D.length;t++)D.info.segmentStarts&&-1!==D.info.segmentStarts.indexOf(t)||(O=Math.max(D[t]-D[t-1],O));(f=D.info).gapSize=O,this.closestPointRange=D.info.totalRange,this.groupMap=w.groupMap,this.currentDataGrouping=f,function(t,e,i){let s;let o=t.options,r=o.dataGrouping,n=t.currentDataGrouping&&t.currentDataGrouping.gapSize;if(r&&t.xData&&n&&t.groupMap){let o=e.length-1,a=r.anchor,l=u(r.firstAnchor,a),h=u(r.lastAnchor,a);if(a&&"start"!==a){let t=n*({middle:.5,end:1})[a];for(s=e.length-1;s--&&s>0;)e[s]+=t}if(l&&"start"!==l&&t.xData[0]>=e[0]){let i;let s=t.groupMap[0].start,o=t.groupMap[0].length;p(s)&&p(o)&&(i=s+(o-1)),e[0]=({middle:e[0]+.5*n,end:e[0]+n,firstPoint:t.xData[0],lastPoint:i&&t.xData[i]})[l]}if(h&&"start"!==h&&n&&e[o]>=i-n){let i=t.groupMap[t.groupMap.length-1].start;e[o]=({middle:e[o]+.5*n,end:e[o]+n,firstPoint:i&&t.xData[i],lastPoint:t.xData[t.xData.length-1]})[h]}}}(this,E,A),c&&(l((s=E)[0])&&p(b.min)&&p(b.dataMin)&&s[0]<b.min&&((!l(b.options.min)&&b.min<=b.dataMin||b.min===b.dataMin)&&(b.min=Math.min(s[0],b.min)),b.dataMin=Math.min(s[0],b.dataMin)),l(s[s.length-1])&&p(b.max)&&p(b.dataMax)&&s[s.length-1]>b.max&&((!l(b.options.max)&&p(b.dataMax)&&b.max>=b.dataMax||b.max===b.dataMax)&&(b.max=Math.max(s[s.length-1],b.max)),b.dataMax=Math.max(s[s.length-1],b.dataMax))),a.groupAll&&(this.allGroupedData=B,E=(x=this.cropData(E,B,b.min,b.max)).xData,B=x.yData,this.cropStart=x.start),this.processedXData=E,this.processedYData=B}else this.groupMap=null;this.hasGroupedData=r,this.preventGraphAnimation=(g&&g.totalRange)!==(f&&f.totalRange)}}function m(){this.groupedData&&(this.groupedData.forEach(function(t,e){t&&(this.groupedData[e]=t.destroy?t.destroy():null)},this),this.groupedData.length=0)}function v(){g.apply(this),this.destroyGroupedData(),this.groupedData=this.hasGroupedData?this.points:null}function b(){return this.is("arearange")?"range":this.is("ohlc")?"ohlc":this.is("hlc")?"hlc":this.is("column")||this.options.cumulative?"sum":"average"}function y(e,i,s,o){let r=this,n=r.data,a=r.options&&r.options.data,h=[],d=[],u=[],g=e.length,f=!!i,x=[],m=r.pointArrayMap,v=m&&m.length,b=["x"].concat(m||["y"]),y=this.options.dataGrouping&&this.options.dataGrouping.groupAll,M,S,A,k=0,C=0,D="function"==typeof o?o:o&&t[o]?t[o]:t[r.getDGApproximation&&r.getDGApproximation()||"average"];if(v){let t=m.length;for(;t--;)x.push([])}else x.push([]);let w=v||1;for(let t=0;t<=g;t++)if(!(e[t]<s[0])){for(;void 0!==s[k+1]&&e[t]>=s[k+1]||t===g;){M=s[k],r.dataGroupInfo={start:y?C:r.cropStart+C,length:x[0].length},A=D.apply(r,x),r.pointClass&&!l(r.dataGroupInfo.options)&&(r.dataGroupInfo.options=c(r.pointClass.prototype.optionsToObject.call({series:r},r.options.data[r.cropStart+C])),b.forEach(function(t){delete r.dataGroupInfo.options[t]})),void 0!==A&&(h.push(M),d.push(A),u.push(r.dataGroupInfo)),C=t;for(let t=0;t<w;t++)x[t].length=0,x[t].hasNulls=!1;if(k+=1,t===g)break}if(t===g)break;if(m){let e;let i=r.options.dataGrouping&&r.options.dataGrouping.groupAll?t:r.cropStart+t,s=n&&n[i]||r.pointClass.prototype.applyOptions.apply({series:r},[a[i]]);for(let t=0;t<v;t++)p(e=s[m[t]])?x[t].push(e):null===e&&(x[t].hasNulls=!0)}else p(S=f?i[t]:null)?x[0].push(S):null===S&&(x[0].hasNulls=!0)}return{groupedXData:h,groupedYData:d,groupMap:u}}function M(t){let i=t.options,o=this.type,r=this.chart.options.plotOptions,n=this.useCommonDataGrouping&&e.common,a=e.seriesSpecific,l=s.defaultOptions.plotOptions[o].dataGrouping;if(r&&(a[o]||n)){let t=this.chart.rangeSelector;l||(l=c(e.common,a[o])),i.dataGrouping=c(n,l,r.series&&r.series.dataGrouping,r[o].dataGrouping,this.userOptions.dataGrouping,!i.isInternal&&t&&p(t.selected)&&t.buttonOptions[t.selected].dataGrouping)}}return{compose:function(t){let e=t.prototype.pointClass;r.pushUnique(f,e)&&a(e,"update",function(){if(this.dataGroup)return h(24,!1,this.series.chart),!1}),r.pushUnique(f,t)&&(a(t,"afterSetOptions",M),a(t,"destroy",m),d(t.prototype,{applyGrouping:x,destroyGroupedData:m,generatePoints:v,getDGApproximation:b,groupData:y}))},groupData:y}}),i(e,"Extensions/DataGrouping/DataGrouping.js",[e["Extensions/DataGrouping/DataGroupingAxisComposition.js"],e["Extensions/DataGrouping/DataGroupingDefaults.js"],e["Extensions/DataGrouping/DataGroupingSeriesComposition.js"],e["Core/Templating.js"],e["Core/Utilities.js"]],function(t,e,i,s,o){let{format:r}=s,{addEvent:n,extend:a,isNumber:l}=o,h=[];function d(t){let i=this.chart,s=i.time,o=t.labelConfig,n=o.series,h=n.options,d=n.tooltipOptions,p=h.dataGrouping,c=n.xAxis,u=d.xDateFormat,g,f,x,m,v,b=d[t.isFooter?"footerFormat":"headerFormat"];c&&"datetime"===c.options.type&&p&&l(o.key)&&(f=n.currentDataGrouping,x=p.dateTimeLabelFormats||e.common.dateTimeLabelFormats,f?(m=x[f.unitName],1===f.count?u=m[0]:(u=m[1],g=m[2])):!u&&x&&c.dateTime&&(u=c.dateTime.getXDateFormat(o.x,d.dateTimeLabelFormats)),v=s.dateFormat(u,o.key),g&&(v+=s.dateFormat(g,o.key+f.totalRange-1)),n.chart.styledMode&&(b=this.styledModeFormat(b)),t.text=r(b,{point:a(o.point,{key:v}),series:n},i),t.preventDefault())}let p={compose:function(e,s,r){t.compose(e),i.compose(s),r&&o.pushUnique(h,r)&&n(r,"headerFormatter",d)},groupData:i.groupData};return p}),i(e,"masters/modules/datagrouping.src.js",[e["Core/Globals.js"],e["Extensions/DataGrouping/ApproximationDefaults.js"],e["Extensions/DataGrouping/ApproximationRegistry.js"],e["Extensions/DataGrouping/DataGrouping.js"]],function(t,e,i,s){t.dataGrouping={approximationDefaults:e,approximations:i},s.compose(t.Axis,t.Series,t.Tooltip)}),i(e,"Extensions/Annotations/NavigationBindingsUtilities.js",[e["Core/Utilities.js"]],function(t){let{defined:e,isNumber:i,pick:s}=t,o={backgroundColor:"string",borderColor:"string",borderRadius:"string",color:"string",fill:"string",fontSize:"string",labels:"string",name:"string",stroke:"string",title:"string"};return{annotationsFieldsTypes:o,getAssignedAxis:function(t){return t.filter(t=>{let e=t.axis.getExtremes(),o=e.min,r=e.max,n=s(t.axis.minPointOffset,0);return i(o)&&i(r)&&t.value>=o-n&&t.value<=r+n&&!t.axis.options.isInternal})[0]},getFieldType:function(t,i){let s=o[t],r=typeof i;return e(s)&&(r=s),({string:"text",number:"number",boolean:"checkbox"})[r]}}}),i(e,"Extensions/MouseWheelZoom/MouseWheelZoom.js",[e["Core/Utilities.js"],e["Extensions/Annotations/NavigationBindingsUtilities.js"]],function(t,e){let i,s,o;let{addEvent:r,isObject:n,pick:a,defined:l,merge:h,isNumber:d}=t,{getAssignedAxis:p}=e,c=[],u={enabled:!0,sensitivity:1.1},g=t=>n(t)?h(u,t):h(u,{enabled:!l(t)||t}),f=(t,e,i,s)=>(i+s>t+e&&(s>e?(s=e,i=t):i=t+e-s),s>e&&(s=e),i<t&&(i=t),{rangeStart:i,rangeWidth:s}),x=function(t){let e=t.options;l(i)&&clearTimeout(i),l(s)||(s=e.startOnTick,o=e.endOnTick),(s||o)&&(e.startOnTick=!1,e.endOnTick=!1),i=setTimeout(()=>{if(l(s)&&l(o)){e.startOnTick=s,e.endOnTick=o;let{min:i,max:r}=t.getExtremes();t.forceRedraw=!0,t.setExtremes(i,r),s=o=void 0}},400)},m=function(t,e,i){if(!l(i))return .5;let s=(i-e.pos)/e.len,o=e.isXAxis;return o&&!e.reversed!=!t.inverted||!o&&e.reversed?1-s:s},v=function(t,e,i,s,o){let r=e.isXAxis,n=!1;if(l(e.max)&&l(e.min)&&l(e.dataMax)&&l(e.dataMin)){r||x(e);let h=e.max-e.min,p=d(o)?o:e.min+h/2,c=m(t,e,i),u=h*s,g=p-u*c,v=a(e.options.max,e.dataMax)-a(e.options.min,e.dataMin),b=e.options.min?0:v*e.options.minPadding,y=e.options.max?0:v*e.options.maxPadding,M=a(e.options.min,e.dataMin)-b,S=v+y+b,A=f(M,S,g,u),k=A.rangeStart<a(e.options.min,M)||A.rangeStart===e.min&&A.rangeWidth>S&&A.rangeStart+A.rangeWidth<a(e.options.max,Number.MIN_VALUE)||A.rangeWidth===e.max-e.min;l(s)&&!k?(e.setExtremes(A.rangeStart,A.rangeStart+A.rangeWidth,!1),n=!0):e.setExtremes(void 0,void 0,!1)}return n},b=function(t,e,i,s,o,r,n){let l=a(n.type,t.zooming.type,""),h=/x/.test(l),d=/y/.test(l),p=i.toValue(o),c=s.toValue(r);if(t.inverted){let t=s.pos+s.len;p=i.toValue(r),c=s.toValue(o);let e=o;o=r,r=t-e+s.pos}let u=h&&v(t,i,o,e,p),g=d&&v(t,s,r,e,c),f=u||g;return f&&t.redraw(!1),f};function y(){let t=this,e=g(t.zooming.mouseWheel);e.enabled&&r(this.container,"wheel",i=>{i=this.pointer.normalize(i);let s=!t.pointer.inClass(i.target,"highcharts-no-mousewheel");if(t.isInsidePlot(i.chartX-t.plotLeft,i.chartY-t.plotTop)&&s){let s=e.sensitivity||1.1,o=i.detail||(i.deltaY||0)/120,r=p(this.pointer.getCoordinates(i).xAxis),n=p(this.pointer.getCoordinates(i).yAxis),a=b(t,Math.pow(s,o),r?r.axis:t.xAxis[0],n?n.axis:t.yAxis[0],i.chartX,i.chartY,e);a&&i.preventDefault&&i.preventDefault()}})}return{compose:function(t){-1===c.indexOf(t)&&(c.push(t),r(t,"afterGetContainer",y))}}}),i(e,"masters/modules/mouse-wheel-zoom.src.js",[e["Core/Globals.js"],e["Extensions/MouseWheelZoom/MouseWheelZoom.js"]],function(t,e){e.compose(t.Chart)}),i(e,"Series/DataModifyComposition.js",[e["Core/Axis/Axis.js"],e["Core/Series/Point.js"],e["Core/Series/Series.js"],e["Core/Utilities.js"]],function(t,e,i,s){var o;let{prototype:{tooltipFormatter:r}}=e,{addEvent:n,arrayMax:a,arrayMin:l,correctFloat:h,defined:d,isArray:p,isNumber:c,isString:u,pick:g}=s;return function(t){let e=[];function i(t,e,i){!this.isXAxis&&(this.series.forEach(function(i){"compare"===t&&"boolean"!=typeof e?i.setCompare(e,!1):"cumulative"!==t||u(e)||i.setCumulative(e,!1)}),g(i,!0)&&this.chart.redraw())}function o(t){let e=this,{numberFormatter:i}=e.series.chart,s=function(s){t=t.replace("{point."+s+"}",(e[s]>0&&"change"===s?"+":"")+i(e[s],g(e.series.tooltipOptions.changeDecimals,2)))};return d(e.change)&&s("change"),d(e.cumulativeSum)&&s("cumulativeSum"),r.apply(this,[t])}function f(){let t;let e=this.options.compare;("percent"===e||"value"===e||this.options.cumulative)&&(t=new S(this),"percent"===e||"value"===e?t.initCompare(e):t.initCumulative()),this.dataModify=t}function x(t){let e=t.dataExtremes,i=e.activeYData;if(this.dataModify&&e){let t;this.options.compare?t=[this.dataModify.modifyValue(e.dataMin),this.dataModify.modifyValue(e.dataMax)]:this.options.cumulative&&p(i)&&i.length>=2&&(t=S.getCumulativeExtremes(i)),t&&(e.dataMin=l(t),e.dataMax=a(t))}}function m(t,e){this.options.compare=this.userOptions.compare=t,this.update({},g(e,!0)),this.dataModify&&("value"===t||"percent"===t)?this.dataModify.initCompare(t):this.points.forEach(t=>{delete t.change})}function v(){if(this.xAxis&&this.processedYData&&this.dataModify){let t=this.processedXData,e=this.processedYData,i=e.length,s=!0===this.options.compareStart?0:1,o=-1,r;for(this.pointArrayMap&&(o=this.pointArrayMap.indexOf(this.options.pointValKey||this.pointValKey||"y")),r=0;r<i-s;r++){let i=e[r]&&o>-1?e[r][o]:e[r];if(c(i)&&0!==i&&t[r+s]>=(this.xAxis.min||0)){this.dataModify.compareValue=i;break}}}}function b(t,e){this.setModifier("compare",t,e)}function y(t,e){t=g(t,!1),this.options.cumulative=this.userOptions.cumulative=t,this.update({},g(e,!0)),this.dataModify?this.dataModify.initCumulative():this.points.forEach(t=>{delete t.cumulativeSum})}function M(t,e){this.setModifier("cumulative",t,e)}t.compose=function(t,r,a){if(s.pushUnique(e,t)){let e=t.prototype;e.setCompare=m,e.setCumulative=y,n(t,"afterInit",f),n(t,"afterGetExtremes",x),n(t,"afterProcessData",v)}if(s.pushUnique(e,r)){let t=r.prototype;t.setCompare=b,t.setModifier=i,t.setCumulative=M}if(s.pushUnique(e,a)){let t=a.prototype;t.tooltipFormatter=o}return t};class S{constructor(t){this.series=t}modifyValue(){return 0}static getCumulativeExtremes(t){let e=1/0,i=-1/0;return t.reduce((t,s)=>{let o=t+s;return e=Math.min(e,o,t),i=Math.max(i,o,t),o}),[e,i]}initCompare(t){this.modifyValue=function(e,i){null===e&&(e=0);let s=this.compareValue;if(void 0!==e&&void 0!==s){if("value"===t)e-=s;else{let t=this.series.options.compareBase;e=100*(e/s)-(100===t?0:100)}if(void 0!==i){let t=this.series.points[i];t&&(t.change=e)}return e}return 0}}initCumulative(){this.modifyValue=function(t,e){if(null===t&&(t=0),void 0!==t&&void 0!==e){let i=e>0?this.series.points[e-1]:null;i&&i.cumulativeSum&&(t=h(i.cumulativeSum+t));let s=this.series.points[e];return s&&(s.cumulativeSum=t),t}return 0}}}t.Additions=S}(o||(o={})),o}),i(e,"Core/Axis/NavigatorAxisComposition.js",[e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e){let{isTouchDevice:i}=t,{addEvent:s,correctFloat:o,defined:r,isNumber:n,pick:a}=e,l=[];function h(){this.navigatorAxis||(this.navigatorAxis=new p(this))}function d(t){let e=this.chart,s=e.options,o=s.navigator,n=this.navigatorAxis,a=e.zooming.pinchType,l=s.rangeSelector,h=e.zooming.type;if(this.isXAxis&&(o&&o.enabled||l&&l.enabled)){if("y"===h)t.zoomed=!1;else if((!i&&"xy"===h||i&&"xy"===a)&&this.options.range){let e=n.previousZoom;r(t.newMin)?n.previousZoom=[this.min,this.max]:e&&(t.newMin=e[0],t.newMax=e[1],n.previousZoom=void 0)}}void 0!==t.zoomed&&t.preventDefault()}class p{static compose(t){e.pushUnique(l,t)&&(t.keepProps.push("navigatorAxis"),s(t,"init",h),s(t,"zoom",d))}constructor(t){this.axis=t}destroy(){this.axis=void 0}toFixedRange(t,e,i,s){let l=this.axis,h=l.chart,d=a(i,l.translate(t,!0,!l.horiz)),p=a(s,l.translate(e,!0,!l.horiz)),c=h&&h.fixedRange,u=(l.pointRange||0)/2;return r(i)||(d=o(d+u)),r(s)||(p=o(p-u)),c&&l.dataMin&&l.dataMax&&(p>=l.dataMax&&(d=o(l.dataMax-c)),d<=l.dataMin&&(p=o(l.dataMin+c))),n(d)&&n(p)||(d=p=void 0),{min:d,max:p}}}return p}),i(e,"Stock/Navigator/NavigatorDefaults.js",[e["Core/Color/Color.js"],e["Core/Series/SeriesRegistry.js"]],function(t,e){let{parse:i}=t,{seriesTypes:s}=e,o={height:40,margin:25,maskInside:!0,handles:{width:7,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:"#f2f2f2",borderColor:"#999999"},maskFill:i("#667aff").setOpacity(.3).get(),outlineColor:"#999999",outlineWidth:1,series:{type:void 0===s.areaspline?"line":"areaspline",fillOpacity:.05,lineWidth:1,compare:null,sonification:{enabled:!1},dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},threshold:null},xAxis:{overscroll:0,className:"highcharts-navigator-xaxis",tickLength:0,lineWidth:0,gridLineColor:"#e6e6e6",gridLineWidth:1,tickPixelInterval:200,labels:{align:"left",style:{color:"#000000",fontSize:"0.7em",opacity:.6,textOutline:"2px contrast"},x:3,y:-4},crosshair:!1},yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}};return o}),i(e,"Stock/Navigator/NavigatorSymbols.js",[],function(){return{"navigator-handle":function(t,e,i,s,o={}){let r=o.width?o.width/2:i,n=Math.round(r/3)+.5;return[["M",-r-1,.5],["L",r,.5],["L",r,(s=o.height||s)+.5],["L",-r-1,s+.5],["L",-r-1,.5],["M",-n,4],["L",-n,s-3],["M",n-1,4],["L",n-1,s-3]]}}}),i(e,"Stock/Navigator/NavigatorComposition.js",[e["Core/Defaults.js"],e["Core/Globals.js"],e["Core/Axis/NavigatorAxisComposition.js"],e["Stock/Navigator/NavigatorDefaults.js"],e["Stock/Navigator/NavigatorSymbols.js"],e["Core/Renderer/RendererRegistry.js"],e["Core/Utilities.js"]],function(t,e,i,s,o,r,n){let a;let{defaultOptions:l,setOptions:h}=t,{isTouchDevice:d}=e,{getRendererType:p}=r,{addEvent:c,extend:u,merge:g,pick:f}=n,x=[];function m(){this.navigator&&this.navigator.setBaseSeries(null,!1)}function v(){let t,e,i;let s=this.legend,o=this.navigator;if(o){t=s&&s.options,e=o.xAxis,i=o.yAxis;let{scrollbarHeight:r,scrollButtonSize:n}=o;this.inverted?(o.left=o.opposite?this.chartWidth-r-o.height:this.spacing[3]+r,o.top=this.plotTop+n):(o.left=f(e.left,this.plotLeft+n),o.top=o.navigatorOptions.top||this.chartHeight-o.height-r-(this.scrollbar?.options.margin||0)-this.spacing[2]-(this.rangeSelector&&this.extraBottomMargin?this.rangeSelector.getHeight():0)-(t&&"bottom"===t.verticalAlign&&"proximate"!==t.layout&&t.enabled&&!t.floating?s.legendHeight+f(t.margin,10):0)-(this.titleOffset?this.titleOffset[2]:0)),e&&i&&(this.inverted?e.options.left=i.options.left=o.left:e.options.top=i.options.top=o.top,e.setAxisSize(),i.setAxisSize())}}function b(t){!this.navigator&&!this.scroller&&(this.options.navigator.enabled||this.options.scrollbar.enabled)&&(this.scroller=this.navigator=new a(this),f(t.redraw,!0)&&this.redraw(t.animation))}function y(){let t=this.options;(t.navigator.enabled||t.scrollbar.enabled)&&(this.scroller=this.navigator=new a(this))}function M(){let t=this.options,e=t.navigator,i=t.rangeSelector;if((e&&e.enabled||i&&i.enabled)&&(!d&&"x"===this.zooming.type||d&&"x"===this.zooming.pinchType))return!1}function S(t){let e=t.navigator;if(e&&t.xAxis[0]){let i=t.xAxis[0].getExtremes();e.render(i.min,i.max)}}function A(t){let e=t.options.navigator||{},i=t.options.scrollbar||{};!this.navigator&&!this.scroller&&(e.enabled||i.enabled)&&(g(!0,this.options.navigator,e),g(!0,this.options.scrollbar,i),delete t.options.navigator,delete t.options.scrollbar)}function k(){this.chart.navigator&&!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,!1)}return{compose:function(t,e,r,d){if(i.compose(t),a=r,n.pushUnique(x,e)){let t=e.prototype;t.callbacks.push(S),c(e,"afterAddSeries",m),c(e,"afterSetChartSize",v),c(e,"afterUpdate",b),c(e,"beforeRender",y),c(e,"beforeShowResetZoom",M),c(e,"update",A)}n.pushUnique(x,d)&&c(d,"afterUpdate",k),n.pushUnique(x,p)&&u(p().prototype.symbols,o),n.pushUnique(x,h)&&u(l,{navigator:s})}}}),i(e,"Core/Axis/ScrollbarAxis.js",[e["Core/Utilities.js"]],function(t){var e;let{addEvent:i,defined:s,pick:o,pushUnique:r}=t;return function(t){let e;let n=[];function a(t){let e=o(t.options&&t.options.min,t.min),i=o(t.options&&t.options.max,t.max);return{axisMin:e,axisMax:i,scrollMin:s(t.dataMin)?Math.min(e,t.min,t.dataMin,o(t.threshold,1/0)):e,scrollMax:s(t.dataMax)?Math.max(i,t.max,t.dataMax,o(t.threshold,-1/0)):i}}function l(){let t=this.scrollbar,e=t&&!t.options.opposite,i=this.horiz?2:e?3:1;t&&(this.chart.scrollbarsOffsets=[0,0],this.chart.axisOffset[i]+=t.size+(t.options.margin||0))}function h(){let t=this;t.options&&t.options.scrollbar&&t.options.scrollbar.enabled&&(t.options.scrollbar.vertical=!t.horiz,t.options.startOnTick=t.options.endOnTick=!1,t.scrollbar=new e(t.chart.renderer,t.options.scrollbar,t.chart),i(t.scrollbar,"changed",function(e){let i,o;let{axisMin:r,axisMax:n,scrollMin:l,scrollMax:h}=a(t),d=h-l;if(s(r)&&s(n)){if(t.horiz&&!t.reversed||!t.horiz&&t.reversed?(i=l+d*this.to,o=l+d*this.from):(i=l+d*(1-this.from),o=l+d*(1-this.to)),this.shouldUpdateExtremes(e.DOMType)){let s="mousemove"!==e.DOMType&&"touchmove"!==e.DOMType&&void 0;t.setExtremes(o,i,!0,s,e)}else this.setRange(this.from,this.to)}}))}function d(){let t,e,i;let{scrollMin:o,scrollMax:r}=a(this),n=this.scrollbar,l=this.axisTitleMargin+(this.titleOffset||0),h=this.chart.scrollbarsOffsets,d=this.options.margin||0;if(n&&h){if(this.horiz)this.opposite||(h[1]+=l),n.position(this.left,this.top+this.height+2+h[1]-(this.opposite?d:0),this.width,this.height),this.opposite||(h[1]+=d),t=1;else{let e;this.opposite&&(h[0]+=l),e=n.options.opposite?this.left+this.width+2+h[0]-(this.opposite?0:d):this.opposite?0:d,n.position(e,this.top,this.width,this.height),this.opposite&&(h[0]+=d),t=0}h[t]+=n.size+(n.options.margin||0),isNaN(o)||isNaN(r)||!s(this.min)||!s(this.max)||this.min===this.max?n.setRange(0,1):(e=(this.min-o)/(r-o),i=(this.max-o)/(r-o),this.horiz&&!this.reversed||!this.horiz&&this.reversed?n.setRange(e,i):n.setRange(1-i,1-e))}}t.compose=function(t,s){r(n,s)&&(e=s),r(n,t)&&(i(t,"afterGetOffset",l),i(t,"afterInit",h),i(t,"afterRender",d))}}(e||(e={})),e}),i(e,"Stock/Scrollbar/ScrollbarDefaults.js",[e["Core/Globals.js"]],function(t){let{isTouchDevice:e}=t;return{height:10,barBorderRadius:5,buttonBorderRadius:0,buttonsEnabled:!1,liveRedraw:void 0,margin:void 0,minWidth:6,opposite:!0,step:.2,zIndex:3,barBackgroundColor:"#cccccc",barBorderWidth:0,barBorderColor:"#cccccc",buttonArrowColor:"#333333",buttonBackgroundColor:"#e6e6e6",buttonBorderColor:"#cccccc",buttonBorderWidth:1,rifleColor:"none",trackBackgroundColor:"rgba(255, 255, 255, 0.001)",trackBorderColor:"#cccccc",trackBorderRadius:5,trackBorderWidth:1}}),i(e,"Stock/Scrollbar/Scrollbar.js",[e["Core/Defaults.js"],e["Core/Globals.js"],e["Core/Axis/ScrollbarAxis.js"],e["Stock/Scrollbar/ScrollbarDefaults.js"],e["Core/Utilities.js"]],function(t,e,i,s,o){let{defaultOptions:r}=t,{addEvent:n,correctFloat:a,defined:l,destroyObjectProperties:h,fireEvent:d,merge:p,pick:c,removeEvent:u}=o;class g{static compose(t){i.compose(t,g)}static swapXY(t,e){return e&&t.forEach(t=>{let e;let i=t.length;for(let s=0;s<i;s+=2)"number"==typeof(e=t[s+1])&&(t[s+1]=t[s+2],t[s+2]=e)}),t}constructor(t,e,i){this._events=[],this.chart=void 0,this.chartX=0,this.chartY=0,this.from=0,this.group=void 0,this.options=void 0,this.renderer=void 0,this.scrollbar=void 0,this.scrollbarButtons=[],this.scrollbarGroup=void 0,this.scrollbarLeft=0,this.scrollbarRifles=void 0,this.scrollbarStrokeWidth=1,this.scrollbarTop=0,this.size=0,this.to=0,this.track=void 0,this.trackBorderWidth=1,this.userOptions=void 0,this.x=0,this.y=0,this.init(t,e,i)}addEvents(){let t=this.options.inverted?[1,0]:[0,1],i=this.scrollbarButtons,s=this.scrollbarGroup.element,o=this.track.element,r=this.mouseDownHandler.bind(this),a=this.mouseMoveHandler.bind(this),l=this.mouseUpHandler.bind(this),h=[[i[t[0]].element,"click",this.buttonToMinClick.bind(this)],[i[t[1]].element,"click",this.buttonToMaxClick.bind(this)],[o,"click",this.trackClick.bind(this)],[s,"mousedown",r],[s.ownerDocument,"mousemove",a],[s.ownerDocument,"mouseup",l]];e.hasTouch&&h.push([s,"touchstart",r],[s.ownerDocument,"touchmove",a],[s.ownerDocument,"touchend",l]),h.forEach(function(t){n.apply(null,t)}),this._events=h}buttonToMaxClick(t){let e=(this.to-this.from)*c(this.options.step,.2);this.updatePosition(this.from+e,this.to+e),d(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:t})}buttonToMinClick(t){let e=a(this.to-this.from)*c(this.options.step,.2);this.updatePosition(a(this.from-e),a(this.to-e)),d(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:t})}cursorToScrollbarPosition(t){let e=this.options,i=e.minWidth>this.calculatedWidth?e.minWidth:0;return{chartX:(t.chartX-this.x-this.xOffset)/(this.barWidth-i),chartY:(t.chartY-this.y-this.yOffset)/(this.barWidth-i)}}destroy(){let t=this,e=t.chart.scroller;t.removeEvents(),["track","scrollbarRifles","scrollbar","scrollbarGroup","group"].forEach(function(e){t[e]&&t[e].destroy&&(t[e]=t[e].destroy())}),e&&t===e.scrollbar&&(e.scrollbar=null,h(e.scrollbarButtons))}drawScrollbarButton(t){let e=this.renderer,i=this.scrollbarButtons,s=this.options,o=this.size,r=e.g().add(this.group);if(i.push(r),s.buttonsEnabled){let n=e.rect().addClass("highcharts-scrollbar-button").add(r);this.chart.styledMode||n.attr({stroke:s.buttonBorderColor,"stroke-width":s.buttonBorderWidth,fill:s.buttonBackgroundColor}),n.attr(n.crisp({x:-.5,y:-.5,width:o+1,height:o+1,r:s.buttonBorderRadius},n.strokeWidth()));let a=e.path(g.swapXY([["M",o/2+(t?-1:1),o/2-3],["L",o/2+(t?-1:1),o/2+3],["L",o/2+(t?2:-2),o/2]],s.vertical)).addClass("highcharts-scrollbar-arrow").add(i[t]);this.chart.styledMode||a.attr({fill:s.buttonArrowColor})}}init(t,e,i){this.scrollbarButtons=[],this.renderer=t,this.userOptions=e,this.options=p(s,r.scrollbar,e),this.options.margin=c(this.options.margin,10),this.chart=i,this.size=c(this.options.size,this.options.height),e.enabled&&(this.render(),this.addEvents())}mouseDownHandler(t){let e=this.chart.pointer.normalize(t),i=this.cursorToScrollbarPosition(e);this.chartX=i.chartX,this.chartY=i.chartY,this.initPositions=[this.from,this.to],this.grabbedCenter=!0}mouseMoveHandler(t){let e;let i=this.chart.pointer.normalize(t),s=this.options,o=s.vertical?"chartY":"chartX",r=this.initPositions||[];this.grabbedCenter&&(!t.touches||0!==t.touches[0][o])&&(e=this.cursorToScrollbarPosition(i)[o]-this[o],this.hasDragged=!0,this.updatePosition(r[0]+e,r[1]+e),this.hasDragged&&d(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:t.type,DOMEvent:t}))}mouseUpHandler(t){this.hasDragged&&d(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:t.type,DOMEvent:t}),this.grabbedCenter=this.hasDragged=this.chartX=this.chartY=null}position(t,e,i,s){let o=this.options,{buttonsEnabled:r,margin:n=0,vertical:a}=o,l=this.rendered?"animate":"attr",h=s,d=0;this.group.show(),this.x=t,this.y=e+this.trackBorderWidth,this.width=i,this.height=s,this.xOffset=h,this.yOffset=d,a?(this.width=this.yOffset=i=d=this.size,this.xOffset=h=0,this.yOffset=d=r?this.size:0,this.barWidth=s-(r?2*i:0),this.x=t+=n):(this.height=s=this.size,this.xOffset=h=r?this.size:0,this.barWidth=i-(r?2*s:0),this.y=this.y+n),this.group[l]({translateX:t,translateY:this.y}),this.track[l]({width:i,height:s}),this.scrollbarButtons[1][l]({translateX:a?0:i-h,translateY:a?s-d:0})}removeEvents(){this._events.forEach(function(t){u.apply(null,t)}),this._events.length=0}render(){let t=this.renderer,e=this.options,i=this.size,s=this.chart.styledMode,o=t.g("scrollbar").attr({zIndex:e.zIndex}).hide().add();this.group=o,this.track=t.rect().addClass("highcharts-scrollbar-track").attr({r:e.trackBorderRadius||0,height:i,width:i}).add(o),s||this.track.attr({fill:e.trackBackgroundColor,stroke:e.trackBorderColor,"stroke-width":e.trackBorderWidth});let r=this.trackBorderWidth=this.track.strokeWidth();this.track.attr({x:-r%2/2,y:-r%2/2}),this.scrollbarGroup=t.g().add(o),this.scrollbar=t.rect().addClass("highcharts-scrollbar-thumb").attr({height:i-r,width:i-r,r:e.barBorderRadius||0}).add(this.scrollbarGroup),this.scrollbarRifles=t.path(g.swapXY([["M",-3,i/4],["L",-3,2*i/3],["M",0,i/4],["L",0,2*i/3],["M",3,i/4],["L",3,2*i/3]],e.vertical)).addClass("highcharts-scrollbar-rifles").add(this.scrollbarGroup),s||(this.scrollbar.attr({fill:e.barBackgroundColor,stroke:e.barBorderColor,"stroke-width":e.barBorderWidth}),this.scrollbarRifles.attr({stroke:e.rifleColor,"stroke-width":1})),this.scrollbarStrokeWidth=this.scrollbar.strokeWidth(),this.scrollbarGroup.translate(-this.scrollbarStrokeWidth%2/2,-this.scrollbarStrokeWidth%2/2),this.drawScrollbarButton(0),this.drawScrollbarButton(1)}setRange(t,e){let i,s;let o=this.options,r=o.vertical,n=o.minWidth,h=this.barWidth,d=!this.rendered||this.hasDragged||this.chart.navigator&&this.chart.navigator.hasDragged?"attr":"animate";if(!l(h))return;let p=h*Math.min(e,1);i=Math.ceil(h*(t=Math.max(t,0))),this.calculatedWidth=s=a(p-i),s<n&&(i=(h-n+s)*t,s=n);let c=Math.floor(i+this.xOffset+this.yOffset),u=s/2-.5;this.from=t,this.to=e,r?(this.scrollbarGroup[d]({translateY:c}),this.scrollbar[d]({height:s}),this.scrollbarRifles[d]({translateY:u}),this.scrollbarTop=c,this.scrollbarLeft=0):(this.scrollbarGroup[d]({translateX:c}),this.scrollbar[d]({width:s}),this.scrollbarRifles[d]({translateX:u}),this.scrollbarLeft=c,this.scrollbarTop=0),s<=12?this.scrollbarRifles.hide():this.scrollbarRifles.show(),!1===o.showFull&&(t<=0&&e>=1?this.group.hide():this.group.show()),this.rendered=!0}shouldUpdateExtremes(t){return c(this.options.liveRedraw,e.svg&&!e.isTouchDevice&&!this.chart.boosted)||"mouseup"===t||"touchend"===t||!l(t)}trackClick(t){let e=this.chart.pointer.normalize(t),i=this.to-this.from,s=this.y+this.scrollbarTop,o=this.x+this.scrollbarLeft;this.options.vertical&&e.chartY>s||!this.options.vertical&&e.chartX>o?this.updatePosition(this.from+i,this.to+i):this.updatePosition(this.from-i,this.to-i),d(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:t})}update(t){this.destroy(),this.init(this.chart.renderer,p(!0,this.options,t),this.chart)}updatePosition(t,e){e>1&&(t=a(1-a(e-t)),e=1),t<0&&(e=a(e-t),t=0),this.from=t,this.to=e}}return g.defaultOptions=s,r.scrollbar=p(!0,g.defaultOptions,r.scrollbar),g}),i(e,"Stock/Navigator/Navigator.js",[e["Core/Axis/Axis.js"],e["Core/Defaults.js"],e["Core/Globals.js"],e["Core/Axis/NavigatorAxisComposition.js"],e["Stock/Navigator/NavigatorComposition.js"],e["Stock/Scrollbar/Scrollbar.js"],e["Core/Utilities.js"]],function(t,e,i,s,o,r,n){let{defaultOptions:a}=e,{hasTouch:l,isTouchDevice:h}=i,{addEvent:d,clamp:p,correctFloat:c,defined:u,destroyObjectProperties:g,erase:f,extend:x,find:m,fireEvent:v,isArray:b,isNumber:y,merge:M,pick:S,removeEvent:A,splat:k}=n;function C(t,...e){let i=[].filter.call(e,y);if(i.length)return Math[t].apply(0,i)}class D{static compose(t,e,i){o.compose(t,e,D,i)}constructor(t){this.baseSeries=void 0,this.chart=void 0,this.handles=void 0,this.height=void 0,this.left=void 0,this.navigatorEnabled=void 0,this.navigatorGroup=void 0,this.navigatorOptions=void 0,this.navigatorSeries=void 0,this.navigatorSize=void 0,this.opposite=void 0,this.outline=void 0,this.range=void 0,this.rendered=void 0,this.scrollbarHeight=0,this.scrollButtonSize=void 0,this.shades=void 0,this.size=void 0,this.top=void 0,this.xAxis=void 0,this.yAxis=void 0,this.zoomedMax=void 0,this.zoomedMin=void 0,this.init(t)}drawHandle(t,e,i,s){let o=this.navigatorOptions.handles.height;this.handles[e][s](i?{translateX:Math.round(this.left+this.height/2),translateY:Math.round(this.top+parseInt(t,10)+.5-o)}:{translateX:Math.round(this.left+parseInt(t,10)),translateY:Math.round(this.top+this.height/2-o/2-1)})}drawOutline(t,e,i,s){let o=this.navigatorOptions.maskInside,r=this.outline.strokeWidth(),n=r/2,a=r%2/2,l=this.scrollButtonSize,h=this.size,d=this.top,p=this.height,c=d-n,u=d+p,g=this.left,f,x;i?(f=d+e+a,e=d+t+a,x=[["M",g+p,d-l-a],["L",g+p,f],["L",g,f],["M",g,e],["L",g+p,e],["L",g+p,d+h+l]],o&&x.push(["M",g+p,f-n],["L",g+p,e+n])):(g-=l,t+=g+l-a,e+=g+l-a,x=[["M",g,c],["L",t,c],["L",t,u],["M",e,u],["L",e,c],["L",g+h+2*l,d+n]],o&&x.push(["M",t-n,c],["L",e+n,c])),this.outline[s]({d:x})}drawMasks(t,e,i,s){let o,r,n,a;let l=this.left,h=this.top,d=this.height;i?(n=[l,l,l],a=[h,h+t,h+e],r=[d,d,d],o=[t,e-t,this.size-e]):(n=[l,l+t,l+e],a=[h,h,h],r=[t,e-t,this.size-e],o=[d,d,d]),this.shades.forEach((t,e)=>{t[s]({x:n[e],y:a[e],width:r[e],height:o[e]})})}renderElements(){let t=this,e=t.navigatorOptions,i=e.maskInside,s=t.chart,o=s.inverted,r=s.renderer,n={cursor:o?"ns-resize":"ew-resize"},a=t.navigatorGroup=r.g("navigator").attr({zIndex:8,visibility:"hidden"}).add();if([!i,i,!i].forEach((i,o)=>{let l=r.rect().addClass("highcharts-navigator-mask"+(1===o?"-inside":"-outside")).add(a);s.styledMode||(l.attr({fill:i?e.maskFill:"rgba(0,0,0,0)"}),1===o&&l.css(n)),t.shades[o]=l}),t.outline=r.path().addClass("highcharts-navigator-outline").add(a),s.styledMode||t.outline.attr({"stroke-width":e.outlineWidth,stroke:e.outlineColor}),e.handles&&e.handles.enabled){let i=e.handles,{height:o,width:l}=i;[0,1].forEach(e=>{t.handles[e]=r.symbol(i.symbols[e],-l/2-1,0,l,o,i),s.inverted&&t.handles[e].attr({rotation:90,rotationOriginX:Math.floor(-l/2),rotationOriginY:(o+l)/2}),t.handles[e].attr({zIndex:7-e}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+["left","right"][e]).add(a),s.styledMode||t.handles[e].attr({fill:i.backgroundColor,stroke:i.borderColor,"stroke-width":i.lineWidth}).css(n)})}}update(t){(this.series||[]).forEach(t=>{t.baseSeries&&delete t.baseSeries.navigatorSeries}),this.destroy();let e=this.chart.options;M(!0,e.navigator,t),this.init(this.chart)}render(t,e,i,s){let o=this.chart,r=this.xAxis,n=r.pointRange||0,a=r.navigatorAxis.fake?o.xAxis[0]:r,l=this.navigatorEnabled,h=this.rendered,d=o.inverted,g=o.xAxis[0].minRange,f=o.xAxis[0].options.maxRange,x=this.scrollButtonSize,m,b,M,A=this.scrollbarHeight,k,C;if(this.hasDragged&&!u(i))return;if(t=c(t-n/2),e=c(e+n/2),!y(t)||!y(e)){if(!h)return;i=0,s=S(r.width,a.width)}this.left=S(r.left,o.plotLeft+x+(d?o.plotWidth:0));let D=this.size=k=S(r.len,(d?o.plotHeight:o.plotWidth)-2*x);m=d?A:k+2*x,i=S(i,r.toPixels(t,!0)),s=S(s,r.toPixels(e,!0)),y(i)&&Math.abs(i)!==1/0||(i=0,s=m);let w=r.toValue(i,!0),E=r.toValue(s,!0),B=Math.abs(c(E-w));B<g?this.grabbedLeft?i=r.toPixels(E-g-n,!0):this.grabbedRight&&(s=r.toPixels(w+g+n,!0)):u(f)&&c(B-n)>f&&(this.grabbedLeft?i=r.toPixels(E-f-n,!0):this.grabbedRight&&(s=r.toPixels(w+f+n,!0))),this.zoomedMax=p(Math.max(i,s),0,D),this.zoomedMin=p(this.fixedWidth?this.zoomedMax-this.fixedWidth:Math.min(i,s),0,D),this.range=this.zoomedMax-this.zoomedMin,D=Math.round(this.zoomedMax);let O=Math.round(this.zoomedMin);l&&(this.navigatorGroup.attr({visibility:"inherit"}),C=h&&!this.hasDragged?"animate":"attr",this.drawMasks(O,D,d,C),this.drawOutline(O,D,d,C),this.navigatorOptions.handles.enabled&&(this.drawHandle(O,0,d,C),this.drawHandle(D,1,d,C))),this.scrollbar&&(d?(M=this.top-x,b=this.left-A+(l||!a.opposite?0:(a.titleOffset||0)+a.axisTitleMargin),A=k+2*x):(M=this.top+(l?this.height:-A),b=this.left-x),this.scrollbar.position(b,M,m,A),this.scrollbar.setRange(this.zoomedMin/(k||1),this.zoomedMax/(k||1))),this.rendered=!0,v(this,"afterRender")}addMouseEvents(){let t=this,e=t.chart,i=e.container,s=[],o,r;t.mouseMoveHandler=o=function(e){t.onMouseMove(e)},t.mouseUpHandler=r=function(e){t.onMouseUp(e)},(s=t.getPartsEvents("mousedown")).push(d(e.renderTo,"mousemove",o),d(i.ownerDocument,"mouseup",r)),l&&(s.push(d(e.renderTo,"touchmove",o),d(i.ownerDocument,"touchend",r)),s.concat(t.getPartsEvents("touchstart"))),t.eventsToUnbind=s,t.series&&t.series[0]&&s.push(d(t.series[0].xAxis,"foundExtremes",function(){e.navigator.modifyNavigatorAxisExtremes()}))}getPartsEvents(t){let e=this,i=[];return["shades","handles"].forEach(function(s){e[s].forEach(function(o,r){i.push(d(o.element,t,function(t){e[s+"Mousedown"](t,r)}))})}),i}shadesMousedown(t,e){t=this.chart.pointer.normalize(t);let i=this.chart,s=this.xAxis,o=this.zoomedMin,r=this.size,n=this.range,a=this.left,l=t.chartX,h,d,p,c;i.inverted&&(l=t.chartY,a=this.top),1===e?(this.grabbedCenter=l,this.fixedWidth=n,this.dragOffset=l-o):(c=l-a-n/2,0===e?c=Math.max(0,c):2===e&&c+n>=r&&(c=r-n,this.reversedExtremes?(c-=n,d=this.getUnionExtremes().dataMin):h=this.getUnionExtremes().dataMax),c!==o&&(this.fixedWidth=n,u((p=s.navigatorAxis.toFixedRange(c,c+n,d,h)).min)&&i.xAxis[0].setExtremes(Math.min(p.min,p.max),Math.max(p.min,p.max),!0,null,{trigger:"navigator"})))}handlesMousedown(t,e){t=this.chart.pointer.normalize(t);let i=this.chart,s=i.xAxis[0],o=this.reversedExtremes;0===e?(this.grabbedLeft=!0,this.otherHandlePos=this.zoomedMax,this.fixedExtreme=o?s.min:s.max):(this.grabbedRight=!0,this.otherHandlePos=this.zoomedMin,this.fixedExtreme=o?s.max:s.min),i.fixedRange=null}onMouseMove(t){let e=this,i=e.chart,s=e.navigatorSize,o=e.range,r=e.dragOffset,n=i.inverted,a=e.left,l;(!t.touches||0!==t.touches[0].pageX)&&(l=(t=i.pointer.normalize(t)).chartX,n&&(a=e.top,l=t.chartY),e.grabbedLeft?(e.hasDragged=!0,e.render(0,0,l-a,e.otherHandlePos)):e.grabbedRight?(e.hasDragged=!0,e.render(0,0,e.otherHandlePos,l-a)):e.grabbedCenter&&(e.hasDragged=!0,l<r?l=r:l>s+r-o&&(l=s+r-o),e.render(0,0,l-r,l-r+o)),e.hasDragged&&e.scrollbar&&S(e.scrollbar.options.liveRedraw,!h&&!this.chart.boosted)&&(t.DOMType=t.type,setTimeout(function(){e.onMouseUp(t)},0)))}onMouseUp(t){let e,i,s,o,r,n;let a=this.chart,l=this.xAxis,h=this.scrollbar,d=t.DOMEvent||t,p=a.inverted,c=this.rendered&&!this.hasDragged?"animate":"attr";(this.hasDragged&&(!h||!h.hasDragged)||"scrollbar"===t.trigger)&&(s=this.getUnionExtremes(),this.zoomedMin===this.otherHandlePos?o=this.fixedExtreme:this.zoomedMax===this.otherHandlePos&&(r=this.fixedExtreme),this.zoomedMax===this.size&&(r=this.reversedExtremes?s.dataMin:s.dataMax),0===this.zoomedMin&&(o=this.reversedExtremes?s.dataMax:s.dataMin),u((n=l.navigatorAxis.toFixedRange(this.zoomedMin,this.zoomedMax,o,r)).min)&&a.xAxis[0].setExtremes(Math.min(n.min,n.max),Math.max(n.min,n.max),!0,!this.hasDragged&&null,{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:d})),"mousemove"!==t.DOMType&&"touchmove"!==t.DOMType&&(this.grabbedLeft=this.grabbedRight=this.grabbedCenter=this.fixedWidth=this.fixedExtreme=this.otherHandlePos=this.hasDragged=this.dragOffset=null),this.navigatorEnabled&&y(this.zoomedMin)&&y(this.zoomedMax)&&(i=Math.round(this.zoomedMin),e=Math.round(this.zoomedMax),this.shades&&this.drawMasks(i,e,p,c),this.outline&&this.drawOutline(i,e,p,c),this.navigatorOptions.handles.enabled&&Object.keys(this.handles).length===this.handles.length&&(this.drawHandle(i,0,p,c),this.drawHandle(e,1,p,c)))}removeEvents(){this.eventsToUnbind&&(this.eventsToUnbind.forEach(function(t){t()}),this.eventsToUnbind=void 0),this.removeBaseSeriesEvents()}removeBaseSeriesEvents(){let t=this.baseSeries||[];this.navigatorEnabled&&t[0]&&(!1!==this.navigatorOptions.adaptToUpdatedData&&t.forEach(function(t){A(t,"updatedData",this.updatedDataHandler)},this),t[0].xAxis&&A(t[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))}init(e){let i=e.options,o=i.navigator||{},n=o.enabled,a=i.scrollbar||{},l=a.enabled,h=n&&o.height||0,p=l&&a.height||0,c=a.buttonsEnabled&&p||0;this.handles=[],this.shades=[],this.chart=e,this.setBaseSeries(),this.height=h,this.scrollbarHeight=p,this.scrollButtonSize=c,this.scrollbarEnabled=l,this.navigatorEnabled=n,this.navigatorOptions=o,this.scrollbarOptions=a,this.opposite=S(o.opposite,!!(!n&&e.inverted));let u=this,g=u.baseSeries,f=e.xAxis.length,x=e.yAxis.length,m=g&&g[0]&&g[0].xAxis||e.xAxis[0]||{options:{}};if(e.isDirtyBox=!0,u.navigatorEnabled?(u.xAxis=new t(e,M({breaks:m.options.breaks,ordinal:m.options.ordinal},o.xAxis,{id:"navigator-x-axis",yAxis:"navigator-y-axis",type:"datetime",index:f,isInternal:!0,offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:0,maxPadding:0,zoomEnabled:!1},e.inverted?{offsets:[c,0,-c,0],width:h}:{offsets:[0,-c,0,c],height:h}),"xAxis"),u.yAxis=new t(e,M(o.yAxis,{id:"navigator-y-axis",alignTicks:!1,offset:0,index:x,isInternal:!0,reversed:S(o.yAxis&&o.yAxis.reversed,e.yAxis[0]&&e.yAxis[0].reversed,!1),zoomEnabled:!1},e.inverted?{width:h}:{height:h}),"yAxis"),g||o.series.data?u.updateNavigatorSeries(!1):0===e.series.length&&(u.unbindRedraw=d(e,"beforeRedraw",function(){e.series.length>0&&!u.series&&(u.setBaseSeries(),u.unbindRedraw())})),u.reversedExtremes=e.inverted&&!u.xAxis.reversed||!e.inverted&&u.xAxis.reversed,u.renderElements(),u.addMouseEvents()):(u.xAxis={chart:e,navigatorAxis:{fake:!0},translate:function(t,i){let s=e.xAxis[0],o=s.getExtremes(),r=s.len-2*c,n=C("min",s.options.min,o.dataMin),a=C("max",s.options.max,o.dataMax)-n;return i?t*a/r+n:r*(t-n)/a},toPixels:function(t){return this.translate(t)},toValue:function(t){return this.translate(t,!0)}},u.xAxis.navigatorAxis.axis=u.xAxis,u.xAxis.navigatorAxis.toFixedRange=s.prototype.toFixedRange.bind(u.xAxis.navigatorAxis)),e.options.scrollbar.enabled){let t=M(e.options.scrollbar,{vertical:e.inverted});!y(t.margin)&&u.navigatorEnabled&&(t.margin=e.inverted?-3:3),e.scrollbar=u.scrollbar=new r(e.renderer,t,e),d(u.scrollbar,"changed",function(t){let e=u.size,i=e*this.to,s=e*this.from;u.hasDragged=u.scrollbar.hasDragged,u.render(0,0,s,i),this.shouldUpdateExtremes(t.DOMType)&&setTimeout(function(){u.onMouseUp(t)})})}u.addBaseSeriesEvents(),u.addChartEvents()}getUnionExtremes(t){let e;let i=this.chart.xAxis[0],s=this.xAxis,o=s.options,r=i.options;return t&&null===i.dataMin||(e={dataMin:S(o&&o.min,C("min",r.min,i.dataMin,s.dataMin,s.min)),dataMax:S(o&&o.max,C("max",r.max,i.dataMax,s.dataMax,s.max))}),e}setBaseSeries(t,e){let i=this.chart,s=this.baseSeries=[];t=t||i.options&&i.options.navigator.baseSeries||(i.series.length?m(i.series,t=>!t.options.isInternal).index:0),(i.series||[]).forEach((e,i)=>{!e.options.isInternal&&(e.options.showInNavigator||(i===t||e.options.id===t)&&!1!==e.options.showInNavigator)&&s.push(e)}),this.xAxis&&!this.xAxis.navigatorAxis.fake&&this.updateNavigatorSeries(!0,e)}updateNavigatorSeries(t,e){let i=this,s=i.chart,o=i.baseSeries,r={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:"navigator-x-axis",yAxis:"navigator-y-axis",showInLegend:!1,stacking:void 0,isInternal:!0,states:{inactive:{opacity:1}}},n=i.series=(i.series||[]).filter(t=>{let e=t.baseSeries;return!(0>o.indexOf(e))||(e&&(A(e,"updatedData",i.updatedDataHandler),delete e.navigatorSeries),t.chart&&t.destroy(),!1)}),l,h,d=i.navigatorOptions.series,p;o&&o.length&&o.forEach(t=>{let c=t.navigatorSeries,u=x({color:t.color,visible:t.visible},b(d)?a.navigator.series:d);if(c&&!1===i.navigatorOptions.adaptToUpdatedData)return;r.name="Navigator "+o.length,p=(l=t.options||{}).navigatorOptions||{},u.dataLabels=k(u.dataLabels),(h=M(l,r,u,p)).pointRange=S(u.pointRange,p.pointRange,a.plotOptions[h.type||"line"].pointRange);let g=p.data||u.data;i.hasNavigatorData=i.hasNavigatorData||!!g,h.data=g||l.data&&l.data.slice(0),c&&c.options?c.update(h,e):(t.navigatorSeries=s.initSeries(h),t.navigatorSeries.baseSeries=t,n.push(t.navigatorSeries))}),(d.data&&!(o&&o.length)||b(d))&&(i.hasNavigatorData=!1,(d=k(d)).forEach((t,e)=>{r.name="Navigator "+(n.length+1),(h=M(a.navigator.series,{color:s.series[e]&&!s.series[e].options.isInternal&&s.series[e].color||s.options.colors[e]||s.options.colors[0]},r,t)).data=t.data,h.data&&(i.hasNavigatorData=!0,n.push(s.initSeries(h)))})),t&&this.addBaseSeriesEvents()}addBaseSeriesEvents(){let t=this,e=t.baseSeries||[];e[0]&&e[0].xAxis&&e[0].eventsToUnbind.push(d(e[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes)),e.forEach(e=>{e.eventsToUnbind.push(d(e,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)})),e.eventsToUnbind.push(d(e,"hide",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!1,!1)})),!1!==this.navigatorOptions.adaptToUpdatedData&&e.xAxis&&e.eventsToUnbind.push(d(e,"updatedData",this.updatedDataHandler)),e.eventsToUnbind.push(d(e,"remove",function(){this.navigatorSeries&&(f(t.series,this.navigatorSeries),u(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),delete this.navigatorSeries)}))})}getBaseSeriesMin(t){return this.baseSeries.reduce(function(t,e){return Math.min(t,e.xData&&e.xData.length?e.xData[0]:t)},t)}modifyNavigatorAxisExtremes(){let t=this.xAxis;if(void 0!==t.getExtremes){let e=this.getUnionExtremes(!0);e&&(e.dataMin!==t.min||e.dataMax!==t.max)&&(t.min=e.dataMin,t.max=e.dataMax)}}modifyBaseAxisExtremes(){let t,e;let i=this.chart.navigator,s=this.getExtremes(),o=s.min,r=s.max,n=s.dataMin,a=s.dataMax,l=r-o,h=i.stickToMin,d=i.stickToMax,p=S(this.options.overscroll,0),c=i.series&&i.series[0],u=!!this.setExtremes,g=this.eventArgs&&"rangeSelectorButton"===this.eventArgs.trigger;!g&&(h&&(t=(e=n)+l),d&&(t=a+p,h||(e=Math.max(n,t-l,i.getBaseSeriesMin(c&&c.xData?c.xData[0]:-Number.MAX_VALUE)))),u&&(h||d)&&y(e)&&(this.min=this.userMin=e,this.max=this.userMax=t)),i.stickToMin=i.stickToMax=null}updatedDataHandler(){let t=this.chart.navigator,e=this.navigatorSeries,i=t.reversedExtremes?0===Math.round(t.zoomedMin):Math.round(t.zoomedMax)>=Math.round(t.size);t.stickToMax=S(this.chart.options.navigator&&this.chart.options.navigator.stickToMax,i),t.stickToMin=t.shouldStickToMin(this,t),e&&!t.hasNavigatorData&&(e.options.pointStart=this.xData[0],e.setData(this.options.data,!1,null,!1))}shouldStickToMin(t,e){let i=e.getBaseSeriesMin(t.xData[0]),s=t.xAxis,o=s.max,r=s.min,n=s.options.range;return!!(y(o)&&y(r))&&(n&&o-i>0?o-i<n:r<=i)}addChartEvents(){this.eventsToUnbind||(this.eventsToUnbind=[]),this.eventsToUnbind.push(d(this.chart,"redraw",function(){let t=this.navigator,e=t&&(t.baseSeries&&t.baseSeries[0]&&t.baseSeries[0].xAxis||this.xAxis[0]);e&&t.render(e.min,e.max)}),d(this.chart,"getMargins",function(){let t=this.navigator,e=t.opposite?"plotTop":"marginBottom";this.inverted&&(e=t.opposite?"marginRight":"plotLeft"),this[e]=(this[e]||0)+(t.navigatorEnabled||!this.inverted?t.height+t.scrollbarHeight:0)+t.navigatorOptions.margin}))}destroy(){this.removeEvents(),this.xAxis&&(f(this.chart.xAxis,this.xAxis),f(this.chart.axes,this.xAxis)),this.yAxis&&(f(this.chart.yAxis,this.yAxis),f(this.chart.axes,this.yAxis)),(this.series||[]).forEach(t=>{t.destroy&&t.destroy()}),["series","xAxis","yAxis","shades","outline","scrollbarTrack","scrollbarRifles","scrollbarGroup","scrollbar","navigatorGroup","rendered"].forEach(t=>{this[t]&&this[t].destroy&&this[t].destroy(),this[t]=null}),[this.handles].forEach(t=>{g(t)})}}return D}),i(e,"Stock/RangeSelector/RangeSelectorDefaults.js",[],function(){return{lang:{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"",rangeSelectorTo:"→"},rangeSelector:{allButtonsEnabled:!1,buttons:void 0,buttonSpacing:5,dropdown:"responsive",enabled:void 0,verticalAlign:"top",buttonTheme:{width:28,height:18,padding:2,zIndex:7},floating:!1,x:0,y:0,height:void 0,inputBoxBorderColor:"none",inputBoxHeight:17,inputBoxWidth:void 0,inputDateFormat:"%e %b %Y",inputDateParser:void 0,inputEditDateFormat:"%Y-%m-%d",inputEnabled:!0,inputPosition:{align:"right",x:0,y:0},inputSpacing:5,selected:void 0,buttonPosition:{align:"left",x:0,y:0},inputStyle:{color:"#334eff",cursor:"pointer",fontSize:"0.8em"},labelStyle:{color:"#666666",fontSize:"0.8em"}}}}),i(e,"Stock/RangeSelector/RangeSelectorComposition.js",[e["Core/Defaults.js"],e["Stock/RangeSelector/RangeSelectorDefaults.js"],e["Core/Utilities.js"]],function(t,e,i){let s;let{defaultOptions:o,setOptions:r}=t,{addEvent:n,defined:a,extend:l,find:h,isNumber:d,merge:p,pick:c}=i,u=[],g=[];function f(){let t,e;let i=this.range,s=i.type,o=this.max,r=this.chart.time,n=function(t,e){let i="year"===s?"FullYear":"Month",o=new r.Date(t),n=r.get(i,o);return r.set(i,o,n+e),n===r.get(i,o)&&r.set("Date",o,0),o.getTime()-t};d(i)?(t=o-i,e=i):i&&(t=o+n(o,-(i.count||1)),this.chart&&(this.chart.fixedRange=o-t));let a=c(this.dataMin,Number.MIN_VALUE);return d(t)||(t=a),t<=a&&(t=a,void 0===e&&(e=n(t,i.count)),this.newMax=Math.min(t+e,c(this.dataMax,Number.MAX_VALUE))),d(o)?!d(i)&&i&&i._offsetMin&&(t+=i._offsetMin):t=void 0,t}function x(){this.options.rangeSelector&&this.options.rangeSelector.enabled&&(this.rangeSelector=new s(this))}function m(){let t=this.axes,e=this.rangeSelector;if(e){d(e.deferredYTDClick)&&(e.clickButton(e.deferredYTDClick),delete e.deferredYTDClick),t.forEach(t=>{t.updateNames(),t.setScale()}),this.getAxisMargins(),e.render();let i=e.options.verticalAlign;e.options.floating||("bottom"===i?this.extraBottomMargin=!0:"middle"===i||(this.extraTopMargin=!0))}}function v(t){let e,i,s,o;let r=t.rangeSelector,a=()=>{r&&(e=t.xAxis[0].getExtremes(),i=t.legend,o=r&&r.options.verticalAlign,d(e.min)&&r.render(e.min,e.max),i.display&&"top"===o&&o===i.options.verticalAlign&&(s=p(t.spacingBox),"vertical"===i.options.layout?s.y=t.plotTop:s.y+=r.getHeight(),i.group.placed=!1,i.align(s)))};if(r){let e=h(u,e=>e[0]===t);e||u.push([t,[n(t.xAxis[0],"afterSetExtremes",function(t){r&&r.render(t.min,t.max)}),n(t,"redraw",a)]]),a()}}function b(){for(let t=0,e=u.length;t<e;++t){let e=u[t];if(e[0]===this){e[1].forEach(t=>t()),u.splice(t,1);return}}}function y(){let t=this.rangeSelector;if(t){let e=t.getHeight();this.extraTopMargin&&(this.plotTop+=e),this.extraBottomMargin&&(this.marginBottom+=e)}}function M(){let t=this.rangeSelector;if(t&&!t.options.floating){t.render();let e=t.options.verticalAlign;"bottom"===e?this.extraBottomMargin=!0:"middle"!==e&&(this.extraTopMargin=!0)}}function S(t){let e=t.options,i=e.rangeSelector,o=this.extraBottomMargin,r=this.extraTopMargin,n=this.rangeSelector;if(i&&i.enabled&&!a(n)&&this.options.rangeSelector&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=n=new s(this)),this.extraBottomMargin=!1,this.extraTopMargin=!1,n){v(this);let t=i&&i.verticalAlign||n.options&&n.options.verticalAlign;n.options.floating||("bottom"===t?this.extraBottomMargin=!0:"middle"===t||(this.extraTopMargin=!0)),(this.extraBottomMargin!==o||this.extraTopMargin!==r)&&(this.isDirtyBox=!0)}}return{compose:function(t,a,h){if(s=h,i.pushUnique(g,t)&&(t.prototype.minFromRange=f),i.pushUnique(g,a)){n(a,"afterGetContainer",x),n(a,"beforeRender",m),n(a,"destroy",b),n(a,"getMargins",y),n(a,"render",M),n(a,"update",S);let t=a.prototype;t.callbacks.push(v)}i.pushUnique(g,r)&&(l(o,{rangeSelector:e.rangeSelector}),l(o.lang,e.lang))}}}),i(e,"Stock/RangeSelector/RangeSelector.js",[e["Core/Axis/Axis.js"],e["Core/Defaults.js"],e["Core/Globals.js"],e["Stock/RangeSelector/RangeSelectorComposition.js"],e["Core/Renderer/SVG/SVGElement.js"],e["Core/Utilities.js"]],function(t,e,i,s,o,r){let{defaultOptions:n}=e,{addEvent:a,createElement:l,css:h,defined:d,destroyObjectProperties:p,discardElement:c,extend:u,fireEvent:g,isNumber:f,merge:x,objectEach:m,pad:v,pick:b,pInt:y,splat:M}=r;class S{static compose(t,e){s.compose(t,e,S)}constructor(t){this.buttons=void 0,this.buttonOptions=S.prototype.defaultButtons,this.initialButtonGroupWidth=0,this.options=void 0,this.chart=t,this.init(t)}clickButton(e,i){let s=this.chart,o=this.buttonOptions[e],r=s.xAxis[0],n=s.scroller&&s.scroller.getUnionExtremes()||r||{},l=o.type,h=o.dataGrouping,p=n.dataMin,c=n.dataMax,u,x=r&&Math.round(Math.min(r.max,b(c,r.max))),m,v=o._range,y,S,A,k,C,D=!0;if(null!==p&&null!==c){if(s.fixedRange=v,this.setSelected(e),h&&(this.forcedDataGrouping=!0,t.prototype.setDataGrouping.call(r||{chart:this.chart},h,!1),this.frozenStates=o.preserveDataGrouping),"month"===l||"year"===l)r?(k={range:o,max:x,chart:s,dataMin:p,dataMax:c},u=r.minFromRange.call(k),f(k.newMax)&&(x=k.newMax),D=!1):v=o;else if(v)x=Math.min((u=Math.max(x-v,p))+v,c),D=!1;else if("ytd"===l){if(r)(void 0===c||void 0===p)&&(p=Number.MAX_VALUE,c=Number.MIN_VALUE,s.series.forEach(t=>{let e=t.xData;e&&(p=Math.min(e[0],p),c=Math.max(e[e.length-1],c))}),i=!1),u=y=(C=this.getYTDExtremes(c,p,s.time.useUTC)).min,x=C.max;else{this.deferredYTDClick=e;return}}else"all"===l&&r&&(s.navigator&&s.navigator.baseSeries[0]&&(s.navigator.baseSeries[0].xAxis.options.range=void 0),u=p,x=c);D&&o._offsetMin&&d(u)&&(u+=o._offsetMin),o._offsetMax&&d(x)&&(x+=o._offsetMax),this.dropdown&&(this.dropdown.selectedIndex=e+1),r?r.setExtremes(u,x,b(i,!0),void 0,{trigger:"rangeSelectorButton",rangeSelectorButton:o}):(A=(m=M(s.options.xAxis)[0]).range,m.range=v,S=m.min,m.min=y,a(s,"load",function(){m.range=A,m.min=S})),g(this,"afterBtnClick")}}setSelected(t){this.selected=this.options.selected=t}init(t){let e=this,i=t.options.rangeSelector,s=i.buttons||e.defaultButtons.slice(),o=i.selected,r=function(){let t=e.minInput,i=e.maxInput;t&&t.blur&&g(t,"blur"),i&&i.blur&&g(i,"blur")};e.chart=t,e.options=i,e.buttons=[],e.buttonOptions=s,this.eventsToUnbind=[],this.eventsToUnbind.push(a(t.container,"mousedown",r)),this.eventsToUnbind.push(a(t,"resize",r)),s.forEach(e.computeButtonRange),void 0!==o&&s[o]&&this.clickButton(o,!1),this.eventsToUnbind.push(a(t,"load",function(){t.xAxis&&t.xAxis[0]&&a(t.xAxis[0],"setExtremes",function(i){this.max-this.min!==t.fixedRange&&"rangeSelectorButton"!==i.trigger&&"updatedData"!==i.trigger&&e.forcedDataGrouping&&!e.frozenStates&&this.setDataGrouping(!1,!1)})}))}updateButtonStates(){let t=this,e=this.chart,i=this.dropdown,s=e.xAxis[0],o=Math.round(s.max-s.min),r=!s.hasVisibleSeries,n=24*36e5,a=e.scroller&&e.scroller.getUnionExtremes()||s,l=a.dataMin,h=a.dataMax,d=t.getYTDExtremes(h,l,e.time.useUTC),p=d.min,c=d.max,u=t.selected,g=t.options.allButtonsEnabled,x=t.buttons,m=f(u);t.buttonOptions.forEach((e,a)=>{let d=e._range,f=e.type,v=e.count||1,b=x[a],y=e._offsetMax-e._offsetMin,M=a===u,S=d>h-l,A=d<s.minRange,k=0,C=!1,D=!1,w=d===o;("month"===f||"year"===f)&&o+36e5>=({month:28,year:365})[f]*n*v-y&&o-36e5<=({month:31,year:366})[f]*n*v+y?w=!0:"ytd"===f?(w=c-p+y===o,C=!M):"all"===f&&(w=s.max-s.min>=h-l,D=!M&&m&&w);let E=!g&&(S||A||D||r),B=M&&w||w&&!m&&!C||M&&t.frozenStates;E?k=3:B&&(m=!0,k=2),b.state!==k&&(b.setState(k),i&&(i.options[a+1].disabled=E,2===k&&(i.selectedIndex=a+1)),0===k&&u===a&&t.setSelected())})}computeButtonRange(t){let e=t.type,i=t.count||1,s={millisecond:1,second:1e3,minute:6e4,hour:36e5,day:864e5,week:6048e5};s[e]?t._range=s[e]*i:("month"===e||"year"===e)&&(t._range=24*({month:30,year:365})[e]*36e5*i),t._offsetMin=b(t.offsetMin,0),t._offsetMax=b(t.offsetMax,0),t._range+=t._offsetMax-t._offsetMin}getInputValue(t){let e="min"===t?this.minInput:this.maxInput,i=this.chart.options.rangeSelector,s=this.chart.time;return e?("text"===e.type&&i.inputDateParser||this.defaultInputDateParser)(e.value,s.useUTC,s):0}setInputValue(t,e){let i=this.options,s=this.chart.time,o="min"===t?this.minInput:this.maxInput,r="min"===t?this.minDateBox:this.maxDateBox;if(o){let t=o.getAttribute("data-hc-time"),n=d(t)?Number(t):void 0;if(d(e)){let t=n;d(t)&&o.setAttribute("data-hc-time-previous",t),o.setAttribute("data-hc-time",e),n=e}o.value=s.dateFormat(this.inputTypeFormats[o.type]||i.inputEditDateFormat,n),r&&r.attr({text:s.dateFormat(i.inputDateFormat,n)})}}setInputExtremes(t,e,i){let s="min"===t?this.minInput:this.maxInput;if(s){let t=this.inputTypeFormats[s.type],o=this.chart.time;if(t){let r=o.dateFormat(t,e);s.min!==r&&(s.min=r);let n=o.dateFormat(t,i);s.max!==n&&(s.max=n)}}}showInput(t){let e="min"===t?this.minDateBox:this.maxDateBox,i="min"===t?this.minInput:this.maxInput;if(i&&e&&this.inputGroup){let t="text"===i.type,{translateX:s=0,translateY:o=0}=this.inputGroup,{x:r=0,width:n=0,height:a=0}=e,{inputBoxWidth:l}=this.options;h(i,{width:t?n+(l?-2:20)+"px":"auto",height:a-2+"px",border:"2px solid silver"}),t&&l?h(i,{left:s+r+"px",top:o+"px"}):h(i,{left:Math.min(Math.round(r+s-(i.offsetWidth-n)/2),this.chart.chartWidth-i.offsetWidth)+"px",top:o-(i.offsetHeight-a)/2+"px"})}}hideInput(t){let e="min"===t?this.minInput:this.maxInput;e&&h(e,{top:"-9999em",border:0,width:"1px",height:"1px"})}defaultInputDateParser(t,e,s){let o=t.split("/").join("-").split(" ").join("T");if(-1===o.indexOf("T")&&(o+="T00:00"),e)o+="Z";else{var r;if(i.isSafari&&(!((r=o).length>6)||r.lastIndexOf("-")!==r.length-6&&r.lastIndexOf("+")!==r.length-6)){let t=new Date(o).getTimezoneOffset()/60;o+=t<=0?`+${v(-t)}:00`:`-${v(t)}:00`}}let n=Date.parse(o);if(!f(n)){let e=t.split("-");n=Date.UTC(y(e[0]),y(e[1])-1,y(e[2]))}return s&&e&&f(n)&&(n+=s.getTimezoneOffset(n)),n}drawInput(t){let{chart:e,div:s,inputGroup:o}=this,r=this,a=e.renderer.style||{},d=e.renderer,p=e.options.rangeSelector,c=n.lang,g="min"===t;function m(){let{maxInput:i,minInput:s}=r,o=e.xAxis[0],n=e.scroller&&e.scroller.getUnionExtremes()||o,a=n.dataMin,l=n.dataMax,h=r.getInputValue(t);h!==Number(M.getAttribute("data-hc-time-previous"))&&f(h)&&(M.setAttribute("data-hc-time-previous",h),g&&i&&f(a)?h>Number(i.getAttribute("data-hc-time"))?h=void 0:h<a&&(h=a):s&&f(l)&&(h<Number(s.getAttribute("data-hc-time"))?h=void 0:h>l&&(h=l)),void 0!==h&&o.setExtremes(g?h:o.min,g?o.max:h,void 0,void 0,{trigger:"rangeSelectorInput"}))}let v=c[g?"rangeSelectorFrom":"rangeSelectorTo"]||"",b=d.label(v,0).addClass("highcharts-range-label").attr({padding:v?2:0,height:v?p.inputBoxHeight:0}).add(o),y=d.label("",0).addClass("highcharts-range-input").attr({padding:2,width:p.inputBoxWidth,height:p.inputBoxHeight,"text-align":"center"}).on("click",function(){r.showInput(t),r[t+"Input"].focus()});e.styledMode||y.attr({stroke:p.inputBoxBorderColor,"stroke-width":1}),y.add(o);let M=l("input",{name:t,className:"highcharts-range-selector"},void 0,s);M.setAttribute("type",function(t){let e=-1!==t.indexOf("%L");if(e)return"text";let i=["a","A","d","e","w","b","B","m","o","y","Y"].some(e=>-1!==t.indexOf("%"+e)),s=["H","k","I","l","M","S"].some(e=>-1!==t.indexOf("%"+e));return i&&s?"datetime-local":i?"date":s?"time":"text"}(p.inputDateFormat||"%e %b %Y")),e.styledMode||(b.css(x(a,p.labelStyle)),y.css(x({color:"#333333"},a,p.inputStyle)),h(M,u({position:"absolute",border:0,boxShadow:"0 0 15px rgba(0,0,0,0.3)",width:"1px",height:"1px",padding:0,textAlign:"center",fontSize:a.fontSize,fontFamily:a.fontFamily,top:"-9999em"},p.inputStyle))),M.onfocus=()=>{r.showInput(t)},M.onblur=()=>{M===i.doc.activeElement&&m(),r.hideInput(t),r.setInputValue(t),M.blur()};let S=!1;return M.onchange=()=>{S||(m(),r.hideInput(t),M.blur())},M.onkeypress=t=>{13===t.keyCode&&m()},M.onkeydown=t=>{S=!0,(38===t.keyCode||40===t.keyCode)&&m()},M.onkeyup=()=>{S=!1},{dateBox:y,input:M,label:b}}getPosition(){let t=this.chart,e=t.options.rangeSelector,i="top"===e.verticalAlign?t.plotTop-t.axisOffset[0]:0;return{buttonTop:i+e.buttonPosition.y,inputTop:i+e.inputPosition.y-10}}getYTDExtremes(t,e,i){let s=this.chart.time,o=new s.Date(t),r=s.get("FullYear",o),n=i?s.Date.UTC(r,0,1):+new s.Date(r,0,1),a=o.getTime();return{max:Math.min(t||a,a),min:Math.max(e,n)}}render(t,e){let i=this.chart,s=i.renderer,o=i.container,r=i.options,n=r.rangeSelector,a=b(r.chart.style&&r.chart.style.zIndex,0)+1,h=n.inputEnabled,p=this.rendered;if(!1!==n.enabled){if(!p&&(this.group=s.g("range-selector-group").attr({zIndex:7}).add(),this.div=l("div",void 0,{position:"relative",height:0,zIndex:a}),this.buttonOptions.length&&this.renderButtons(),o.parentNode&&o.parentNode.insertBefore(this.div,o),h)){this.inputGroup=s.g("input-group").add(this.group);let t=this.drawInput("min");this.minDateBox=t.dateBox,this.minLabel=t.label,this.minInput=t.input;let e=this.drawInput("max");this.maxDateBox=e.dateBox,this.maxLabel=e.label,this.maxInput=e.input}if(h){this.setInputValue("min",t),this.setInputValue("max",e);let s=i.scroller&&i.scroller.getUnionExtremes()||i.xAxis[0]||{};if(d(s.dataMin)&&d(s.dataMax)){let t=i.xAxis[0].minRange||0;this.setInputExtremes("min",s.dataMin,Math.min(s.dataMax,this.getInputValue("max"))-t),this.setInputExtremes("max",Math.max(s.dataMin,this.getInputValue("min"))+t,s.dataMax)}if(this.inputGroup){let t=0;[this.minLabel,this.minDateBox,this.maxLabel,this.maxDateBox].forEach(e=>{if(e){let{width:i}=e.getBBox();i&&(e.attr({x:t}),t+=i+n.inputSpacing)}})}}this.alignElements(),this.rendered=!0}}renderButtons(){let{buttons:t,chart:e,options:s}=this,o=n.lang,r=e.renderer,h=x(s.buttonTheme),d=h&&h.states,p=h.width||28;delete h.width,delete h.states,this.buttonGroup=r.g("range-selector-buttons").add(this.group);let c=this.dropdown=l("select",void 0,{position:"absolute",width:"1px",height:"1px",padding:0,border:0,top:"-9999em",cursor:"pointer",opacity:1e-4},this.div);a(c,"touchstart",()=>{c.style.fontSize="16px"}),[[i.isMS?"mouseover":"mouseenter"],[i.isMS?"mouseout":"mouseleave"],["change","click"]].forEach(([e,i])=>{a(c,e,()=>{let s=t[this.currentButtonIndex()];s&&g(s.element,i||e)})}),this.zoomText=r.label(o&&o.rangeSelectorZoom||"",0).attr({padding:s.buttonTheme.padding,height:s.buttonTheme.height,paddingLeft:0,paddingRight:0}).add(this.buttonGroup),this.chart.styledMode||(this.zoomText.css(s.labelStyle),h["stroke-width"]=b(h["stroke-width"],0)),l("option",{textContent:this.zoomText.textStr,disabled:!0},void 0,c),this.buttonOptions.forEach((e,i)=>{l("option",{textContent:e.title||e.text},void 0,c),t[i]=r.button(e.text,0,0,t=>{let s;let o=e.events&&e.events.click;o&&(s=o.call(e,t)),!1!==s&&this.clickButton(i),this.isActive=!0},h,d&&d.hover,d&&d.select,d&&d.disabled).attr({"text-align":"center",width:p}).add(this.buttonGroup),e.title&&t[i].attr("title",e.title)})}alignElements(){let{buttonGroup:t,buttons:e,chart:i,group:s,inputGroup:o,options:r,zoomText:n}=this,a=i.options,l=a.exporting&&!1!==a.exporting.enabled&&a.navigation&&a.navigation.buttonOptions,{buttonPosition:h,inputPosition:d,verticalAlign:p}=r,c=(t,e)=>l&&this.titleCollision(i)&&"top"===p&&"right"===e.align&&e.y-t.getBBox().height-12<(l.y||0)+(l.height||0)+i.spacing[0]?-40:0,u=i.plotLeft;if(s&&h&&d){let a=h.x-i.spacing[3];if(t){if(this.positionButtons(),!this.initialButtonGroupWidth){let t=0;n&&(t+=n.getBBox().width+5),e.forEach((i,s)=>{t+=i.width||0,s!==e.length-1&&(t+=r.buttonSpacing)}),this.initialButtonGroupWidth=t}u-=i.spacing[3],this.updateButtonStates();let o=c(t,h);this.alignButtonGroup(o),s.placed=t.placed=i.hasLoaded}let l=0;o&&(l=c(o,d),"left"===d.align?a=u:"right"===d.align&&(a=-Math.max(i.axisOffset[1],-l)),o.align({y:d.y,width:o.getBBox().width,align:d.align,x:d.x+a-2},!0,i.spacingBox),o.placed=i.hasLoaded),this.handleCollision(l),s.align({verticalAlign:p},!0,i.spacingBox);let g=s.alignAttr.translateY,f=s.getBBox().height+20,x=0;if("bottom"===p){let t=i.legend&&i.legend.options,e=t&&"bottom"===t.verticalAlign&&t.enabled&&!t.floating?i.legend.legendHeight+b(t.margin,10):0;x=g-(f=f+e-20)-(r.floating?0:r.y)-(i.titleOffset?i.titleOffset[2]:0)-10}"top"===p?(r.floating&&(x=0),i.titleOffset&&i.titleOffset[0]&&(x=i.titleOffset[0]),x+=i.margin[0]-i.spacing[0]||0):"middle"===p&&(d.y===h.y?x=g:(d.y||h.y)&&(d.y<0||h.y<0?x-=Math.min(d.y,h.y):x=g-f)),s.translate(r.x,r.y+Math.floor(x));let{minInput:m,maxInput:v,dropdown:y}=this;r.inputEnabled&&m&&v&&(m.style.marginTop=s.translateY+"px",v.style.marginTop=s.translateY+"px"),y&&(y.style.marginTop=s.translateY+"px")}}alignButtonGroup(t,e){let{chart:i,options:s,buttonGroup:o,buttons:r}=this,{buttonPosition:n}=s,a=i.plotLeft-i.spacing[3],l=n.x-i.spacing[3];"right"===n.align?l+=t-a:"center"===n.align&&(l-=a/2),o&&o.align({y:n.y,width:b(e,this.initialButtonGroupWidth),align:n.align,x:l},!0,i.spacingBox)}positionButtons(){let{buttons:t,chart:e,options:i,zoomText:s}=this,o=e.hasLoaded?"animate":"attr",{buttonPosition:r}=i,n=e.plotLeft,a=n;s&&"hidden"!==s.visibility&&(s[o]({x:b(n+r.x,n)}),a+=r.x+s.getBBox().width+5);for(let e=0,s=this.buttonOptions.length;e<s;++e)"hidden"!==t[e].visibility?(t[e][o]({x:a}),a+=(t[e].width||0)+i.buttonSpacing):t[e][o]({x:n})}handleCollision(t){let{chart:e,buttonGroup:i,inputGroup:s}=this,{buttonPosition:o,dropdown:r,inputPosition:n}=this.options,a=()=>{let t=0;return this.buttons.forEach(e=>{let i=e.getBBox();i.width>t&&(t=i.width)}),t},l=e=>{if(s&&i){let r=s.alignAttr.translateX+s.alignOptions.x-t+s.getBBox().x+2,a=s.alignOptions.width,l=i.alignAttr.translateX+i.getBBox().x;return l+e>r&&r+a>l&&o.y<n.y+s.getBBox().height}return!1},h=()=>{s&&i&&s.attr({translateX:s.alignAttr.translateX+(e.axisOffset[1]>=-t?0:-t),translateY:s.alignAttr.translateY+i.getBBox().height+10})};if(i){if("always"===r){this.collapseButtons(t),l(a())&&h();return}"never"===r&&this.expandButtons()}s&&i?n.align===o.align||l(this.initialButtonGroupWidth+20)?"responsive"===r?(this.collapseButtons(t),l(a())&&h()):h():"responsive"===r&&this.expandButtons():i&&"responsive"===r&&(this.initialButtonGroupWidth>e.plotWidth?this.collapseButtons(t):this.expandButtons())}collapseButtons(t){let{buttons:e,buttonOptions:i,chart:s,dropdown:o,options:r,zoomText:n}=this,a=s.userOptions.rangeSelector&&s.userOptions.rangeSelector.buttonTheme||{},l=t=>({text:t?`${t} ▾`:"▾",width:"auto",paddingLeft:b(r.buttonTheme.paddingLeft,a.padding,8),paddingRight:b(r.buttonTheme.paddingRight,a.padding,8)});n&&n.hide();let h=!1;i.forEach((t,i)=>{let s=e[i];2!==s.state?s.hide():(s.show(),s.attr(l(t.text)),h=!0)}),h||(o&&(o.selectedIndex=0),e[0].show(),e[0].attr(l(this.zoomText&&this.zoomText.textStr)));let{align:d}=r.buttonPosition;this.positionButtons(),("right"===d||"center"===d)&&this.alignButtonGroup(t,e[this.currentButtonIndex()].getBBox().width),this.showDropdown()}expandButtons(){let{buttons:t,buttonOptions:e,options:i,zoomText:s}=this;this.hideDropdown(),s&&s.show(),e.forEach((e,s)=>{let o=t[s];o.show(),o.attr({text:e.text,width:i.buttonTheme.width||28,paddingLeft:b(i.buttonTheme.paddingLeft,"unset"),paddingRight:b(i.buttonTheme.paddingRight,"unset")}),o.state<2&&o.setState(0)}),this.positionButtons()}currentButtonIndex(){let{dropdown:t}=this;return t&&t.selectedIndex>0?t.selectedIndex-1:0}showDropdown(){let{buttonGroup:t,buttons:e,chart:i,dropdown:s}=this;if(t&&s){let{translateX:o=0,translateY:r=0}=t,n=e[this.currentButtonIndex()].getBBox();h(s,{left:i.plotLeft+o+"px",top:r+.5+"px",width:n.width+"px",height:n.height+"px"}),this.hasVisibleDropdown=!0}}hideDropdown(){let{dropdown:t}=this;t&&(h(t,{top:"-9999em",width:"1px",height:"1px"}),this.hasVisibleDropdown=!1)}getHeight(){let t=this.options,e=this.group,i=t.inputPosition,s=t.buttonPosition,o=t.y,r=s.y,n=i.y,a=0;return t.height?t.height:(this.alignElements(),a=e?e.getBBox(!0).height+13+o:0,(n<0&&r<0||n>0&&r>0)&&(a+=Math.abs(Math.min(n,r))),a)}titleCollision(t){return!(t.options.title.text||t.options.subtitle.text)}update(t){let e=this.chart;x(!0,e.options.rangeSelector,t),this.destroy(),this.init(e),this.render()}destroy(){let t=this,e=t.minInput,i=t.maxInput;t.eventsToUnbind&&(t.eventsToUnbind.forEach(t=>t()),t.eventsToUnbind=void 0),p(t.buttons),e&&(e.onfocus=e.onblur=e.onchange=null),i&&(i.onfocus=i.onblur=i.onchange=null),m(t,function(e,i){e&&"chart"!==i&&(e instanceof o?e.destroy():e instanceof window.HTMLElement&&c(e)),e!==S.prototype[i]&&(t[i]=null)},this)}}return u(S.prototype,{defaultButtons:[{type:"month",count:1,text:"1m",title:"View 1 month"},{type:"month",count:3,text:"3m",title:"View 3 months"},{type:"month",count:6,text:"6m",title:"View 6 months"},{type:"ytd",text:"YTD",title:"View year to date"},{type:"year",count:1,text:"1y",title:"View 1 year"},{type:"all",text:"All",title:"View all"}],inputTypeFormats:{"datetime-local":"%Y-%m-%dT%H:%M:%S",date:"%Y-%m-%d",time:"%H:%M:%S"}}),S}),i(e,"Core/Axis/OrdinalAxis.js",[e["Core/Axis/Axis.js"],e["Core/Globals.js"],e["Core/Series/Series.js"],e["Core/Utilities.js"]],function(t,e,i,s){var o;let{addEvent:r,correctFloat:n,css:a,defined:l,error:h,pick:d,timeUnits:p}=s,c=[];return function(t){function o(t,e,i,s,o=[],r=0,n){let a={},d=this.options.tickPixelInterval,c=this.chart.time,u=[],g,f,x,m,v,b=0,y=[],M=-Number.MAX_VALUE;if(!this.options.ordinal&&!this.options.breaks||!o||o.length<3||void 0===e)return c.getTimeTicks.apply(c,arguments);let S=o.length;for(g=0;g<S;g++){if(v=g&&o[g-1]>i,o[g]<e&&(b=g),g===S-1||o[g+1]-o[g]>5*r||v){if(o[g]>M){for(f=c.getTimeTicks(t,o[b],o[g],s);f.length&&f[0]<=M;)f.shift();f.length&&(M=f[f.length-1]),u.push(y.length),y=y.concat(f)}b=g+1}if(v)break}if(f){if(m=f.info,n&&m.unitRange<=p.hour){for(b=1,g=y.length-1;b<g;b++)c.dateFormat("%d",y[b])!==c.dateFormat("%d",y[b-1])&&(a[y[b]]="day",x=!0);x&&(a[y[0]]="day"),m.higherRanks=a}m.segmentStarts=u,y.info=m}else h(12,!1,this.chart);if(n&&l(d)){let t=y.length,e=[],s=[],o,r,n,l,h,p=t;for(;p--;)r=this.translate(y[p]),n&&(s[p]=n-r),e[p]=n=r;for(s.sort(),(l=s[Math.floor(s.length/2)])<.6*d&&(l=null),p=y[t-1]>i?t-1:t,n=void 0;p--;)h=Math.abs(n-(r=e[p])),n&&h<.8*d&&(null===l||h<.8*l)?(a[y[p]]&&!a[y[p+1]]?(o=p+1,n=r):o=p,y.splice(o,1)):n=r}return y}function u(t){let e=this.ordinal,i=e.positions;if(!i)return t;let s=i.length-1,o;return(t<0?t=i[0]:t>s?t=i[s]:(s=Math.floor(t),o=t-s),void 0!==o&&void 0!==i[s])?i[s]+(o?o*(i[s+1]-i[s]):0):t}function g(t){let e=this.ordinal,i=this.old?this.old.min:this.min,s=this.old?this.old.transA:this.transA,o=e.positions;if(!o)return t;let r=n((t-i)*s+this.minPixelPadding),a=t>=o[0]&&t<=o[o.length-1];if(a||(o=e.getExtendedPositions()),o&&o.length){let i=o.indexOf(t),s=-1!==i?i:n(e.getIndexOfPoint(r,o)),a=n(s%1);if(s>=0&&s<=o.length-1){let t=o[Math.floor(s)],e=o[Math.ceil(s)];return o[Math.floor(s)]+a*(e-t)}}return t}function f(e,i){let s=t.Additions.findIndexOf(e,i,!0);if(e[s]===i)return s;let o=(i-e[s])/(e[s+1]-e[s]);return s+o}function x(){this.ordinal||(this.ordinal=new t.Additions(this))}function m(){this.isXAxis&&l(this.options.overscroll)&&this.max===this.dataMax&&(!this.chart.mouseIsDown||this.isInternal)&&(!this.eventArgs||this.eventArgs&&"navigator"!==this.eventArgs.trigger)&&(this.max+=this.options.overscroll,!this.isInternal&&l(this.userMin)&&(this.min+=this.options.overscroll))}function v(){this.horiz&&!this.isDirty&&(this.isDirty=this.isOrdinal&&this.chart.navigator&&!this.chart.navigator.adaptToUpdatedData)}function b(){this.ordinal&&(this.ordinal.beforeSetTickPositions(),this.tickInterval=this.ordinal.postProcessTickInterval(this.tickInterval))}function y(t){let e=this.xAxis[0],i=e.options.overscroll,s=t.originalEvent.chartX,o=this.options.chart.panning,r=!1;if(o&&"y"!==o.type&&e.options.ordinal&&e.series.length){let t,o,n,l;let h=this.mouseDownX,d=e.getExtremes(),p=d.dataMax,c=d.min,u=d.max,g=this.hoverPoints,f=e.closestPointRange||e.ordinal&&e.ordinal.overscrollPointsRange,x=e.translationSlope*(e.ordinal.slope||f),m=Math.round((h-s)/x),v=e.ordinal.getExtendedPositions(),b={ordinal:{positions:v,extendedOrdinalPositions:v}},y=e.index2val,M=e.val2lin;b.ordinal.positions?Math.abs(m)>1&&(g&&g.forEach(function(t){t.setState()}),m<0?(n=b,l=e.ordinal.positions?e:b):(n=e.ordinal.positions?e:b,l=b),p>(o=l.ordinal.positions)[o.length-1]&&o.push(p),this.fixedRange=u-c,(t=e.navigatorAxis.toFixedRange(void 0,void 0,y.apply(n,[M.apply(n,[c,!0])+m]),y.apply(l,[M.apply(l,[u,!0])+m]))).min>=Math.min(d.dataMin,c)&&t.max<=Math.max(p,u)+i&&e.setExtremes(t.min,t.max,!0,!1,{trigger:"pan"}),this.mouseDownX=s,a(this.container,{cursor:"move"})):r=!0}else r=!0;r||o&&/y/.test(o.type)?i&&(e.max=e.dataMax+i):t.preventDefault()}function M(){let t=this.xAxis;t&&t.options.ordinal&&delete t.ordinal.index}function S(t,e){let i;let s=this.ordinal,o=s.positions,r=s.slope,n;if(!o)return t;let a=o.length;if(o[0]<=t&&o[a-1]>=t)i=f(o,t);else{if(!((n=s.getExtendedPositions&&s.getExtendedPositions())&&n.length))return t;let a=n.length;r||(r=(n[a-1]-n[0])/a);let l=f(n,o[0]);if(t>=n[0]&&t<=n[a-1])i=f(n,t)-l;else{if(!e)return t;if(t<n[0]){let e=n[0]-t,s=e/r;i=-l-s}else{let e=t-n[a-1],s=e/r;i=s+a-l}}}return e?i:r*(i||0)+s.offset}t.compose=function(t,e,i){if(s.pushUnique(c,t)){let e=t.prototype;e.getTimeTicks=o,e.index2val=u,e.lin2val=g,e.val2lin=S,e.ordinal2lin=e.val2lin,r(t,"afterInit",x),r(t,"foundExtremes",m),r(t,"afterSetScale",v),r(t,"initialAxisTranslation",b)}return s.pushUnique(c,i)&&r(i,"pan",y),s.pushUnique(c,e)&&r(e,"updatedData",M),t};class A{constructor(t){this.index={},this.axis=t}beforeSetTickPositions(){let t=this.axis,e=t.ordinal,i=t.getExtremes(),s=i.min,o=i.max,r=t.brokenAxis?.hasBreaks,n=t.options.ordinal,a,l,h,p,c,u,g,f=[],x=Number.MAX_VALUE,m=!1,v=!1,b=!1;if(n||r){let i=0;if(t.series.forEach(function(t,e){if(l=[],e>0&&"highcharts-navigator-series"!==t.options.id&&t.processedXData.length>1&&(v=i!==t.processedXData[1]-t.processedXData[0]),i=t.processedXData[1]-t.processedXData[0],t.boosted&&(b=t.boosted),t.reserveSpace()&&(!1!==t.takeOrdinalPosition||r)&&(a=(f=f.concat(t.processedXData)).length,f.sort(function(t,e){return t-e}),x=Math.min(x,d(t.closestPointRange,x)),a)){for(e=0;e<a-1;)f[e]!==f[e+1]&&l.push(f[e+1]),e++;l[0]!==f[0]&&l.unshift(f[0]),f=l}}),v&&b&&(f.pop(),f.shift()),(a=f.length)>2){for(h=f[1]-f[0],g=a-1;g--&&!m;)f[g+1]-f[g]!==h&&(m=!0);!t.options.keepOrdinalPadding&&(f[0]-s>h||o-f[f.length-1]>h)&&(m=!0)}else t.options.overscroll&&(2===a?x=f[1]-f[0]:1===a?(x=t.options.overscroll,f=[f[0],f[0]+x]):x=e.overscrollPointsRange);m||t.forceOrdinal?(t.options.overscroll&&(e.overscrollPointsRange=x,f=f.concat(e.getOverscrollPositions())),e.positions=f,p=t.ordinal2lin(Math.max(s,f[0]),!0),c=Math.max(t.ordinal2lin(Math.min(o,f[f.length-1]),!0),1),e.slope=u=(o-s)/(c-p),e.offset=s-p*u):(e.overscrollPointsRange=d(t.closestPointRange,e.overscrollPointsRange),e.positions=t.ordinal.slope=e.offset=void 0)}t.isOrdinal=n&&m,e.groupIntervalFactor=null}static findIndexOf(t,e,i){let s=0,o=t.length-1,r;for(;s<o;)t[r=Math.ceil((s+o)/2)]<=e?s=r:o=r-1;return t[s]===e?s:i?s:-1}getExtendedPositions(){let t=this,s=t.axis,o=s.constructor.prototype,r=s.chart,n=s.series[0].currentDataGrouping,a=n?n.count+n.unitName:"raw",l=s.options.overscroll,h=s.getExtremes(),d,p,c=t.index;return c||(c=t.index={}),c[a]||((d={series:[],chart:r,forceOrdinal:!1,getExtremes:function(){return{min:h.dataMin,max:h.dataMax+l}},applyGrouping:o.applyGrouping,getGroupPixelWidth:o.getGroupPixelWidth,getTimeTicks:o.getTimeTicks,options:{ordinal:!0},ordinal:{getGroupIntervalFactor:this.getGroupIntervalFactor},ordinal2lin:o.ordinal2lin,getIndexOfPoint:o.getIndexOfPoint,val2lin:o.val2lin}).ordinal.axis=d,s.series.forEach(function(s){(p={xAxis:d,xData:s.xData.slice(),chart:r,groupPixelWidth:s.groupPixelWidth,destroyGroupedData:e.noop,getProcessedData:i.prototype.getProcessedData,applyGrouping:i.prototype.applyGrouping,reserveSpace:i.prototype.reserveSpace,visible:s.visible}).xData=p.xData.concat(t.getOverscrollPositions()),p.options={dataGrouping:n?{firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",enabled:!0,forced:!0,approximation:"open",units:[[n.unitName,[n.count]]]}:{enabled:!1}},d.series.push(p),s.processData.apply(p)}),d.applyGrouping({hasExtremesChanged:!0}),p.closestPointRange!==p.basePointRange&&p.currentDataGrouping&&(d.forceOrdinal=!0),s.ordinal.beforeSetTickPositions.apply({axis:d}),c[a]=d.ordinal.positions),c[a]}getGroupIntervalFactor(t,e,i){this.axis;let s=i.processedXData,o=s.length,r=[],n,a,l=this.groupIntervalFactor;if(!l){for(a=0;a<o-1;a++)r[a]=s[a+1]-s[a];r.sort(function(t,e){return t-e}),n=r[Math.floor(o/2)],t=Math.max(t,s[0]),e=Math.min(e,s[o-1]),this.groupIntervalFactor=l=o*n/(e-t)}return l}getIndexOfPoint(t,e){let i;let s=this.axis,o=this.positions?this.positions[0]:0,r=function(t){let{min:e,max:i}=s;return!!(l(e)&&l(i))&&t.points.some(t=>t.x>=e&&t.x<=i)};s.series.forEach(t=>{let e=t.points?.[0];l(e?.plotX)&&(e.plotX<i||!l(i))&&r(t)&&(i=e.plotX)}),i??(i=s.minPixelPadding);let a=s.translationSlope*(this.slope||s.closestPointRange||this.overscrollPointsRange),h=n((t-i)/a);return A.findIndexOf(e,o,!0)+h}getOverscrollPositions(){let t=this.axis,e=t.options.overscroll,i=this.overscrollPointsRange,s=[],o=t.dataMax;if(l(i))for(;o<=t.dataMax+e;)s.push(o+=i);return s}postProcessTickInterval(t){let e=this.axis,i=this.slope;return i?e.options.breaks?e.closestPointRange||t:t/(i/e.closestPointRange):t}}t.Additions=A}(o||(o={})),o}),i(e,"Series/HLC/HLCPoint.js",[e["Core/Series/SeriesRegistry.js"]],function(t){let{column:{prototype:{pointClass:e}}}=t.seriesTypes;return class extends e{constructor(){super(...arguments),this.close=void 0,this.high=void 0,this.low=void 0,this.options=void 0,this.plotClose=void 0,this.series=void 0}}}),i(e,"Series/HLC/HLCSeriesDefaults.js",[],function(){return{lineWidth:1,tooltip:{pointFormat:'<span style="color:{point.color}">●</span> <b> {series.name}</b><br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'},threshold:null,states:{hover:{lineWidth:3}},stickyTracking:!0}}),i(e,"Series/HLC/HLCSeries.js",[e["Series/HLC/HLCPoint.js"],e["Series/HLC/HLCSeriesDefaults.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,i,s){let{column:o}=i.seriesTypes,{extend:r,merge:n}=s;class a extends o{constructor(){super(...arguments),this.data=void 0,this.options=void 0,this.points=void 0,this.yData=void 0}extendStem(t,e,i){let s=t[0],o=t[1];"number"==typeof s[2]&&(s[2]=Math.max(i+e,s[2])),"number"==typeof o[2]&&(o[2]=Math.min(i-e,o[2]))}getPointPath(t,e){let i=e.strokeWidth(),s=t.series,o=i%2/2,r=Math.round(t.plotX)-o,n=Math.round(t.shapeArgs.width/2),a=t.plotClose,l=[["M",r,Math.round(t.yBottom)],["L",r,Math.round(t.plotHigh)]];return null!==t.close&&(a=Math.round(t.plotClose)+o,l.push(["M",r,a],["L",r+n,a]),s.extendStem(l,i/2,a)),l}drawSinglePoint(t){let e=t.series,i=e.chart,s,o=t.graphic;void 0!==t.plotY&&(o||(t.graphic=o=i.renderer.path().add(e.group)),i.styledMode||o.attr(e.pointAttribs(t,t.selected&&"select")),s=e.getPointPath(t,o),o[o?"animate":"attr"]({d:s}).addClass(t.getClassName(),!0))}drawPoints(){this.points.forEach(this.drawSinglePoint)}init(){super.init.apply(this,arguments),this.options.stacking=void 0}pointAttribs(t,e){let i=super.pointAttribs.call(this,t,e);return delete i.fill,i}toYData(t){return[t.high,t.low,t.close]}translate(){let t=this,e=t.yAxis,i=this.pointArrayMap&&this.pointArrayMap.slice()||[],s=i.map(t=>`plot${t.charAt(0).toUpperCase()+t.slice(1)}`);s.push("yBottom"),i.push("low"),super.translate.apply(t),t.points.forEach(function(o){i.forEach(function(i,r){let n=o[i];null!==n&&(t.dataModify&&(n=t.dataModify.modifyValue(n)),o[s[r]]=e.toPixels(n,!0))}),o.tooltipPos[1]=o.plotHigh+e.pos-t.chart.plotTop})}}return a.defaultOptions=n(o.defaultOptions,e),r(a.prototype,{pointClass:t,animate:null,directTouch:!1,pointArrayMap:["high","low","close"],pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"},pointValKey:"close"}),i.registerSeriesType("hlc",a),a}),i(e,"Series/OHLC/OHLCPoint.js",[e["Core/Series/SeriesRegistry.js"]],function(t){let{seriesTypes:{hlc:e}}=t;class i extends e.prototype.pointClass{constructor(){super(...arguments),this.open=void 0,this.options=void 0,this.plotOpen=void 0,this.series=void 0}getClassName(){return super.getClassName.call(this)+(this.open<this.close?" highcharts-point-up":" highcharts-point-down")}resolveUpColor(){this.open<this.close&&!this.options.color&&this.series.options.upColor&&(this.color=this.series.options.upColor)}resolveColor(){super.resolveColor(),this.resolveUpColor()}getZone(){let t=super.getZone();return this.resolveUpColor(),t}applyOptions(){return super.applyOptions.apply(this,arguments),this.resolveColor&&this.resolveColor(),this}}return i}),i(e,"Series/OHLC/OHLCSeriesDefaults.js",[],function(){return{tooltip:{pointFormat:'<span style="color:{point.color}">●</span> <b> {series.name}</b><br/>Open: {point.open}<br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'}}}),i(e,"Series/OHLC/OHLCSeries.js",[e["Series/OHLC/OHLCPoint.js"],e["Series/OHLC/OHLCSeriesDefaults.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,i,s){let{seriesTypes:{hlc:o}}=i,{addEvent:r,extend:n,merge:a}=s,l=[];function h(t){let e=t.options,i=e.dataGrouping;i&&e.useOhlcData&&"highcharts-navigator-series"!==e.id&&(i.approximation="ohlc")}function d(t){let e=t.options;e.useOhlcData&&"highcharts-navigator-series"!==e.id&&n(this,{pointValKey:p.prototype.pointValKey,pointArrayMap:p.prototype.pointArrayMap,toYData:p.prototype.toYData})}class p extends o{constructor(){super(...arguments),this.data=void 0,this.options=void 0,this.points=void 0}static compose(t,...e){s.pushUnique(l,t)&&(r(t,"afterSetOptions",h),r(t,"init",d))}getPointPath(t,e){let i=super.getPointPath(t,e),s=e.strokeWidth(),o=s%2/2,r=Math.round(t.plotX)-o,n=Math.round(t.shapeArgs.width/2),a=t.plotOpen;return null!==t.open&&(a=Math.round(t.plotOpen)+o,i.push(["M",r,a],["L",r-n,a]),super.extendStem(i,s/2,a)),i}pointAttribs(t,e){let i=super.pointAttribs.call(this,t,e),s=this.options;return delete i.fill,!t.options.color&&s.upColor&&t.open<t.close&&(i.stroke=s.upColor),i}toYData(t){return[t.open,t.high,t.low,t.close]}}return p.defaultOptions=a(o.defaultOptions,e),n(p.prototype,{pointClass:t,pointArrayMap:["open","high","low","close"]}),i.registerSeriesType("ohlc",p),p}),i(e,"Series/Candlestick/CandlestickSeriesDefaults.js",[e["Core/Defaults.js"],e["Core/Utilities.js"]],function(t,e){let{defaultOptions:i}=t,{merge:s}=e;return{states:{hover:{lineWidth:2}},threshold:null,lineColor:"#000000",lineWidth:1,upColor:"#ffffff",stickyTracking:!0}}),i(e,"Series/Candlestick/CandlestickSeries.js",[e["Series/Candlestick/CandlestickSeriesDefaults.js"],e["Core/Defaults.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,i,s){let{defaultOptions:o}=e,{column:r,ohlc:n}=i.seriesTypes,{merge:a}=s;class l extends n{constructor(){super(...arguments),this.data=void 0,this.options=void 0,this.points=void 0}pointAttribs(t,e){let i=r.prototype.pointAttribs.call(this,t,e),s=this.options,o=t.open<t.close,n=s.lineColor||this.color,a=t.color||this.color;if(i["stroke-width"]=s.lineWidth,i.fill=t.options.color||o&&s.upColor||a,i.stroke=t.options.lineColor||o&&s.upLineColor||n,e){let t=s.states[e];i.fill=t.color||i.fill,i.stroke=t.lineColor||i.stroke,i["stroke-width"]=t.lineWidth||i["stroke-width"]}return i}drawPoints(){let t=this.points,e=this.chart,i=this.yAxis.reversed;for(let s of t){let t=s.graphic,o,r,n,a,l,h,d,p,c,u,g=!t;void 0!==s.plotY&&(t||(s.graphic=t=e.renderer.path().add(this.group)),this.chart.styledMode||t.attr(this.pointAttribs(s,s.selected&&"select")).shadow(this.options.shadow),d=t.strokeWidth()%2/2,p=Math.round(s.plotX)-d,n=Math.min(o=s.plotOpen,r=s.plotClose),a=Math.max(o,r),u=Math.round(s.shapeArgs.width/2),l=i?a!==s.yBottom:Math.round(n)!==Math.round(s.plotHigh),h=i?Math.round(n)!==Math.round(s.plotHigh):a!==s.yBottom,n=Math.round(n)+d,a=Math.round(a)+d,(c=[]).push(["M",p-u,a],["L",p-u,n],["L",p+u,n],["L",p+u,a],["Z"],["M",p,n],["L",p,l?Math.round(i?s.yBottom:s.plotHigh):n],["M",p,a],["L",p,h?Math.round(i?s.plotHigh:s.yBottom):a]),t[g?"attr":"animate"]({d:c}).addClass(s.getClassName(),!0))}}}return l.defaultOptions=a(n.defaultOptions,o.plotOptions,{tooltip:n.defaultOptions.tooltip},t),i.registerSeriesType("candlestick",l),l}),i(e,"Series/Flags/FlagsPoint.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){let{column:{prototype:{pointClass:i}}}=t.seriesTypes,{isNumber:s}=e;return class extends i{constructor(){super(...arguments),this.options=void 0,this.series=void 0,this.ttBelow=!1}isValid(){return s(this.y)||void 0===this.y}hasNewShapeType(){let t=this.options.shape||this.series.options.shape;return this.graphic&&t&&t!==this.graphic.symbolKey}}}),i(e,"Series/Flags/FlagsSeriesDefaults.js",[],function(){return{pointRange:0,allowOverlapX:!1,shape:"flag",stackDistance:12,textAlign:"center",tooltip:{pointFormat:"{point.text}"},threshold:null,y:-30,fillColor:"#ffffff",lineWidth:1,states:{hover:{lineColor:"#000000",fillColor:"#ccd3ff"}},style:{fontSize:"0.7em",fontWeight:"bold"}}}),i(e,"Series/Flags/FlagsSymbols.js",[e["Core/Renderer/RendererRegistry.js"]],function(t){var e;return function(e){let i=[];function s(t,e,i,s,o){let r=o&&o.anchorX||t,n=o&&o.anchorY||e,a=this.circle(r-1,n-1,2,2);return a.push(["M",r,n],["L",t,e+s],["L",t,e],["L",t+i,e],["L",t+i,e+s],["L",t,e+s],["Z"]),a}function o(t,e){t[e+"pin"]=function(i,s,o,r,n){let a;let l=n&&n.anchorX,h=n&&n.anchorY;if("circle"===e&&r>o&&(i-=Math.round((r-o)/2),o=r),a=t[e](i,s,o,r),l&&h){let n=l;if("circle"===e)n=i+o/2;else{let t=a[0],e=a[1];"M"===t[0]&&"L"===e[0]&&(n=(t[1]+e[1])/2)}let d=s>h?s:s+r;a.push(["M",n,d],["L",l,h]),a=a.concat(t.circle(l-1,h-1,2,2))}return a}}e.compose=function(e){if(-1===i.indexOf(e)){i.push(e);let t=e.prototype.symbols;t.flag=s,o(t,"circle"),o(t,"square")}let r=t.getRendererType();i.indexOf(r)&&i.push(r)}}(e||(e={})),e}),i(e,"Series/OnSeriesComposition.js",[e["Series/Column/ColumnSeries.js"],e["Core/Series/Series.js"],e["Core/Utilities.js"]],function(t,e,i){var s;let{prototype:o}=t,{prototype:r}=e,{defined:n,stableSort:a}=i;return function(t){let e=[];function s(t){return r.getPlotBox.call(this.options.onSeries&&this.chart.get(this.options.onSeries)||this,t)}function l(){o.translate.apply(this);let t=this,e=t.options,i=t.chart,s=t.points,r=e.onSeries,l=r&&i.get(r),h=l&&l.options.step,d=l&&l.points,p=i.inverted,c=t.xAxis,u=t.yAxis,g=s.length-1,f,x,m=e.onKey||"y",v=d&&d.length,b=0,y,M,S,A,k;if(l&&l.visible&&v){for(b=(l.pointXOffset||0)+(l.barW||0)/2,A=l.currentDataGrouping,M=d[v-1].x+(A?A.totalRange:0),a(s,(t,e)=>t.x-e.x),m="plot"+m[0].toUpperCase()+m.substr(1);v--&&s[g];)if(y=d[v],(f=s[g]).y=y.y,y.x<=f.x&&void 0!==y[m]){if(f.x<=M&&(f.plotY=y[m],y.x<f.x&&!h&&(S=d[v+1])&&void 0!==S[m])){if(n(f.plotX)&&l.is("spline")){let t=[y.plotX||0,y.plotY||0],e=[S.plotX||0,S.plotY||0],i=y.controlPoints?.high||t,s=S.controlPoints?.low||e,o=(o,r)=>Math.pow(1-o,3)*t[r]+3*(1-o)*(1-o)*o*i[r]+3*(1-o)*o*o*s[r]+o*o*o*e[r],r=0,a=1,l;for(let t=0;t<100;t++){let t=(r+a)/2,e=o(t,0);if(null===e)break;if(.25>Math.abs(e-f.plotX)){l=t;break}e<f.plotX?r=t:a=t}n(l)&&(f.plotY=o(l,1),f.y=u.toValue(f.plotY,!0))}else k=(f.x-y.x)/(S.x-y.x),f.plotY+=k*(S[m]-y[m]),f.y+=k*(S.y-y.y)}if(g--,v++,g<0)break}}s.forEach((e,i)=>{let o;e.plotX+=b,(void 0===e.plotY||p)&&(e.plotX>=0&&e.plotX<=c.len?p?(e.plotY=c.translate(e.x,0,1,0,1),e.plotX=n(e.y)?u.translate(e.y,0,0,0,1):0):e.plotY=(c.opposite?0:t.yAxis.len)+c.offset:e.shapeArgs={}),(x=s[i-1])&&x.plotX===e.plotX&&(void 0===x.stackIndex&&(x.stackIndex=0),o=x.stackIndex+1),e.stackIndex=o}),this.onSeries=l}t.compose=function(t){if(i.pushUnique(e,t)){let e=t.prototype;e.getPlotBox=s,e.translate=l}return t},t.getPlotBox=s,t.translate=l}(s||(s={})),s}),i(e,"Series/Flags/FlagsSeries.js",[e["Series/Flags/FlagsPoint.js"],e["Series/Flags/FlagsSeriesDefaults.js"],e["Series/Flags/FlagsSymbols.js"],e["Core/Globals.js"],e["Series/OnSeriesComposition.js"],e["Core/Renderer/RendererUtilities.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Renderer/SVG/SVGElement.js"],e["Core/Utilities.js"]],function(t,e,i,s,o,r,n,a,l){let{noop:h}=s,{distribute:d}=r,{series:p,seriesTypes:{column:c}}=n,{addEvent:u,defined:g,extend:f,merge:x,objectEach:m,wrap:v}=l;class b extends c{constructor(){super(...arguments),this.data=void 0,this.options=void 0,this.points=void 0}animate(t){t&&this.setClip()}drawPoints(){let t,e,i,s,o,r,n,l,h,p,c;let u=this.points,f=this.chart,b=f.renderer,y=f.inverted,M=this.options,S=M.y,A=this.yAxis,k={},C=[];for(s=u.length;s--;)o=u[s],p=(y?o.plotY:o.plotX)>this.xAxis.len,t=o.plotX,n=o.stackIndex,i=o.options.shape||M.shape,void 0!==(e=o.plotY)&&(e=o.plotY+S-(void 0!==n&&n*M.stackDistance)),o.anchorX=n?void 0:o.plotX,l=n?void 0:o.plotY,c="flag"!==i,r=o.graphic,void 0!==e&&t>=0&&!p?(r&&o.hasNewShapeType()&&(r=r.destroy()),r||(r=o.graphic=b.label("",null,null,i,null,null,M.useHTML).addClass("highcharts-point").add(this.markerGroup),o.graphic.div&&(o.graphic.div.point=o),r.isNew=!0),r.attr({align:c?"center":"left",width:M.width,height:M.height,"text-align":M.textAlign}),f.styledMode||r.attr(this.pointAttribs(o)).css(x(M.style,o.style)).shadow(M.shadow),t>0&&(t-=r.strokeWidth()%2),h={y:e,anchorY:l},M.allowOverlapX&&(h.x=t,h.anchorX=o.anchorX),r.attr({text:o.options.title||M.title||"A"})[r.isNew?"attr":"animate"](h),M.allowOverlapX||(k[o.plotX]?k[o.plotX].size=Math.max(k[o.plotX].size,r.width||0):k[o.plotX]={align:c?.5:0,size:r.width||0,target:t,anchorX:t}),o.tooltipPos=[t,e+A.pos-f.plotTop]):r&&(o.graphic=r.destroy());if(!M.allowOverlapX){let t=100;for(let e of(m(k,function(e){e.plotX=e.anchorX,C.push(e),t=Math.max(e.size,t)}),d(C,y?A.len:this.xAxis.len,t),u)){let t=e.plotX,i=e.graphic,s=i&&k[t];s&&i&&(g(s.pos)?i[i.isNew?"attr":"animate"]({x:s.pos+(s.align||0)*s.size,anchorX:e.anchorX}).show().isNew=!1:i.hide().isNew=!0)}}M.useHTML&&this.markerGroup&&v(this.markerGroup,"on",function(t){return a.prototype.on.apply(t.apply(this,[].slice.call(arguments,1)),[].slice.call(arguments,1))})}drawTracker(){let t=this.points;for(let e of(super.drawTracker(),t)){let i=e.graphic;i&&(e.unbindMouseOver&&e.unbindMouseOver(),e.unbindMouseOver=u(i.element,"mouseover",function(){for(let s of(e.stackIndex>0&&!e.raised&&(e._y=i.y,i.attr({y:e._y-8}),e.raised=!0),t))s!==e&&s.raised&&s.graphic&&(s.graphic.attr({y:s._y}),s.raised=!1)}))}}pointAttribs(t,e){let i=this.options,s=t&&t.color||this.color,o=i.lineColor,r=t&&t.lineWidth,n=t&&t.fillColor||i.fillColor;return e&&(n=i.states[e].fillColor,o=i.states[e].lineColor,r=i.states[e].lineWidth),{fill:n||s,stroke:o||s,"stroke-width":r||i.lineWidth||0}}setClip(){p.prototype.setClip.apply(this,arguments),!1!==this.options.clip&&this.sharedClipKey&&this.markerGroup&&this.markerGroup.clip(this.chart.sharedClips[this.sharedClipKey])}}return b.compose=i.compose,b.defaultOptions=x(c.defaultOptions,e),o.compose(b),f(b.prototype,{allowDG:!1,forceCrop:!0,invertible:!1,noSharedTooltip:!0,pointClass:t,sorted:!1,takeOrdinalPosition:!1,trackerGroups:["markerGroup"],buildKDTree:h,init:p.prototype.init}),n.registerSeriesType("flags",b),b}),i(e,"Core/Chart/StockChart.js",[e["Core/Chart/Chart.js"],e["Core/Templating.js"],e["Core/Defaults.js"],e["Stock/Navigator/NavigatorDefaults.js"],e["Stock/RangeSelector/RangeSelectorDefaults.js"],e["Stock/Scrollbar/ScrollbarDefaults.js"],e["Core/Utilities.js"]],function(t,e,i,s,o,r,n){let{format:a}=e,{getOptions:l}=i,{addEvent:h,clamp:d,defined:p,extend:c,find:u,isNumber:g,isString:f,merge:x,pick:m,pushUnique:v,splat:b}=n;function y(t,e){return"xAxis"===t?{minPadding:0,maxPadding:0,overscroll:0,ordinal:!0,title:{text:null},labels:{overflow:"justify"},showLastLabel:!0}:"yAxis"===t?{labels:{y:-2},opposite:m(e.opposite,!0),showLastLabel:!!(e.categories||"category"===e.type),title:{text:null}}:{}}function M(t,e){if("xAxis"===t){let t=m(e.navigator&&e.navigator.enabled,s.enabled,!0),i={type:"datetime",categories:void 0};return t&&(i.startOnTick=!1,i.endOnTick=!1),i}return{}}class S extends t{init(t,e){let i=l(),n=t.xAxis,a=t.yAxis,h=m(t.navigator&&t.navigator.enabled,s.enabled,!0);t.xAxis=t.yAxis=void 0;let d=x({chart:{panning:{enabled:!0,type:"x"},zooming:{pinchType:"x",mouseWheel:{type:"x"}}},navigator:{enabled:h},scrollbar:{enabled:m(r.enabled,!0)},rangeSelector:{enabled:m(o.rangeSelector.enabled,!0)},title:{text:null},tooltip:{split:m(i.tooltip&&i.tooltip.split,!0),crosshairs:!0},legend:{enabled:!1}},t,{isStock:!0});t.xAxis=n,t.yAxis=a,d.xAxis=b(t.xAxis||{}).map((e,s)=>x(y("xAxis",e),i.xAxis,i.xAxis&&i.xAxis[s],e,M("xAxis",t))),d.yAxis=b(t.yAxis||{}).map((t,e)=>x(y("yAxis",t),i.yAxis,i.yAxis&&i.yAxis[e],t)),super.init(d,e)}createAxis(t,e){return e.axis=x(y(t,e.axis),e.axis,M(t,this.userOptions)),super.createAxis(t,e)}}return h(t,"update",function(t){let e=t.options;"scrollbar"in e&&this.navigator&&(x(!0,this.options.scrollbar,e.scrollbar),this.navigator.update({}),delete e.scrollbar)}),function(t){let e=[];function i(t){if(!this.crosshair||!this.crosshair.label||!this.crosshair.label.enabled||!this.cross||!g(this.min)||!g(this.max))return;let e=this.chart,i=this.logarithmic,s=this.crosshair.label,o=this.horiz,r=this.opposite,n=this.left,l=this.top,h=this.width,d="inside"===this.options.tickPosition,p=!1!==this.crosshair.snap,u=t.e||this.cross&&this.cross.e,f=t.point,x=this.crossLabel,v,b,y=s.format,M="",S,A=0,k=this.min,C=this.max;i&&(k=i.lin2log(this.min),C=i.lin2log(this.max));let D=o?"center":r?"right"===this.labelAlign?"right":"left":"left"===this.labelAlign?"left":"center";x||(x=this.crossLabel=e.renderer.label("",0,void 0,s.shape||"callout").addClass("highcharts-crosshair-label highcharts-color-"+(f&&f.series?f.series.colorIndex:this.series[0]&&this.series[0].colorIndex)).attr({align:s.align||D,padding:m(s.padding,8),r:m(s.borderRadius,3),zIndex:2}).add(this.labelGroup),e.styledMode||x.attr({fill:s.backgroundColor||f&&f.series&&f.series.color||"#666666",stroke:s.borderColor||"","stroke-width":s.borderWidth||0}).css(c({color:"#ffffff",fontWeight:"normal",fontSize:"0.7em",textAlign:"center"},s.style||{}))),o?(v=p?(f.plotX||0)+n:u.chartX,b=l+(r?0:this.height)):(v=n+this.offset+(r?h:0),b=p?(f.plotY||0)+l:u.chartY),y||s.formatter||(this.dateTime&&(M="%b %d, %Y"),y="{value"+(M?":"+M:"")+"}");let w=p?this.isXAxis?f.x:f.y:this.toValue(o?u.chartX:u.chartY),E=f&&f.series?f.series.isPointInside(f):g(w)&&w>k&&w<C,B="";y?B=a(y,{value:w},e):s.formatter&&g(w)&&(B=s.formatter.call(this,w)),x.attr({text:B,x:v,y:b,visibility:E?"inherit":"hidden"});let O=x.getBBox();!g(x.x)||o||r||(v=x.x-O.width/2),g(x.y)&&(o?(d&&!r||!d&&r)&&(b=x.y-O.height):b=x.y-O.height/2),S=o?{left:n-O.x,right:n+this.width-O.x}:{left:"left"===this.labelAlign?n:0,right:"right"===this.labelAlign?n+this.width:e.chartWidth};let T=x.translateX||0;T<S.left&&(A=S.left-T),T+O.width>=S.right&&(A=-(T+O.width-S.right)),x.attr({x:v+A,y:b,anchorX:o?v:this.opposite?0:e.chartWidth,anchorY:o?this.opposite?e.chartHeight:0:b+O.height/2})}function s(){this.crossLabel&&(this.crossLabel=this.crossLabel.hide())}function o(t){let e=this.chart,i=this.options,s=e._labelPanes=e._labelPanes||{},o=i.labels;if(e.options.isStock&&"yAxis"===this.coll){let e=i.top+","+i.height;!s[e]&&o.enabled&&(15===o.distance&&1===this.side&&(o.distance=0),void 0===o.align&&(o.align="right"),s[e]=this,t.align="right",t.preventDefault())}}function r(){let t=this.chart,e=this.options&&this.options.top+","+this.options.height;e&&t._labelPanes&&t._labelPanes[e]===this&&delete t._labelPanes[e]}function n(t){let e=this,i=e.isLinked&&!e.series&&e.linkedParent?e.linkedParent.series:e.series,s=e.chart,o=s.renderer,r=e.left,n=e.top,a=[],l=t.translatedValue,h=t.value,c=t.force,x,v,b,y,M=[],S,A;if(s.options.isStock&&!1!==t.acrossPanes&&"xAxis"===e.coll||"yAxis"===e.coll){for(let o of(t.preventDefault(),M=(t=>{let o="xAxis"===t?"yAxis":"xAxis",r=e.options[o];return g(r)?[s[o][r]]:f(r)?[s.get(r)]:i.map(t=>t[o])})(e.coll),e.isXAxis?s.yAxis:s.xAxis))if(!p(o.options.id)||-1===o.options.id.indexOf("navigator")){let t=o.isXAxis?"yAxis":"xAxis",i=p(o.options[t])?s[t][o.options[t]]:s[t][0];e===i&&M.push(o)}for(let t of(S=M.length?[]:[e.isXAxis?s.yAxis[0]:s.xAxis[0]],M))-1!==S.indexOf(t)||u(S,e=>e.pos===t.pos&&e.len===t.len)||S.push(t);if(g(A=m(l,e.translate(h||0,void 0,void 0,t.old)))){if(e.horiz)for(let t of S){let i;y=(v=t.pos)+t.len,x=b=Math.round(A+e.transB),"pass"!==c&&(x<r||x>r+e.width)&&(c?x=b=d(x,r,r+e.width):i=!0),i||a.push(["M",x,v],["L",b,y])}else for(let t of S){let i;b=(x=t.pos)+t.len,v=y=Math.round(n+e.height-A),"pass"!==c&&(v<n||v>n+e.height)&&(c?v=y=d(v,n,n+e.height):i=!0),i||a.push(["M",x,v],["L",b,y])}}t.path=a.length>0?o.crispPolyLine(a,t.lineWidth||1):void 0}}function l(t){if(this.chart.options.isStock){let e;this.is("column")||this.is("columnrange")?e={borderWidth:0,shadow:!1}:this.is("scatter")||this.is("sma")||(e={marker:{enabled:!1,radius:2}}),e&&(t.plotOptions[this.type]=x(t.plotOptions[this.type],e))}}function b(){let t=this.chart,e=this.options,i=e.dataGrouping,s=!1!==this.allowDG&&i&&m(i.enabled,t.options.isStock);return s}function y(t,e){for(let i=0;i<t.length;i+=2){let s=t[i],o=t[i+1];s[1]===o[1]&&(s[1]=o[1]=Math.round(s[1])-e%2/2),s[2]===o[2]&&(s[2]=o[2]=Math.round(s[2])+e%2/2)}return t}t.compose=function(t,a,d){v(e,t)&&(h(t,"afterDrawCrosshair",i),h(t,"afterHideCrosshair",s),h(t,"autoLabelAlign",o),h(t,"destroy",r),h(t,"getPlotLinePath",n)),v(e,a)&&(a.prototype.forceCropping=b,h(a,"setOptions",l)),v(e,d)&&(d.prototype.crispPolyLine=y)},t.stockChart=function(e,i,s){return new t(e,i,s)}}(S||(S={})),S}),i(e,"masters/modules/stock.src.js",[e["Core/Globals.js"],e["Series/DataModifyComposition.js"],e["Stock/Navigator/Navigator.js"],e["Stock/RangeSelector/RangeSelector.js"],e["Stock/Scrollbar/Scrollbar.js"],e["Core/Axis/OrdinalAxis.js"],e["Series/OHLC/OHLCSeries.js"],e["Series/Flags/FlagsSeries.js"],e["Core/Chart/StockChart.js"]],function(t,e,i,s,o,r,n,a,l){t.Navigator=i,t.RangeSelector=s,t.Scrollbar=o,t.StockChart=t.stockChart=l.stockChart,e.compose(t.Series,t.Axis,t.Point),a.compose(t.Renderer),i.compose(t.Axis,t.Chart,t.Series),n.compose(t.Series),r.compose(t.Axis,t.Series,t.Chart),s.compose(t.Axis,t.Chart),o.compose(t.Axis),l.compose(t.Axis,t.Series,t.SVGRenderer)})});//# sourceMappingURL=stock.js.map