/**
 * Highcharts JS v11.2.0 (2023-10-30)
 *
 * Wind barb series module
 *
 * (c) 2010-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */!function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/windbarb",["highcharts"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function i(t,e,i,o){t.hasOwnProperty(e)||(t[e]=o.apply(null,i),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:t[e]}})))}i(e,"Extensions/DataGrouping/ApproximationRegistry.js",[],function(){return{}}),i(e,"Series/OnSeriesComposition.js",[e["Series/Column/ColumnSeries.js"],e["Core/Series/Series.js"],e["Core/Utilities.js"]],function(t,e,i){var o;let{prototype:r}=t,{prototype:s}=e,{defined:n,stableSort:a}=i;return function(t){let e=[];function o(t){return s.getPlotBox.call(this.options.onSeries&&this.chart.get(this.options.onSeries)||this,t)}function l(){r.translate.apply(this);let t=this,e=t.options,i=t.chart,o=t.points,s=e.onSeries,l=s&&i.get(s),p=l&&l.options.step,h=l&&l.points,u=i.inverted,d=t.xAxis,c=t.yAxis,f=o.length-1,b,g,m=e.onKey||"y",x=h&&h.length,y=0,v,S,L,j,w;if(l&&l.visible&&x){for(y=(l.pointXOffset||0)+(l.barW||0)/2,j=l.currentDataGrouping,S=h[x-1].x+(j?j.totalRange:0),a(o,(t,e)=>t.x-e.x),m="plot"+m[0].toUpperCase()+m.substr(1);x--&&o[f];)if(v=h[x],(b=o[f]).y=v.y,v.x<=b.x&&void 0!==v[m]){if(b.x<=S&&(b.plotY=v[m],v.x<b.x&&!p&&(L=h[x+1])&&void 0!==L[m])){if(n(b.plotX)&&l.is("spline")){let t=[v.plotX||0,v.plotY||0],e=[L.plotX||0,L.plotY||0],i=v.controlPoints?.high||t,o=L.controlPoints?.low||e,r=(r,s)=>Math.pow(1-r,3)*t[s]+3*(1-r)*(1-r)*r*i[s]+3*(1-r)*r*r*o[s]+r*r*r*e[s],s=0,a=1,l;for(let t=0;t<100;t++){let t=(s+a)/2,e=r(t,0);if(null===e)break;if(.25>Math.abs(e-b.plotX)){l=t;break}e<b.plotX?s=t:a=t}n(l)&&(b.plotY=r(l,1),b.y=c.toValue(b.plotY,!0))}else w=(b.x-v.x)/(L.x-v.x),b.plotY+=w*(L[m]-v[m]),b.y+=w*(L.y-v.y)}if(f--,x++,f<0)break}}o.forEach((e,i)=>{let r;e.plotX+=y,(void 0===e.plotY||u)&&(e.plotX>=0&&e.plotX<=d.len?u?(e.plotY=d.translate(e.x,0,1,0,1),e.plotX=n(e.y)?c.translate(e.y,0,0,0,1):0):e.plotY=(d.opposite?0:t.yAxis.len)+d.offset:e.shapeArgs={}),(g=o[i-1])&&g.plotX===e.plotX&&(void 0===g.stackIndex&&(g.stackIndex=0),r=g.stackIndex+1),e.stackIndex=r}),this.onSeries=l}t.compose=function(t){if(i.pushUnique(e,t)){let e=t.prototype;e.getPlotBox=o,e.translate=l}return t},t.getPlotBox=o,t.translate=l}(o||(o={})),o}),i(e,"Series/Windbarb/WindbarbPoint.js",[e["Series/Column/ColumnSeries.js"],e["Core/Utilities.js"]],function(t,e){let{isNumber:i}=e;class o extends t.prototype.pointClass{constructor(){super(...arguments),this.beaufort=void 0,this.beaufortLevel=void 0,this.direction=void 0,this.options=void 0,this.series=void 0,this.value=void 0}isValid(){return i(this.value)&&this.value>=0}}return o}),i(e,"Series/Windbarb/WindbarbSeriesDefaults.js",[],function(){return{dataGrouping:{enabled:!0,approximation:"windbarb",groupPixelWidth:30},lineWidth:2,onSeries:null,states:{hover:{lineWidthPlus:0}},tooltip:{pointFormat:'<span style="color:{point.color}">●</span> {series.name}: <b>{point.value}</b> ({point.beaufort})<br/>'},vectorLength:20,colorKey:"value",yOffset:-20,xOffset:0}}),i(e,"Series/Windbarb/WindbarbSeries.js",[e["Core/Animation/AnimationUtilities.js"],e["Extensions/DataGrouping/ApproximationRegistry.js"],e["Core/Globals.js"],e["Series/OnSeriesComposition.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"],e["Series/Windbarb/WindbarbPoint.js"],e["Series/Windbarb/WindbarbSeriesDefaults.js"]],function(t,e,i,o,r,s,n,a){let{animObject:l}=t,{column:p}=r.seriesTypes,{extend:h,merge:u,pick:d}=s;class c extends p{constructor(){super(...arguments),this.data=void 0,this.options=void 0,this.points=void 0}init(t,e){super.init(t,e)}pointAttribs(t,e){let i=this.options,o=t.color||this.color,r=this.options.lineWidth;return e&&(o=i.states[e].color||o,r=(i.states[e].lineWidth||r)+(i.states[e].lineWidthPlus||0)),{stroke:o,"stroke-width":r}}windArrow(t){let e=t.beaufortLevel,i=this.options.vectorLength/20,o=1.943844*t.value,r,s=-10;if(t.isNull)return[];if(0===e)return this.chart.renderer.symbols.circle(-10*i,-10*i,20*i,20*i);let n=[["M",0,7*i],["L",-1.5*i,7*i],["L",0,10*i],["L",1.5*i,7*i],["L",0,7*i],["L",0,-10*i]];if((r=(o-o%50)/50)>0)for(;r--;)n.push(-10===s?["L",0,s*i]:["M",0,s*i],["L",5*i,s*i+2],["L",0,s*i+4]),o-=50,s+=7;if((r=(o-o%10)/10)>0)for(;r--;)n.push(-10===s?["L",0,s*i]:["M",0,s*i],["L",7*i,s*i]),o-=10,s+=3;if((r=(o-o%5)/5)>0)for(;r--;)n.push(-10===s?["L",0,s*i]:["M",0,s*i],["L",4*i,s*i]),o-=5,s+=3;return n}drawPoints(){let t=this.chart,e=this.yAxis,i=t.inverted,o=this.options.vectorLength/2;for(let r of this.points){let s=r.plotX,n=r.plotY;!1===this.options.clip||t.isInsidePlot(s,0)?(r.graphic||(r.graphic=this.chart.renderer.path().add(this.markerGroup).addClass("highcharts-point highcharts-color-"+d(r.colorIndex,r.series.colorIndex))),r.graphic.attr({d:this.windArrow(r),translateX:s+this.options.xOffset,translateY:n+this.options.yOffset,rotation:r.direction}),this.chart.styledMode||r.graphic.attr(this.pointAttribs(r))):r.graphic&&(r.graphic=r.graphic.destroy()),r.tooltipPos=[s+this.options.xOffset+(i&&!this.onSeries?o:0),n+this.options.yOffset-(i?0:o+e.pos-t.plotTop)]}}animate(t){t?this.markerGroup.attr({opacity:.01}):this.markerGroup.animate({opacity:1},l(this.options.animation))}markerAttribs(t,e){return{}}getExtremes(){return{}}shouldShowTooltip(t,e,i={}){return i.ignoreX=this.chart.inverted,i.ignoreY=!i.ignoreX,super.shouldShowTooltip(t,e,i)}}return c.defaultOptions=u(p.defaultOptions,a),o.compose(c),h(c.prototype,{beaufortFloor:[0,.3,1.6,3.4,5.5,8,10.8,13.9,17.2,20.8,24.5,28.5,32.7],beaufortName:["Calm","Light air","Light breeze","Gentle breeze","Moderate breeze","Fresh breeze","Strong breeze","Near gale","Gale","Strong gale","Storm","Violent storm","Hurricane"],invertible:!1,parallelArrays:["x","value","direction"],pointArrayMap:["value","direction"],pointClass:n,trackerGroups:["markerGroup"],translate:function(){let t=this.beaufortFloor,e=this.beaufortName;for(let i of(o.translate.call(this),this.points)){let o=0;for(;o<t.length&&!(t[o]>i.value);o++);i.beaufortLevel=o-1,i.beaufort=e[o-1]}}}),r.registerSeriesType("windbarb",c),e.windbarb||(e.windbarb=(t,e)=>{let o=0,r=0;for(let s=0,n=t.length;s<n;s++)o+=t[s]*Math.cos(e[s]*i.deg2rad),r+=t[s]*Math.sin(e[s]*i.deg2rad);return[t.reduce((t,e)=>t+e,0)/t.length,Math.atan2(r,o)/i.deg2rad]}),c}),i(e,"masters/modules/windbarb.src.js",[],function(){})});//# sourceMappingURL=windbarb.js.map